/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scheduler;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.scheduler.SchedulerImpl;
import com.ibm.ws.scheduler.SchedulerServiceImpl;
import com.ibm.ws.scheduler.resources.Messages;
import com.ibm.ws.scheduler.spi.TaskInfo;
import com.ibm.ws.security.role.RoleBasedAuthorizer;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;

public class SecurityControlImpl {
    private static final TraceComponent tc = Tr.register(SecurityControlImpl.class, "Scheduler", "com.ibm.ws.scheduler.resources.SchedulerMessages");
    public static final int OWNERTOKEN_MAXLEN = 200;
    public static final String OWNERTOKEN_ADMIN = "ADMIN";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkAccess(TaskInfo taskInfo, long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkAccess", new Object[]{taskInfo.getTaskId(), SchedulerImpl.getMethodNameFromOperation(l)});
        }
        try {
            SecurityControlImpl.checkTaskOperationAccess(l, taskInfo);
            if (l != 4128L) {
                SecurityControlImpl.checkJ2EENameOfCaller(taskInfo);
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkAccess");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkJ2EENameOfCaller(TaskInfo taskInfo) {
        boolean bl = tc.isDebugEnabled();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkJ2EENameOfCaller", new Object[]{taskInfo.getTaskId()});
        }
        try {
            J2EEName j2EEName = SecurityControlImpl.getCurrentJ2EEName();
            J2EEName j2EEName2 = taskInfo.getJ2EEName();
            String string = SecurityControlImpl.getOwnerToken(j2EEName);
            if (!string.equals(OWNERTOKEN_ADMIN) && !string.equals(SecurityControlImpl.getOwnerToken(j2EEName2))) {
                if (bl) {
                    String string2 = j2EEName.getApplication();
                    String string3 = j2EEName2 != null ? j2EEName2.getApplication().toString() : null;
                    Tr.debug(tc, "Denying Access. J2EENames do not match.", new Object[]{string2, string3});
                }
                throw new SecurityException(Messages.getMessage("SCHD0127E"));
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkJ2EENameOfCaller");
            }
        }
    }

    public static J2EEName getCurrentJ2EEName() {
        J2EEName j2EEName = null;
        ComponentMetaData componentMetaData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        if (componentMetaData != null) {
            j2EEName = componentMetaData.getJ2EEName();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ComponentMetaData, J2EEName for thread:", new Object[]{componentMetaData, j2EEName});
        }
        return j2EEName;
    }

    public static String getCurrentOwnerToken() {
        J2EEName j2EEName = SecurityControlImpl.getCurrentJ2EEName();
        return SecurityControlImpl.getOwnerToken(j2EEName);
    }

    public static String getOwnerToken(J2EEName j2EEName) {
        if (j2EEName != null) {
            String string = j2EEName.getApplication();
            if (string.length() > 200) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WARNING:  OwnerToken truncated.  It is greater than 200 characters.");
                }
                int n = string.hashCode();
                String string2 = Integer.toHexString(n).toUpperCase();
                return string.substring(0, 200 - string2.length()) + string2;
            }
            return string;
        }
        return OWNERTOKEN_ADMIN;
    }

    public void method() {
    }

    public static void checkMethodAccess(String string) throws SecurityException {
        RoleBasedAuthorizer roleBasedAuthorizer = SchedulerServiceImpl.instance().getRoleBasedAuthorizer();
        if (!roleBasedAuthorizer.checkAccess("WASScheduler", "WASScheduler", string)) {
            throw new SecurityException(Messages.getMessage("SCHD0096E", string));
        }
    }

    public static void checkTaskOperationAccess(long l, TaskInfo taskInfo) {
        if (!((SchedulerServiceImpl)SchedulerServiceImpl.instance()).isTaskOperationSupported(2L, l, taskInfo)) {
            throw new SecurityException(Messages.getMessage("SCHD0097E", new String[]{SchedulerImpl.getMethodNameFromOperation(l), taskInfo.getClass().getName()}));
        }
    }
}

