/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scheduler;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.scheduler.ByteSerializable;
import com.ibm.ws.scheduler.ByteSerializationUtils;
import com.ibm.ws.scheduler.NotificationSinkHolder;
import com.ibm.ws.scheduler.NotificationSinkHolderI;
import com.ibm.ws.scheduler.Runnable;
import com.ibm.ws.scheduler.SchedulerServiceImpl;
import com.ibm.ws.scheduler.TaskHolderI;
import com.ibm.ws.scheduler.ThreadContextHolder;
import com.ibm.ws.scheduler.ThreadContextHolderI;
import com.ibm.ws.scheduler.UserCalendarHolder;
import com.ibm.ws.scheduler.UserCalendarHolderI;
import com.ibm.ws.scheduler.Utils;
import com.ibm.ws.scheduler.exception.ByteSerializeException;
import com.ibm.ws.scheduler.exception.InvalidVersionException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TaskInfoBinaryData
implements TaskHolderI,
Serializable,
ByteSerializable {
    private static final TraceComponent tc = Tr.register(TaskInfoBinaryData.class, "Scheduler", "com.ibm.ws.scheduler.resources.SchedulerMessages");
    private static final long serialVersionUID = 393216L;
    public static final short VER_6_0_0 = 1536;
    private static final short FIELD_QUANTITY = 11;
    private static final short BYTEID_J2EENAME = 9473;
    private static final short BYTEID_CTXHOLDER = 9474;
    private static final short BYTEID_USERCALHOLDER = 9475;
    private static final short BYTEID_NOTIFSINKHOLDER = 9476;
    private static final short BYTEID_TARGETRUNNABLE = 9477;
    private static final short BYTEID_USERINFO = 9478;
    private static final short BYTEID_RECOVERYOPTION = 9479;
    private static final short BYTEID_TIMECALCMETHOD = 9480;
    private static final short BYTEID_EXECUTIONOPTIONS = 9481;
    private static final short BYTEID_AUTHENTICATIONALIAS = 9482;
    private static final short BYTEID_EXPECTEDDURATION = 9483;
    private static final short VERSID_J2EENAME = 1536;
    private static final short VERSID_CTXHOLDER = 1536;
    private static final short VERSID_USERCALHOLDER = 1536;
    private static final short VERSID_NOTIFSINKHOLDER = 1536;
    private static final short VERSID_TARGETRUNNABLE = 1536;
    private static final short VERSID_USERINFO = 1536;
    private static final short VERSID_RECOVERYOPTION = 1536;
    private static final short VERSID_TIMECALCMETHOD = 1536;
    private static final short VERSID_EXECUTIONOPTIONS = 1536;
    private static final short VERSID_AUTHENTICATIONALIAS = 1536;
    private static final short VERSID_EXPECTEDDURATION = 1536;
    private transient J2EEName j2eeName;
    private transient ThreadContextHolderI threadContextHolder;
    private transient UserCalendarHolderI userCalendarHolder = null;
    private transient NotificationSinkHolderI notificationSinkHolder = null;
    private transient Runnable targetRunnable = null;
    private transient byte[] userInfo = null;
    private transient int recoveryOption = 0;
    private transient int timeCalcMethod = 0;
    private transient int executionOptions = 0;
    private transient String authenticationAlias = null;
    private transient int expectedDuration = 0;
    private transient boolean ds_j2eeName = true;
    private transient boolean ds_threadContextHolder = true;
    private transient boolean ds_userCalendarHolder = true;
    private transient boolean ds_notificationSinkHolder = true;
    private transient boolean ds_targetRunnable = true;
    private transient boolean ds_userInfo = true;
    private transient boolean ds_recoveryOption = true;
    private transient boolean ds_timeCalcMethod = true;
    private transient boolean ds_executionOptions = true;
    private transient boolean ds_authenticationAlias = true;
    private transient boolean ds_expectedDuration = true;
    private transient byte[] bytes = null;
    private transient Object bytesLock = new Object();
    private transient boolean isDirty = false;

    public TaskInfoBinaryData() {
    }

    public TaskInfoBinaryData(byte[] byArray) {
        this();
        this.bytes = byArray;
        this.ds_j2eeName = false;
        this.ds_threadContextHolder = false;
        this.ds_userCalendarHolder = false;
        this.ds_notificationSinkHolder = false;
        this.ds_targetRunnable = false;
        this.ds_userInfo = false;
        this.ds_recoveryOption = false;
        this.ds_timeCalcMethod = false;
        this.ds_executionOptions = false;
        this.ds_authenticationAlias = false;
        this.ds_expectedDuration = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "writeObject");
        }
        try {
            objectOutputStream.defaultWriteObject();
            objectOutputStream.writeObject(this.getBytes());
        }
        finally {
            if (bl) {
                Tr.exit(tc, "writeObject");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "readObject");
        }
        try {
            this.bytesLock = new Object();
            objectInputStream.defaultReadObject();
            byte[] byArray = (byte[])objectInputStream.readObject();
            this.setBytes(byArray);
        }
        finally {
            if (bl) {
                Tr.exit(tc, "readObject");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getObjectByIDAndVersion(short s, short s2, J2EEName j2EEName) throws ByteSerializeException, InvalidVersionException {
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "getObjectByIDAndVersion", new Object[]{"0x" + Integer.toHexString(s), "0x" + Integer.toHexString(s2), j2EEName});
        }
        try {
            Object object = this.bytesLock;
            synchronized (object) {
                Object object2 = ByteSerializationUtils.getObjectByIDAndVersion(this.bytes, new short[]{s}, new short[]{s2}, new J2EEName[]{j2EEName}, null)[0];
                if (bl) {
                    Tr.exit(tc, "getObjectByIDAndVersion", object2);
                }
                return object2;
            }
        }
        catch (InvalidVersionException invalidVersionException) {
            if (bl) {
                Tr.exit(tc, "getObjectByIDAndVersion", new Object[]{invalidVersionException});
            }
            throw invalidVersionException;
        }
        catch (ByteSerializeException byteSerializeException) {
            FFDCFilter.processException(byteSerializeException, "com.ibm.ws.scheduler.TaskInfoBinaryData.getBytesByIDAndVersion", "370");
            if (bl) {
                Tr.exit(tc, "getObjectByIDAndVersion", new Object[]{byteSerializeException});
            }
            throw byteSerializeException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.TaskInfoBinaryData.getBytesByIDAndVersion", "380");
            if (bl) {
                Tr.exit(tc, "getObjectByIDAndVersion", new Object[]{throwable});
            }
            throw new ByteSerializeException(Utils.getExceptionMessageWithType(throwable), throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBytes(byte[] byArray) {
        Object object = this.bytesLock;
        synchronized (object) {
            this.bytes = byArray;
            this.ds_j2eeName = false;
            this.ds_threadContextHolder = false;
            this.ds_userCalendarHolder = false;
            this.ds_notificationSinkHolder = false;
            this.ds_targetRunnable = false;
            this.ds_userInfo = false;
            this.ds_recoveryOption = false;
            this.ds_timeCalcMethod = false;
            this.ds_executionOptions = false;
            this.ds_authenticationAlias = false;
            this.ds_expectedDuration = false;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getBytes() throws ByteSerializeException {
        boolean bl = tc.isEntryEnabled();
        boolean bl2 = tc.isDebugEnabled();
        if (bl) {
            Tr.entry(tc, "getBytes");
        }
        Object object = this.bytesLock;
        synchronized (object) {
            Object object2;
            block27: {
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                    ByteSerializationUtils.writeHeader(objectOutputStream, (short)11);
                    if (this.ds_j2eeName) {
                        object2 = this.getJ2EEName();
                        ByteSerializationUtils.writeFieldObject(objectOutputStream, (short)9473, (short)1536, object2 == null ? null : object2.getBytes());
                    } else {
                        objectOutputStream.write(ByteSerializationUtils.getFieldBytesByIDAndVersion(this.bytes, (short)9473, (short)1536));
                    }
                    if (this.ds_threadContextHolder) {
                        ByteSerializationUtils.writeFieldByteSerializable(objectOutputStream, (short)9474, (short)1536, (ThreadContextHolder)this.getThreadContextHolder());
                    } else {
                        objectOutputStream.write(ByteSerializationUtils.getFieldBytesByIDAndVersion(this.bytes, (short)9474, (short)1536));
                    }
                    if (this.ds_userCalendarHolder) {
                        ByteSerializationUtils.writeFieldByteSerializable(objectOutputStream, (short)9475, (short)1536, this.getUserCalendarHolder());
                    } else {
                        objectOutputStream.write(ByteSerializationUtils.getFieldBytesByIDAndVersion(this.bytes, (short)9475, (short)1536));
                    }
                    if (this.ds_notificationSinkHolder) {
                        ByteSerializationUtils.writeFieldByteSerializable(objectOutputStream, (short)9476, (short)1536, this.getNotificationSinkHolder());
                    } else {
                        objectOutputStream.write(ByteSerializationUtils.getFieldBytesByIDAndVersion(this.bytes, (short)9476, (short)1536));
                    }
                    if (this.ds_targetRunnable) {
                        ByteSerializationUtils.writeFieldObject(objectOutputStream, (short)9477, (short)1536, this.getTargetRunnable());
                    } else {
                        objectOutputStream.write(ByteSerializationUtils.getFieldBytesByIDAndVersion(this.bytes, (short)9477, (short)1536));
                    }
                    if (this.ds_userInfo) {
                        ByteSerializationUtils.writeFieldBytes(objectOutputStream, (short)9478, (short)1536, this.getUserInfo());
                    } else {
                        objectOutputStream.write(ByteSerializationUtils.getFieldBytesByIDAndVersion(this.bytes, (short)9478, (short)1536));
                    }
                    ByteSerializationUtils.writeFieldInt(objectOutputStream, (short)9479, (short)1536, this.getRecoveryOption());
                    ByteSerializationUtils.writeFieldInt(objectOutputStream, (short)9480, (short)1536, this.getTimeCalcMethod());
                    ByteSerializationUtils.writeFieldInt(objectOutputStream, (short)9481, (short)1536, this.getTaskExecutionOptions());
                    if (this.ds_authenticationAlias) {
                        ByteSerializationUtils.writeFieldObject(objectOutputStream, (short)9482, (short)1536, this.getAuthenticationAlias());
                    } else {
                        objectOutputStream.write(ByteSerializationUtils.getFieldBytesByIDAndVersion(this.bytes, (short)9482, (short)1536));
                    }
                    ByteSerializationUtils.writeFieldInt(objectOutputStream, (short)9483, (short)1536, this.getExpectedDuration());
                    objectOutputStream.flush();
                    objectOutputStream.close();
                    if (bl2) {
                        Tr.debug(tc, "Old byte[] Len: " + (this.bytes == null ? -1 : this.bytes.length));
                    }
                    this.bytes = byteArrayOutputStream.toByteArray();
                    if (bl2) {
                        Tr.debug(tc, "New byte[] Len: " + (this.bytes == null ? -1 : this.bytes.length));
                    }
                    byteArrayOutputStream.close();
                    object2 = this.bytes;
                    if (!bl) break block27;
                }
                catch (ByteSerializeException byteSerializeException) {
                    try {
                        FFDCFilter.processException((Throwable)byteSerializeException, "com.ibm.ws.scheduler.TaskInfoBinaryData.getBytes", "640", this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception in getBytes: " + byteSerializeException);
                        }
                        throw byteSerializeException;
                        catch (Throwable throwable) {
                            FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.TaskInfoBinaryData.getBytes", "650", this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Exception in getBytes: " + throwable);
                            }
                            throw new ByteSerializeException(Utils.getExceptionMessageWithType(throwable), throwable);
                        }
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Tr.exit(tc, "getBytes", new Object[]{this.bytes});
                        }
                        throw throwable;
                    }
                }
                Tr.exit(tc, "getBytes", new Object[]{this.bytes});
            }
            return object2;
        }
    }

    public void setIsDirty(boolean bl) {
        this.isDirty = bl;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public String getAuthenticationAlias() {
        if (!this.ds_authenticationAlias) {
            this.authenticationAlias = (String)this.getObjectByIDAndVersion((short)9482, (short)1536, null);
            this.ds_authenticationAlias = true;
        }
        return this.authenticationAlias;
    }

    public int getTaskExecutionOptions() {
        if (!this.ds_executionOptions) {
            Integer n = (Integer)this.getObjectByIDAndVersion((short)9481, (short)1536, null);
            if (n != null) {
                this.executionOptions = n;
            }
            this.ds_executionOptions = true;
        }
        return this.executionOptions;
    }

    public J2EEName getJ2EEName() {
        if (!this.ds_j2eeName) {
            byte[] byArray = (byte[])this.getObjectByIDAndVersion((short)9473, (short)1536, null);
            this.j2eeName = byArray == null ? null : ((SchedulerServiceImpl)SchedulerServiceImpl.instance()).getJ2EENameFactory().create(byArray);
            this.ds_j2eeName = true;
        }
        return this.j2eeName;
    }

    public NotificationSinkHolderI getNotificationSinkHolder() {
        if (!this.ds_notificationSinkHolder) {
            byte[] byArray = (byte[])this.getObjectByIDAndVersion((short)9476, (short)1536, null);
            if (byArray == null) {
                this.notificationSinkHolder = null;
            } else {
                this.notificationSinkHolder = new NotificationSinkHolder();
                ByteSerializationUtils.getObjectFromBytes(byArray, this.notificationSinkHolder, this.getJ2EEName());
            }
            this.ds_notificationSinkHolder = true;
        }
        return this.notificationSinkHolder;
    }

    public int getRecoveryOption() {
        if (!this.ds_recoveryOption) {
            Integer n = (Integer)this.getObjectByIDAndVersion((short)9479, (short)1536, null);
            if (n != null) {
                this.recoveryOption = n;
            }
            this.ds_recoveryOption = true;
        }
        return this.recoveryOption;
    }

    public Runnable getTargetRunnable() {
        if (!this.ds_targetRunnable) {
            this.targetRunnable = (Runnable)this.getObjectByIDAndVersion((short)9477, (short)1536, this.getJ2EEName());
            this.ds_targetRunnable = true;
        }
        return this.targetRunnable;
    }

    public ThreadContextHolderI getThreadContextHolder() {
        if (!this.ds_threadContextHolder) {
            byte[] byArray = (byte[])this.getObjectByIDAndVersion((short)9474, (short)1536, null);
            if (byArray == null) {
                this.threadContextHolder = null;
            } else {
                this.threadContextHolder = new ThreadContextHolder();
                ByteSerializationUtils.getObjectFromBytes(byArray, (ThreadContextHolder)this.threadContextHolder, null);
            }
            this.ds_threadContextHolder = true;
        }
        return this.threadContextHolder;
    }

    public int getTimeCalcMethod() {
        if (!this.ds_timeCalcMethod) {
            Integer n = (Integer)this.getObjectByIDAndVersion((short)9480, (short)1536, null);
            if (n != null) {
                this.timeCalcMethod = n;
            }
            this.ds_timeCalcMethod = true;
        }
        return this.timeCalcMethod;
    }

    public UserCalendarHolderI getUserCalendarHolder() {
        if (!this.ds_userCalendarHolder) {
            byte[] byArray = (byte[])this.getObjectByIDAndVersion((short)9475, (short)1536, null);
            if (byArray == null) {
                this.userCalendarHolder = null;
            } else {
                this.userCalendarHolder = new UserCalendarHolder();
                ByteSerializationUtils.getObjectFromBytes(byArray, this.userCalendarHolder, this.getJ2EEName());
            }
            this.ds_userCalendarHolder = true;
        }
        return this.userCalendarHolder;
    }

    public byte[] getUserInfo() {
        if (!this.ds_userInfo) {
            this.userInfo = (byte[])this.getObjectByIDAndVersion((short)9478, (short)1536, null);
            this.ds_userInfo = true;
        }
        return this.userInfo;
    }

    public int getExpectedDuration() {
        if (!this.ds_expectedDuration) {
            Integer n = (Integer)this.getObjectByIDAndVersion((short)9483, (short)1536, null);
            if (n != null) {
                this.expectedDuration = n;
            }
            this.ds_expectedDuration = true;
        }
        return this.expectedDuration;
    }

    public void setAuthenticationAlias(String string) {
        this.ds_authenticationAlias = true;
        this.authenticationAlias = string;
    }

    public void setTaskExecutionOptions(int n) {
        this.ds_executionOptions = true;
        this.executionOptions = n;
    }

    public void setJ2EEName(J2EEName j2EEName) {
        this.ds_j2eeName = true;
        this.j2eeName = j2EEName;
    }

    public void setNotificationSinkHolder(NotificationSinkHolderI notificationSinkHolderI) {
        this.ds_notificationSinkHolder = true;
        this.notificationSinkHolder = notificationSinkHolderI;
    }

    public void setRecoveryOption(int n) {
        this.ds_recoveryOption = true;
        this.recoveryOption = n;
    }

    public void setTargetRunnable(Runnable runnable) {
        this.ds_targetRunnable = true;
        this.targetRunnable = runnable;
    }

    public void setThreadContextHolder(ThreadContextHolderI threadContextHolderI) {
        this.ds_threadContextHolder = true;
        this.threadContextHolder = threadContextHolderI;
    }

    public void setTimeCalcMethod(int n) {
        this.ds_timeCalcMethod = true;
        this.timeCalcMethod = n;
    }

    public void setUserCalendarHolder(UserCalendarHolderI userCalendarHolderI) {
        this.ds_userCalendarHolder = true;
        this.userCalendarHolder = userCalendarHolderI;
    }

    public void setUserInfo(byte[] byArray) {
        this.ds_userInfo = true;
        this.userInfo = byArray;
    }

    public void setExpectedDuration(int n) {
        this.ds_expectedDuration = true;
        this.expectedDuration = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("TaskInfoBinaryData: [");
        stringBuffer.append("BYTELEN=").append(this.bytes == null ? -1 : this.bytes.length).append(", ");
        stringBuffer.append("J2EENME=").append(this.j2eeName).append(", ");
        stringBuffer.append("THDCTXH=").append(this.threadContextHolder).append(", ");
        stringBuffer.append("USRCALH=").append(this.userCalendarHolder).append(", ");
        stringBuffer.append("NOSINKH=").append(this.notificationSinkHolder).append(", ");
        stringBuffer.append("TGTRUNN=").append(this.targetRunnable).append(", ");
        stringBuffer.append("USERINF=").append(this.userInfo).append(", ");
        stringBuffer.append("RCOVOPT=").append(this.recoveryOption).append(", ");
        stringBuffer.append("TIMEOPT=").append(this.timeCalcMethod).append(", ");
        stringBuffer.append("EXECOPT=").append(this.executionOptions).append(", ");
        stringBuffer.append("AUTHALS=").append(this.authenticationAlias).append(", ");
        stringBuffer.append("EXPTDUR=").append(this.expectedDuration).append(", ");
        stringBuffer.append("ISDIRTY=").append(this.isDirty);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

