/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scheduler;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.scheduler.AbstractTask;
import com.ibm.ws.scheduler.spi.TaskInfo;
import com.ibm.ws.scheduler.spi.TaskStatus;
import java.util.Date;

public class TaskStatusImpl
implements TaskStatus {
    private static final TraceComponent tc = Tr.register(TaskStatusImpl.class, "Scheduler", "com.ibm.ws.scheduler.resources.SchedulerMessages");
    private int status = 0;
    protected String TASKID = null;
    protected String NAME = null;
    protected int REPEATSLEFT = 0;
    protected Date NEXTFIRETIME = null;
    protected Date CREATETIME = null;
    private static final long serialVersionUID = -1839671640150939645L;

    public TaskStatusImpl() {
    }

    public TaskStatusImpl(TaskInfo taskInfo) {
        this.status = TaskStatusImpl.getStatus(taskInfo);
        this.TASKID = taskInfo.getTaskId();
        this.NAME = taskInfo.getName();
        this.REPEATSLEFT = taskInfo.getRepeatsLeft();
        this.NEXTFIRETIME = taskInfo.getNextFireTime();
        this.CREATETIME = taskInfo.getCreateTime();
    }

    public TaskStatusImpl(TaskInfo taskInfo, int n) {
        this.status = n;
        this.TASKID = taskInfo.getTaskId();
        this.NAME = taskInfo.getName();
        this.REPEATSLEFT = taskInfo.getRepeatsLeft();
        this.NEXTFIRETIME = taskInfo.getNextFireTime();
        this.CREATETIME = taskInfo.getCreateTime();
    }

    public TaskStatusImpl(String string, int n, String string2, int n2, Date date, Date date2) {
        this.TASKID = string;
        this.status = n;
        this.NAME = string2;
        this.REPEATSLEFT = n2;
        this.NEXTFIRETIME = date;
        this.CREATETIME = date2;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public String getTaskId() {
        return this.TASKID;
    }

    public String getName() {
        return this.NAME;
    }

    public int getRepeatsLeft() {
        return this.REPEATSLEFT;
    }

    public Date getNextFireTime() {
        return this.NEXTFIRETIME;
    }

    public Date getTimeCreated() {
        return this.CREATETIME;
    }

    private static int getStatus(TaskInfo taskInfo) {
        return TaskStatusImpl.getStatus(taskInfo.getRepeatsLeft(), taskInfo.getSuspended(), taskInfo.getCancelled(), taskInfo.getRunning(), taskInfo.getAutoPurge());
    }

    public static int getStatus(int n, boolean bl, byte by, boolean bl2) {
        return TaskStatusImpl.getStatus(n, TaskStatusImpl.isSuspended(by), bl, TaskStatusImpl.isRunning(by), bl2);
    }

    public static int getStatus(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (bl3 && !bl2 && !bl) {
            return 5;
        }
        if (n == 0 && !bl3) {
            if (bl4) {
                return -1;
            }
            return 4;
        }
        if (bl2) {
            return 3;
        }
        if (bl) {
            return 2;
        }
        return 1;
    }

    public void setStatus(TaskInfo taskInfo) {
        this.status = TaskStatusImpl.getStatus(taskInfo);
    }

    public int hashCode() {
        return TaskStatusImpl.getLongFromTaskID(this.TASKID).intValue();
    }

    protected static Long getLongFromTaskID(String string) {
        if (string == null || string.length() == 0) {
            return new Long(-1L);
        }
        return Long.valueOf(string, 10);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof TaskStatusImpl)) {
            return super.equals(object);
        }
        if (object instanceof AbstractTask) {
            AbstractTask abstractTask = (AbstractTask)object;
            return (abstractTask.TASKID == null && this.TASKID == null || abstractTask.TASKID.equals(this.TASKID)) && (abstractTask.CREATETIME == null && this.CREATETIME == null || abstractTask.CREATETIME.equals(this.CREATETIME)) && (abstractTask.NAME == null && this.NAME == null || abstractTask.NAME.equals(this.NAME)) && (abstractTask.NEXTFIRETIME == null && this.NEXTFIRETIME == null || abstractTask.NEXTFIRETIME.equals(this.NEXTFIRETIME)) && abstractTask.REPEATSLEFT == this.REPEATSLEFT;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean canRun() {
        return this.status == 5 || this.status == 1;
    }

    public String toString() {
        if (tc.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("TaskStatusImpl: [");
            stringBuffer.append("TASKID=");
            stringBuffer.append(this.TASKID);
            stringBuffer.append(", ");
            stringBuffer.append("STATUS=");
            stringBuffer.append(TaskStatusImpl.getStatusAsString(this.status));
            stringBuffer.append(", ");
            stringBuffer.append("NAME=");
            stringBuffer.append(this.NAME);
            stringBuffer.append(", ");
            stringBuffer.append("CREATETIME=");
            stringBuffer.append(this.CREATETIME);
            stringBuffer.append(", ");
            stringBuffer.append("NEXTFIRETIME=");
            stringBuffer.append(this.NEXTFIRETIME);
            stringBuffer.append(", ");
            stringBuffer.append("REPEATSLEFT=");
            stringBuffer.append(this.REPEATSLEFT);
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
        return super.toString();
    }

    public static boolean isRunning(byte by) {
        return (by & 2) == 2;
    }

    public static byte setRunningBit(byte by, boolean bl) {
        if (bl) {
            by = (byte)(by | 2);
            return by;
        }
        by = (byte)(by & 0xFFFFFFFD);
        return by;
    }

    public static boolean isSuspended(byte by) {
        return (by & 1) == 1;
    }

    public static byte setSuspendedBit(byte by, boolean bl) {
        if (bl) {
            by = (byte)(by | 1);
            return by;
        }
        by = (byte)(by & 0xFFFFFFFE);
        return by;
    }

    public static String getStatusAsString(int n) {
        switch (n) {
            case 3: {
                return "CANCELLED";
            }
            case 4: {
                return "COMPLETE";
            }
            case -1: {
                return "INVALID";
            }
            case 5: {
                return "RUNNING";
            }
            case 1: {
                return "SCHEDULED";
            }
            case 2: {
                return "SUSPENDED";
            }
        }
        return "UNKNOWN(" + n + ")";
    }
}

