/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scheduler;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ce.cm.DuplicateKeyException;
import com.ibm.websphere.scheduler.SchedulerNotAvailableException;
import com.ibm.websphere.scheduler.TaskInvalid;
import com.ibm.websphere.scheduler.TaskPending;
import com.ibm.websphere.scheduler.TaskStatus;
import com.ibm.ws.extensionhelper.TransactionControl;
import com.ibm.ws.extensionhelper.TxHandle;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.scheduler.AbstractTask;
import com.ibm.ws.scheduler.BlobInfo;
import com.ibm.ws.scheduler.CfgHelperTask;
import com.ibm.ws.scheduler.DBHelper;
import com.ibm.ws.scheduler.LazyTaskHolder;
import com.ibm.ws.scheduler.LazyTaskHolderI;
import com.ibm.ws.scheduler.Range;
import com.ibm.ws.scheduler.SchedulerServiceImpl;
import com.ibm.ws.scheduler.SecurityControlImpl;
import com.ibm.ws.scheduler.TaskInfoBinaryData;
import com.ibm.ws.scheduler.TaskStatusImpl;
import com.ibm.ws.scheduler.TaskStore;
import com.ibm.ws.scheduler.Utils;
import com.ibm.ws.scheduler.config.SchedulerConfiguration;
import com.ibm.ws.scheduler.exception.RowVersionNotUpdated;
import com.ibm.ws.scheduler.exception.SchedulerDataStoreException;
import com.ibm.ws.scheduler.exception.TaskLoadException;
import com.ibm.ws.scheduler.exception.TaskVersionMismatch;
import com.ibm.ws.scheduler.resources.Messages;
import com.ibm.ws.scheduler.spi.Scheduler;
import com.ibm.ws.scheduler.spi.TaskInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import javax.naming.NamingException;

class TaskStoreImpl
implements TaskStore {
    private static final TraceComponent tc = Tr.register(TaskStoreImpl.class, "Scheduler", "com.ibm.ws.scheduler.resources.SchedulerMessages");
    protected DBHelper dbHelper = null;
    protected static Map partitionIDs = new HashMap();
    protected static int LOCK_RETRY_COUNT = 5;
    protected static int LOCK_RETRY_WAIT = 1000;
    protected static Map taskIDs = new HashMap();
    protected static Random rnd = new Random(System.currentTimeMillis());
    protected int[] conv50Partitions;
    protected int[] nonconv50Partitions;

    public TaskStoreImpl(DBHelper dBHelper) throws NamingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.dbHelper = dBHelper;
        Scheduler scheduler = dBHelper.getScheduler();
        if (scheduler != null) {
            SchedulerConfiguration schedulerConfiguration = scheduler.getSchedulerConfiguration();
            if (schedulerConfiguration.getDisableV50TaskInteroperability()) {
                this.conv50Partitions = new int[0];
                this.nonconv50Partitions = new int[0];
            } else {
                int n = schedulerConfiguration.getPartitionRangeLBound_50();
                int n2 = schedulerConfiguration.getPartitionRangeUBound_50();
                this.conv50Partitions = new int[n2 - n + 1];
                this.nonconv50Partitions = new int[n2 - n + 1];
                int n3 = 0;
                int n4 = n;
                while (n4 <= n2) {
                    this.conv50Partitions[n3] = n4 * 1000;
                    this.nonconv50Partitions[n3] = n4++;
                    ++n3;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    protected int getRandomPartitionID() {
        SchedulerConfiguration schedulerConfiguration = this.dbHelper.getScheduler().getSchedulerConfiguration();
        int n = schedulerConfiguration.getPartitionRangeUBound() - schedulerConfiguration.getPartitionRangeLBound() + 1;
        int n2 = rnd.nextInt(n);
        return n2 + schedulerConfiguration.getPartitionRangeLBound();
    }

    /*
     * Loose catch block
     */
    public TaskInfo create(Connection connection, TaskInfo taskInfo) throws SchedulerNotAvailableException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create: " + taskInfo.getTaskId());
        }
        long l = -1L;
        String string = "";
        int n = 0;
        int n2 = -1;
        byte by = 0;
        boolean bl = false;
        long l2 = 0L;
        String string2 = null;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        String string3 = null;
        int n3 = 0;
        int n4 = 0;
        byte[] byArray = null;
        String string4 = null;
        boolean bl2 = false;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        String string5 = null;
        long l6 = 0L;
        boolean bl3 = taskInfo.getTaskId() != null;
        try {
            SchedulerServiceImpl schedulerServiceImpl = null;
            boolean bl4 = taskInfo instanceof CfgHelperTask;
            if (!bl4) {
                schedulerServiceImpl = (SchedulerServiceImpl)SchedulerServiceImpl.instance();
            }
            Statement statement = null;
            try {
                Cloneable cloneable;
                String string6 = this.dbHelper.getSQLStatement("CREATE", "TASK");
                boolean bl5 = false;
                int n9 = 25;
                int n10 = 0;
                while (!bl5 && n10 <= n9) {
                    statement = connection.prepareStatement(string6);
                    if (!bl3) {
                        taskInfo.setTaskId(this.getNextTaskID(connection));
                    }
                    l = TaskStoreImpl.getLongTaskID(taskInfo.getTaskId());
                    this.setLong((PreparedStatement)statement, 1, l);
                    string = taskInfo.getVersion();
                    statement.setString(2, string);
                    n = taskInfo.getRowVersion() + 1;
                    taskInfo.setRowVersion(n);
                    statement.setInt(3, n);
                    n2 = bl4 ? 32768 : schedulerServiceImpl.getTaskIDFromTaskInfoImplementation(taskInfo.getClass());
                    statement.setInt(4, n2);
                    by = taskInfo.getStateBits();
                    statement.setByte(5, by);
                    bl = taskInfo.getCancelled();
                    statement.setBoolean(6, bl);
                    l2 = taskInfo.getNextFireTime().getTime();
                    this.setLong((PreparedStatement)statement, 7, l2);
                    string2 = taskInfo.getStartByInterval();
                    statement.setString(8, string2);
                    cloneable = taskInfo.getStartByTime();
                    if (cloneable != null) {
                        this.setLong((PreparedStatement)statement, 9, ((Date)cloneable).getTime());
                    } else {
                        this.setNullLong((PreparedStatement)statement, 9);
                    }
                    Date date = taskInfo.getStartTime();
                    if (date != null) {
                        this.setLong((PreparedStatement)statement, 10, date.getTime());
                    } else {
                        this.setNullLong((PreparedStatement)statement, 10);
                    }
                    Date date2 = taskInfo.getValidToTime();
                    if (date2 != null) {
                        this.setLong((PreparedStatement)statement, 11, date2.getTime());
                    } else {
                        this.setNullLong((PreparedStatement)statement, 11);
                    }
                    string3 = taskInfo.getRepeatInterval();
                    statement.setString(12, string3);
                    n3 = taskInfo.getMaximumRepeats();
                    statement.setInt(13, n3);
                    n4 = taskInfo.getRepeatsLeft();
                    statement.setInt(14, n4);
                    byArray = string.equals("50") ? this.serialize(taskInfo.getTaskHolder()) : taskInfo.getTaskHolder().getBytes();
                    statement.setBinaryStream(15, new ByteArrayInputStream(byArray), byArray.length);
                    string4 = taskInfo.getName();
                    if (string4 == null) {
                        string4 = "";
                    }
                    statement.setString(16, string4);
                    bl2 = taskInfo.getAutoPurge();
                    statement.setBoolean(17, bl2);
                    n5 = taskInfo.getFailureAction();
                    statement.setInt(18, n5);
                    n6 = taskInfo.getMaximumAttempts();
                    statement.setInt(19, n6);
                    n7 = taskInfo.getQOS();
                    statement.setInt(20, n7);
                    n8 = bl4 ? 0 : this.getRandomPartitionID();
                    taskInfo.setPartition(n8);
                    statement.setInt(21, n8);
                    string5 = bl4 ? "ADMIN" : SecurityControlImpl.getOwnerToken(taskInfo.getJ2EEName());
                    statement.setString(22, string5);
                    taskInfo.setCreateTime(new Date());
                    l6 = taskInfo.getCreateTime().getTime();
                    this.setLong((PreparedStatement)statement, 23, l6);
                    if (tc.isDebugEnabled()) {
                        int n11 = 0;
                        if (byArray != null) {
                            n11 = byArray.length;
                        }
                        Tr.debug(tc, "Create parameters: ", new Object[]{new Long(l), string, new Integer(n), new Integer(n2), new Byte(by), new Boolean(bl), new Long(l2), string2, new Long(l3), new Long(l4), new Long(l5), string3, new Integer(n3), new Integer(n4), new Integer(n11), string4, new Boolean(bl2), new Integer(n5), new Integer(n6), new Integer(n7), new Integer(n8), string5, new Long(l6)});
                    }
                    try {
                        ++n10;
                        if (this.executeUpdateWithRetry((PreparedStatement)statement) != 1) {
                            throw new SchedulerNotAvailableException(Messages.getMessage("SCHD0056W", new Object[]{taskInfo.getTaskId(), this.dbHelper.getScheduler().getSchedulerConfiguration().getName(), this.dbHelper.getScheduler().getSchedulerConfiguration().getJndiName()}));
                        }
                        bl5 = true;
                    }
                    catch (DuplicateKeyException duplicateKeyException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "DuplicateKeyException during update/create: TASKID=" + l + ", RETRY#:" + n10);
                        }
                        try {
                            if (statement != null) {
                                statement.close();
                            }
                        }
                        catch (Throwable throwable) {
                            FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.TaskStoreImpl.create", "412", this);
                        }
                        if (!bl3) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Duplicate task id detected while updating.  Aborting for task: " + l);
                        }
                        throw duplicateKeyException;
                    }
                }
                cloneable = taskInfo;
                return cloneable;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.TaskStoreImpl.create", "187", this);
                this.dumpSQLExceptionInfo(throwable);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Caught exception: ", throwable);
                }
                if (throwable instanceof SchedulerNotAvailableException) {
                    throw (SchedulerNotAvailableException)throwable;
                }
                throw new SchedulerNotAvailableException(Utils.getExceptionMessageWithType(throwable), throwable);
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.TaskStoreImpl.create", "200", this);
                }
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "create");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Connection connection, TaskInfo taskInfo) throws SchedulerNotAvailableException, RowVersionNotUpdated, TaskPending {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "update", new Object[]{taskInfo == null ? null : taskInfo.getClass(), taskInfo});
        }
        int n = -1;
        long l = -1L;
        String string = "";
        int n2 = 0;
        byte by = 0;
        boolean bl = false;
        long l2 = 0L;
        String string2 = null;
        Date date = null;
        Date date2 = null;
        Date date3 = null;
        String string3 = null;
        int n3 = 0;
        int n4 = 0;
        String string4 = null;
        boolean bl2 = false;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        String string5 = null;
        byte[] byArray = null;
        BlobInfo blobInfo = null;
        int n9 = 0;
        try {
            Statement statement = null;
            try {
                String string6;
                boolean bl3;
                boolean bl4 = bl3 = taskInfo.isDirty() || taskInfo.getTaskHolder().isDirty();
                if (bl3) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Writing blob.  Task.isDirty=" + taskInfo.isDirty() + ", TaskHolder.isDirty=" + taskInfo.getTaskHolder().isDirty());
                    }
                    blobInfo = this.getBlobForUpdate(connection, TaskStoreImpl.getLongTaskID(taskInfo.getTaskId()), taskInfo.getRowVersion());
                    string6 = this.dbHelper.getSQLStatement("UPDATEWITHBLOB", "TASK");
                } else {
                    string6 = this.dbHelper.getSQLStatement("UPDATE", "TASK");
                }
                statement = connection.prepareStatement(string6);
                string = taskInfo.getVersion();
                statement.setString(1, string);
                n2 = taskInfo.getRowVersion();
                n9 = n2 + 1;
                taskInfo.setRowVersion(n9);
                statement.setInt(2, n9);
                by = taskInfo.getStateBits();
                statement.setByte(3, by);
                bl = taskInfo.getCancelled();
                statement.setBoolean(4, bl);
                l2 = taskInfo.getNextFireTime().getTime();
                this.setLong((PreparedStatement)statement, 5, l2);
                string2 = taskInfo.getStartByInterval();
                statement.setString(6, string2);
                date = taskInfo.getStartByTime();
                if (date != null) {
                    this.setLong((PreparedStatement)statement, 7, date.getTime());
                } else {
                    this.setNullLong((PreparedStatement)statement, 7);
                }
                date2 = taskInfo.getStartTime();
                if (date2 != null) {
                    this.setLong((PreparedStatement)statement, 8, date2.getTime());
                } else {
                    this.setNullLong((PreparedStatement)statement, 8);
                }
                date3 = taskInfo.getValidToTime();
                if (date3 != null) {
                    this.setLong((PreparedStatement)statement, 9, date3.getTime());
                } else {
                    this.setNullLong((PreparedStatement)statement, 9);
                }
                string3 = taskInfo.getRepeatInterval();
                statement.setString(10, string3);
                n3 = taskInfo.getMaximumRepeats();
                statement.setInt(11, n3);
                n4 = taskInfo.getRepeatsLeft();
                statement.setInt(12, n4);
                string4 = taskInfo.getName();
                if (string4 == null) {
                    string4 = "";
                }
                statement.setString(13, string4);
                bl2 = taskInfo.getAutoPurge();
                statement.setBoolean(14, bl2);
                n5 = taskInfo.getFailureAction();
                statement.setInt(15, n5);
                n6 = taskInfo.getMaximumAttempts();
                statement.setInt(16, n6);
                n7 = taskInfo.getQOS();
                statement.setInt(17, n7);
                n8 = taskInfo.getPartition();
                statement.setInt(18, n8);
                string5 = SecurityControlImpl.getOwnerToken(taskInfo.getJ2EEName());
                statement.setString(19, string5);
                int n10 = 20;
                int n11 = 21;
                if (bl3) {
                    byArray = string.equals("50") ? this.serialize(taskInfo.getTaskHolder()) : taskInfo.getTaskHolder().getBytes();
                    if (blobInfo != null) {
                        this.setBlob((PreparedStatement)statement, 20, blobInfo.getBlob(), byArray);
                    } else {
                        statement.setBinaryStream(20, new ByteArrayInputStream(byArray), byArray.length);
                    }
                    n10 = 21;
                    n11 = 22;
                }
                l = TaskStoreImpl.getLongTaskID(taskInfo.getTaskId());
                this.setLong((PreparedStatement)statement, n10, l);
                statement.setInt(n11, n2);
                taskInfo.setPartition(n8);
                n = this.executeUpdateWithRetry((PreparedStatement)statement);
                try {
                    if (blobInfo != null) {
                        blobInfo.close();
                    }
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.scheduler.TaskStoreImpl.update", "200", this);
                }
                if (n != 1) {
                    throw new TaskPending(Messages.getMessage("SCHD0057W", new Object[]{taskInfo.getTaskId(), this.dbHelper.getScheduler().getSchedulerConfiguration().getName(), this.dbHelper.getScheduler().getSchedulerConfiguration().getJndiName()}));
                }
                if (tc.isDebugEnabled()) {
                    String string7 = "NOBLOB";
                    if (byArray != null && bl3) {
                        string7 = "BLOBLEN=" + byArray.length;
                    }
                    Tr.debug(tc, "Update parameters: ", new Object[]{new Long(l), string, new Integer(n2), new Byte(by), new Boolean(bl), new Long(l2), string2, date, date2, date3, string3, new Integer(n3), new Integer(n4), string4, new Boolean(bl2), new Integer(n5), new Integer(n6), new Integer(n7), new Integer(n8), string5, string7});
                }
            }
            catch (Throwable throwable) {
                TaskPending taskPending;
                SQLException sQLException;
                this.dumpSQLExceptionInfo(throwable);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Caught exception executing update statement: ", new Object[]{throwable, new Byte(by), new Boolean(bl), new Long(l2), date, new Integer(n4), new Integer(n8), new Long(l), new Integer(n2)});
                }
                if (throwable instanceof SQLException && this.isDeadlockException(sQLException = (SQLException)throwable)) {
                    taskPending = new TaskPending(Messages.getMessage("SCHD0058W", new Object[]{taskInfo.getTaskId(), this.dbHelper.getScheduler().getSchedulerConfiguration().getName(), this.dbHelper.getScheduler().getSchedulerConfiguration().getJndiName()}), sQLException);
                }
                if (taskPending instanceof TaskPending) {
                    throw (TaskPending)taskPending;
                }
                FFDCFilter.processException((Throwable)taskPending, "com.ibm.ws.scheduler.TaskStoreImpl.update", "250", this);
                throw new SchedulerNotAvailableException(Utils.getExceptionMessageWithType(taskPending), taskPending);
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.TaskStoreImpl.update", "263", this);
                }
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "update: " + n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(Connection connection, TaskInfo taskInfo) throws SchedulerNotAvailableException, TaskPending {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "remove");
        }
        Statement statement = null;
        int n = -1;
        long l = -1L;
        try {
            String string = this.dbHelper.getSQLStatement("REMOVE", "TASK");
            statement = connection.prepareStatement(string);
            l = TaskStoreImpl.getLongTaskID(taskInfo.getTaskId());
            this.setLong((PreparedStatement)statement, 1, l);
            statement.setInt(2, taskInfo.getRowVersion());
            n = this.executeUpdateWithRetry((PreparedStatement)statement);
            if (n == 1) return;
            throw new TaskPending(Messages.getMessage("SCHD0059W", new Object[]{taskInfo.getTaskId(), this.dbHelper.getScheduler().getSchedulerConfiguration().getName(), this.dbHelper.getScheduler().getSchedulerConfiguration().getJndiName()}));
        }
        catch (TaskPending taskPending) {
            throw taskPending;
        }
        catch (Throwable throwable) {
            TaskPending taskPending;
            SQLException sQLException;
            this.dumpSQLExceptionInfo(throwable);
            if (throwable instanceof SQLException && this.isDeadlockException(sQLException = (SQLException)throwable)) {
                taskPending = new TaskPending(Messages.getMessage("SCHD0060W", new Object[]{taskInfo.getTaskId(), this.dbHelper.getScheduler().getSchedulerConfiguration().getName(), this.dbHelper.getScheduler().getSchedulerConfiguration().getJndiName()}), sQLException);
            }
            if (taskPending instanceof TaskPending) {
                throw (TaskPending)taskPending;
            }
            FFDCFilter.processException((Throwable)taskPending, "com.ibm.ws.scheduler.TaskStoreImpl.remove", "326", this);
            throw new SchedulerNotAvailableException(Utils.getExceptionMessageWithType(taskPending), taskPending);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.TaskStoreImpl.remove", "337", this);
            }
            finally {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "remove: " + n);
                }
            }
        }
    }

    public TaskInfo findByPrimaryKey(Connection connection, String string, String string2, boolean bl) throws TaskInvalid, SchedulerNotAvailableException {
        return this.load(connection, string, string2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String _findByPrimaryKey(Connection connection, String string) throws SchedulerNotAvailableException {
        String string2;
        ResultSet resultSet;
        Statement statement;
        block28: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "_findByPrimaryKey:" + string);
            }
            statement = null;
            resultSet = null;
            string2 = null;
            String string3 = this.dbHelper.getSQLStatement("FINDBYPRIMARYKEY", "TASK");
            statement = connection.prepareStatement(string3);
            this.setLong((PreparedStatement)statement, 1, TaskStoreImpl.getLongTaskID(string));
            resultSet = this.executePrivilegedQueryWithRetry((PreparedStatement)statement);
            if (!this.nextWithRetry(resultSet)) break block28;
            String string4 = string2 = resultSet.getString(1);
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement == null) return string4;
                statement.close();
                return string4;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.TaskStoreImpl._findByPrimaryKey", "588", this);
                return string4;
            }
            finally {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "_findByPrimaryKey: " + string2);
                }
            }
        }
        String string5 = null;
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement == null) return string5;
            statement.close();
            return string5;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.TaskStoreImpl._findByPrimaryKey", "588", this);
            return string5;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "_findByPrimaryKey: " + string2);
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            try {
                Exception exception = privilegedActionException.getException();
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.scheduler.TaskStoreImpl._findByPrimaryKey", "573", this);
                this.dumpSQLExceptionInfo(exception);
                throw new SchedulerNotAvailableException(Utils.getExceptionMessageWithType(exception), exception);
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.TaskStoreImpl._findByPrimaryKey", "576", this);
                    this.dumpSQLExceptionInfo(throwable);
                    throw new SchedulerNotAvailableException(Utils.getExceptionMessageWithType(throwable), throwable);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (statement == null) throw throwable;
                    statement.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    FFDCFilter.processException(throwable2, "com.ibm.ws.scheduler.TaskStoreImpl._findByPrimaryKey", "588", this);
                    throw throwable;
                }
                finally {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "_findByPrimaryKey: " + string2);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskInfo load(Connection connection, String string, String string2, boolean bl) throws SchedulerNotAvailableException, TaskInvalid {
        TaskInfo taskInfo;
        ResultSet resultSet;
        Statement statement;
        block33: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "load", new Object[]{connection, string, string2, "lockTask=" + bl});
            }
            statement = null;
            resultSet = null;
            taskInfo = null;
            if (connection == null) {
                throw new IllegalArgumentException(Messages.getMessage("SCHD0109E", "connection"));
            }
            if (string == null) {
                throw new IllegalArgumentException(Messages.getMessage("SCHD0109E", "taskId"));
            }
            if (string2 == null) {
                throw new IllegalArgumentException(Messages.getMessage("SCHD0109E", "ownerToken"));
            }
            boolean bl2 = false;
            String string3 = "LOAD";
            if (string2.equalsIgnoreCase("ADMIN")) {
                string3 = "LOADALL";
                bl2 = true;
            }
            if (bl) {
                string3 = string3 + "WITHLOCK";
            }
            String string4 = this.dbHelper.getSQLStatement(string3, "TASK");
            statement = connection.prepareStatement(string4);
            this.setLong((PreparedStatement)statement, 1, TaskStoreImpl.getLongTaskID(string));
            if (!bl2) {
                statement.setString(2, string2);
            }
            if (!this.nextWithRetry(resultSet = this.executeQueryWithRetry((PreparedStatement)statement))) break block33;
            try {
                taskInfo = this.loadTaskFromResultSet(resultSet);
            }
            catch (TaskVersionMismatch taskVersionMismatch) {
                throw taskVersionMismatch;
            }
            catch (TaskLoadException taskLoadException) {
                if (this.isBinaryDataLoadException(taskLoadException)) {
                    throw new TaskInvalid(Messages.getMessage("SCHD0061E", new String[]{string, string2}), taskLoadException.getCause());
                }
                throw taskLoadException.getCause();
            }
            TaskInfo taskInfo2 = taskInfo;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.TaskStoreImpl.load", "448", this);
            }
            finally {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "load", taskInfo);
                }
            }
            return taskInfo2;
        }
        try {
            try {
                throw new TaskInvalid(Messages.getMessage("SCHD0061E", new String[]{string, string2}));
            }
            catch (Throwable throwable) {
                if (throwable instanceof TaskInvalid) {
                    throw (TaskInvalid)throwable;
                }
                FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.TaskStoreImpl.load", "432", this);
                this.dumpSQLExceptionInfo(throwable);
                throw new SchedulerNotAvailableException(Utils.getExceptionMessageWithType(throwable), throwable);
            }
        }
        catch (Throwable throwable) {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Throwable throwable2) {
                FFDCFilter.processException(throwable2, "com.ibm.ws.scheduler.TaskStoreImpl.load", "448", this);
            }
            finally {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "load", taskInfo);
                }
            }
            throw throwable;
        }
    }

    protected String getPartitionSQL_FINDTASKSBEFORENOTCOMPLETE(Range[] rangeArray, int[] nArray, int[] nArray2) {
        if (rangeArray == null || rangeArray.length < 1) {
            throw new IllegalArgumentException(Messages.getMessage("SCHD0123E", new String[]{"partitionRanges", "<> null & <> \"\""}));
        }
        StringBuffer stringBuffer = new StringBuffer("(");
        for (int i = 0; i < rangeArray.length; ++i) {
            stringBuffer.append("(");
            stringBuffer.append("PARTITIONID");
            stringBuffer.append(" >= ");
            stringBuffer.append(rangeArray[i].getLbound());
            stringBuffer.append(" AND ");
            stringBuffer.append("PARTITIONID");
            stringBuffer.append(" <= ");
            stringBuffer.append(rangeArray[i].getUbound());
            stringBuffer.append(")");
            if (i >= rangeArray.length - 1) continue;
            stringBuffer.append(" OR ");
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        block1: for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            int n2 = nArray2[i];
            for (int j = 0; j < rangeArray.length; ++j) {
                if (!rangeArray[j].contains(n)) continue;
                if (stringBuffer2.length() > 0) {
                    stringBuffer2.append(", ");
                }
                stringBuffer2.append(n2);
                continue block1;
            }
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer.append(" OR (");
            stringBuffer.append("PARTITIONID");
            stringBuffer.append(" IN (");
            stringBuffer.append(stringBuffer2);
            stringBuffer.append("))");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public PreparedStatement getQuery_FINDTASKSBEFORENOTCOMPLETE(Connection connection, Date date, Range[] rangeArray, int[] nArray, int[] nArray2, boolean bl) throws SQLException {
        String string = this.getPartitionSQL_FINDTASKSBEFORENOTCOMPLETE(rangeArray, nArray, nArray2);
        String string2 = bl ? this.dbHelper.getSQLStatement("FINDTASKSBEFORENOTCOMPLETERECOVERY", "TASK") : this.dbHelper.getSQLStatement("FINDTASKSBEFORENOTCOMPLETE", "TASK");
        string2 = Utils.replaceString(string2, "<findtasks_partitionid_list>", string);
        PreparedStatement preparedStatement = connection.prepareStatement(string2, 1003, 1007);
        this.setLong(preparedStatement, 1, date.getTime());
        return preparedStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskInfo[] loadTasksFromResultSet(ResultSet resultSet, int n) throws SchedulerNotAvailableException {
        TaskInfo[] taskInfoArray;
        boolean bl = tc.isDebugEnabled();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadTasksFromResultSet", new Object[]{this.dbHelper.getRealTableName("TASK") + "," + new Integer(n)});
        }
        int n2 = 0;
        try {
            ArrayList<TaskInfo> arrayList = new ArrayList<TaskInfo>(n);
            long l = System.currentTimeMillis();
            while (n2 < n && this.nextWithRetry(resultSet)) {
                long l2 = -1L;
                try {
                    try {
                        TaskInfo taskInfo = this.loadTaskFromResultSet(resultSet);
                        arrayList.add(taskInfo);
                        ++n2;
                    }
                    catch (TaskVersionMismatch taskVersionMismatch) {
                    }
                    catch (TaskLoadException taskLoadException) {
                        l2 = taskLoadException.getTaskID();
                        if (this.isBinaryDataLoadException(taskLoadException)) {
                            throw new TaskInvalid(Messages.getMessage("SCHD0061E", new String[]{TaskStoreImpl.getStringTaskID(l2), "NA"}), taskLoadException.getCause());
                        }
                        throw taskLoadException.getCause();
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.TaskStoreImpl.loadTasksFromResultSet", "650", this);
                    this.dumpSQLExceptionInfo(throwable);
                    if (bl) {
                        Tr.debug(tc, "Error loading task: " + TaskStoreImpl.getStringTaskID(l2), new Object[]{throwable});
                    }
                    Tr.service(tc, "SCHD0102I", new Object[]{"Error loading task from persistent store.  TaskID=" + TaskStoreImpl.getStringTaskID(l2) + ", Scheduler Instance=" + this.dbHelper.getScheduler().getSchedulerConfiguration().getJndiName()});
                }
            }
            if (bl) {
                Tr.debug(tc, "EndTaskLoad: " + (System.currentTimeMillis() - l) + "ms, " + n2 + " tasks");
            }
            TaskInfo[] taskInfoArray2 = new AbstractTask[n2];
            taskInfoArray = taskInfoArray2 = arrayList.toArray(taskInfoArray2);
        }
        catch (Throwable throwable) {
            try {
                FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.TaskStoreImpl.loadTasksFromResultSet", "716", this);
                this.dumpSQLExceptionInfo(throwable);
                if (throwable instanceof SchedulerNotAvailableException) {
                    throw (SchedulerNotAvailableException)throwable;
                }
                throw new SchedulerNotAvailableException(Utils.getExceptionMessageWithType(throwable), throwable);
            }
            catch (Throwable throwable2) {
                block16: {
                    if (!tc.isEntryEnabled()) break block16;
                    Tr.exit(tc, "loadTasksFromResultSet", new Integer(n2));
                }
                throw throwable2;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadTasksFromResultSet", new Integer(n2));
        }
        return taskInfoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResultSet findTasksBeforeNotComplete(Connection connection, Date date, int n, Range[] rangeArray, boolean bl) throws SchedulerNotAvailableException {
        ResultSet resultSet;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findTasksBeforeNotComplete", new Object[]{date + " (" + (this.dbHelper == null ? "DBHELPER=<null>" : this.dbHelper.getRealTableName("TASK")) + "," + date.getTime() + "," + new Integer(n) + "," + Range.toString(rangeArray) + "," + bl + ")"});
        }
        ResultSet resultSet2 = null;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.getQuery_FINDTASKSBEFORENOTCOMPLETE(connection, date, rangeArray, this.conv50Partitions, this.nonconv50Partitions, bl);
            preparedStatement.setMaxRows(n);
            resultSet = resultSet2 = this.executePrivilegedQueryWithRetry(preparedStatement);
        }
        catch (PrivilegedActionException privilegedActionException) {
            try {
                Exception exception = privilegedActionException.getException();
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.scheduler.TaskStoreImpl.findTasksBeforeNotComplete", "713", this);
                this.dumpSQLExceptionInfo(exception);
                throw new SchedulerNotAvailableException(Utils.getExceptionMessageWithType(exception), exception);
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.TaskStoreImpl.findTasksBeforeNotComplete", "716", this);
                    this.dumpSQLExceptionInfo(throwable);
                    if (!(throwable instanceof SchedulerNotAvailableException)) throw new SchedulerNotAvailableException(Utils.getExceptionMessageWithType(throwable), throwable);
                    throw (SchedulerNotAvailableException)throwable;
                }
            }
            catch (Throwable throwable) {
                if (!tc.isEntryEnabled()) throw throwable;
                Tr.exit(tc, "findTasksBeforeNotComplete");
                throw throwable;
            }
        }
        if (!tc.isEntryEnabled()) return resultSet;
        Tr.exit(tc, "findTasksBeforeNotComplete");
        return resultSet;
    }

    private TaskInfo loadTaskFromResultSet(ResultSet resultSet) throws TaskLoadException, TaskVersionMismatch {
        Serializable serializable;
        boolean bl = tc.isDebugEnabled();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadTaskFromResultSet");
        }
        long l = -1L;
        String string = "";
        int n = 0;
        int n2 = -1;
        byte by = 0;
        boolean bl2 = false;
        Date date = null;
        String string2 = null;
        Date date2 = null;
        Date date3 = null;
        Date date4 = null;
        String string3 = null;
        int n3 = 0;
        int n4 = 0;
        String string4 = null;
        boolean bl3 = false;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        Date date5 = null;
        byte[] byArray = null;
        AbstractTask abstractTask = null;
        try {
            l = resultSet.getLong(1);
            string = resultSet.getString(2);
            if (!(string.equals("50") || string.equals("502") || string.equals("60"))) {
                TaskVersionMismatch taskVersionMismatch = new TaskVersionMismatch(Messages.getMessage("SCHD0062E", new String[]{string, TaskStoreImpl.getStringTaskID(l), "50,502,60"}));
                taskVersionMismatch.setVersion(string);
                throw taskVersionMismatch;
            }
            n = resultSet.getInt(3);
            n2 = resultSet.getInt(4);
            by = resultSet.getByte(5);
            bl2 = resultSet.getBoolean(6);
            date = new Date(resultSet.getLong(7));
            string2 = resultSet.getString(8);
            if (resultSet.wasNull()) {
                string2 = null;
            }
            date2 = new Date(resultSet.getLong(9));
            if (resultSet.wasNull()) {
                date2 = null;
            }
            date3 = new Date(resultSet.getLong(10));
            if (resultSet.wasNull()) {
                date3 = null;
            }
            date4 = new Date(resultSet.getLong(11));
            if (resultSet.wasNull()) {
                date4 = null;
            }
            string3 = resultSet.getString(12);
            if (resultSet.wasNull()) {
                string3 = null;
            }
            n3 = resultSet.getInt(13);
            n4 = resultSet.getInt(14);
            long l2 = System.currentTimeMillis();
            byArray = this.getBytesFromStream(resultSet.getBinaryStream(15));
            if (bl) {
                Tr.debug(tc, "TaskHolder Load Time=" + (System.currentTimeMillis() - l2) + "ms");
            }
            long l3 = System.currentTimeMillis();
            string4 = resultSet.getString(16);
            if (resultSet.wasNull()) {
                string4 = null;
            }
            bl3 = resultSet.getBoolean(17);
            n5 = resultSet.getInt(18);
            n6 = resultSet.getInt(19);
            n7 = resultSet.getInt(20);
            n8 = resultSet.getInt(21);
            if (resultSet.wasNull()) {
                n8 = 0;
            }
            date5 = new Date(resultSet.getLong(22));
            try {
                Serializable serializable2;
                serializable = null;
                serializable = n2 == 32768 ? CfgHelperTask.class : ((SchedulerServiceImpl)SchedulerServiceImpl.instance()).getTaskInfoImplementation(n2);
                abstractTask = (AbstractTask)serializable.newInstance();
                if (string.equals("60")) {
                    serializable2 = new TaskInfoBinaryData(byArray);
                    abstractTask.initialize(TaskStoreImpl.getStringTaskID(l), string, n, by, bl2, date, string2, date2, date3, date4, string3, n3, n4, (TaskInfoBinaryData)serializable2, string4, bl3, n5, n6, n7, n8, date5);
                } else {
                    serializable2 = new LazyTaskHolder(byArray, string);
                    if (bl) {
                        Tr.debug(tc, "TaskHolder Deserialization Time=" + (System.currentTimeMillis() - l3) + "ms");
                    }
                    abstractTask.initialize(TaskStoreImpl.getStringTaskID(l), string, n, by, bl2, date, string2, date2, date3, date4, string3, n3, n4, (LazyTaskHolderI)serializable2, string4, bl3, n5, n6, n7, n8, date5);
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.TaskStoreImpl.loadTaskFromResultSet", "775", this);
                throw new TaskLoadException(Utils.getExceptionMessageWithType(throwable), throwable, l);
            }
            serializable = abstractTask;
        }
        catch (Throwable throwable) {
            try {
                if (throwable instanceof TaskLoadException) {
                    throw (TaskLoadException)throwable;
                }
                throw new TaskLoadException(Utils.getExceptionMessageWithType(throwable), throwable, l);
            }
            catch (Throwable throwable2) {
                if (tc.isDebugEnabled()) {
                    int n9 = 0;
                    if (byArray != null) {
                        n9 = byArray.length;
                    }
                    Tr.debug(tc, "Read complete.  Blob sizes: " + n9);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "loadTaskFromResultSet: " + abstractTask);
                }
                throw throwable2;
            }
        }
        if (tc.isDebugEnabled()) {
            int n10 = 0;
            if (byArray != null) {
                n10 = byArray.length;
            }
            Tr.debug(tc, "Read complete.  Blob sizes: " + n10);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadTaskFromResultSet: " + abstractTask);
        }
        return serializable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskStatus loadTaskStatusFromResultSet(ResultSet resultSet) throws SQLException, ClassNotFoundException, IOException, SchedulerDataStoreException, TaskVersionMismatch {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadTaskFromResultSet");
        }
        long l = -1L;
        String string = "";
        byte by = 0;
        boolean bl = false;
        Date date = null;
        int n = 0;
        String string2 = null;
        Date date2 = null;
        Object var11_10 = null;
        try {
            l = resultSet.getLong(1);
            string = resultSet.getString(2);
            if (!(string.equals("50") || string.equals("502") || string.equals("60"))) {
                TaskVersionMismatch taskVersionMismatch = new TaskVersionMismatch("Version mismatch for task.");
                taskVersionMismatch.setVersion(string);
                throw taskVersionMismatch;
            }
            by = resultSet.getByte(3);
            bl = resultSet.getBoolean(4);
            date = new Date(resultSet.getLong(5));
            n = resultSet.getInt(6);
            string2 = resultSet.getString(7);
            date2 = new Date(resultSet.getLong(8));
            if (resultSet.wasNull()) {
                string2 = null;
            }
            TaskStatusImpl taskStatusImpl = new TaskStatusImpl(TaskStoreImpl.getStringTaskID(l), TaskStatusImpl.getStatus(n, bl, by, false), string2, n, date, date2);
            return taskStatusImpl;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "loadTaskFromResultSet: " + var11_10);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object[] findByName(Connection connection, String string, String string2, Class clazz, int n, int n2, boolean bl) throws SchedulerNotAvailableException, IndexOutOfBoundsException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findTasksWithName");
        }
        ResultSet resultSet = null;
        Statement statement = null;
        try {
            String string3;
            if (bl) {
                TaskStoreImpl.validateIndex(n, n2);
            }
            if (string == null) {
                string = "";
            }
            boolean bl2 = false;
            if (string2.equalsIgnoreCase("ADMIN")) {
                bl2 = true;
            }
            if (clazz == TaskStatus.class) {
                string3 = bl2 ? this.dbHelper.getSQLStatement("FINDALLSTATUSBYNAME", "TASK") : this.dbHelper.getSQLStatement("FINDSTATUSBYNAME", "TASK");
            } else {
                if (clazz != com.ibm.websphere.scheduler.TaskInfo.class) throw new IllegalArgumentException("Incorrect Task Type.");
                string3 = bl2 ? this.dbHelper.getSQLStatement("FINDALLBYNAME", "TASK") : this.dbHelper.getSQLStatement("FINDBYNAME", "TASK");
            }
            statement = connection.prepareStatement(string3);
            statement.setString(1, string);
            if (!bl2) {
                statement.setString(2, string2);
            }
            if (bl) {
                int n3 = n2 == Integer.MAX_VALUE ? 0 : n2 + 1;
                statement.setMaxRows(n3);
            }
            resultSet = this.executePrivilegedQueryWithRetry((PreparedStatement)statement);
            Vector<TaskStatus> vector = new Vector<TaskStatus>();
            boolean bl3 = true;
            if (bl) {
                if (resultSet.getType() != 1003) {
                    bl3 = resultSet.absolute(n + 1);
                } else {
                    for (int i = 0; i < n && (bl3 = this.nextWithRetry(resultSet)); ++i) {
                    }
                }
            }
            if (bl3) {
                while (this.nextWithRetry(resultSet)) {
                    long l = -1L;
                    try {
                        try {
                            TaskStatus taskStatus = null;
                            if (clazz == (class$com$ibm$websphere$scheduler$TaskStatus == null ? TaskStoreImpl.class$("com.ibm.websphere.scheduler.TaskStatus") : class$com$ibm$websphere$scheduler$TaskStatus)) {
                                taskStatus = this.loadTaskStatusFromResultSet(resultSet);
                            } else {
                                if (clazz != (class$com$ibm$websphere$scheduler$TaskInfo == null ? TaskStoreImpl.class$("com.ibm.websphere.scheduler.TaskInfo") : class$com$ibm$websphere$scheduler$TaskInfo)) throw new IllegalArgumentException("Incorrect Task Type.");
                                taskStatus = this.loadTaskFromResultSet(resultSet);
                            }
                            vector.add(taskStatus);
                        }
                        catch (TaskVersionMismatch taskVersionMismatch) {
                        }
                        catch (TaskLoadException taskLoadException) {
                            l = taskLoadException.getTaskID();
                            if (!this.isBinaryDataLoadException(taskLoadException)) throw taskLoadException.getCause();
                            throw new TaskInvalid(Messages.getMessage("SCHD0061E", new String[]{TaskStoreImpl.getStringTaskID(l), string2}), taskLoadException.getCause());
                        }
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.TaskStoreImpl.findTasksBeforeNotComplete", "700", this);
                        this.dumpSQLExceptionInfo(throwable);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Error loading TaskStatus: " + TaskStoreImpl.getStringTaskID(l), new Object[]{throwable});
                        }
                        Tr.service(tc, "Invalid task detected.  TaskID=" + TaskStoreImpl.getStringTaskID(l) + ", Scheduler=" + this.dbHelper.getScheduler().getSchedulerConfiguration().getJndiName());
                    }
                }
            }
            if (clazz == TaskStatus.class) {
                Object[] objectArray = new TaskStatus[]{};
                Object[] objectArray2 = objectArray = vector.toArray(objectArray);
                return objectArray2;
            }
            if (clazz == com.ibm.websphere.scheduler.TaskInfo.class) {
                Object[] objectArray = new TaskInfo[]{};
                Object[] objectArray3 = objectArray = vector.toArray(objectArray);
                return objectArray3;
            }
            throw new IllegalArgumentException("Incorrect Task Type.");
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.scheduler.TaskStoreImpl.findTasksWithName", "765", this);
            this.dumpSQLExceptionInfo(exception);
            throw new SchedulerNotAvailableException(Utils.getExceptionMessageWithType(exception), exception);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.TaskStoreImpl.findTasksWithName", "768", this);
            this.dumpSQLExceptionInfo(throwable);
            throw new SchedulerNotAvailableException(Utils.getExceptionMessageWithType(throwable), throwable);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.TaskStoreImpl.findTasksWithName", "780", this);
            }
            finally {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "findTasksWithName");
                }
            }
        }
    }

    public Object[] findByName(Connection connection, String string, String string2, Class clazz) throws SchedulerNotAvailableException {
        return this.findByName(connection, string, string2, clazz, -1, -1, false);
    }

    protected byte[] getBytesFromStream(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return new byte[0];
        }
        byte[] byArray = new byte[2048];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        inputStream.close();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Read bytes; " + byArray2.length);
        }
        byteArrayOutputStream.close();
        return byArray2;
    }

    protected byte[] serialize(Serializable serializable) throws IOException {
        if (serializable == null) {
            return new byte[0];
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(serializable);
        objectOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        return byArray;
    }

    public DBHelper getDBHelper() {
        return this.dbHelper;
    }

    protected void dumpSQLExceptionInfo(Throwable throwable) {
        this.dbHelper.dumpSQLExceptionInfo(throwable);
    }

    public boolean isDeadlockException(SQLException sQLException) {
        return false;
    }

    public String getPaddedTaskID(String string) {
        return Utils.getPaddedString(string, 36, ' ', false);
    }

    protected boolean nextWithRetry(ResultSet resultSet) throws SQLException {
        boolean bl = tc.isDebugEnabled();
        int n = 1;
        boolean bl2 = true;
        boolean bl3 = false;
        SQLException sQLException = null;
        while (bl2) {
            try {
                long l = System.currentTimeMillis();
                bl3 = resultSet.next();
                if (bl && System.currentTimeMillis() - l > 50L) {
                    Tr.debug(tc, "Excessive next() time: " + (System.currentTimeMillis() - l) + "ms");
                }
                bl2 = false;
            }
            catch (SQLException sQLException2) {
                if (this.isDeadlockException(sQLException2)) {
                    if (sQLException == null) {
                        sQLException = sQLException2;
                    }
                    if (++n > LOCK_RETRY_COUNT) {
                        if (sQLException != null) {
                            throw sQLException;
                        }
                        throw sQLException2;
                    }
                    if (bl) {
                        Tr.debug(tc, "Lock detected.  Retrying...");
                    }
                    try {
                        Thread.sleep(LOCK_RETRY_WAIT);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        if (sQLException == null) continue;
                        throw sQLException;
                    }
                }
                if (sQLException != null) {
                    throw sQLException;
                }
                throw sQLException2;
            }
        }
        return bl3;
    }

    protected ResultSet executeQueryWithRetry(PreparedStatement preparedStatement) throws SQLException {
        boolean bl = tc.isDebugEnabled();
        int n = 1;
        boolean bl2 = true;
        ResultSet resultSet = null;
        SQLException sQLException = null;
        while (bl2) {
            try {
                if (bl) {
                    Tr.debug(tc, "BeginQuery");
                }
                long l = System.currentTimeMillis();
                resultSet = preparedStatement.executeQuery();
                if (bl) {
                    Tr.debug(tc, "EndQuery: " + (System.currentTimeMillis() - l) + "ms");
                }
                bl2 = false;
            }
            catch (SQLException sQLException2) {
                if (this.isDeadlockException(sQLException2)) {
                    if (sQLException == null) {
                        sQLException = sQLException2;
                    }
                    if (++n > LOCK_RETRY_COUNT) {
                        if (sQLException != null) {
                            throw sQLException;
                        }
                        throw sQLException2;
                    }
                    if (bl) {
                        Tr.debug(tc, "Lock detected.  Retrying...");
                    }
                    try {
                        Thread.sleep(LOCK_RETRY_WAIT);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        if (sQLException == null) continue;
                        throw sQLException;
                    }
                }
                if (sQLException != null) {
                    throw sQLException;
                }
                throw sQLException2;
            }
        }
        return resultSet;
    }

    protected ResultSet executePrivilegedQueryWithRetry(PreparedStatement preparedStatement) throws PrivilegedActionException {
        ExecuteQueryPriviledged executeQueryPriviledged = new ExecuteQueryPriviledged(preparedStatement, true);
        return (ResultSet)AccessController.doPrivileged(executeQueryPriviledged);
    }

    protected int executeUpdateWithRetry(PreparedStatement preparedStatement) throws SQLException {
        boolean bl = tc.isDebugEnabled();
        int n = 1;
        boolean bl2 = true;
        int n2 = -1;
        SQLException sQLException = null;
        while (bl2) {
            try {
                if (bl) {
                    Tr.debug(tc, "BeginQuery");
                }
                long l = System.currentTimeMillis();
                n2 = preparedStatement.executeUpdate();
                if (bl) {
                    Tr.debug(tc, "EndQuery: " + (System.currentTimeMillis() - l) + "ms");
                }
                bl2 = false;
            }
            catch (SQLException sQLException2) {
                if (this.isDeadlockException(sQLException2)) {
                    if (sQLException == null) {
                        sQLException = sQLException2;
                    }
                    if (++n > LOCK_RETRY_COUNT) {
                        if (sQLException != null) {
                            throw sQLException;
                        }
                        throw sQLException2;
                    }
                    if (bl) {
                        Tr.debug(tc, "Lock detected.  Retrying...");
                    }
                    try {
                        Thread.sleep(LOCK_RETRY_WAIT);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        if (sQLException == null) continue;
                        throw sQLException;
                    }
                }
                if (sQLException != null) {
                    throw sQLException;
                }
                throw sQLException2;
            }
        }
        return n2;
    }

    protected String getNextTaskID(Connection connection) throws SQLException, SchedulerNotAvailableException {
        String string = this.getNextAvailableTaskID(false);
        return string;
    }

    protected synchronized String getNextAvailableTaskID(boolean bl) throws SQLException, SchedulerNotAvailableException {
        String string = this.dbHelper.getDataSourceJNDIName() + "#" + this.dbHelper.getTablePrefixName();
        if (!taskIDs.containsKey(string)) {
            taskIDs.put(string, new TaskIDReservation());
        }
        TaskIDReservation taskIDReservation = (TaskIDReservation)taskIDs.get(string);
        if (taskIDReservation.nextTaskID == taskIDReservation.maxTaskID || bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Generating new set of task id's using infokey: " + string);
            }
            long[] lArray = this.getAvailableTaskIDRange(taskIDReservation.taskIDBatchSize);
            taskIDReservation.nextTaskID = lArray[0];
            taskIDReservation.maxTaskID = lArray[1];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "New TaskID range is: " + taskIDReservation.nextTaskID + "-" + taskIDReservation.maxTaskID);
            }
        } else {
            ++taskIDReservation.nextTaskID;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Returning new TaskID= " + taskIDReservation.nextTaskID + " for infokey: " + string);
        }
        return new Long(taskIDReservation.nextTaskID).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long[] getAvailableTaskIDRange(int n) throws SchedulerNotAvailableException, SQLException {
        Connection connection = null;
        TxHandle txHandle = null;
        TransactionControl transactionControl = this.dbHelper.getTransactionControl();
        try {
            long l;
            long l2;
            txHandle = transactionControl.preinvoke(true, false);
            connection = this.dbHelper.getConnection(txHandle, 2, true);
            String string = "TASKID";
            try {
                String string2 = this.getDBRegValue(connection, string, null, true);
                if (string2 != null) {
                    l2 = Long.parseLong(string2) + 1L;
                    l = l2 + (long)n - 1L;
                    this.setDBRegValue(connection, string, new Long(l).toString());
                } else {
                    try {
                        l2 = 1L;
                        l = l2 + (long)n - 1L;
                        this.setNewDBRegValue(connection, string, new Long(l).toString());
                    }
                    catch (DuplicateKeyException duplicateKeyException) {
                        string2 = this.getDBRegValue(connection, string, null, true);
                        l2 = Long.parseLong(string2) + 1L;
                        l = l2 + (long)n - 1L;
                        this.setDBRegValue(connection, string, new Long(l).toString());
                    }
                }
            }
            finally {
                if (connection != null) {
                    try {
                        connection.commit();
                    }
                    catch (SQLException sQLException) {
                        FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.scheduler.TaskStoreImpl.getAvailableTaskIDRange", "1160", this);
                        this.dumpSQLExceptionInfo(sQLException);
                    }
                    try {
                        this.dbHelper.returnConnection(connection);
                    }
                    catch (SQLException sQLException) {
                        FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.scheduler.TaskStoreImpl.getAvailableTaskIDRange", "1161", this);
                        this.dumpSQLExceptionInfo(sQLException);
                    }
                }
            }
            transactionControl.postinvoke(txHandle);
            return new long[]{l2, l};
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.TaskStoreImpl.getAvailableTaskIDRange", "1150", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught : ", throwable);
            }
            if (txHandle != null) {
                transactionControl.handleException(txHandle);
            }
            if (throwable instanceof SQLException) {
                this.dumpSQLExceptionInfo(throwable);
                throw (SQLException)throwable;
            }
            throw new SchedulerNotAvailableException(Utils.getExceptionMessageWithType(throwable), throwable);
        }
    }

    protected String getDBRegValue(Connection connection, String string, String string2, boolean bl) throws SQLException {
        String string3 = string2;
        ResultSet resultSet = null;
        Statement statement = null;
        try {
            String string4 = "FINDBYKEY";
            if (bl) {
                string4 = "FINDBYKEYWITHLOCK";
            }
            String string5 = this.dbHelper.getSQLStatement(string4, "TREG");
            statement = connection.prepareStatement(string5);
            statement.setString(1, string);
            resultSet = this.executeQueryWithRetry((PreparedStatement)statement);
            if (this.nextWithRetry(resultSet)) {
                string3 = resultSet.getString(1);
            }
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.scheduler.TaskStoreImpl.getDBRegValue", "1200", this);
            this.dumpSQLExceptionInfo(sQLException);
            throw sQLException;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.scheduler.TaskStoreImpl.getDBRegValue", "1200", this);
                this.dumpSQLExceptionInfo(sQLException);
            }
        }
        return string3;
    }

    protected boolean setDBRegValue(Connection connection, String string, String string2) throws SQLException {
        Statement statement = null;
        try {
            statement = connection.prepareStatement(this.dbHelper.getSQLStatement("UPDATE", "TREG"));
            statement.setString(1, string2);
            statement.setString(2, string);
            if (this.executeUpdateWithRetry((PreparedStatement)statement) == 1) {
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.scheduler.TaskStoreImpl.setDBRegValue", "1250", this);
            this.dumpSQLExceptionInfo(sQLException);
            throw sQLException;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.scheduler.TaskStoreImpl.setDBRegValue", "1255", this);
                this.dumpSQLExceptionInfo(sQLException);
            }
        }
        return false;
    }

    protected boolean setNewDBRegValue(Connection connection, String string, String string2) throws SQLException {
        Statement statement = null;
        try {
            statement = connection.prepareStatement(this.dbHelper.getSQLStatement("CREATE", "TREG"));
            statement.setString(1, string);
            statement.setString(2, string2);
            if (this.executeUpdateWithRetry((PreparedStatement)statement) == 1) {
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.scheduler.TaskStoreImpl.setNewDBRegValue", "1300", this);
            this.dumpSQLExceptionInfo(sQLException);
            throw sQLException;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.scheduler.TaskStoreImpl.setNewDBRegValue", "1305", this);
                this.dumpSQLExceptionInfo(sQLException);
            }
        }
        return false;
    }

    protected static long getLongTaskID(String string) {
        return Long.parseLong(string);
    }

    protected static String getStringTaskID(long l) {
        return new Long(l).toString();
    }

    protected void setLong(PreparedStatement preparedStatement, int n, long l) throws SQLException {
        preparedStatement.setLong(n, l);
    }

    protected void setNullLong(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setNull(n, -5);
    }

    public void getTableStatus() throws SchedulerDataStoreException {
        if (!this.dbHelper.existsTable(this.dbHelper.getRealTableName("TREG"))) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Table " + this.dbHelper.getRealTableName("TREG") + "does not exist or is inaccessible");
            }
            throw new SchedulerDataStoreException(this.dbHelper.getRealTableName("TREG"));
        }
        if (!this.dbHelper.existsTable(this.dbHelper.getRealTableName("TASK"))) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Table " + this.dbHelper.getRealTableName("TASK") + "does not exist or is inaccessible");
            }
            throw new SchedulerDataStoreException(this.dbHelper.getRealTableName("TASK"));
        }
    }

    protected BlobInfo getBlobForUpdate(Connection connection, long l, int n) throws SQLException, TaskPending {
        return null;
    }

    protected void setBlob(PreparedStatement preparedStatement, int n, Blob blob, byte[] byArray) throws Exception {
        if (preparedStatement == null || blob == null || byArray == null) {
            return;
        }
    }

    protected static void validateIndex(int n, int n2) throws IndexOutOfBoundsException {
        if (n > n2) {
            throw new IndexOutOfBoundsException(Messages.getMessage("SCHD0091E", new String[]{new Integer(n).toString(), new Integer(n2).toString()}));
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException(Messages.getMessage("SCHD0092E", new Integer(n).toString()));
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException(Messages.getMessage("SCHD0093E", new Integer(n2).toString()));
        }
        if (n2 < n) {
            throw new IndexOutOfBoundsException(Messages.getMessage("SCHD0094E", new String[]{new Integer(n2).toString(), new Integer(n).toString()}));
        }
    }

    public boolean dropTables(Connection connection) throws SchedulerDataStoreException {
        String string = null;
        Statement statement = null;
        boolean bl = false;
        try {
            if (this.dbHelper.existsTable(this.dbHelper.getRealTableName("TASK"), connection)) {
                string = this.dbHelper.getSQLStatement("DROPINDEX1", "TASK");
                statement = connection.prepareStatement(string);
                statement.execute();
                string = this.dbHelper.getSQLStatement("DROPINDEX2", "TASK");
                statement = connection.prepareStatement(string);
                statement.execute();
                string = this.dbHelper.getSQLStatement("DROPTABLE", "TASK");
                statement = connection.prepareStatement(string);
                statement.execute();
                bl = true;
            } else {
                Tr.info(tc, Messages.getMessage("SCHD0089I", this.dbHelper.getRealTableName("TASK")));
            }
            if (this.dbHelper.existsTable(this.dbHelper.getRealTableName("TREG"), connection)) {
                string = this.dbHelper.getSQLStatement("DROPTABLE", "TREG");
                statement = connection.prepareStatement(string);
                statement.execute();
                bl = true;
            } else {
                Tr.info(tc, Messages.getMessage("SCHD0089I", this.dbHelper.getRealTableName("TASK")));
            }
            boolean bl2 = bl;
            return bl2;
        }
        catch (SQLException sQLException) {
            this.dumpSQLExceptionInfo(sQLException);
            throw new SchedulerDataStoreException(Utils.getExceptionMessageWithType(sQLException), sQLException);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public boolean createTables(Connection connection) throws SchedulerDataStoreException {
        boolean bl = false;
        try {
            if (!this.dbHelper.existsTable(this.dbHelper.getRealTableName("TASK"), connection)) {
                this.executeSQL("CREATETABLE", "TASK", connection, false);
                this.executeSQL("ALTERTABLE", "TASK", connection, true);
                this.executeSQL("CREATEINDEX1", "TASK", connection, false);
                this.executeSQL("CREATEINDEX2", "TASK", connection, false);
                bl = true;
            } else {
                Tr.info(tc, Messages.getMessage("SCHD0086I", this.dbHelper.getRealTableName("TASK")));
            }
            if (!this.dbHelper.existsTable(this.dbHelper.getRealTableName("TREG"), connection)) {
                this.executeSQL("CREATETABLE", "TREG", connection, false);
                bl = true;
            } else {
                Tr.info(tc, Messages.getMessage("SCHD0086I", this.dbHelper.getRealTableName("TREG")));
            }
            return bl;
        }
        catch (SQLException sQLException) {
            this.dumpSQLExceptionInfo(sQLException);
            throw new SchedulerDataStoreException(Utils.getExceptionMessageWithType(sQLException), sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeSQL(String string, String string2, Connection connection, boolean bl) throws SQLException, SchedulerDataStoreException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "executeSQL");
        }
        Statement statement = null;
        try {
            String string3 = this.dbHelper.getSQLStatement(string, string2);
            if (string3 != null && string3.length() > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SQL Statement for statement key: " + string + " for table key: " + string2 + " is " + string3);
                }
                statement = connection.prepareStatement(string3);
                statement.execute();
            } else if (!bl) {
                throw new SchedulerDataStoreException(Messages.getMessage("SCHD0095E", new String[]{string, string2}));
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.TaskStoreImpl.executeSQL", "2334", this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "executeSQL");
        }
    }

    protected boolean isBinaryDataLoadException(TaskLoadException taskLoadException) {
        return false;
    }

    class TaskIDReservation {
        short taskIDBatchSize = (short)50;
        long nextTaskID = -1L;
        long maxTaskID = -1L;

        TaskIDReservation() {
        }
    }

    protected class ExecuteQueryPriviledged
    implements PrivilegedExceptionAction {
        PreparedStatement stmt = null;
        boolean withRetry = true;

        ExecuteQueryPriviledged(PreparedStatement preparedStatement, boolean bl) {
            this.stmt = preparedStatement;
            this.withRetry = bl;
        }

        public Object run() throws SQLException {
            if (this.withRetry) {
                return TaskStoreImpl.this.executeQueryWithRetry(this.stmt);
            }
            return this.stmt.executeQuery();
        }
    }
}

