/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scheduler;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.scheduler.DBHelper;
import com.ibm.ws.scheduler.TaskStoreImpl;
import com.ibm.ws.scheduler.exception.TaskLoadException;
import java.sql.SQLException;
import javax.naming.NamingException;

class TaskStoreImplInformix
extends TaskStoreImpl {
    private static final TraceComponent tc = Tr.register(TaskStoreImplInformix.class, "Scheduler", "com.ibm.ws.scheduler.resources.SchedulerMessages");
    private static final int ERR_ISAM_ROWLOCK = -107;
    private static final int ERR_ISAM_DEADLOCK = -143;
    private static final int ERR_ISAM_KEYLOCK = -144;
    private static final int ERR_RECORDLOCKBYUSERREAD = -233;
    private static final int ERR_LOCKROWUPDATE = -263;
    private static final int ERR_RECORDLOCKBYUSER = -378;
    private static final int ERR_ROWPOSITITIONERROR = -243;
    private static final int ERR_COULDNOTDOPHYSICAL_ORDER_READ = -244;
    private static final int[] ERRS_LOCKS = new int[]{-107, -143, -144, -233, -263, -378, -243, -244};

    public TaskStoreImplInformix(DBHelper dBHelper) throws NamingException {
        super(dBHelper);
    }

    public boolean isDeadlockException(SQLException sQLException) {
        int n = sQLException.getErrorCode();
        for (int i = 0; i < ERRS_LOCKS.length; ++i) {
            if (n != ERRS_LOCKS[i]) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Lock error detected: " + n);
            }
            this.dumpSQLExceptionInfo(sQLException);
            return true;
        }
        SQLException sQLException2 = sQLException.getNextException();
        if (sQLException2 != null && sQLException2 instanceof SQLException) {
            SQLException sQLException3 = sQLException2;
            return this.isDeadlockException(sQLException3);
        }
        return false;
    }

    protected boolean isBinaryDataLoadException(TaskLoadException taskLoadException) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isBinaryDataLoadException", taskLoadException);
        }
        if (taskLoadException == null) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (Throwable throwable = taskLoadException.getCause(); throwable != null; throwable = throwable.getCause()) {
            if (throwable instanceof SQLException) {
                int n = ((SQLException)throwable).getErrorCode();
                if (n == -79701) {
                    bl = true;
                    continue;
                }
                if (n != -604 || !bl) continue;
                bl2 = true;
                break;
            }
            if (!(throwable instanceof NullPointerException) || !bl) continue;
            bl2 = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isBinaryDataLoadException", new Boolean(bl2));
        }
        return bl2;
    }
}

