/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scheduler;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ce.cm.DuplicateKeyException;
import com.ibm.websphere.scheduler.SchedulerNotAvailableException;
import com.ibm.websphere.scheduler.TaskPending;
import com.ibm.ws.extensionhelper.exception.UnableToInitializeException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.scheduler.BlobInfo;
import com.ibm.ws.scheduler.BlobInfoImpl;
import com.ibm.ws.scheduler.CfgHelperTask;
import com.ibm.ws.scheduler.DBHelper;
import com.ibm.ws.scheduler.SchedulerServiceImpl;
import com.ibm.ws.scheduler.SecurityControlImpl;
import com.ibm.ws.scheduler.TaskStoreImpl;
import com.ibm.ws.scheduler.Utils;
import com.ibm.ws.scheduler.resources.Messages;
import com.ibm.ws.scheduler.spi.TaskInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import javax.naming.NamingException;

class TaskStoreImplOracle
extends TaskStoreImpl {
    private static final TraceComponent tc = Tr.register(TaskStoreImplOracle.class, "Scheduler", "com.ibm.ws.scheduler.resources.SchedulerMessages");
    protected Class clsOracleBlob;
    protected Method meth_putBytes;
    protected Method meth_getBinaryOutputStream;

    public TaskStoreImplOracle(DBHelper dBHelper) throws NamingException, UnableToInitializeException {
        super(dBHelper);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TaskStoreImplOracle");
        }
        try {
            this.clsOracleBlob = dBHelper.loadClass("oracle.sql.BLOB");
            this.meth_putBytes = this.clsOracleBlob.getMethod("putBytes", Long.TYPE, [B.class);
            this.meth_getBinaryOutputStream = this.clsOracleBlob.getMethod("getBinaryOutputStream", new Class[0]);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.scheduler.TaskStoreImplOracle", "100", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception resolving an Oracle class or method: ", exception);
            }
            throw new UnableToInitializeException(Utils.getExceptionMessageWithType(exception), exception);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "TaskStoreImplOracle");
            }
        }
    }

    /*
     * Loose catch block
     */
    public TaskInfo create(Connection connection, TaskInfo taskInfo) throws SchedulerNotAvailableException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create: " + taskInfo.getTaskId());
        }
        long l = -1L;
        String string = "";
        int n = 0;
        int n2 = -1;
        byte by = 0;
        boolean bl = false;
        long l2 = 0L;
        String string2 = null;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        String string3 = null;
        int n3 = 0;
        int n4 = 0;
        byte[] byArray = null;
        String string4 = null;
        boolean bl2 = false;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        String string5 = null;
        long l6 = 0L;
        int n9 = 0;
        ResultSet resultSet = null;
        boolean bl3 = taskInfo.getTaskId() != null;
        try {
            SchedulerServiceImpl schedulerServiceImpl = null;
            boolean bl4 = taskInfo instanceof CfgHelperTask;
            if (!bl4) {
                schedulerServiceImpl = (SchedulerServiceImpl)SchedulerServiceImpl.instance();
            }
            Statement statement = null;
            try {
                Cloneable cloneable;
                Object object;
                String string6 = this.dbHelper.getSQLStatement("CREATE", "TASK");
                boolean bl5 = false;
                int n10 = 25;
                int n11 = 0;
                while (!bl5 && n11 <= n10) {
                    statement = connection.prepareStatement(string6);
                    if (!bl3) {
                        taskInfo.setTaskId(this.getNextTaskID(connection));
                    }
                    l = TaskStoreImplOracle.getLongTaskID(taskInfo.getTaskId());
                    statement.setLong(1, l);
                    string = taskInfo.getVersion();
                    statement.setString(2, string);
                    n = taskInfo.getRowVersion();
                    statement.setInt(3, n);
                    n2 = bl4 ? 32768 : schedulerServiceImpl.getTaskIDFromTaskInfoImplementation(taskInfo.getClass());
                    statement.setInt(4, n2);
                    by = taskInfo.getStateBits();
                    statement.setByte(5, by);
                    bl = taskInfo.getCancelled();
                    statement.setBoolean(6, bl);
                    l2 = taskInfo.getNextFireTime().getTime();
                    statement.setLong(7, l2);
                    string2 = taskInfo.getStartByInterval();
                    statement.setString(8, string2);
                    object = taskInfo.getStartByTime();
                    if (object != null) {
                        statement.setLong(9, ((Date)object).getTime());
                    } else {
                        statement.setNull(9, -5);
                    }
                    cloneable = taskInfo.getStartTime();
                    if (cloneable != null) {
                        statement.setLong(10, ((Date)cloneable).getTime());
                    } else {
                        statement.setNull(10, -5);
                    }
                    Date date = taskInfo.getValidToTime();
                    if (date != null) {
                        statement.setLong(11, date.getTime());
                    } else {
                        statement.setNull(11, -5);
                    }
                    string3 = taskInfo.getRepeatInterval();
                    statement.setString(12, string3);
                    n3 = taskInfo.getMaximumRepeats();
                    statement.setInt(13, n3);
                    n4 = taskInfo.getRepeatsLeft();
                    statement.setInt(14, n4);
                    string4 = taskInfo.getName();
                    if (string4 == null) {
                        string4 = "";
                    }
                    statement.setString(15, string4);
                    bl2 = taskInfo.getAutoPurge();
                    statement.setBoolean(16, bl2);
                    n5 = taskInfo.getFailureAction();
                    statement.setInt(17, n5);
                    n6 = taskInfo.getMaximumAttempts();
                    statement.setInt(18, n6);
                    n7 = taskInfo.getQOS();
                    statement.setInt(19, n7);
                    n8 = bl4 ? 0 : this.getRandomPartitionID();
                    taskInfo.setPartition(n8);
                    statement.setInt(20, n8);
                    string5 = bl4 ? "ADMIN" : SecurityControlImpl.getOwnerToken(taskInfo.getJ2EEName());
                    statement.setString(21, string5);
                    taskInfo.setCreateTime(new Date());
                    l6 = taskInfo.getCreateTime().getTime();
                    statement.setLong(22, l6);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Insert parameters: ", new Object[]{new Long(l), string, new Integer(n), new Integer(n2), new Byte(by), new Boolean(bl), new Long(l2), string2, new Long(l3), new Long(l4), new Long(l5), string3, new Integer(n3), new Integer(n4), string4, new Boolean(bl2), new Integer(n5), new Integer(n6), new Integer(n7), new Integer(n8), string5, new Long(l6)});
                    }
                    try {
                        ++n11;
                        if (statement.executeUpdate() != 1) {
                            throw new SchedulerNotAvailableException(Messages.getMessage("SCHD0056W", taskInfo.getTaskId()));
                        }
                        bl5 = true;
                    }
                    catch (DuplicateKeyException duplicateKeyException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "DuplicateKeyException during update/create: TASKID=" + l + ", RETRY#:" + n11);
                        }
                        try {
                            if (statement != null) {
                                statement.close();
                            }
                        }
                        catch (Throwable throwable) {
                            FFDCFilter.processException((Throwable)duplicateKeyException, "com.ibm.ws.scheduler.TaskStoreImplOracle.create", "250", this);
                        }
                        if (!bl3) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Duplicate task id detected while updating.  Aborting for task: " + l);
                        }
                        throw duplicateKeyException;
                    }
                }
                object = this.getBlobForUpdate(connection, l, n);
                byArray = string.equals("50") ? this.serialize(taskInfo.getTaskHolder()) : taskInfo.getTaskHolder().getBytes();
                string6 = this.dbHelper.getSQLStatement("UPDATEOBJECTS", "TASK");
                statement = connection.prepareStatement(string6);
                this.setBlob((PreparedStatement)statement, 1, object.getBlob(), byArray);
                statement.setLong(2, l);
                statement.setInt(3, n);
                taskInfo.setRowVersion(taskInfo.getRowVersion() + 1);
                if (statement.executeUpdate() != 1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Could not update blobs in new row.");
                    }
                    throw new TaskPending(Messages.getMessage("SCHD0057W", new Object[]{taskInfo.getTaskId(), this.dbHelper.getScheduler().getSchedulerConfiguration().getName(), this.dbHelper.getScheduler().getSchedulerConfiguration().getJndiName()}));
                }
                try {
                    object.close();
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.scheduler.TaskStoreImplOracle.create", "280", this);
                }
                if (tc.isDebugEnabled()) {
                    if (byArray != null) {
                        n9 = byArray.length;
                    }
                    Tr.debug(tc, "Create complete.  Blob sizes: " + n9);
                }
                cloneable = taskInfo;
                return cloneable;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.TaskStoreImplOracle.create", "300", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Caught exception executing insert statement: ", new Object[]{throwable, new Long(l), new Double(string), new Integer(n), new Integer(n2), new Byte(by), new Boolean(bl), new Long(l2), string2, new Long(l3), new Long(l4), new Long(l5), string3, new Integer(n3), new Integer(n4), new Integer(n9), string4, new Boolean(bl2), new Integer(n5), new Integer(n6), new Integer(n7), new Integer(n8)});
                }
                if (throwable instanceof SchedulerNotAvailableException) {
                    throw (SchedulerNotAvailableException)throwable;
                }
                throw new SchedulerNotAvailableException(Utils.getExceptionMessageWithType(throwable), throwable);
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.TaskStoreImplOracle.create", "262", this);
                }
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.TaskStoreImplOracle.create", "288", this);
                }
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "create");
            }
        }
    }

    protected BlobInfo getBlobForUpdate(Connection connection, long l, int n) throws SQLException, TaskPending {
        BlobInfoImpl blobInfoImpl = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = this.dbHelper.getSQLStatement("LOCKOBJECTS", "TASK");
        preparedStatement = connection.prepareStatement(string);
        preparedStatement.setFetchSize(1);
        preparedStatement.setLong(1, l);
        preparedStatement.setInt(2, n);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Select FOR UPDATE parameters: ", new Object[]{new Long(l), new Integer(n)});
        }
        if (!(resultSet = preparedStatement.executeQuery()).next()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not lock the row for blob retrieval.");
            }
            throw new TaskPending(Messages.getMessage("SCHD0057W", new Object[]{new Long(l), this.dbHelper.getScheduler().getSchedulerConfiguration().getName(), this.dbHelper.getScheduler().getSchedulerConfiguration().getJndiName()}));
        }
        blobInfoImpl = new BlobInfoImpl(resultSet, resultSet.getBlob(1));
        try {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.TaskStoreImplOracle.update", "650", this);
        }
        return blobInfoImpl;
    }

    protected void setBlob(PreparedStatement preparedStatement, int n, Blob blob, byte[] byArray) throws Exception {
        int n2;
        Object object;
        try {
            object = this.getDBHelper().getDriverVersion();
            object = ((String)object).substring(0, ((String)object).indexOf(46));
            n2 = Integer.parseInt((String)object);
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, this.getClass().getName() + ".setBlob", "577", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to parse driver version: " + this.getDBHelper().getDriverVersion());
            }
            n2 = 0;
        }
        object = n2 >= 10 ? blob.setBinaryStream(1L) : (OutputStream)this.meth_getBinaryOutputStream.invoke((Object)blob, (Object[])null);
        ((OutputStream)object).write(byArray);
        try {
            ((OutputStream)object).flush();
            ((OutputStream)object).close();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.scheduler.TaskStoreImplOracle.setBlob", "700", this);
        }
        preparedStatement.setBlob(n, blob);
    }
}

