/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scheduler;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.scheduler.DBHelper;
import com.ibm.ws.scheduler.TaskStoreImpl;
import com.ibm.ws.scheduler.Utils;
import com.ibm.ws.scheduler.exception.SchedulerDataStoreException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.NamingException;

class TaskStoreImplSybase
extends TaskStoreImpl {
    private static final TraceComponent tc = Tr.register(TaskStoreImplSybase.class, "Scheduler", "com.ibm.ws.scheduler.resources.SchedulerMessages");

    public TaskStoreImplSybase(DBHelper dBHelper) throws NamingException {
        super(dBHelper);
    }

    public boolean createTables(Connection connection) throws SchedulerDataStoreException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTables", "Sybase detected - use a new Connection with AutoCommit enabled.");
        }
        Connection connection2 = null;
        try {
            connection2 = this.dbHelper.getConnection();
            connection2.setAutoCommit(true);
            bl = super.createTables(connection2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".createTables", "86", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTables", sQLException);
            }
            throw new SchedulerDataStoreException(Utils.getExceptionMessageWithType(sQLException), sQLException);
        }
        finally {
            if (connection2 != null) {
                try {
                    this.dbHelper.returnConnection(connection2);
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".createTables", "102", this);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTables", "Database was " + (bl ? "" : "not ") + "updated");
        }
        return bl;
    }

    public boolean dropTables(Connection connection) throws SchedulerDataStoreException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dropTables", "Sybase detected - use a new Connection with AutoCommit enabled.");
        }
        Connection connection2 = null;
        try {
            connection2 = this.dbHelper.getConnection();
            connection2.setAutoCommit(true);
            bl = super.dropTables(connection2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".dropTables", "145", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "dropTables", sQLException);
            }
            throw new SchedulerDataStoreException(Utils.getExceptionMessageWithType(sQLException), sQLException);
        }
        finally {
            if (connection2 != null) {
                try {
                    this.dbHelper.returnConnection(connection2);
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".dropTables", "161", this);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dropTables", "Database was " + (bl ? "" : "not ") + "updated");
        }
        return bl;
    }
}

