/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scheduler;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.scheduler.Range;
import com.ibm.ws.scheduler.exception.ByteSerializeException;
import com.ibm.ws.scheduler.exception.SerializableWrappedException;
import com.ibm.ws.scheduler.resources.Messages;
import com.ibm.ws.security.auth.j2c.WSDefaultPrincipalMapping;
import com.ibm.ws.security.cred.AuthDataCredential;
import com.ibm.ws.util.WsObjectInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.ObjectName;
import javax.security.auth.login.LoginException;
import org.omg.CORBA.OBJECT_NOT_EXIST;

public class Utils {
    private static final TraceComponent tc = Tr.register(Utils.class, "Scheduler", "com.ibm.ws.scheduler.resources.SchedulerMessages");
    public static final String EOLN = System.getProperty("line.separator");
    public static final String LOG_INDENT = "    ";
    public static final String EOLN_INDENT = EOLN + "    ";
    private static Class[] throwableConSignature = new Class[]{String.class, Throwable.class};
    private static Class[] throwableConSignatureAlternate = new Class[]{String.class};

    public static String printStackTrace(Throwable throwable) {
        StringWriter stringWriter = null;
        try {
            stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            stringWriter.close();
            printWriter.close();
        }
        catch (IOException iOException) {
            FFDCFilter.processException(iOException, "com.ibm.ws.scheduler.Utils.printStackTrace", "113");
            iOException.printStackTrace();
        }
        return stringWriter.toString();
    }

    public static Properties getPropertyFile(String string) {
        Properties properties;
        block10: {
            InputStream inputStream;
            block9: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "getPropertyFile", new Object[]{string});
                }
                properties = new Properties();
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                inputStream = classLoader.getResourceAsStream(string);
                if (inputStream == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Property file not found in classpath.");
                    }
                    try {
                        inputStream = new FileInputStream(string);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        FFDCFilter.processException(fileNotFoundException, "com.ibm.ws.scheduler.Utils", "105");
                        if (!tc.isDebugEnabled()) break block9;
                        Tr.debug(tc, "Property file not found in path.", new Object[]{fileNotFoundException});
                    }
                }
            }
            if (inputStream != null) {
                try {
                    properties.load(inputStream);
                }
                catch (IOException iOException) {
                    FFDCFilter.processException(iOException, "com.ibm.ws.scheduler.Utils", "116");
                    if (!tc.isDebugEnabled()) break block10;
                    Tr.debug(tc, "IOException reading from property file.", new Object[]{iOException});
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertyFile", new Object[]{properties.elements()});
        }
        return properties;
    }

    public static int getRangeLBound(String string, String string2) {
        int n = string.indexOf(string2);
        if (n >= 0) {
            return Integer.parseInt(string.substring(0, n).trim());
        }
        return Integer.parseInt(string.trim());
    }

    public static int getRangeUBound(String string, String string2) {
        int n = string.indexOf(string2);
        if (n >= 0) {
            return Integer.parseInt(string.substring(n + 1).trim());
        }
        return Integer.parseInt(string.trim());
    }

    public static String getItemsFromRange(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = Utils.getRangeLBound(string, string2);
        int n2 = Utils.getRangeUBound(string, string2);
        for (int i = n; i <= n2; ++i) {
            stringBuffer.append(i);
            if (i == n2) continue;
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    public static String getKeyFromKeyValue(String string, String string2) {
        int n = string.indexOf(string2);
        if (n >= 0) {
            return string.substring(0, n).trim();
        }
        return string.trim();
    }

    public static String getValueItemFromKeyValue(String string, String string2) {
        int n = string.indexOf(string2);
        if (n >= 0) {
            return string.substring(n + 1).trim();
        }
        return string.trim();
    }

    public static String getJNDIConfig(String string, String string2, String string3, String string4) {
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
        while (stringTokenizer.hasMoreTokens()) {
            String string5;
            int n;
            String string6 = stringTokenizer.nextToken();
            int n2 = string6.indexOf(string);
            if (n2 >= (n = string6.indexOf(string4)) || n2 == -1 || (string5 = string6.substring(n2, n).trim()).compareTo(string) != 0) continue;
            return string6.substring(n + 1).trim();
        }
        return null;
    }

    public static String replaceString(String string, String string2, String string3) {
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n2 = string.indexOf(string2, n)) >= 0) {
            stringBuffer.append(string.substring(n, n2));
            stringBuffer.append(string3);
            n = n2 + string2.length();
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    public static String getPaddedString(String string, int n, char c, boolean bl) {
        if (string.length() >= n) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        if (bl) {
            for (int i = 0; i < n - string.length(); ++i) {
                stringBuffer.append(c);
            }
        } else {
            for (int i = 0; i < n - string.length(); ++i) {
                stringBuffer.insert(0, c);
            }
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deserialize(InputStream inputStream) throws IOException, ClassNotFoundException {
        if (inputStream == null) {
            return null;
        }
        WsObjectInputStream wsObjectInputStream = new WsObjectInputStream(inputStream);
        Object object = null;
        try {
            object = wsObjectInputStream.readObject();
        }
        finally {
            try {
                wsObjectInputStream.close();
            }
            catch (IOException iOException) {
                FFDCFilter.processException(iOException, "com.ibm.ws.scheduler.Utils.deserialize", "372");
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                FFDCFilter.processException(iOException, "com.ibm.ws.scheduler.Utils.deserialize", "381");
            }
        }
        return object;
    }

    public static List[] getPartitionDistribution(Range[] rangeArray, int n) {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < rangeArray.length; ++n2) {
            n3 += rangeArray[n2].getSize();
        }
        n2 = n3 / n;
        if (n > n3) {
            n2 = 1;
        }
        int n4 = n2;
        List[] listArray = new ArrayList[n];
        listArray[0] = new ArrayList();
        int n5 = 0;
        for (int i = 0; i < rangeArray.length; ++i) {
            int n6;
            int n7;
            Range range = rangeArray[i];
            Range range2 = null;
            for (int j = n6 = rangeArray[i].getSize(); j > 0; j -= n7) {
                int n8 = range2 == null ? range.getLbound() : range2.getUbound() + 1;
                int n9 = n5 == n - 1 && i == rangeArray.length - 1 ? n8 + j - 1 : (n5 != n - 1 ? (j > n4 ? n8 + n4 - 1 : n8 + j - 1) : range.getUbound());
                n7 = n9 - n8 + 1;
                Range range3 = new Range(n8, n9);
                ((ArrayList)listArray[n5]).add(range3);
                range2 = range3;
                if ((n4 -= n7) > 0 || n5 >= n - 1) continue;
                listArray[++n5] = new ArrayList();
                n4 = n2;
            }
        }
        return listArray;
    }

    public static int fibonacci(int n) {
        int n2 = -1;
        int n3 = 1;
        for (int i = 0; i <= n; ++i) {
            int n4 = n3 + n2;
            n2 = n3;
            n3 = n4;
        }
        return n3;
    }

    public static int getDecayingAverage(float[] fArray, int[] nArray) {
        float f = 0.0f;
        for (int i = 0; i < nArray.length; ++i) {
            f += (float)nArray[i] * fArray[i];
        }
        return (int)f;
    }

    public static Range[] insertRange(Range[] rangeArray, Range range) {
        Range[] rangeArray2 = new Range[rangeArray.length + 1];
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        while (n < rangeArray.length) {
            if (rangeArray[n].equals(range)) {
                return rangeArray;
            }
            if (!bl && (n == 0 && range.getUbound() < rangeArray[n].getLbound() || range.getUbound() < rangeArray[n].getLbound() && range.getLbound() > rangeArray[n - 1].getUbound())) {
                rangeArray2[n2] = range;
                ++n2;
                bl = true;
            }
            rangeArray2[n2] = rangeArray[n];
            ++n;
            ++n2;
        }
        if (!bl) {
            rangeArray2[rangeArray2.length - 1] = range;
        }
        return rangeArray2;
    }

    public static Range[] removeRange(Range[] rangeArray, Range range) {
        Range[] rangeArray2 = new Range[rangeArray.length - 1];
        int n = 0;
        int n2 = 0;
        while (n < rangeArray2.length) {
            if (range.equals(rangeArray[n])) {
                ++n2;
            }
            rangeArray2[n] = rangeArray[n2];
            ++n;
            ++n2;
        }
        return rangeArray2;
    }

    public static ObjectName createMBean(String string, String string2, String string3, RuntimeCollaborator runtimeCollaborator, Properties properties) throws PrivilegedActionException {
        Utils utils;
        boolean bl = tc.isEntryEnabled();
        boolean bl2 = tc.isDebugEnabled();
        if (bl) {
            Tr.entry(tc, "createMBean");
        }
        ObjectName objectName = null;
        Utils utils2 = utils = new Utils();
        utils2.getClass();
        objectName = (ObjectName)AccessController.doPrivileged(utils2.new ActivateMBeanPA(AdminServiceFactory.getMBeanFactory(), string, runtimeCollaborator, string2, string3, properties));
        if (bl) {
            Tr.exit(tc, "createMBean");
        }
        return objectName;
    }

    public static void destroyMBean(ObjectName objectName) throws AdminException {
        if (objectName != null) {
            AdminServiceFactory.getMBeanFactory().deactivateMBean(objectName);
        }
    }

    public static Exception createSerializableException(Throwable throwable, Class[] classArray) {
        List<Class> list = classArray == null ? Collections.EMPTY_LIST : Arrays.asList(classArray);
        try {
            Exception exception = (Exception)throwable.getClass().getConstructor(throwableConSignature).newInstance(throwable.getMessage(), Utils.parseException(throwable.getCause(), list, 0));
            exception.setStackTrace(throwable.getStackTrace());
            return exception;
        }
        catch (Throwable throwable2) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "createSerializableException", throwable2);
            }
            try {
                Exception exception = (Exception)throwable.getClass().getConstructor(throwableConSignatureAlternate).newInstance(throwable.getMessage());
                exception.initCause(Utils.parseException(throwable.getCause(), list, 0));
                exception.setStackTrace(throwable.getStackTrace());
                return exception;
            }
            catch (Throwable throwable3) {
                FFDCFilter.processException(throwable3, "com.ibm.ws.scheduler.Utils", "688");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "createSerializableException", throwable3);
                }
                return new SerializableWrappedException(Utils.parseException(throwable.getCause(), list, 0));
            }
        }
    }

    public static Throwable parseException(Throwable throwable, List list, int n) {
        Throwable throwable2;
        String string;
        block10: {
            if (throwable == null) {
                return null;
            }
            if (throwable instanceof SerializableWrappedException) {
                return throwable;
            }
            Class<?> clazz = throwable.getClass();
            string = clazz.getName();
            throwable2 = throwable.getCause();
            if (throwable2 != null && n <= 100 && throwable2 != throwable) {
                throwable2 = Utils.parseException(throwable2, list, ++n);
            }
            if (list.contains(clazz)) {
                try {
                    if (throwable2 == null) {
                        return throwable;
                    }
                    Throwable throwable3 = (Throwable)clazz.getConstructor(throwableConSignature).newInstance(throwable.getMessage(), throwable2);
                    throwable3.setStackTrace(throwable.getStackTrace());
                    return throwable3;
                }
                catch (Throwable throwable4) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "createSerializableException", throwable4);
                    }
                    try {
                        Throwable throwable5 = (Throwable)clazz.getConstructor(throwableConSignatureAlternate).newInstance(throwable.getMessage());
                        throwable5.initCause(throwable2);
                        throwable5.setStackTrace(throwable.getStackTrace());
                        return throwable5;
                    }
                    catch (Throwable throwable6) {
                        FFDCFilter.processException(throwable6, "com.ibm.ws.scheduler.Utils.parseException", "761");
                        if (!tc.isDebugEnabled()) break block10;
                        Tr.debug(tc, "createSerializableException", throwable6);
                    }
                }
            }
        }
        String string2 = Utils.getExceptionMessageWithType(throwable, string);
        return new SerializableWrappedException(string2, throwable.getStackTrace(), string, throwable2);
    }

    public static AuthDataCredential getAuthDataCredentialFromAlias(String string) throws LoginException {
        return WSDefaultPrincipalMapping.getAuthData(string);
    }

    private static String processType() {
        return AdminServiceFactory.getAdminService().getProcessType();
    }

    public static boolean isAppServer() {
        String string = Utils.processType();
        return string != null && (string.equals("ManagedProcess") || string.equals("UnManagedProcess"));
    }

    public static String dumpClassLoader(ClassLoader classLoader, String string) {
        if (classLoader == null) {
            return "ClassLoader=<null>";
        }
        return classLoader.toString();
    }

    public static String getExceptionMessageWithType(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        return Utils.getExceptionMessageWithType(throwable, throwable.getClass().getName());
    }

    public static String getExceptionMessageWithType(Throwable throwable, String string) {
        if (throwable == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        String string2 = throwable.getLocalizedMessage();
        if (string2 != null) {
            stringBuffer.append(": ");
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static ByteSerializeException getHomeHandleExceptionWrapper(ByteSerializeException byteSerializeException) {
        if (byteSerializeException == null) {
            return byteSerializeException;
        }
        Throwable throwable = byteSerializeException.getCause();
        if (throwable == null) {
            return byteSerializeException;
        }
        if (throwable instanceof OBJECT_NOT_EXIST) {
            OBJECT_NOT_EXIST oBJECT_NOT_EXIST = (OBJECT_NOT_EXIST)throwable;
            int n = oBJECT_NOT_EXIST.minor;
            if (n == 1229126673 || n == 1229126674 || n == 1229126675 || n == 1229126676 || n == 1229126677 || n == 1229126678 || n == 1229126679) {
                return new ByteSerializeException(Messages.getMessage("SCHD0108E", Utils.getExceptionMessageWithType(oBJECT_NOT_EXIST)), oBJECT_NOT_EXIST);
            }
        }
        return byteSerializeException;
    }

    private class ActivateMBeanPA
    implements PrivilegedExceptionAction {
        private MBeanFactory mbeanFactory;
        private String name;
        private RuntimeCollaborator runtimeCollaborator;
        private String mbeanID;
        private String arg;
        private Properties props;

        ActivateMBeanPA(MBeanFactory mBeanFactory, String string, RuntimeCollaborator runtimeCollaborator, String string2, String string3, Properties properties) {
            this.mbeanFactory = mBeanFactory;
            this.name = string;
            this.runtimeCollaborator = runtimeCollaborator;
            this.mbeanID = string2;
            this.arg = string3;
            this.props = properties;
        }

        public Object run() throws AdminException {
            return this.mbeanFactory.activateMBean(this.name, this.runtimeCollaborator, this.mbeanID, this.arg, this.props);
        }
    }
}

