/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scheduler;

import com.ibm.ejs.models.base.resources.J2EEResourceFactory;
import com.ibm.ejs.models.base.resources.J2EEResourceProperty;
import com.ibm.ejs.models.base.resources.J2EEResourcePropertySet;
import com.ibm.ejs.models.base.resources.J2EEResourceProvider;
import com.ibm.ejs.models.base.resources.MappingModule;
import com.ibm.ejs.models.base.resources.jdbc.DataSource;
import com.ibm.ejs.models.base.resources.jdbc.JDBCProvider;
import com.ibm.ejs.models.base.resources.jdbc.WAS40DataSource;
import com.ibm.ejs.models.base.resources.jdbc.impl.JDBCProviderImpl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.extensionhelper.ExtensionHelper;
import com.ibm.ws.extensionhelper.TransactionControl;
import com.ibm.ws.extensionhelper.TxHandle;
import com.ibm.ws.extensionhelper.exception.UnableToInitializeException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.leasemanager.impl.LeaseManagerDBHelper;
import com.ibm.ws.leasemanager.impl.LeaseStore;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.ResourceMgr;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.VariableMapFactory;
import com.ibm.ws.scheduler.CfgHelperTask;
import com.ibm.ws.scheduler.DBHelper;
import com.ibm.ws.scheduler.DBHelperImpl;
import com.ibm.ws.scheduler.SchedulerConfigHelper;
import com.ibm.ws.scheduler.SchedulerConfigService;
import com.ibm.ws.scheduler.TaskStore;
import com.ibm.ws.scheduler.Utils;
import com.ibm.ws.scheduler.config.SchedulerBaseConfigurationImpl;
import com.ibm.ws.scheduler.config.SchedulerConfiguration;
import com.ibm.ws.scheduler.exception.SchedulerDataStoreException;
import com.ibm.ws.scheduler.exception.SchedulerDataStoreWarning;
import com.ibm.ws.scheduler.resources.Messages;
import com.ibm.ws.scheduler.spi.TaskInfo;
import com.ibm.ws.scripting.ObjectNameHelper;
import com.ibm.ws.security.auth.j2c.WSDefaultPrincipalMapping;
import com.ibm.ws.security.cred.AuthDataCredential;
import java.io.File;
import java.io.FileNotFoundException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class WASSchedulerCfgHelper
implements SchedulerConfigHelper {
    private static final TraceComponent tc = Tr.register(WASSchedulerCfgHelper.class, "Scheduler", "com.ibm.ws.scheduler.resources.SchedulerMessages");
    SchedulerConfigService scs = null;
    static int count = 0;
    AdminService adminService = null;
    String processType = null;
    int processTypeID = -1;
    private static final int VERIFY_OPERATION = 1;
    private static final int CREATE_OPERATION = 2;
    private static final int DROP_OPERATION = 3;
    private static final int SEARCH_STRATEGY_ALL = 1;
    private static final int SEARCH_STRATEGY_CURRENT_AND_HIGHER_ONLY = 2;
    private static final int DEFAULT_SEARCH_STRATEGY = 2;
    private static final String SCHEDULER_PROP_CONFIGURATION_SEARCH_STRATEGY = "scheduler.config.search.strategy";
    private static final String PROP_FILE = "com/ibm/ws/scheduler/Databases.properties";
    private static final String[] MBEAN_COMMON_OP_SIGNATURE = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
    private static final int[] CONFIG_LOCATION_TYPES = new int[]{4, 3, 2, 0};

    public WASSchedulerCfgHelper(SchedulerConfigService schedulerConfigService) {
        this.scs = schedulerConfigService;
        this.adminService = AdminServiceFactory.getAdminService();
        this.processType = this.adminService.getProcessType();
        this.processTypeID = this.processType.equals("DeploymentManager") ? 0 : (this.processType.equals("NodeAgent") ? 3 : 4);
    }

    private static String configRootScopeToString(int n) {
        switch (n) {
            case 4: {
                return "SERVER (" + n + ')';
            }
            case 3: {
                return "NODE (" + n + ')';
            }
            case 0: {
                return "CELL (" + n + ')';
            }
            case 2: {
                return "CLUSTER (" + n + ')';
            }
        }
        return "UNKNOWN (" + n + ')';
    }

    public static Map createSQLSubstitutionMap(String string) {
        final String string2 = "ADD CONSTRAINT [" + string;
        final String string3 = "CREATE CLUSTERED INDEX [" + string;
        final String string4 = "CREATE INDEX [" + string;
        final String string5 = "].[" + string;
        TreeMap<String, String> treeMap = new TreeMap<String, String>(new Comparator(){

            public int compare(Object object, Object object2) {
                return object.equals(object2) ? 0 : (object.equals(string2) ? -1 : (object2.equals(string2) ? 1 : (object.equals(string3) ? -1 : (object2.equals(string3) ? 1 : (object.equals(string4) ? -1 : (object2.equals(string4) ? 1 : (object.equals(string5) ? -1 : (object2.equals(string5) ? 1 : ((Comparable)object).compareTo(object2)))))))));
            }
        });
        String[] stringArray = WASSchedulerCfgHelper.getTableParts(string);
        String string6 = stringArray[0];
        String string7 = stringArray[1];
        String string8 = stringArray[2];
        if (string6 != null) {
            treeMap.put(string2, "ADD CONSTRAINT [" + string8);
            treeMap.put(string3, "CREATE CLUSTERED INDEX [" + string8);
            treeMap.put(string4, "CREATE INDEX [" + string8);
            treeMap.put(string5, "].[" + string8);
            treeMap.put("[" + string, "[" + string6 + "].[" + string7 + "].[" + string8);
            treeMap.put("\"" + string, "\"" + string6 + "\".\"" + string7 + "\".\"" + string8);
        } else if (string7 != null) {
            treeMap.put(string2, "ADD CONSTRAINT [" + string8);
            treeMap.put(string3, "CREATE CLUSTERED INDEX [" + string8);
            treeMap.put(string4, "CREATE INDEX [" + string8);
            treeMap.put(string5, "].[" + string8);
            treeMap.put("[" + string, "[" + string7 + "].[" + string8);
            treeMap.put("\"" + string, "\"" + string7 + "\".\"" + string8);
        }
        return treeMap;
    }

    private static String[] getTableParts(String string) {
        String[] stringArray = new String[]{null, null, null};
        if (string == null) {
            return stringArray;
        }
        stringArray[2] = string;
        int n = string.lastIndexOf(46);
        if (n != -1) {
            stringArray[2] = string.substring(n + 1);
            stringArray[1] = string.substring(0, n);
            int n2 = string.lastIndexOf(46, n - 1);
            if (n2 != -1) {
                stringArray[1] = string.substring(n2 + 1, n);
                stringArray[0] = string.substring(0, n2);
            }
        }
        return stringArray;
    }

    public void verifyTables(String string) throws SchedulerDataStoreException {
        this.verifyTables(string, null, null);
    }

    public void verifyTables(String string, String string2, String string3) throws SchedulerDataStoreException {
        this.process(1, string, string2, string3);
    }

    public void verifyTables(String string, String string2) throws SchedulerDataStoreException {
        try {
            AuthDataCredential authDataCredential = Utils.getAuthDataCredentialFromAlias(string2);
            String string3 = null;
            String string4 = null;
            if (authDataCredential != null) {
                string3 = authDataCredential.getUserName();
                string4 = authDataCredential.getPassword();
            }
            this.verifyTables(string, string3, string4);
        }
        catch (SchedulerDataStoreException schedulerDataStoreException) {
            throw schedulerDataStoreException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.WASSchedulerCfgHelper.verifyTables", "183", this);
            throw new SchedulerDataStoreException(Utils.getExceptionMessageWithType(throwable), throwable);
        }
    }

    public Boolean createTables(String string) throws SchedulerDataStoreException {
        return this.createTables(string, null, null);
    }

    public Boolean createTables(String string, String string2, String string3) throws SchedulerDataStoreException {
        return new Boolean(this.process(2, string, string2, string3));
    }

    public Boolean createTables(String string, String string2) throws SchedulerDataStoreException {
        try {
            AuthDataCredential authDataCredential = Utils.getAuthDataCredentialFromAlias(string2);
            String string3 = null;
            String string4 = null;
            if (authDataCredential != null) {
                string3 = authDataCredential.getUserName();
                string4 = authDataCredential.getPassword();
            }
            return this.createTables(string, string3, string4);
        }
        catch (SchedulerDataStoreException schedulerDataStoreException) {
            throw schedulerDataStoreException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.WASSchedulerCfgHelper.createTables", "256", this);
            throw new SchedulerDataStoreException(Utils.getExceptionMessageWithType(throwable), throwable);
        }
    }

    public Boolean dropTables(String string) throws SchedulerDataStoreException {
        return this.dropTables(string, null, null);
    }

    public Boolean dropTables(String string, String string2, String string3) throws SchedulerDataStoreException {
        return new Boolean(this.process(3, string, string2, string3));
    }

    public Boolean dropTables(String string, String string2) throws SchedulerDataStoreException {
        try {
            AuthDataCredential authDataCredential = Utils.getAuthDataCredentialFromAlias(string2);
            String string3 = null;
            String string4 = null;
            if (authDataCredential != null) {
                string3 = authDataCredential.getUserName();
                string4 = authDataCredential.getPassword();
            }
            return this.dropTables(string, string3, string4);
        }
        catch (SchedulerDataStoreException schedulerDataStoreException) {
            throw schedulerDataStoreException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.WASSchedulerCfgHelper.dropTables", "308", this);
            throw new SchedulerDataStoreException(Utils.getExceptionMessageWithType(throwable), throwable);
        }
    }

    public void verifyTables(SchedulerConfiguration schedulerConfiguration) throws SchedulerDataStoreException {
        try {
            this.verifyTables(this.getDatabaseHelper(schedulerConfiguration), this.getDatabaseHelperLeaseManager(schedulerConfiguration), schedulerConfiguration);
        }
        catch (UnableToInitializeException unableToInitializeException) {
            FFDCFilter.processException((Throwable)unableToInitializeException, "com.ibm.ws.scheduler.WASSchedulerCfgHelper.verifyTables", "321", this);
            throw new SchedulerDataStoreException(Utils.getExceptionMessageWithType(unableToInitializeException), unableToInitializeException);
        }
    }

    public Boolean createTables(SchedulerConfiguration schedulerConfiguration) throws SchedulerDataStoreException {
        boolean bl = false;
        try {
            bl = this.createTables(this.getDatabaseHelper(schedulerConfiguration), this.getDatabaseHelperLeaseManager(schedulerConfiguration), schedulerConfiguration);
        }
        catch (UnableToInitializeException unableToInitializeException) {
            FFDCFilter.processException((Throwable)unableToInitializeException, "com.ibm.ws.scheduler.WASSchedulerCfgHelper.createTables", "336", this);
            throw new SchedulerDataStoreException(Utils.getExceptionMessageWithType(unableToInitializeException), unableToInitializeException);
        }
        return new Boolean(bl);
    }

    public Boolean dropTables(SchedulerConfiguration schedulerConfiguration) throws SchedulerDataStoreException {
        boolean bl = false;
        try {
            bl = this.dropTables(this.getDatabaseHelper(schedulerConfiguration), this.getDatabaseHelperLeaseManager(schedulerConfiguration), schedulerConfiguration);
        }
        catch (UnableToInitializeException unableToInitializeException) {
            FFDCFilter.processException((Throwable)unableToInitializeException, "com.ibm.ws.scheduler.WASSchedulerCfgHelper.dropTables", "354", this);
            throw new SchedulerDataStoreException(Utils.getExceptionMessageWithType(unableToInitializeException), unableToInitializeException);
        }
        return new Boolean(bl);
    }

    private DataSourceProperties getDataSourceProperties(VariableMap variableMap, String string, ConfigLocation configLocation, String string2, String string3) throws SchedulerDataStoreException {
        try {
            DataSourceInfo dataSourceInfo = this.findDataSourceConfig(variableMap, string, configLocation);
            DataSourceProperties dataSourceProperties = new DataSourceProperties(dataSourceInfo.dataSource, variableMap, dataSourceInfo.dataSourceLocation);
            if (string2 != null && string2.length() > 0) {
                dataSourceProperties.setUserid(string2);
                dataSourceProperties.setPassword(string3);
            }
            return dataSourceProperties;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (this.processType.equals("DeploymentManager")) {
                SchedulerDataStoreException schedulerDataStoreException = new SchedulerDataStoreException("Unable to access the scheduler tables from the deployment manager. The server or node agent might not be running.", illegalArgumentException);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getDataSourceProperties", schedulerDataStoreException);
                }
                throw schedulerDataStoreException;
            }
            FFDCFilter.processException((Throwable)illegalArgumentException, this.getClass().getName() + ".getDataSourceProperties", "620", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getDataSourceProperties", illegalArgumentException);
            }
            throw illegalArgumentException;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void verifyTables(DBHelper dBHelper, LeaseManagerDBHelper leaseManagerDBHelper, SchedulerConfiguration schedulerConfiguration) throws SchedulerDataStoreException {
        Connection connection = null;
        TransactionControl transactionControl = dBHelper.getTransactionControl();
        TxHandle txHandle = null;
        try {
            TaskStore taskStore = dBHelper.getTaskStore();
            try {
                taskStore.getTableStatus();
            }
            catch (SchedulerDataStoreException schedulerDataStoreException) {
                FFDCFilter.processException((Throwable)schedulerDataStoreException, "com.ibm.ws.scheduler.WASSchedulerCfgHelper.verifyTables", "414", this);
                throw new SchedulerDataStoreException(Messages.getMessage("SCHD0046E", new String[]{schedulerDataStoreException.getMessage(), schedulerConfiguration.getDataSourceJndiName(), schedulerConfiguration.getName(), schedulerConfiguration.getJndiName()}));
            }
            txHandle = transactionControl.preinvoke();
            connection = dBHelper.getConnection(txHandle, 2, true);
            TaskInfo taskInfo = new CfgHelperTask();
            TaskInfo taskInfo2 = taskStore.create(connection, taskInfo);
            taskInfo = taskStore.findByPrimaryKey(connection, taskInfo2.getTaskId(), "ADMIN", true);
            taskStore.remove(connection, taskInfo);
            if (!leaseManagerDBHelper.isTablesSetupProperly()) {
                throw new SchedulerDataStoreWarning(Messages.getMessage("SCHD0084W", new String[]{schedulerConfiguration.getDataSourceJndiName(), schedulerConfiguration.getName(), schedulerConfiguration.getJndiName()}));
            }
            transactionControl.postinvoke(txHandle);
            Tr.info(tc, Messages.getMessage("SCHD0100I"));
        }
        catch (SchedulerDataStoreWarning schedulerDataStoreWarning) {
            try {
                FFDCFilter.processException((Throwable)schedulerDataStoreWarning, "com.ibm.ws.scheduler.WASSchedulerCfgHelper.verifyTables", "439", this);
                try {
                    transactionControl.postinvoke(txHandle);
                    throw schedulerDataStoreWarning;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.WASSchedulerCfgHelper.verifyTables", "447", this);
                }
                throw schedulerDataStoreWarning;
                catch (SchedulerDataStoreException schedulerDataStoreException) {
                    FFDCFilter.processException((Throwable)schedulerDataStoreException, "com.ibm.ws.scheduler.WASSchedulerCfgHelper.verifyTables", "453", this);
                    try {
                        transactionControl.handleException(txHandle);
                        throw schedulerDataStoreException;
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.WASSchedulerCfgHelper.verifyTables", "461", this);
                    }
                    throw schedulerDataStoreException;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.WASSchedulerCfgHelper.verifyTables", "467", this);
                    try {
                        transactionControl.handleException(txHandle);
                        throw new SchedulerDataStoreException(Utils.getExceptionMessageWithType(throwable), throwable);
                    }
                    catch (Throwable throwable2) {
                        FFDCFilter.processException(throwable2, "com.ibm.ws.scheduler.WASSchedulerCfgHelper.verifyTables", "475", this);
                    }
                    throw new SchedulerDataStoreException(Utils.getExceptionMessageWithType(throwable), throwable);
                }
            }
            catch (Throwable throwable) {
                try {
                    dBHelper.returnConnection(connection);
                    throw throwable;
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.scheduler.WASSchedulerCfgHelper.verifyTables", "488", this);
                }
                throw throwable;
            }
        }
        try {
            dBHelper.returnConnection(connection);
            return;
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.scheduler.WASSchedulerCfgHelper.verifyTables", "488", this);
            return;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean dropTables(DBHelper dBHelper, LeaseManagerDBHelper leaseManagerDBHelper, SchedulerConfiguration schedulerConfiguration) throws SchedulerDataStoreException {
        boolean bl;
        Connection connection = null;
        TransactionControl transactionControl = dBHelper.getTransactionControl();
        TxHandle txHandle = null;
        boolean bl2 = false;
        try {
            TaskStore taskStore = dBHelper.getTaskStore();
            txHandle = transactionControl.preinvoke();
            connection = dBHelper.getConnection(txHandle, 2, true);
            bl2 = taskStore.dropTables(connection);
            if (leaseManagerDBHelper.isTablesSetupProperly()) {
                LeaseStore leaseStore = leaseManagerDBHelper.getLeaseStore();
                bl2 = leaseStore.dropTables(connection);
            }
            transactionControl.postinvoke(txHandle);
            if (bl2) {
                Tr.info(tc, Messages.getMessage("SCHD0090I"));
            }
            bl = bl2;
        }
        catch (SchedulerDataStoreWarning schedulerDataStoreWarning) {
            try {
                FFDCFilter.processException((Throwable)schedulerDataStoreWarning, "com.ibm.ws.scheduler.WASSchedulerCfgHelper.dropTables", "524", this);
                try {
                    transactionControl.postinvoke(txHandle);
                    throw schedulerDataStoreWarning;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.WASSchedulerCfgHelper.dropTables", "532", this);
                }
                throw schedulerDataStoreWarning;
                catch (SchedulerDataStoreException schedulerDataStoreException) {
                    FFDCFilter.processException((Throwable)schedulerDataStoreException, "com.ibm.ws.scheduler.WASSchedulerCfgHelper.dropTables", "538", this);
                    try {
                        transactionControl.handleException(txHandle);
                        throw schedulerDataStoreException;
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.WASSchedulerCfgHelper.dropTables", "546", this);
                    }
                    throw schedulerDataStoreException;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.WASSchedulerCfgHelper.dropTables", "552", this);
                    try {
                        transactionControl.handleException(txHandle);
                        throw new SchedulerDataStoreException(Utils.getExceptionMessageWithType(throwable), throwable);
                    }
                    catch (Throwable throwable2) {
                        FFDCFilter.processException(throwable2, "com.ibm.ws.scheduler.WASSchedulerCfgHelper.dropTables", "560", this);
                    }
                    throw new SchedulerDataStoreException(Utils.getExceptionMessageWithType(throwable), throwable);
                }
            }
            catch (Throwable throwable) {
                try {
                    dBHelper.returnConnection(connection);
                    throw throwable;
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.scheduler.WASSchedulerCfgHelper.dropTables", "573", this);
                }
                throw throwable;
            }
        }
        try {
            dBHelper.returnConnection(connection);
            return bl;
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.scheduler.WASSchedulerCfgHelper.dropTables", "573", this);
        }
        return bl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean createTables(DBHelper dBHelper, LeaseManagerDBHelper leaseManagerDBHelper, SchedulerConfiguration schedulerConfiguration) throws SchedulerDataStoreException {
        boolean bl;
        Connection connection = null;
        TransactionControl transactionControl = dBHelper.getTransactionControl();
        TxHandle txHandle = null;
        boolean bl2 = false;
        try {
            TaskStore taskStore = dBHelper.getTaskStore();
            txHandle = transactionControl.preinvoke();
            connection = dBHelper.getConnection(txHandle, 2, true);
            bl2 = taskStore.createTables(connection);
            LeaseStore leaseStore = leaseManagerDBHelper.getLeaseStore();
            bl2 = leaseStore.createTables(connection);
            transactionControl.postinvoke(txHandle);
            if (bl2) {
                Tr.info(tc, Messages.getMessage("SCHD0087I"));
            }
            bl = bl2;
        }
        catch (SchedulerDataStoreWarning schedulerDataStoreWarning) {
            try {
                FFDCFilter.processException((Throwable)schedulerDataStoreWarning, "com.ibm.ws.scheduler.WASSchedulerCfgHelper.createTables", "607", this);
                try {
                    transactionControl.postinvoke(txHandle);
                    throw schedulerDataStoreWarning;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.WASSchedulerCfgHelper.createTables", "615", this);
                }
                throw schedulerDataStoreWarning;
                catch (SchedulerDataStoreException schedulerDataStoreException) {
                    FFDCFilter.processException((Throwable)schedulerDataStoreException, "com.ibm.ws.scheduler.WASSchedulerCfgHelper.createTables", "621", this);
                    try {
                        transactionControl.handleException(txHandle);
                        throw schedulerDataStoreException;
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.WASSchedulerCfgHelper.createTables", "629", this);
                    }
                    throw schedulerDataStoreException;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.WASSchedulerCfgHelper.createTables", "635", this);
                    try {
                        transactionControl.handleException(txHandle);
                        throw new SchedulerDataStoreException(Utils.getExceptionMessageWithType(throwable), throwable);
                    }
                    catch (Throwable throwable2) {
                        FFDCFilter.processException(throwable2, "com.ibm.ws.scheduler.WASSchedulerCfgHelper.createTables", "643", this);
                    }
                    throw new SchedulerDataStoreException(Utils.getExceptionMessageWithType(throwable), throwable);
                }
            }
            catch (Throwable throwable) {
                try {
                    dBHelper.returnConnection(connection);
                    throw throwable;
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.scheduler.WASSchedulerCfgHelper.createTables", "656", this);
                }
                throw throwable;
            }
        }
        try {
            dBHelper.returnConnection(connection);
            return bl;
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.scheduler.WASSchedulerCfgHelper.createTables", "656", this);
        }
        return bl;
    }

    private DBHelper getDatabaseHelper(DataSourceProperties dataSourceProperties, String string) throws UnableToInitializeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDatabaseHelper", new Object[]{dataSourceProperties, string});
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("dbhelper.statements.file", PROP_FILE);
        hashMap.put("dbhelper.jndi.name", dataSourceProperties.getJNDIName());
        hashMap.put("dbhelper.username", dataSourceProperties.getUserid());
        hashMap.put("dbhelper.password", dataSourceProperties.getPassword());
        hashMap.put("dbhelper.table.prefix", string);
        hashMap.put("dbhelper.replacement.map", WASSchedulerCfgHelper.createSQLSubstitutionMap(string));
        hashMap.put("dbhelper.datasource.classname", dataSourceProperties.getDataSourceClassname());
        hashMap.put("dbhelper.datasource.classpath", dataSourceProperties.getClasspathAsString());
        hashMap.put("dbhelper.datasource.properties", dataSourceProperties.getProperties());
        DBHelperImpl dBHelperImpl = new DBHelperImpl(null, this.getExtensionHelper(), hashMap);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDatabaseHelper", dBHelperImpl);
        }
        return dBHelperImpl;
    }

    private LeaseManagerDBHelper getDatabaseHelperLeaseManager(DataSourceProperties dataSourceProperties, String string) throws UnableToInitializeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDatabaseHelperLeaseManager", new Object[]{dataSourceProperties, string});
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("dbhelper.statements.file", "com/ibm/ws/leasemanager/impl/leasemanager_statements.properties");
        hashMap.put("dbhelper.jndi.name", dataSourceProperties.getJNDIName());
        hashMap.put("dbhelper.username", dataSourceProperties.getUserid());
        hashMap.put("dbhelper.password", dataSourceProperties.getPassword());
        hashMap.put("dbhelper.table.prefix", string);
        hashMap.put("dbhelper.replacement.map", WASSchedulerCfgHelper.createSQLSubstitutionMap(string));
        hashMap.put("dbhelper.datasource.classname", dataSourceProperties.getDataSourceClassname());
        hashMap.put("dbhelper.datasource.classpath", dataSourceProperties.getClasspathAsString());
        hashMap.put("dbhelper.datasource.properties", dataSourceProperties.getProperties());
        LeaseManagerDBHelper leaseManagerDBHelper = new LeaseManagerDBHelper(this.getExtensionHelper(), hashMap);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDatabaseHelperLeaseManager", leaseManagerDBHelper);
        }
        return leaseManagerDBHelper;
    }

    private DBHelper getDatabaseHelper(SchedulerConfiguration schedulerConfiguration) throws UnableToInitializeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDatabaseHelper", schedulerConfiguration);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("dbhelper.statements.file", PROP_FILE);
        hashMap.put("dbhelper.jndi.name", schedulerConfiguration.getDataSourceJndiName());
        hashMap.put("dbhelper.username", schedulerConfiguration.getUsername());
        hashMap.put("dbhelper.password", schedulerConfiguration.getPassword());
        hashMap.put("dbhelper.table.prefix", schedulerConfiguration.getTablePrefix());
        hashMap.put("dbhelper.replacement.map", WASSchedulerCfgHelper.createSQLSubstitutionMap(schedulerConfiguration.getTablePrefix()));
        DBHelperImpl dBHelperImpl = new DBHelperImpl(null, this.getExtensionHelper(), hashMap);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDatabaseHelper", dBHelperImpl);
        }
        return dBHelperImpl;
    }

    private LeaseManagerDBHelper getDatabaseHelperLeaseManager(SchedulerConfiguration schedulerConfiguration) throws UnableToInitializeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDatabaseHelperLeaseManager", schedulerConfiguration);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("dbhelper.statements.file", "com/ibm/ws/leasemanager/impl/leasemanager_statements.properties");
        hashMap.put("dbhelper.jndi.name", schedulerConfiguration.getDataSourceJndiName());
        hashMap.put("dbhelper.username", schedulerConfiguration.getUsername());
        hashMap.put("dbhelper.password", schedulerConfiguration.getPassword());
        hashMap.put("dbhelper.table.prefix", schedulerConfiguration.getTablePrefix());
        hashMap.put("dbhelper.replacement.map", WASSchedulerCfgHelper.createSQLSubstitutionMap(schedulerConfiguration.getTablePrefix()));
        LeaseManagerDBHelper leaseManagerDBHelper = new LeaseManagerDBHelper(this.getExtensionHelper(), hashMap);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDatabaseHelperLeaseManager", leaseManagerDBHelper);
        }
        return leaseManagerDBHelper;
    }

    private void reload() throws RuntimeError, RuntimeWarning {
        ResourceMgr resourceMgr;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "reload");
        }
        if ((resourceMgr = this.getResourceMgr()) != null) {
            resourceMgr.reload();
        }
    }

    private VariableMap getVariableMap(ConfigLocation configLocation) throws RuntimeError {
        VariableMap variableMap = this.scs.getVariableMap();
        if (variableMap != null && !this.processType.equals("DeploymentManager")) {
            variableMap.refresh();
        } else {
            variableMap = this.createVariableMap(configLocation);
        }
        return variableMap;
    }

    private boolean process(int n, String string, String string2, String string3) throws SchedulerDataStoreException {
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "process", new Object[]{WASSchedulerCfgHelper.getOperationAsString(n), string, string2});
        }
        boolean bl2 = false;
        try {
            ConfigLocation configLocation;
            ObjectName objectName = ObjectNameHelper.makeObjectName(string);
            try {
                this.reload();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.WASSchedulerCfgHelper.process", "758", this);
            }
            ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
            ConfigLocation configLocation2 = this.getConfigLocation(configDataId);
            com.ibm.websphere.models.config.scheduler.SchedulerConfiguration schedulerConfiguration = this.getSchedulerConfiguration(configDataId, configLocation2);
            if (schedulerConfiguration == null) {
                throw new SchedulerDataStoreException(Messages.getMessage("SCHD0083E", configDataId.toString()));
            }
            SchedulerBaseConfigurationImpl schedulerBaseConfigurationImpl = new SchedulerBaseConfigurationImpl((J2EEResourceFactory)schedulerConfiguration);
            if ((string2 == null || string2.length() == 0) && schedulerBaseConfigurationImpl.getUsername() != null && schedulerBaseConfigurationImpl.getUsername().length() > 0) {
                string2 = schedulerBaseConfigurationImpl.getUsername();
                string3 = schedulerBaseConfigurationImpl.getPassword();
            }
            if ((configLocation = new ConfigLocation()).isLevelLower(configLocation2)) {
                configLocation = configLocation2;
            }
            VariableMap variableMap = this.getVariableMap(configLocation2);
            bl2 = this.processAtDelegate(n, variableMap, configLocation2, schedulerBaseConfigurationImpl, string, configLocation, string2, string3);
        }
        catch (SchedulerDataStoreException schedulerDataStoreException) {
            FFDCFilter.processException((Throwable)schedulerDataStoreException, "com.ibm.ws.scheduler.WASSchedulerCfgHelper.process", "796", this);
            throw schedulerDataStoreException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.WASSchedulerCfgHelper.process", "801", this);
            throw new SchedulerDataStoreException(Utils.getExceptionMessageWithType(throwable), throwable);
        }
        if (bl) {
            Tr.exit(tc, "process", new Boolean(bl2));
        }
        return bl2;
    }

    private boolean processLocally(int n, DataSourceProperties dataSourceProperties, SchedulerConfiguration schedulerConfiguration) throws SchedulerDataStoreException, UnableToInitializeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processLocally", new Object[]{WASSchedulerCfgHelper.getOperationAsString(n), dataSourceProperties, schedulerConfiguration});
        }
        try {
            boolean bl = false;
            DBHelper dBHelper = this.getDatabaseHelper(dataSourceProperties, schedulerConfiguration.getTablePrefix());
            LeaseManagerDBHelper leaseManagerDBHelper = this.getDatabaseHelperLeaseManager(dataSourceProperties, schedulerConfiguration.getTablePrefix());
            switch (n) {
                case 1: {
                    this.verifyTables(dBHelper, leaseManagerDBHelper, schedulerConfiguration);
                    break;
                }
                case 2: {
                    bl = this.createTables(dBHelper, leaseManagerDBHelper, schedulerConfiguration);
                    break;
                }
                case 3: {
                    bl = this.dropTables(dBHelper, leaseManagerDBHelper, schedulerConfiguration);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "processLocally", bl ? "Database was updated" : "Database was not updated");
            }
            return bl;
        }
        catch (Throwable throwable) {
            String string = null;
            switch (n) {
                case 1: {
                    string = Messages.getMessage("TABLE_OPERATION_VERIFY");
                    break;
                }
                case 2: {
                    string = Messages.getMessage("TABLE_OPERATION_CREATE");
                    break;
                }
                case 3: {
                    string = Messages.getMessage("TABLE_OPERATION_DROP");
                }
            }
            Tr.warning(tc, "SCHD0130W", new Object[]{string, throwable});
            if (throwable instanceof SchedulerDataStoreException) {
                throw (SchedulerDataStoreException)throwable;
            }
            if (throwable instanceof UnableToInitializeException) {
                throw (UnableToInitializeException)throwable;
            }
            throw new SchedulerDataStoreException(Utils.getExceptionMessageWithType(throwable), throwable);
        }
    }

    /*
     * Exception decompiling
     */
    private boolean processAtDelegate(int var1_1, VariableMap var2_2, ConfigLocation var3_3, SchedulerConfiguration var4_4, String var5_5, ConfigLocation var6_6, String var7_7, String var8_8) throws Throwable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected ObjectName getMBean(String string) {
        boolean bl;
        block7: {
            bl = tc.isEntryEnabled();
            boolean bl2 = tc.isDebugEnabled();
            if (bl) {
                Tr.entry(tc, "getMBean", new Object[]{string});
            }
            try {
                ObjectName objectName = new ObjectName(string);
                Iterator iterator = this.adminService.queryNames(objectName, null).iterator();
                if (iterator.hasNext()) {
                    ObjectName objectName2 = (ObjectName)iterator.next();
                    if (iterator.hasNext() && bl2) {
                        Tr.debug(tc, "Multiple MBeans found when only one was expected");
                    }
                    if (bl) {
                        Tr.exit(tc, "getMBean", new Object[]{objectName2});
                    }
                    return objectName2;
                }
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                FFDCFilter.processException((Throwable)malformedObjectNameException, "com.ibm.ws.scheduler.WASSchedulerCfgHelper.getMBean", "958", this);
                if (!bl2) break block7;
                Tr.debug(tc, "Invalid MBean filter passed to getMBean: " + string);
            }
        }
        if (bl) {
            Tr.exit(tc, "getMBean");
        }
        return null;
    }

    private String getLocatorString(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer("WebSphere:type=WASSchedulerCfgHelper,node=");
        stringBuffer.append(string);
        stringBuffer.append(",process=");
        stringBuffer.append(string2);
        stringBuffer.append(",*");
        return stringBuffer.toString();
    }

    private DataSourceInfo findDataSourceConfig(VariableMap variableMap, String string, ConfigLocation configLocation) throws SchedulerDataStoreException {
        int n = this.getIntFromVariableMap(variableMap, SCHEDULER_PROP_CONFIGURATION_SEARCH_STRATEGY, 2);
        Repository repository2 = this.getRepository();
        ConfigRoot configRoot = repository2.getConfigRoot();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = this.getLocationIndex(configLocation.getLocationType());
        Resource resource = null;
        DataSourceInfo dataSourceInfo = null;
        configLocation.setConfigRootLocation(configRoot, CONFIG_LOCATION_TYPES[n2]);
        for (int i = 0; i < CONFIG_LOCATION_TYPES.length && dataSourceInfo == null; ++i) {
            try {
                arrayList.add(configRoot.getAbsolutePath(CONFIG_LOCATION_TYPES[n2], "resources.xml"));
                resource = configRoot.getResource(CONFIG_LOCATION_TYPES[n2], "resources.xml");
                EList eList = resource.getContents();
                Iterator iterator = eList.iterator();
                while (iterator.hasNext() && dataSourceInfo == null) {
                    J2EEResourceFactory j2EEResourceFactory;
                    Object e2 = iterator.next();
                    if (!(e2 instanceof JDBCProviderImpl) || (j2EEResourceFactory = this.findDataSource((J2EEResourceProvider)e2, string)) == null) continue;
                    dataSourceInfo = new DataSourceInfo(j2EEResourceFactory, configLocation.getSubConfigLocation(CONFIG_LOCATION_TYPES[n2]));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (++n2 < CONFIG_LOCATION_TYPES.length) continue;
            if (n == 2) {
                i = n2;
                continue;
            }
            n2 = 0;
        }
        if (dataSourceInfo == null) {
            throw new SchedulerDataStoreException(Messages.getMessage("SCHD0085E", new String[]{string, arrayList.toString()}));
        }
        return dataSourceInfo;
    }

    private J2EEResourceFactory findDataSource(J2EEResourceProvider j2EEResourceProvider, String string) {
        EList eList = j2EEResourceProvider.getFactories();
        Iterator iterator = eList.iterator();
        J2EEResourceFactory j2EEResourceFactory = null;
        while (iterator.hasNext() && j2EEResourceFactory == null) {
            J2EEResourceFactory j2EEResourceFactory2 = (J2EEResourceFactory)iterator.next();
            if (!j2EEResourceFactory2.getJndiName().equals(string)) continue;
            j2EEResourceFactory = j2EEResourceFactory2;
        }
        return j2EEResourceFactory;
    }

    private int getLocationIndex(int n) {
        for (int i = 0; i < CONFIG_LOCATION_TYPES.length; ++i) {
            if (n != CONFIG_LOCATION_TYPES[i]) continue;
            return i;
        }
        throw new IllegalArgumentException("Unsupported ConfigRoot type specified: " + n);
    }

    private com.ibm.websphere.models.config.scheduler.SchedulerConfiguration getSchedulerConfiguration(ConfigDataId configDataId, ConfigLocation configLocation) throws SchedulerDataStoreException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSchedulerConfiguration", new Object[]{configDataId, configLocation});
        }
        com.ibm.websphere.models.config.scheduler.SchedulerConfiguration schedulerConfiguration = null;
        Resource resource = null;
        try {
            String string;
            String string2 = string = configDataId.getHref();
            if (string.lastIndexOf(")") != -1) {
                string2 = string.substring(0, string.lastIndexOf(")"));
            }
            URI uRI = URI.createURI((String)string2);
            ConfigRoot configRoot = this.getRepository().getConfigRoot();
            configLocation.setConfigRootLocation(configRoot);
            resource = configRoot.getResource(configLocation.getLocationType(), uRI.lastSegment());
            schedulerConfiguration = (com.ibm.websphere.models.config.scheduler.SchedulerConfiguration)resource.getEObject(uRI.fragment());
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.WASSchedulerCfgHelper.getSchedulerConfiguration", "1123", this);
            throw new SchedulerDataStoreException(Utils.getExceptionMessageWithType(throwable), throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSchedulerConfiguration", schedulerConfiguration);
        }
        return schedulerConfiguration;
    }

    private ConfigLocation getConfigLocation(ConfigDataId configDataId) throws MalformedObjectNameException, SchedulerDataStoreException {
        return new ConfigLocation(configDataId);
    }

    private ExtensionHelper getExtensionHelper() {
        return this.scs.getExtensionHelper();
    }

    private ResourceMgr getResourceMgr() {
        return this.scs.getResourceMgr();
    }

    private Repository getRepository() {
        return this.scs.getRepository();
    }

    private int getIntFromVariableMap(VariableMap variableMap, String string, int n) {
        int n2 = n;
        StringBuffer stringBuffer = new StringBuffer("$(");
        stringBuffer.append(string);
        stringBuffer.append(")");
        String string2 = stringBuffer.toString();
        String string3 = null;
        try {
            string3 = variableMap.expand(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (string3 != null && string3.trim().length() != 0) {
            try {
                n2 = Integer.valueOf(string3);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.WASSchedulerCfgHelper.getIntFromVariableMap", "1183", this);
            }
        }
        return n2;
    }

    private void updateVariableMap(VariableMap variableMap, ConfigRoot configRoot, int n, boolean bl) throws Exception {
        block3: {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "updateVariableMap", new Object[]{variableMap, configRoot, WASSchedulerCfgHelper.configRootScopeToString(n), bl ? "fail if missing" : "skip if missing"});
            }
            try {
                variableMap.addVariableMap(configRoot.getResource(n, "variables.xml"));
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (!bl) break block3;
                throw fileNotFoundException;
            }
        }
    }

    private VariableMap createVariableMap(ConfigLocation configLocation) throws RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createVariableMap", configLocation);
        }
        VariableMap variableMap = VariableMapFactory.createVariableMap(new HashMap());
        ConfigRoot configRoot = this.getRepository().getConfigRoot();
        configLocation.setConfigRootLocation(configRoot, 4);
        try {
            if (this.processType.equals("ManagedProcess") || this.processType.equals("UnManagedProcess")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, this.processType.equals("ManagedProcess") ? "Managed process" : "Standalone process");
                }
                this.updateVariableMap(variableMap, configRoot, 0, true);
                if (configLocation.clusterLocation != null) {
                    this.updateVariableMap(variableMap, configRoot, 2, false);
                }
                if (configLocation.nodeLocation != null) {
                    this.updateVariableMap(variableMap, configRoot, 3, true);
                }
                if (configLocation.serverLocation != null) {
                    this.updateVariableMap(variableMap, configRoot, 4, true);
                }
            } else if (this.processType.equals("NodeAgent")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Node agent process");
                }
                this.updateVariableMap(variableMap, configRoot, 0, true);
                if (configLocation.clusterLocation != null) {
                    this.updateVariableMap(variableMap, configRoot, 2, false);
                }
                if (configLocation.serverLocation != null) {
                    this.updateVariableMap(variableMap, configRoot, 4, true);
                }
                if (configLocation.nodeLocation != null) {
                    this.updateVariableMap(variableMap, configRoot, 3, true);
                }
            } else if (this.processType.equals("DeploymentManager")) {
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Deployment manager process");
                }
                if (configLocation.serverLocation != null) {
                    this.updateVariableMap(variableMap, configRoot, 4, true);
                }
                if (configLocation.nodeLocation != null) {
                    this.updateVariableMap(variableMap, configRoot, 3, true);
                }
                if (configLocation.clusterLocation != null) {
                    this.updateVariableMap(variableMap, configRoot, 2, false);
                }
                this.updateVariableMap(variableMap, configRoot, 0, true);
            }
        }
        catch (Throwable throwable) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createVariableMap", throwable);
            }
            throw new RuntimeError(throwable.getMessage(), throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createVariableMap", variableMap);
        }
        return variableMap;
    }

    private static final String getOperationAsString(int n) {
        switch (n) {
            case 1: {
                return "VERIFY (" + n + ')';
            }
            case 2: {
                return "CREATE (" + n + ')';
            }
            case 3: {
                return "DROP (" + n + ')';
            }
        }
        return "UNKNOWN (" + n + ')';
    }

    class DataSourceProperties {
        Properties props = null;
        ArrayList classPath = null;
        ArrayList nativePath = null;
        VariableMap varMap = null;
        String dataSourceClassname = null;
        String JNDIName = null;
        AuthDataCredential authDC = null;
        String userid = null;
        String pwd = null;
        ConfigLocation configLocation = null;

        public DataSourceProperties(J2EEResourceFactory j2EEResourceFactory, VariableMap variableMap, ConfigLocation configLocation) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "DataSourceProperties.<init>", new Object[]{j2EEResourceFactory, variableMap, configLocation});
            }
            this.varMap = variableMap;
            this.retrieveDataSourceProperties(j2EEResourceFactory);
            this.configLocation = configLocation;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "DataSourceProperties.<init>");
            }
        }

        public String getDatabaseName() {
            return this.props.getProperty("databaseName", null);
        }

        public String getDataSourceClassname() {
            return this.dataSourceClassname;
        }

        public ArrayList getClasspath() {
            return this.classPath;
        }

        public Properties getProperties() {
            return this.props;
        }

        public String getJNDIName() {
            return this.JNDIName;
        }

        public String getClasspathAsString() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "DataSourceProperties.getClasspathAsString");
            }
            ArrayList arrayList = this.getClasspath();
            Iterator iterator = arrayList.iterator();
            StringBuffer stringBuffer = new StringBuffer();
            if (iterator.hasNext()) {
                stringBuffer.append((String)iterator.next());
            }
            while (iterator.hasNext()) {
                stringBuffer.append(File.pathSeparatorChar);
                stringBuffer.append((String)iterator.next());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "DataSourceProperties.getClasspathAsString", stringBuffer.toString());
            }
            return stringBuffer.toString();
        }

        public String getUserid() {
            if (this.userid == null) {
                try {
                    if (this.authDC != null) {
                        this.userid = this.authDC.getUserName();
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.WASSchedulerCfgHelper.getUserid", "1276", this);
                    this.userid = null;
                }
            }
            return this.userid;
        }

        public String getPassword() {
            if (this.pwd == null) {
                try {
                    if (this.authDC != null) {
                        this.pwd = this.authDC.getPassword();
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.WASSchedulerCfgHelper.getPassword", "1295", this);
                    this.pwd = null;
                }
            }
            return this.pwd;
        }

        public void setUserid(String string) {
            this.userid = string;
        }

        public void setPassword(String string) {
            this.pwd = string;
        }

        public ConfigLocation getConfigLocation() {
            return this.configLocation;
        }

        private void retrieveDataSourceProperties(J2EEResourceFactory j2EEResourceFactory) {
            Object object;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "DataSourceProperties.retrieveDataSourceProperties", j2EEResourceFactory);
            }
            this.JNDIName = j2EEResourceFactory.getJndiName();
            JDBCProvider jDBCProvider = (JDBCProvider)j2EEResourceFactory.getProvider();
            this.props = new Properties();
            J2EEResourcePropertySet j2EEResourcePropertySet = j2EEResourceFactory.getPropertySet();
            if (j2EEResourcePropertySet != null) {
                object = j2EEResourcePropertySet.getResourceProperties();
                for (int i = 0; i < object.size(); ++i) {
                    J2EEResourceProperty j2EEResourceProperty = (J2EEResourceProperty)object.get(i);
                    String string = j2EEResourceProperty.getValue();
                    if (string == null) continue;
                    this.props.put(j2EEResourceProperty.getName(), string);
                }
            }
            if (j2EEResourceFactory instanceof WAS40DataSource && (object = ((WAS40DataSource)j2EEResourceFactory).getDatabaseName()) != null) {
                this.props.setProperty("databaseName", (String)object);
            }
            object = this.props.getProperty("databaseName");
            this.setPropertyWithExpand(this.props, "databaseName", (String)object);
            this.setPropertyWithExpand(this.props, "dataStoreHelperClass", this.getDatasourceHelperClassname(j2EEResourceFactory));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "classpath before expand =", jDBCProvider.getClasspath());
            }
            this.classPath = this.expandList((List)jDBCProvider.getClasspath());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "classpath =", this.classPath);
            }
            this.dataSourceClassname = this.varMap.expand(jDBCProvider.getImplementationClassName());
            this.nativePath = this.expandList((List)jDBCProvider.getNativepath());
            this.authDC = this.getAuthDataCreditial(j2EEResourceFactory);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "DataSourceProperties.retrieveDataSourceProperties");
            }
        }

        private String getDatasourceHelperClassname(J2EEResourceFactory j2EEResourceFactory) {
            if (j2EEResourceFactory instanceof DataSource) {
                return ((DataSource)j2EEResourceFactory).getDatasourceHelperClassname();
            }
            return null;
        }

        private void setPropertyWithExpand(Properties properties, String string, String string2) {
            if (string != null && string.length() > 0 && string2 != null) {
                properties.setProperty(string, this.varMap.expand(string2));
            }
        }

        private ArrayList expandList(List list) {
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                arrayList.add(this.varMap.expand((String)iterator.next()));
            }
            return arrayList;
        }

        private AuthDataCredential getAuthDataCreditial(J2EEResourceFactory j2EEResourceFactory) {
            AuthDataCredential authDataCredential = null;
            if (j2EEResourceFactory instanceof WAS40DataSource) {
                this.userid = ((WAS40DataSource)j2EEResourceFactory).getDefaultUser();
                this.pwd = ((WAS40DataSource)j2EEResourceFactory).getDefaultPassword();
            } else {
                try {
                    MappingModule mappingModule;
                    DataSource dataSource = (DataSource)j2EEResourceFactory;
                    authDataCredential = WSDefaultPrincipalMapping.getAuthData(dataSource.getAuthDataAlias());
                    if (authDataCredential == null && (mappingModule = dataSource.getMapping()) != null) {
                        authDataCredential = WSDefaultPrincipalMapping.getAuthData(mappingModule.getAuthDataAlias());
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.WASSchedulerCfgHelper.getAuthDataCreditial", "1438", this);
                    authDataCredential = null;
                }
            }
            return authDataCredential;
        }
    }

    class ConfigLocation {
        private int locationType = 0;
        String cellLocation = null;
        String nodeLocation = null;
        String clusterLocation = null;
        String serverLocation = null;

        public ConfigLocation(ConfigDataId configDataId) throws SchedulerDataStoreException, MalformedObjectNameException {
            ObjectName objectName = ConfigServiceHelper.createObjectName(configDataId);
            if (objectName == null) {
                throw new SchedulerDataStoreException(Messages.getMessage("SCHD0083E", configDataId.toString()));
            }
            Properties properties = ConfigServiceHelper.getObjectLocation(objectName);
            boolean bl = false;
            this.cellLocation = properties.getProperty("cell");
            this.locationType = 0;
            if (this.cellLocation == null) {
                this.cellLocation = WASSchedulerCfgHelper.this.adminService.getCellName();
            } else {
                bl = true;
            }
            this.nodeLocation = properties.getProperty("node");
            if (this.nodeLocation != null) {
                this.locationType = 3;
                bl = true;
            }
            this.clusterLocation = properties.getProperty("cluster");
            if (this.clusterLocation != null) {
                this.locationType = 2;
                bl = true;
            }
            this.serverLocation = properties.getProperty("server");
            if (this.serverLocation != null) {
                this.locationType = 4;
                bl = true;
            }
            if (!bl) {
                throw new SchedulerDataStoreException(Messages.getMessage("SCHD0082E", new String[]{configDataId.toString(), objectName.toString(), properties.toString()}));
            }
        }

        public ConfigLocation() {
            this.cellLocation = WASSchedulerCfgHelper.this.adminService.getCellName();
            this.nodeLocation = WASSchedulerCfgHelper.this.adminService.getNodeName();
            this.serverLocation = WASSchedulerCfgHelper.this.adminService.getProcessName();
            this.locationType = WASSchedulerCfgHelper.this.processTypeID;
        }

        ConfigLocation(ConfigLocation configLocation) {
            this.locationType = configLocation.locationType;
            this.cellLocation = configLocation.cellLocation;
            this.nodeLocation = configLocation.nodeLocation;
            this.clusterLocation = configLocation.clusterLocation;
            this.serverLocation = configLocation.serverLocation;
        }

        public int getLocationType() {
            return this.locationType;
        }

        public void setConfigRootLocation(ConfigRoot configRoot) {
            this.setConfigRootLocation(configRoot, this.locationType);
        }

        public void setConfigRootLocation(ConfigRoot configRoot, int n) {
            if (n == 4) {
                configRoot.setValue(0, this.cellLocation);
                configRoot.setValue(3, this.nodeLocation);
                configRoot.setValue(4, this.serverLocation);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "setConfigRootLocation", "SERVER");
                }
            } else if (n == 2) {
                configRoot.setValue(0, this.cellLocation);
                configRoot.setValue(2, this.clusterLocation);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "setConfigRootLocation", "CLUSTER");
                }
            } else if (n == 3) {
                configRoot.setValue(0, this.cellLocation);
                configRoot.setValue(3, this.nodeLocation);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "setConfigRootLocation", "NODE");
                }
            } else {
                configRoot.setValue(0, this.cellLocation);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "setConfigRootLocation", "OTHER: " + n);
                }
            }
        }

        public ConfigLocation getSubConfigLocation(int n) {
            ConfigLocation configLocation = this;
            if (this.locationType != n && this.locationType != 0) {
                configLocation = new ConfigLocation(this);
                configLocation.locationType = n;
            }
            return configLocation;
        }

        public boolean isLevelLower(ConfigLocation configLocation) {
            return WASSchedulerCfgHelper.this.getLocationIndex(this.locationType) > WASSchedulerCfgHelper.this.getLocationIndex(configLocation.locationType);
        }
    }

    private class DataSourceInfo {
        J2EEResourceFactory dataSource = null;
        ConfigLocation dataSourceLocation = null;

        public DataSourceInfo(J2EEResourceFactory j2EEResourceFactory, ConfigLocation configLocation) {
            this.dataSource = j2EEResourceFactory;
            this.dataSourceLocation = configLocation;
        }
    }
}

