/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scheduler.calendar;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.scheduler.UserCalendarPeriodInvalid;
import com.ibm.websphere.scheduler.UserCalendarSpecifierInvalid;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.scheduler.Utils;
import com.ibm.ws.scheduler.cron.CronExpression;
import com.ibm.ws.scheduler.resources.Messages;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;

public class DefaultUserCalendarBean
implements SessionBean {
    private static final long serialVersionUID = 187921745865643889L;
    static TraceComponent tc = Tr.register(DefaultUserCalendarBean.class, "Scheduler", "com.ibm.ws.scheduler.resources.SchedulerMessages");
    SessionContext mySessionCtx = null;

    public void validate(String string, String string2) throws UserCalendarSpecifierInvalid, UserCalendarPeriodInvalid {
        Date date = this.applyDelta(new Date(System.currentTimeMillis()), string, string2);
    }

    static boolean handleTerm(Calendar calendar, String string, String string2, int n, int n2) throws UserCalendarPeriodInvalid {
        try {
            if (string.endsWith(string2)) {
                if (string2.equals("ms")) {
                    long l = Long.parseLong(string.substring(0, string.length() - string2.length()));
                    calendar.setTimeInMillis(calendar.getTimeInMillis() + l);
                    return true;
                }
                int n3 = Integer.parseInt(string.substring(0, string.length() - string2.length()));
                calendar.add(n, n3 * n2);
                return true;
            }
            return false;
        }
        catch (NumberFormatException numberFormatException) {
            FFDCFilter.processException(numberFormatException, "com.ibm.ws.scheduler.DefaultUserCalendarBean.handleTerm", "95");
            throw new UserCalendarPeriodInvalid(Messages.getMessage("SCHD0119E", numberFormatException.getLocalizedMessage()));
        }
    }

    public Date applyDelta(Date date, String string, String string2) throws UserCalendarSpecifierInvalid, UserCalendarPeriodInvalid {
        Date date2 = null;
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if (string.toUpperCase().equals("CRON")) {
            try {
                CronExpression cronExpression = CronExpression.getCachedExpression(string2);
                date2 = cronExpression.calculateClosestTime(date, true);
            }
            catch (ParseException parseException) {
                throw new UserCalendarPeriodInvalid(Utils.getExceptionMessageWithType(parseException), parseException);
            }
            catch (NumberFormatException numberFormatException) {
                throw new UserCalendarPeriodInvalid(Utils.getExceptionMessageWithType(numberFormatException), numberFormatException);
            }
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            StringTokenizer stringTokenizer = new StringTokenizer(string2.toLowerCase(), " ");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Token is now {0}", new Object[]{string3});
                }
                if (DefaultUserCalendarBean.handleTerm(calendar, string3, "ms", 14, 1) || DefaultUserCalendarBean.handleTerm(calendar, string3, "seconds", 13, 1) || DefaultUserCalendarBean.handleTerm(calendar, string3, "minutes", 12, 1) || DefaultUserCalendarBean.handleTerm(calendar, string3, "hours", 10, 1) || DefaultUserCalendarBean.handleTerm(calendar, string3, "days", 5, 1) || DefaultUserCalendarBean.handleTerm(calendar, string3, "weeks", 5, 7) || DefaultUserCalendarBean.handleTerm(calendar, string3, "years", 1, 1) || DefaultUserCalendarBean.handleTerm(calendar, string3, "months", 2, 1)) continue;
                throw new UserCalendarPeriodInvalid(Messages.getMessage("SCHD0120E", string3));
            }
            date2 = calendar.getTime();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "applyDelta {0} {1} {2} = {3}", new Object[]{date, string, string2, date2});
            }
        }
        return date2;
    }

    public String[] getCalendarNames() {
        return new String[]{"simple", "cron"};
    }

    public SessionContext getSessionContext() {
        return this.mySessionCtx;
    }

    public void setSessionContext(SessionContext sessionContext) {
        this.mySessionCtx = sessionContext;
    }

    public void ejbActivate() {
    }

    public void ejbCreate() throws CreateException {
    }

    public void ejbPassivate() {
    }

    public void ejbRemove() {
    }
}

