/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scheduler.config;

import com.ibm.ejs.models.base.resources.J2EEResourceFactory;
import com.ibm.ejs.models.base.resources.J2EEResourceProperty;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.asynchbeans.WorkManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.scheduler.PartitionInfo;
import com.ibm.ws.scheduler.SchedulerImpl;
import com.ibm.ws.scheduler.config.SchedulerConfiguration;
import com.ibm.ws.scheduler.exception.SchedulerConfigurationException;
import com.ibm.ws.scheduler.resources.Messages;
import com.ibm.ws.security.auth.j2c.WSDefaultPrincipalMapping;
import com.ibm.ws.security.cred.AuthDataCredential;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIResource;

public class SchedulerBaseConfigurationImpl
implements Serializable,
SchedulerConfiguration,
FFDCSelfIntrospectable {
    private static final TraceComponent tc = Tr.register(SchedulerBaseConfigurationImpl.class, "Scheduler", "com.ibm.ws.scheduler.resources.SchedulerMessages");
    private static final long serialVersionUID = 60L;
    private static final int TRANSACTION_SS_SNAPSHOT = 4096;
    protected static final String SCHEDULER_PROP_PARTITION_INFO = "scheduler.partitioninfo";
    protected static final String SCHEDULER_PROP_PARTITION_PREFERRED = "scheduler.preferredpartitions";
    protected static final String SCHEDULER_PROP_DAEMON_THREADS = "scheduler.daemonthreads";
    protected static final String SCHEDULER_PROP_DAEMON_INITQUERYSIZE = "scheduler.initialquerysize";
    protected static final String SCHEDULER_PROP_TASK_MAXTASKLOADSIZE = "scheduler.maxtaskloadsize";
    protected static final String SCHEDULER_PROP_LEASE_ALARM_INTERVALMS = "scheduler.lease.alarmintervalms";
    protected static final String SCHEDULER_PROP_LEASE_TIMEMS = "scheduler.lease.timems";
    protected static final String SCHEDULER_PROP_LEASE_DEFAULT_ALARM_INTERVALMS = "scheduler.lease.default.alarmintervalms";
    protected static final String SCHEDULER_PROP_LEASE_DEFAULT_TIMEMS = "scheduler.lease.default.timems";
    private static final String SCHEDULER_CUSTOMPROP_DAEMON_ALLOWUC = "daemonAllowTranReadUC";
    private static final String SCHEDULER_CUSTOMPROP_DAEMON_FORCEUC = "daemonForceTranReadUC";
    private static final String SCHEDULER_CUSTOMPROP_DAEMON_AUTOSTART = "daemonAutoStart";
    private static final String SCHEDULER_CUSTOMPROP_DEFAULTREADTRANISO = "defaultReadTransactionIso";
    private static final String SCHEDULER_CUSTOMPROP_DEFAULTWRITETRANISO = "defaultWriteTransactionIso";
    private static final String SCHEDULER_CUSTOMPROP_TASKFAILURETHRESHOLD = "taskFailureThreshold";
    private static final String SCHEDULER_CUSTOMPROP_AUTO_CAPITALIZE_TABLE_PREFIX = "autoCapitalizeTablePrefix";
    private static final String SCHEDULER_CUSTOMPROP_DISABLE_V50_TASK_INTEROPERABILITY = "disableV50TaskInteroperability";
    protected String jndiName = null;
    protected String datasourceJndiName = null;
    protected String datasourceUsername = null;
    protected String datasourcePassword = null;
    protected String tablePrefix = null;
    protected long pollIntervalMillis = 30000L;
    protected WorkManager workManager = null;
    protected String id = null;
    protected String name = null;
    protected String description = null;
    protected String workManagerJndiName = "System_WorkManager";
    protected List partitionInfoList = null;
    protected Set preferredPartitions = null;
    protected int daemonThreads = 1;
    protected int initialQuerySize;
    protected int querySize = this.initialQuerySize = 10000;
    protected int recoveryOption = 0;
    protected int timeCalcMethod = 0;
    protected boolean useAdminRoles = false;
    protected int alarmThreads = 5;
    protected int maxTaskLoadSize = 100;
    protected static final int partitionRangeLBound = 5;
    protected static final int partitionRangeUBound = 4100;
    protected static final int partitionRangeLBound_50 = 1;
    protected static final int partitionRangeUBound_50 = 4;
    protected long leaseTimeMS = 60000L;
    protected long leaseAlarmIntervalMS = 40000L;
    boolean allowUncommittedReadPollDaemon = true;
    boolean forceUncommittedReadPollDaemon = false;
    boolean autoStartDaemons = true;
    int defaultReadTranIso = 2;
    int defaultWriteTranIso = 2;
    boolean isSetDefaultReadTranIso = false;
    boolean isSetDefaultWriteTranIso = false;
    int taskFailureThreshold = 10;
    boolean autoCapitalizeTablePrefix = true;
    boolean disableV50TaskInteroperability = false;
    protected float[] decayingAvgWeights = new float[]{0.3f, 0.25f, 0.2f, 0.15f, 0.1f};
    protected float maxQueryIntervalAdjustPct = 0.1f;
    protected Class schedulerImplClass;

    public SchedulerBaseConfigurationImpl(J2EEResourceFactory j2EEResourceFactory) throws SchedulerConfigurationException {
        Class clazz = this.schedulerImplClass = SchedulerImpl.class;
        if (j2EEResourceFactory != null) {
            AuthDataCredential authDataCredential;
            String string;
            Object object;
            com.ibm.websphere.models.config.scheduler.SchedulerConfiguration schedulerConfiguration = (com.ibm.websphere.models.config.scheduler.SchedulerConfiguration)j2EEResourceFactory;
            Resource resource = schedulerConfiguration.eResource();
            String string2 = null;
            if (resource == null || !(resource instanceof XMIResource)) {
                throw new SchedulerConfigurationException(Messages.getMessage("SCHD0020I", "eResource=" + resource));
            }
            Object object2 = (XMIResource)resource;
            string2 = object2.getID((EObject)schedulerConfiguration);
            object2 = schedulerConfiguration.getWorkManagerInfoJNDIName();
            if (object2 == null && (object = schedulerConfiguration.getWorkManagerInfo()) != null) {
                object2 = object.getJndiName();
            }
            this.workManagerJndiName = object2;
            object = null;
            String string3 = null;
            try {
                string = schedulerConfiguration.getDatasourceAlias();
                if (string != null && (authDataCredential = WSDefaultPrincipalMapping.getAuthData(string)) != null) {
                    object = authDataCredential.getUserName();
                    string3 = authDataCredential.getPassword();
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.scheduler.config.SchedulerConfiguration.SchedulerConfiguration", "97", this);
                throw new SchedulerConfigurationException(Messages.getMessage("SCHD0045E", schedulerConfiguration.getJndiName()));
            }
            this.id = string2;
            this.name = schedulerConfiguration.getName();
            this.description = schedulerConfiguration.getDescription();
            this.useAdminRoles = schedulerConfiguration.isUseAdminRoles();
            string = schedulerConfiguration.getPropertySet();
            if (string != null) {
                authDataCredential = string.getResourceProperties();
                Iterator iterator = authDataCredential.iterator();
                while (iterator.hasNext()) {
                    J2EEResourceProperty j2EEResourceProperty = (J2EEResourceProperty)iterator.next();
                    String string4 = j2EEResourceProperty.getName();
                    String string5 = j2EEResourceProperty.getValue();
                    if (string4 == null) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string4 + " = " + string5);
                    }
                    if (string4.equals(SCHEDULER_CUSTOMPROP_DAEMON_ALLOWUC)) {
                        this.allowUncommittedReadPollDaemon = Boolean.valueOf(string5);
                        continue;
                    }
                    if (string4.equals(SCHEDULER_CUSTOMPROP_DAEMON_FORCEUC)) {
                        this.forceUncommittedReadPollDaemon = Boolean.valueOf(string5);
                        continue;
                    }
                    if (string4.equals(SCHEDULER_CUSTOMPROP_DAEMON_AUTOSTART)) {
                        this.autoStartDaemons = Boolean.valueOf(string5);
                        continue;
                    }
                    if (string4.equals(SCHEDULER_CUSTOMPROP_DEFAULTREADTRANISO)) {
                        try {
                            int n = Integer.valueOf(string5);
                            if (n == 2 || n == 1) {
                                this.defaultReadTranIso = n;
                                this.isSetDefaultReadTranIso = true;
                                continue;
                            }
                            Tr.warning(tc, "SCHD0135W", new Object[]{string4, this.name, this.jndiName, "1,2"});
                        }
                        catch (NumberFormatException numberFormatException) {
                            FFDCFilter.processException((Throwable)numberFormatException, "com.ibm.ws.scheduler.config.SchedulerBaseConfigurationImpl.SchedulerBaseConfigurationImpl", "293", this);
                            Tr.warning(tc, "SCHD0135W", new Object[]{string4, this.name, this.jndiName, "java.lang.Integer"});
                        }
                        continue;
                    }
                    if (string4.equals(SCHEDULER_CUSTOMPROP_DEFAULTWRITETRANISO)) {
                        try {
                            int n;
                            this.defaultWriteTranIso = n = Integer.valueOf(string5).intValue();
                            this.isSetDefaultWriteTranIso = true;
                        }
                        catch (NumberFormatException numberFormatException) {
                            FFDCFilter.processException((Throwable)numberFormatException, "com.ibm.ws.scheduler.config.SchedulerBaseConfigurationImpl.SchedulerBaseConfigurationImpl", "323", this);
                            Tr.warning(tc, "SCHD0135W", new Object[]{string4, this.name, this.jndiName, "java.lang.Integer"});
                        }
                        continue;
                    }
                    if (string4.equals(SCHEDULER_CUSTOMPROP_TASKFAILURETHRESHOLD)) {
                        try {
                            int n = Integer.valueOf(string5);
                            if (n >= 0) {
                                this.taskFailureThreshold = n;
                                continue;
                            }
                            Tr.warning(tc, "SCHD0135W", new Object[]{string4, this.name, this.jndiName, ">=0"});
                        }
                        catch (NumberFormatException numberFormatException) {
                            FFDCFilter.processException((Throwable)numberFormatException, "com.ibm.ws.scheduler.config.SchedulerBaseConfigurationImpl.SchedulerBaseConfigurationImpl", "313", this);
                            Tr.warning(tc, "SCHD0135W", new Object[]{string4, this.name, this.jndiName, "java.lang.Integer"});
                        }
                        continue;
                    }
                    if (string4.equals(SCHEDULER_CUSTOMPROP_AUTO_CAPITALIZE_TABLE_PREFIX)) {
                        this.autoCapitalizeTablePrefix = Boolean.valueOf(string5);
                        continue;
                    }
                    if (!string4.equals(SCHEDULER_CUSTOMPROP_DISABLE_V50_TASK_INTEROPERABILITY)) continue;
                    this.disableV50TaskInteroperability = Boolean.valueOf(string5);
                }
            }
            this.initialize(schedulerConfiguration.getJndiName(), schedulerConfiguration.getDatasourceJNDIName(), (String)object, string3, schedulerConfiguration.getTablePrefix(), (long)schedulerConfiguration.getPollInterval() * 1000L);
        }
    }

    protected void initialize(String string, String string2, String string3, String string4, String string5, long l) {
        this.jndiName = string;
        this.datasourceJndiName = string2;
        this.datasourceUsername = string3;
        this.datasourcePassword = string4;
        this.tablePrefix = string5;
        this.pollIntervalMillis = l;
        this.cleanupConfig();
        this.validate();
    }

    protected SchedulerBaseConfigurationImpl() {
        this.schedulerImplClass = SchedulerImpl.class;
    }

    protected void cleanupConfig() {
        if (this.tablePrefix != null) {
            this.tablePrefix = this.tablePrefix.trim();
            if (this.autoCapitalizeTablePrefix) {
                this.tablePrefix = this.tablePrefix.toUpperCase();
            }
        }
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public long getStartupDelayMillis() {
        return 0L;
    }

    public String getDataSourceJndiName() {
        return this.datasourceJndiName;
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public String getUsername() {
        return this.datasourceUsername;
    }

    public String getPassword() {
        return this.datasourcePassword;
    }

    public synchronized void setPollIntervalMillis(int n) {
        this.pollIntervalMillis = n;
    }

    public synchronized int getPollIntervalMillis() {
        return this.pollIntervalMillis > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.pollIntervalMillis;
    }

    public List getPartitionInfoList() {
        return this.partitionInfoList;
    }

    public PartitionInfo[] getPartitionInfos() {
        PartitionInfo[] partitionInfoArray = new PartitionInfo[this.partitionInfoList.size()];
        return this.partitionInfoList.toArray(partitionInfoArray);
    }

    public int getDaemonThreads() {
        return this.daemonThreads;
    }

    public void setDaemonThreads(int n) {
        this.daemonThreads = n;
    }

    public int getPartitionRangeLBound() {
        return 5;
    }

    public int getPartitionRangeUBound() {
        return 4100;
    }

    public int getPartitionRangeLBound_50() {
        return 1;
    }

    public int getPartitionRangeUBound_50() {
        return 4;
    }

    public int getMaxTaskLoadSize() {
        return this.maxTaskLoadSize;
    }

    public void setMaxTaskLoadSize(int n) {
        this.maxTaskLoadSize = n;
    }

    public int getInitialQuerySize() {
        return this.initialQuerySize;
    }

    public void setInitialQuerySize(int n) {
        this.initialQuerySize = n;
    }

    public synchronized int getQuerySize() {
        return this.querySize;
    }

    public synchronized void setQuerySize(int n) {
        this.querySize = n;
    }

    public float[] getDecayingAvgWeights() {
        return this.decayingAvgWeights;
    }

    public void setDecayingAvgWeights(float[] fArray) {
        this.decayingAvgWeights = fArray;
    }

    public float getMaxQueryIntervalAdjustPct() {
        return this.maxQueryIntervalAdjustPct;
    }

    public void setMaxQueryIntervalAdjustPct(float f) {
        this.maxQueryIntervalAdjustPct = f;
    }

    public int getAlarmThreads() {
        return this.alarmThreads;
    }

    public void setAlarmThreads(int n) {
        this.alarmThreads = n;
    }

    public WorkManager getWorkManager() {
        return this.workManager;
    }

    public long getLeaseTimeMS() {
        return this.leaseTimeMS;
    }

    public long getLeaseAlarmIntervalMS() {
        return this.leaseAlarmIntervalMS;
    }

    public void validate() throws SchedulerConfigurationException {
        if (this.jndiName == null) {
            throw new SchedulerConfigurationException(Messages.getMessage("SCHD0043E", this.getName()));
        }
        if (this.datasourceJndiName == null) {
            throw new SchedulerConfigurationException(Messages.getMessage("SCHD0041E", new String[]{this.getName(), this.jndiName}));
        }
        if (this.jndiName.equals(this.datasourceJndiName)) {
            throw new SchedulerConfigurationException(Messages.getMessage("SCHD0071E", new String[]{this.getName(), this.jndiName}));
        }
        if (this.schedulerImplClass == null) {
            throw new SchedulerConfigurationException(Messages.getMessage("SCHD0073E", new String[]{this.getName(), this.jndiName}));
        }
    }

    public int getRecoveryOption() {
        return this.recoveryOption;
    }

    public int getTimeCalcMethod() {
        return this.timeCalcMethod;
    }

    public void setRecoveryOption(int n) {
        this.recoveryOption = n;
    }

    public void setTimeCalcMethod(int n) {
        this.timeCalcMethod = n;
    }

    public Class getSchedulerImplClass() {
        return this.schedulerImplClass;
    }

    public void setSchedulerImplClass(Class clazz) {
        this.schedulerImplClass = clazz;
    }

    public String getName() {
        String string = null;
        if (this.name == null) {
            string = this.getJndiName();
            if (string == null || string.length() == 0) {
                return "Unknown";
            }
            return string;
        }
        return this.name;
    }

    public String getWorkManagerJndiName() {
        return this.workManagerJndiName;
    }

    public boolean getUseAdminRoles() {
        return this.useAdminRoles;
    }

    public void setUseAdminRoles(boolean bl) {
        this.useAdminRoles = bl;
    }

    public String[] introspectSelf() {
        return new String[]{this.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(this)), "JNDI name = " + this.jndiName, "Data Source JNDI name = " + this.datasourceJndiName, "Data Source user name = " + this.datasourceUsername, "Data Source password = ******", "Table prefix = " + this.tablePrefix, "Poll Interval = " + this.pollIntervalMillis + " milliseconds", "Work Manager = " + this.workManager, "ID = " + this.id, "Name = " + this.name, "Description = " + this.description, "Work Manager JNDI name = " + this.workManagerJndiName, "Partition info list = " + this.partitionInfoList, "Preferred partitions = " + this.preferredPartitions, "Number of daemon threads = " + this.daemonThreads, "Initial query size = " + this.initialQuerySize, "Query size = " + this.querySize, "Recovery option = " + SchedulerBaseConfigurationImpl.getRecoveryOptionAsString(this.recoveryOption), "Time calculation method = " + SchedulerBaseConfigurationImpl.getTimeCalculationMethodAsString(this.timeCalcMethod), "Use admin roles? " + this.useAdminRoles, "Number of alarm threads = " + this.alarmThreads, "Task maximum load size = " + this.maxTaskLoadSize, "Lease time = " + this.leaseTimeMS + " milliseconds", "Lease alarm interval = " + this.leaseAlarmIntervalMS + " milliseconds", "Allow poll daemon to do uncommitted reads? " + this.allowUncommittedReadPollDaemon, "Force poll daemon to do uncommitted reads? " + this.forceUncommittedReadPollDaemon, "Automatically start daemons? " + this.autoStartDaemons, "Default read transaction isolation level = " + SchedulerBaseConfigurationImpl.getIsolationLevelAsString(this.defaultReadTranIso), "Default write transaction isolation level = " + SchedulerBaseConfigurationImpl.getIsolationLevelAsString(this.defaultWriteTranIso), "Automatically capitalize the table prefix at runtime? " + this.autoCapitalizeTablePrefix, "Disable V50 task interoperability? " + this.disableV50TaskInteroperability, "Task failure threshold = " + this.taskFailureThreshold, "Decaying average weights = " + this.decayingAvgWeights, "Maximum query interval adjustment percentage = " + this.maxQueryIntervalAdjustPct, "Scheduler implementation class = " + this.schedulerImplClass};
    }

    private static String getIsolationLevelAsString(int n) {
        switch (n) {
            case 0: {
                return "NONE (" + n + ')';
            }
            case 1: {
                return "READ UNCOMMITTED (" + n + ')';
            }
            case 2: {
                return "READ COMMITTED (" + n + ')';
            }
            case 4: {
                return "REPEATABLE READ (" + n + ')';
            }
            case 8: {
                return "SERIALIZABLE (" + n + ')';
            }
            case 16: 
            case 4096: {
                return "SNAPSHOT (" + n + ')';
            }
        }
        return "UNKNOWN (" + n + ')';
    }

    private static String getRecoveryOptionAsString(int n) {
        switch (n) {
            case 0: {
                return "SCHED_RECOVERY_USEDEFAULT (" + n + ')';
            }
            case 1: {
                return "SCHED_RECOVERY_RUNONCE (" + n + ')';
            }
            case 2: {
                return "SCHED_RECOVERY_RUNONCE_NOSTARTBY (" + n + ')';
            }
        }
        return "UNKNOWN (" + n + ')';
    }

    private static String getTimeCalculationMethodAsString(int n) {
        switch (n) {
            case 0: {
                return "SCHED_TIMECALCMETHOD_USEDEFAULT (" + n + ')';
            }
            case 1: {
                return "SCHED_TIMECALCMETHOD_CALCTIME (" + n + ')';
            }
            case 2: {
                return "SCHED_TIMECALCMETHOD_CALCTIME_CATCHUP (" + n + ')';
            }
            case 3: {
                return "SCHED_TIMECALCMETHOD_EXECTIME (" + n + ')';
            }
        }
        return "UNKNOWN (" + n + ')';
    }

    public boolean isAllowUncommittedReadPollDaemon() {
        return this.allowUncommittedReadPollDaemon;
    }

    public boolean isForceUncommittedReadPollDaemon() {
        return this.forceUncommittedReadPollDaemon;
    }

    public boolean isAutoStartDaemons() {
        return this.autoStartDaemons;
    }

    public void setAutoStartDaemons(boolean bl) {
        this.autoStartDaemons = bl;
    }

    public int getDefaultReadTransactionIsolation() {
        return this.defaultReadTranIso;
    }

    public int getDefaultWriteTransactionIsolation() {
        return this.defaultWriteTranIso;
    }

    public void setDefaultReadTransactionIsolation(int n) {
        if (n != 2 && n != 1) {
            throw new IllegalArgumentException(Messages.getMessage("SCHD0123E", new Object[]{"tranIsolation", "1,2"}));
        }
        this.defaultReadTranIso = n;
        this.isSetDefaultReadTranIso = true;
    }

    public void setDefaultWriteTransactionIsolation(int n) {
        this.defaultWriteTranIso = n;
        this.isSetDefaultWriteTranIso = true;
    }

    public int getTaskFailureThreshold() {
        return this.taskFailureThreshold;
    }

    public void setTaskFailureThreshold(int n) {
        this.taskFailureThreshold = n;
    }

    public boolean getDisableV50TaskInteroperability() {
        return this.disableV50TaskInteroperability;
    }

    public void setDisableV50TaskInteroperability(boolean bl) {
        this.disableV50TaskInteroperability = bl;
    }

    public boolean isSetDefaultReadTransactionIsolation() {
        return this.isSetDefaultReadTranIso;
    }

    public boolean isSetDefaultWriteTransactionIsolation() {
        return this.isSetDefaultWriteTranIso;
    }
}

