/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scheduler.config;

import com.ibm.ejs.models.base.resources.J2EEResourceFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.asynchbeans.WorkManager;
import com.ibm.ws.asynchbeans.AsynchBeansService;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.scheduler.PartitionInfo;
import com.ibm.ws.scheduler.SchedulerService;
import com.ibm.ws.scheduler.SchedulerServiceImpl;
import com.ibm.ws.scheduler.Utils;
import com.ibm.ws.scheduler.config.SchedulerBaseConfigurationImpl;
import com.ibm.ws.scheduler.exception.SchedulerConfigurationException;
import com.ibm.ws.scheduler.resources.Messages;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.StringTokenizer;

public class SchedulerConfigurationImpl
extends SchedulerBaseConfigurationImpl {
    private static final TraceComponent tc = Tr.register(SchedulerConfigurationImpl.class, "Scheduler", "com.ibm.ws.scheduler.resources.SchedulerMessages");
    private static final long serialVersionUID = -6215586198578629433L;

    public SchedulerConfigurationImpl(J2EEResourceFactory j2EEResourceFactory) throws SchedulerConfigurationException {
        super(j2EEResourceFactory);
        this.setVariableMapConfig();
        this.validateThis();
    }

    public SchedulerConfigurationImpl(String string, String string2, String string3, String string4, String string5, long l, WorkManager workManager) {
        this.initialize(string, string2, string3, string4, string5, l, workManager);
    }

    public SchedulerConfigurationImpl() {
    }

    protected void initialize(String string, String string2, String string3, String string4, String string5, long l, WorkManager workManager) {
        super.initialize(string, string2, string3, string4, string5, l);
        this.workManager = workManager;
        this.setVariableMapConfig();
        this.validateThis();
    }

    protected void setVariableMapConfig() {
        Object object;
        int n;
        Object object2;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Processing Scheduler Service Variables.");
        }
        SchedulerService schedulerService = SchedulerServiceImpl.instance();
        String string = this.getStringValFromJNDIConfig(schedulerService, this.jndiName, "scheduler.preferredpartitions", "");
        this.preferredPartitions = new HashSet();
        Object object3 = new StringTokenizer(string, "|");
        while (((StringTokenizer)object3).hasMoreTokens()) {
            object2 = ((StringTokenizer)object3).nextToken();
            this.preferredPartitions.add(object2);
        }
        object3 = new ArrayList();
        object2 = new ArrayList();
        String string2 = this.getStringValFromJNDIConfig(schedulerService, this.jndiName, "scheduler.partitioninfo", "P1,1");
        int n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            String string4 = Utils.getKeyFromKeyValue(string3, ",");
            n = Integer.parseInt(Utils.getValueItemFromKeyValue(string3, ","));
            n2 += n;
            object2.add(new Integer(n));
            object3.add(string4);
        }
        int n3 = 4;
        int n4 = 4096;
        this.partitionInfoList = new ArrayList(object2.size());
        int n5 = object3.size();
        for (n = 0; n < n5; ++n) {
            object = (String)object3.get(n);
            int n6 = (Integer)object2.get(n);
            int n7 = n3 + 1;
            int n8 = Math.round((float)n6 / (float)n2 * (float)n4);
            int n9 = n7 + n8;
            if (n + 1 == n5) {
                n9 = 4100;
            }
            n3 = n9;
            this.partitionInfoList.add(new PartitionInfo((String)object, this.preferredPartitions.contains(object), n6, n7, n9));
        }
        Object object4 = new StringTokenizer(string, " ");
        while (((StringTokenizer)object4).hasMoreTokens()) {
            object = ((StringTokenizer)object4).nextToken();
            this.preferredPartitions.add(object);
        }
        this.daemonThreads = this.getIntValFromJNDIConfig(schedulerService, this.jndiName, "scheduler.daemonthreads", this.daemonThreads);
        this.querySize = this.initialQuerySize = this.getIntValFromJNDIConfig(schedulerService, this.jndiName, "scheduler.initialquerysize", this.initialQuerySize);
        this.leaseAlarmIntervalMS = this.getIntValFromJNDIConfig(schedulerService, this.jndiName, "scheduler.lease.alarmintervalms", this.getIntFromVariableMap(schedulerService, "scheduler.lease.default.alarmintervalms", (int)this.leaseAlarmIntervalMS));
        this.leaseTimeMS = this.getIntValFromJNDIConfig(schedulerService, this.jndiName, "scheduler.lease.timems", this.getIntFromVariableMap(schedulerService, "scheduler.lease.default.timems", (int)this.leaseTimeMS));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Scheduler parameters for:     " + this.jndiName);
            object4 = "";
            object = this.partitionInfoList.iterator();
            while (object.hasNext()) {
                PartitionInfo partitionInfo = (PartitionInfo)object.next();
                object4 = (String)object4 + partitionInfo.toString();
                if (!object.hasNext()) continue;
                object4 = (String)object4 + ",";
            }
            Tr.debug(tc, "partitioninfo:                " + (String)object4);
            Tr.debug(tc, "daemonthreads:                " + this.daemonThreads);
            Tr.debug(tc, "initialquerysize:             " + this.initialQuerySize);
            Tr.debug(tc, "Max Task Load Size:           " + this.getMaxTaskLoadSize());
            Tr.debug(tc, "Poll Interval                 " + this.pollIntervalMillis + "ms");
            Tr.debug(tc, "Lease Time                    " + this.leaseTimeMS + "ms");
            Tr.debug(tc, "Lease Alarm Interval          " + this.leaseAlarmIntervalMS + "ms");
            Tr.debug(tc, "daemonAllowTranReadUC:        " + this.allowUncommittedReadPollDaemon);
            Tr.debug(tc, "daemonForceTranReadUC:        " + this.forceUncommittedReadPollDaemon);
            Tr.debug(tc, "defaultReadTranIso:           " + this.defaultReadTranIso);
            Tr.debug(tc, "defaultWriteTranIso:          " + this.defaultWriteTranIso);
            Tr.debug(tc, "taskFailureThreshold:         " + this.taskFailureThreshold);
            Tr.debug(tc, "autoCapitalizeTablePrefix:    " + this.autoCapitalizeTablePrefix);
            Tr.debug(tc, "disableV50TaskInteroperability: " + this.disableV50TaskInteroperability);
        }
    }

    protected boolean getBooleanValFromJNDIConfig(SchedulerService schedulerService, String string, String string2, boolean bl) {
        boolean bl2 = bl;
        String string3 = schedulerService.getServiceVariable(string2, null);
        String string4 = Utils.getJNDIConfig(string, string3, " ", "=");
        if (tc.isDebugEnabled()) {
            if (string3 != null) {
                Tr.debug(tc, "Found variable: " + string2 + "=" + string3);
                Tr.debug(tc, "Digested Version: " + string4);
            } else {
                Tr.debug(tc, "Property not set: " + string2);
            }
        }
        if (string4 != null && string4.trim().length() != 0) {
            try {
                bl2 = Boolean.valueOf(string4);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.config.SchedulerConfigurationImpl.getBooleanValFromJNDIConfig", "371", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Invalid property value.  Expected a boolean.", new Object[]{throwable});
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Unable to set boolean.  Using default.");
        }
        return bl2;
    }

    protected int getIntValFromJNDIConfig(SchedulerService schedulerService, String string, String string2, int n) {
        int n2 = n;
        String string3 = schedulerService.getServiceVariable(string2, null);
        String string4 = Utils.getJNDIConfig(string, string3, " ", "=");
        if (tc.isDebugEnabled()) {
            if (string3 != null) {
                Tr.debug(tc, "Found variable: " + string2 + "=" + string3);
                Tr.debug(tc, "Digested Version: " + string4);
            } else {
                Tr.debug(tc, "Property not set: " + string2);
            }
        }
        if (string4 != null && string4.trim().length() != 0) {
            try {
                n2 = Integer.valueOf(string4);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.config.SchedulerConfigurationImpl.getIntValFromJNDIConfig", "406", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Invalid property value.  Expected an int.", new Object[]{throwable});
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Unable to set int.  Using default.");
        }
        return n2;
    }

    protected String getStringValFromJNDIConfig(SchedulerService schedulerService, String string, String string2, String string3) {
        String string4 = string3;
        String string5 = schedulerService.getServiceVariable(string2, null);
        String string6 = Utils.getJNDIConfig(string, string5, " ", "=");
        if (tc.isDebugEnabled()) {
            if (string5 != null) {
                Tr.debug(tc, "Found variable: " + string2 + "=" + string5);
                Tr.debug(tc, "Digested Version: " + string6);
            } else {
                Tr.debug(tc, "Property not set: " + string2);
            }
        }
        if (string6 != null && string6.trim().length() != 0) {
            string4 = string6;
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Unable to set String.  Using default.");
        }
        return string4;
    }

    protected int getIntFromVariableMap(SchedulerService schedulerService, String string, int n) {
        int n2 = n;
        String string2 = schedulerService.getServiceVariable(string, null);
        if (string2 != null && string2.trim().length() != 0) {
            try {
                n2 = Integer.valueOf(string2);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.config.SchedulerConfigurationImpl.getIntFromVariableMap", "463", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Invalid property value.  Expected an int. Using default value.", new Object[]{throwable});
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Variable not found or not set.  Using default.");
        }
        return n2;
    }

    public void validateThis() throws SchedulerConfigurationException {
        if (this.workManagerJndiName == null) {
            throw new SchedulerConfigurationException(Messages.getMessage("SCHD0042E", new String[]{this.getName(), this.getJndiName()}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkManager getWorkManager() {
        if (this.workManagerJndiName == null) {
            throw new SchedulerConfigurationException(Messages.getMessage("SCHD0042E", new String[]{this.getName(), this.getJndiName()}));
        }
        String string = this.workManagerJndiName;
        synchronized (string) {
            if (this.workManager == null) {
                AsynchBeansService asynchBeansService = null;
                SchedulerServiceImpl schedulerServiceImpl = null;
                try {
                    schedulerServiceImpl = (SchedulerServiceImpl)SchedulerServiceImpl.instance();
                    if (schedulerServiceImpl == null) {
                        throw new SchedulerConfigurationException(Messages.getMessage("ERR_NO_SERVICE", "Scheduler"));
                    }
                    asynchBeansService = (AsynchBeansService)schedulerServiceImpl.getService(AsynchBeansService.class);
                    if (asynchBeansService == null) {
                        throw new SchedulerConfigurationException(Messages.getMessage("ERR_NO_SERVICE", "AsynchBeans"));
                    }
                    this.workManager = asynchBeansService.getWorkManager(this.workManagerJndiName);
                    if (this.workManager == null) {
                        throw new SchedulerConfigurationException(Messages.getMessage("SCHD0018E", this.workManagerJndiName));
                    }
                    if (asynchBeansService != null) {
                        schedulerServiceImpl.releaseService(asynchBeansService);
                    }
                }
                catch (Throwable throwable) {
                    if (asynchBeansService != null) {
                        schedulerServiceImpl.releaseService(asynchBeansService);
                    }
                    throw throwable;
                }
            }
            return this.workManager;
        }
    }
}

