/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scheduler.cron;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.scheduler.cron.CronBasicTerm;
import com.ibm.ws.scheduler.resources.Messages;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class CronDayOfWeekTerm
extends CronBasicTerm {
    private static final TraceComponent tc = Tr.register(CronDayOfWeekTerm.class, "Scheduler", "com.ibm.ws.scheduler.resources.SchedulerMessages");
    static final int K_LAST = 99;
    static final int K_EVERY = 0;
    TreeSet values = new TreeSet();
    int weekNumber = 0;

    public CronDayOfWeekTerm(String string, Map map) throws ParseException {
        if (string.equals("?")) {
            this.values = null;
            return;
        }
        this.parseDayRangeList(string, map);
    }

    void validateDay(int n) throws ParseException {
        if (n < 1 || n > 7) {
            throw new ParseException(Messages.getMessage("SCHD0110E"), 0);
        }
    }

    void parseDayRangeList(String string, Map map) throws ParseException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string2 = stringTokenizer.nextToken();
        this.parseDayRange(string2, map);
        while (stringTokenizer.hasMoreTokens()) {
            this.parseDayRange(stringTokenizer.nextToken(), map);
        }
    }

    void parseDayRange(String string, Map map) throws ParseException {
        boolean bl = tc.isDebugEnabled();
        if (bl) {
            Tr.debug(tc, "parsing '" + string + "'");
        }
        int n = 0;
        int n2 = 0;
        if (string.equals("*")) {
            n = 1;
            n2 = 7;
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
            String string2 = stringTokenizer.nextToken();
            n = this.parseNumber(string2, map);
            this.validateDay(n);
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (stringTokenizer.hasMoreTokens()) {
                    throw new ParseException(Messages.getMessage("SCHD0116E", string), 0);
                }
                n2 = this.parseNumber(string2, map);
                this.validateDay(n2);
                if (n > n2) {
                    throw new ParseException(Messages.getMessage("SCHD0116E", string), 0);
                }
            } else {
                n2 = n;
            }
        }
        for (int i = n; i <= n2; ++i) {
            this.values.add(new Integer(i));
        }
    }

    int calculateMaxWeekNum(Calendar calendar, int n) {
        calendar.set(8, 1);
        calendar.set(7, n);
        int n2 = calendar.get(5);
        int n3 = calendar.get(5);
        return 0;
    }

    public boolean isUnSpecified() {
        return this.values == null;
    }

    public void dump() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Dumping CronDayOfWeekTerm");
            if (this.weekNumber != -1) {
                Tr.debug(tc, "Week specified is " + this.weekNumber);
            } else {
                Tr.debug(tc, "Every week");
            }
            Iterator iterator = this.values.iterator();
            StringBuffer stringBuffer = new StringBuffer("Values: ");
            while (iterator.hasNext()) {
                Integer n = (Integer)iterator.next();
                stringBuffer.append(" ").append(n);
            }
            Tr.debug(tc, stringBuffer.toString());
        }
    }

    public boolean isConstant() {
        return false;
    }

    public Calendar getClosestCandidate(Calendar calendar) {
        int n;
        if (this.values == null) {
            return calendar;
        }
        int n2 = calendar.get(7);
        SortedSet<Integer> sortedSet = this.values.tailSet(new Integer(n2));
        int n3 = 0;
        if (sortedSet.isEmpty()) {
            n = this.getFirstValue();
            n3 = 7 - (n2 - n);
        } else {
            n = sortedSet.first();
            n3 = n - n2;
        }
        Calendar calendar2 = (Calendar)calendar.clone();
        if (n3 != 0) {
            calendar2.add(7, n3);
        }
        return calendar2;
    }

    public int getCalendarField() {
        return 5;
    }

    public int getCalOffset() {
        return 0;
    }

    public int getFirstValue() {
        return (Integer)this.values.first();
    }
}

