/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scheduler.cron;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.scheduler.cron.CronSimpleExpression;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;

public class CronExpression {
    private static final TraceComponent tc = Tr.register(CronExpression.class, "Scheduler", "com.ibm.ws.scheduler.resources.SchedulerMessages");
    static final int MAX_CACHE_SIZE = 100;
    ArrayList expressions;
    boolean debugEnabled;
    static Map expressionCache;
    static LinkedList expressionCacheLRU;

    public static synchronized CronExpression getCachedExpression(String string) throws ParseException {
        CronExpression cronExpression = null;
        if (expressionCache == null) {
            expressionCache = new HashMap();
            expressionCacheLRU = new LinkedList();
        }
        if (expressionCache.containsKey(string)) {
            cronExpression = (CronExpression)expressionCache.get(string);
            expressionCacheLRU.remove(string);
            expressionCacheLRU.addFirst(string);
        } else {
            if (expressionCache.size() >= 100) {
                String string2 = (String)expressionCacheLRU.removeLast();
                expressionCache.remove(string2);
            }
            cronExpression = new CronExpression(string);
            expressionCache.put(string, cronExpression);
            expressionCacheLRU.addLast(string);
        }
        return cronExpression;
    }

    public CronExpression(String string) throws ParseException {
        try {
            this.debugEnabled = false;
            this.parse(string);
        }
        catch (ParseException parseException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Couldn't parse '" + string + "' because " + parseException.getMessage());
            }
            throw parseException;
        }
    }

    void parse(String string) throws ParseException {
        this.expressions = new ArrayList(2);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            CronSimpleExpression cronSimpleExpression = new CronSimpleExpression(stringTokenizer.nextToken());
            this.expressions.add(cronSimpleExpression);
        }
    }

    public Date calculateClosestTime(Date date, boolean bl) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.set(8099, 12, 31);
        Calendar calendar2 = Calendar.getInstance();
        for (int i = 0; i < this.expressions.size(); ++i) {
            CronSimpleExpression cronSimpleExpression = (CronSimpleExpression)this.expressions.get(i);
            Date date2 = cronSimpleExpression.calculateClosestTime(date, bl);
            calendar2.setTime(date2);
            if (!calendar2.before(calendar)) continue;
            calendar.setTime(date2);
        }
        return calendar.getTime();
    }
}

