/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scheduler.cron;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.scheduler.cron.CronBasicTerm;
import com.ibm.ws.scheduler.cron.CronDayOfWeekTerm;
import com.ibm.ws.scheduler.cron.CronSimpleTerm;
import com.ibm.ws.scheduler.resources.Messages;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class CronSimpleExpression {
    private static final TraceComponent tc = Tr.register(CronSimpleExpression.class, "Scheduler", "com.ibm.ws.scheduler.resources.SchedulerMessages");
    static Map months;
    static Map dayNames;
    static Map emptySymbols;
    String text;
    CronSimpleTerm seconds;
    CronSimpleTerm minutes;
    CronSimpleTerm hours;
    CronSimpleTerm day;
    CronSimpleTerm month;
    CronDayOfWeekTerm dayOfWeek;

    public CronSimpleExpression(String string) throws ParseException {
        int n;
        this.text = string;
        StringTokenizer stringTokenizer = new StringTokenizer(this.text, " \t");
        String[] stringArray = new String[6];
        for (n = 0; n < stringArray.length && stringTokenizer.hasMoreTokens(); ++n) {
            stringArray[n] = stringTokenizer.nextToken();
        }
        if (stringArray[stringArray.length - 1] == null) {
            throw new ParseException(Messages.getMessage("SCHD0111E"), 0);
        }
        n = 1;
        try {
            this.seconds = new CronSimpleTerm(stringArray[0], 0, 60, emptySymbols, 13, 0, true);
            n = 2;
            this.minutes = new CronSimpleTerm(stringArray[1], 0, 60, emptySymbols, 12, 0, true);
            n = 3;
            this.hours = new CronSimpleTerm(stringArray[2], 0, 24, emptySymbols, 11, 0, true);
            n = 4;
            this.day = new CronSimpleTerm(stringArray[3], 1, 32, emptySymbols, 5, 0, false);
            n = 5;
            this.month = new CronSimpleTerm(stringArray[4], 1, 13, months, 2, 1, true);
            n = 6;
            this.dayOfWeek = new CronDayOfWeekTerm(stringArray[5], dayNames);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(Messages.getMessage("SCHD0115E", new Object[]{new Integer(n), numberFormatException.getLocalizedMessage()}));
        }
        catch (ParseException parseException) {
            throw new ParseException(Messages.getMessage("SCHD0115E", new Object[]{new Integer(n), parseException.getLocalizedMessage()}), 0);
        }
        if (this.day.isUnSpecified() && this.dayOfWeek.isUnSpecified()) {
            throw new ParseException(Messages.getMessage("SCHD0112E"), 0);
        }
        if (!this.day.isUnSpecified() && !this.dayOfWeek.isUnSpecified()) {
            throw new ParseException(Messages.getMessage("SCHD0112E"), 0);
        }
    }

    public String getText() {
        return this.text;
    }

    public Date calculateClosestTime(Date date, boolean bl) throws ParseException {
        boolean bl2 = tc.isDebugEnabled();
        Calendar calendar = Calendar.getInstance();
        calendar.setLenient(false);
        calendar.setTime(date);
        calendar.setFirstDayOfWeek(1);
        CronBasicTerm[] cronBasicTermArray = new CronBasicTerm[]{this.seconds, this.minutes, this.hours, this.day, this.month};
        if (this.day.isUnSpecified()) {
            cronBasicTermArray[3] = this.dayOfWeek;
        }
        if (bl2) {
            this.dumpCalendar(calendar, cronBasicTermArray, "Initial");
        }
        if (bl) {
            calendar.add(13, 1);
        }
        for (int i = 0; i < cronBasicTermArray.length; ++i) {
            CronBasicTerm cronBasicTerm = cronBasicTermArray[i];
            if (bl2) {
                this.dumpCalendar(calendar, cronBasicTermArray, "Before " + this.getCalendarFieldName(cronBasicTerm.getCalendarField()));
            }
            if (bl2) {
                cronBasicTerm.dump();
            }
            calendar = cronBasicTerm.getClosestCandidate(calendar);
        }
        return calendar.getTime();
    }

    void dumpCalendar(Calendar calendar, CronBasicTerm[] cronBasicTermArray, String string) {
        Tr.debug(tc, "Dump Calendar: " + string);
        for (int i = 0; i < cronBasicTermArray.length; ++i) {
            Tr.debug(tc, " Field: " + this.getCalendarFieldName(cronBasicTermArray[i].getCalendarField()) + " = " + calendar.get(cronBasicTermArray[i].getCalendarField()));
        }
        Tr.debug(tc, "*** Dump Calendar");
    }

    String getCalendarFieldName(int n) {
        switch (n) {
            case 13: {
                return "s";
            }
            case 12: {
                return "m";
            }
            case 11: {
                return "h";
            }
            case 5: {
                return "D";
            }
            case 2: {
                return "M";
            }
            case 1: {
                return "Y";
            }
        }
        return "*";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class clazz = CronSimpleExpression.class;
        synchronized (clazz) {
            emptySymbols = new HashMap();
            months = new HashMap();
            months.put("JAN", new Integer(1));
            months.put("FEB", new Integer(2));
            months.put("MAR", new Integer(3));
            months.put("APR", new Integer(4));
            months.put("MAY", new Integer(5));
            months.put("JUN", new Integer(6));
            months.put("JUL", new Integer(7));
            months.put("AUG", new Integer(8));
            months.put("SEP", new Integer(9));
            months.put("OCT", new Integer(10));
            months.put("NOV", new Integer(11));
            months.put("DEC", new Integer(12));
            dayNames = new HashMap();
            dayNames.put("SUN", new Integer(1));
            dayNames.put("MON", new Integer(2));
            dayNames.put("TUE", new Integer(3));
            dayNames.put("WED", new Integer(4));
            dayNames.put("THU", new Integer(5));
            dayNames.put("FRI", new Integer(6));
            dayNames.put("SAT", new Integer(7));
        }
    }
}

