/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scheduler.cron;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.scheduler.cron.CronBasicTerm;
import com.ibm.ws.scheduler.resources.Messages;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class CronSimpleTerm
extends CronBasicTerm {
    private static final TraceComponent tc = Tr.register(CronSimpleTerm.class, "Scheduler", "com.ibm.ws.scheduler.resources.SchedulerMessages");
    boolean isOptional = false;
    boolean isLast = false;
    boolean isMaxConstant = false;
    TreeSet values;
    int calendarField;
    int calOffset;

    public void dump() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Starting");
            Iterator iterator = this.values.iterator();
            String string = " ";
            while (iterator.hasNext()) {
                Integer n = (Integer)iterator.next();
                string = string + n + " ";
            }
            Tr.debug(tc, string);
        }
    }

    public CronSimpleTerm(String string, int n, int n2, Map map, int n3, int n4, boolean bl) throws NumberFormatException, ParseException {
        this.calendarField = n3;
        this.calOffset = n4;
        this.isMaxConstant = bl;
        this.values = new TreeSet();
        if (string.equals("?")) {
            if (n3 == 5) {
                this.isOptional = true;
                return;
            }
            throw new ParseException(Messages.getMessage("SCHD0113E"), 0);
        }
        if (string.equals("L")) {
            this.isLast = true;
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        if (!stringTokenizer.hasMoreTokens()) {
            throw new ParseException("Empty term: " + string, 0);
        }
        while (stringTokenizer.hasMoreTokens()) {
            int n5;
            int n6;
            String string2 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "/");
            String string3 = stringTokenizer2.nextToken();
            int n7 = 0;
            if (stringTokenizer2.hasMoreTokens()) {
                n7 = this.parseNumber(stringTokenizer2.nextToken(), map);
                if (n7 < 1 || n7 > n2) {
                    throw new ParseException(Messages.getMessage("SCHD0114E", new Object[]{new Integer(n7), string2, new Integer(n2)}), 0);
                }
                if (stringTokenizer2.hasMoreTokens()) {
                    throw new ParseException(Messages.getMessage("SCHD0117E", string2), 0);
                }
            }
            int n8 = n6 = n;
            if (string3.equals("*")) {
                n6 = n;
                n8 = n2 - 1;
            } else {
                StringTokenizer stringTokenizer3 = new StringTokenizer(string3, "-");
                n6 = this.parseNumber(stringTokenizer3.nextToken(), map);
                if (n6 < n || n6 > n2) {
                    throw new ParseException("Invalid term value detected.  Value is out of bounds.", 0);
                }
                if (stringTokenizer3.hasMoreTokens()) {
                    n8 = this.parseNumber(stringTokenizer3.nextToken(), map);
                    if (stringTokenizer3.hasMoreTokens()) {
                        throw new ParseException(Messages.getMessage("SCHD0116E", string3), 0);
                    }
                } else {
                    n8 = n6;
                }
            }
            if (n7 > 0) {
                if (n8 == n6) {
                    n8 = n2 - 1;
                }
                for (n5 = n6; n5 <= n8; n5 += n7) {
                    this.values.add(new Integer(n5));
                }
                continue;
            }
            for (n5 = n6; n5 <= n8; ++n5) {
                this.values.add(new Integer(n5));
            }
        }
    }

    public boolean isUnSpecified() {
        return this.isOptional;
    }

    public boolean isConstant() {
        int n = this.getFirstValue();
        return this.values.size() == 1 && !this.isOptional;
    }

    public int getFirstValue() {
        return (Integer)this.values.first();
    }

    public Calendar getClosestCandidate(Calendar calendar) {
        SortedSet<Integer> sortedSet;
        int n;
        int n2 = calendar.get(this.calendarField) + this.calOffset;
        int n3 = calendar.getActualMaximum(this.calendarField) + this.calOffset;
        int n4 = calendar.getActualMinimum(this.calendarField) + this.calOffset;
        if (this.isOptional) {
            return calendar;
        }
        if (this.isLast) {
            this.isLast = true;
            n = n3;
        } else {
            n = (Integer)this.values.first();
            sortedSet = this.values.tailSet(new Integer(n2));
            if (!sortedSet.isEmpty()) {
                n = (Integer)sortedSet.first();
            }
        }
        sortedSet = (Calendar)calendar.clone();
        int n5 = 0;
        if (n2 != n) {
            n5 = n > n3 ? n3 - n2 + 1 : (n < n2 ? (this.isMaxConstant ? (n3 - n2 + n - this.calOffset + 1) % (n3 - n4 + 1) : n3 - n2 + 1) : n - n2);
        }
        if (n5 != 0) {
            ((Calendar)((Object)sortedSet)).add(this.calendarField, n5);
        }
        if (!this.isLast && !this.values.contains(new Integer(((Calendar)((Object)sortedSet)).get(this.calendarField) + this.calOffset))) {
            return this.getClosestCandidate((Calendar)((Object)sortedSet));
        }
        return sortedSet;
    }

    boolean verifyMaximumIsLessThan(int n) {
        int n2 = (Integer)this.values.last();
        return n2 > n;
    }

    public int getCalendarField() {
        return this.calendarField;
    }

    public void setCalendarField(int n) {
        this.calendarField = n;
    }

    public int getCalOffset() {
        return this.calOffset;
    }

    public void setCalOffset(int n) {
        this.calOffset = n;
    }
}

