/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scheduler.cron;

import java.util.Calendar;
import java.util.Date;

class DayInfo
implements Comparable {
    int dayNumber;
    int weekNumber;

    public DayInfo(int n, int n2) {
        this.dayNumber = n;
        this.weekNumber = n2;
    }

    public DayInfo(DayInfo dayInfo) {
        this.dayNumber = dayInfo.dayNumber;
        this.weekNumber = dayInfo.weekNumber;
    }

    public String toString() {
        return "[" + this.dayNumber + "W" + this.weekNumber + "]";
    }

    public int compareTo(Object object) {
        DayInfo dayInfo = (DayInfo)object;
        if (this.weekNumber == dayInfo.weekNumber) {
            if (this.dayNumber == dayInfo.dayNumber) {
                return 0;
            }
            return this.dayNumber < dayInfo.dayNumber ? -1 : 1;
        }
        return this.weekNumber < dayInfo.weekNumber ? -1 : 1;
    }

    void getFromCalendar(Calendar calendar) {
        this.dayNumber = calendar.get(8);
        this.weekNumber = calendar.get(4);
    }

    public static void main(String[] stringArray) {
        Calendar calendar = Calendar.getInstance();
        Date date = new Date();
        System.out.println("Now: " + date);
        calendar.setTime(date);
        System.out.println("DOW: " + calendar.get(7) + " WEEK: " + calendar.get(4) + " DOWM: " + calendar.get(8));
        System.out.println("Max WOM:" + calendar.getActualMaximum(4) + ", DWOM:" + calendar.getActualMaximum(8));
        calendar.set(7, 7);
        calendar.set(8, 1);
        System.out.println("After: " + calendar.getTime());
    }
}

