/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scheduler.pmi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.SpdLoad;
import com.ibm.websphere.pmi.server.SpdLong;
import com.ibm.websphere.pmi.server.SpdStat;
import com.ibm.ws.scheduler.pmi.SchedulerPerf;

public class SchedulerPmiModule
extends PmiAbstractModule
implements SchedulerPerf {
    private static final long serialVersionUID = 2123218711157885183L;
    private static final TraceComponent tc = Tr.register(SchedulerPmiModule.class, "Scheduler", "com.ibm.ws.scheduler.resources.SchedulerMessages");
    public static final String moduleID = "schedulerModule";
    private SpdLong failedTasks = null;
    private SpdLong executedTasks = null;
    private SpdLong numberOfPolls = null;
    private SpdLoad pollTimeSecs = null;
    private SpdLoad tasksPerSecond = null;
    private SpdLoad collisionsPerSecond = null;
    private SpdLoad timeForPollQueryMS = null;
    private SpdLoad taskExecutionTimeMS = null;
    private SpdLoad tasksExpiringPerPoll = null;
    private SpdLoad tasksExecutedPerPoll = null;
    private SpdLoad taskLatencySecs = null;
    public static final int FAILED_TASKS = 1;
    public static final int EXECUTED_TASKS = 2;
    public static final int POLL_TIME_SECS = 9;
    public static final int TASKS_PER_SECOND = 3;
    public static final int COLLISIONS_PER_SECOND = 4;
    public static final int TIME_FOR_POLL_QUERY_MS = 5;
    public static final int TASKS_EXECUTION_TIME_MS = 6;
    public static final int TASKS_EXPIRING_PER_POLL = 7;
    public static final int TASKS_EXECUTED_PER_POLL = 10;
    public static final int NUMBER_OF_POLLS = 11;
    public static final int TASK_LATENCY_SECS = 8;
    private double totalCollisions = 0.0;
    private double totalExecuted = 0.0;
    private double lastTotalCollisions = 0.0;
    private double lastTotalExecuted = 0.0;
    private long lastTimerFireTime = System.currentTimeMillis();
    private long statsTimerDelta;
    private StatsAggregatorAL statsAggregatorAL = new StatsAggregatorAL();
    private boolean daemonEnabled = false;

    public SchedulerPmiModule(String string, long l) {
        super(moduleID, string);
        this.statsTimerDelta = l;
        this.registerModule(this);
    }

    public void destroy() {
        this.stopAggregator();
        this.unregisterModule(this);
    }

    protected String getInstanceName() {
        return this.instanceName;
    }

    protected boolean longCreated(SpdLong spdLong) {
        switch (spdLong.getId()) {
            case 1: {
                this.failedTasks = spdLong;
                return true;
            }
            case 2: {
                this.executedTasks = spdLong;
                return true;
            }
            case 11: {
                this.numberOfPolls = spdLong;
                return true;
            }
        }
        return false;
    }

    protected boolean statCreated(SpdStat spdStat) {
        switch (spdStat.getId()) {
            default: 
        }
        return false;
    }

    protected boolean loadCreated(SpdLoad spdLoad) {
        switch (spdLoad.getId()) {
            case 3: {
                this.tasksPerSecond = spdLoad;
                return true;
            }
            case 4: {
                this.collisionsPerSecond = spdLoad;
                return true;
            }
            case 5: {
                this.timeForPollQueryMS = spdLoad;
                return true;
            }
            case 6: {
                this.taskExecutionTimeMS = spdLoad;
                return true;
            }
            case 7: {
                this.tasksExpiringPerPoll = spdLoad;
                return true;
            }
            case 10: {
                this.tasksExecutedPerPoll = spdLoad;
                return true;
            }
            case 8: {
                this.taskLatencySecs = spdLoad;
                return true;
            }
            case 9: {
                this.pollTimeSecs = spdLoad;
                return true;
            }
        }
        return false;
    }

    public String getModuleID() {
        return moduleID;
    }

    public int getDefaultLevel() {
        return 1000;
    }

    public void taskExecuted(int n, int n2) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "TaskExecuted: " + n + "ms, " + n2 + "s");
        }
        if (this.taskExecutionTimeMS != null && this.taskExecutionTimeMS.isEnabled()) {
            this.taskExecutionTimeMS.add(n);
        }
        if (this.taskLatencySecs != null && this.taskLatencySecs.isEnabled()) {
            this.taskLatencySecs.add(n2);
        }
        if (this.executedTasks != null && this.executedTasks.isEnabled()) {
            this.executedTasks.increment();
        }
        this.totalExecuted += 1.0;
    }

    public void taskFailed() {
        if (this.failedTasks != null && this.failedTasks.isEnabled()) {
            this.failedTasks.increment();
        }
    }

    public void taskCollided() {
        this.totalCollisions += 1.0;
    }

    public void pollqueryComplete(int n, int n2) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "PollQueryComplete: " + n + "ms, " + n2);
        }
        if (this.timeForPollQueryMS != null && this.timeForPollQueryMS.isEnabled()) {
            this.timeForPollQueryMS.add(n);
        }
        if (this.tasksExpiringPerPoll != null && this.tasksExpiringPerPoll.isEnabled()) {
            this.tasksExpiringPerPoll.add(n2);
        }
    }

    public void pollComplete(int n, int n2, int n3) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "PollComplete: " + n + ", " + n2 + ", " + n3 + "s");
        }
        if (this.tasksExecutedPerPoll != null && this.tasksExecutedPerPoll.isEnabled()) {
            this.tasksExecutedPerPoll.add(n);
        }
        if (this.pollTimeSecs != null && this.pollTimeSecs.isEnabled()) {
            this.pollTimeSecs.add(n3);
        }
        if (this.numberOfPolls != null && this.numberOfPolls.isEnabled()) {
            this.numberOfPolls.increment();
        }
    }

    protected void updateTimerStats() {
        long l = System.currentTimeMillis();
        long l2 = l - this.lastTimerFireTime;
        long l3 = l2 / 1000L;
        this.lastTimerFireTime = l;
        double d = this.totalCollisions;
        double d2 = this.totalExecuted;
        double d3 = (d - this.lastTotalCollisions) / (double)l3;
        double d4 = (d2 - this.lastTotalExecuted) / (double)l3;
        this.lastTotalCollisions = d;
        this.lastTotalExecuted = d2;
        if (this.collisionsPerSecond != null && this.collisionsPerSecond.isEnabled()) {
            this.collisionsPerSecond.add(d3);
        }
        if (this.tasksPerSecond != null && this.tasksPerSecond.isEnabled()) {
            this.tasksPerSecond.add(d4);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Scheduler PMI Stats Aggregator: " + this.instanceName + ", cps=" + d3 + ", tps=" + d4);
        }
    }

    public void daemonDisabled() {
        this.daemonEnabled = false;
        this.changeAggregatorState(!this.bAllCountersDisabled, this.daemonEnabled);
    }

    public void daemonEnabled() {
        if (this.pollTimeSecs != null) {
            this.pollTimeSecs.reset(true);
        }
        if (this.collisionsPerSecond != null) {
            this.collisionsPerSecond.reset(true);
        }
        if (this.tasksPerSecond != null) {
            this.tasksPerSecond.reset(true);
        }
        if (this.tasksExecutedPerPoll != null) {
            this.tasksExecutedPerPoll.reset(true);
        }
        if (this.timeForPollQueryMS != null) {
            this.timeForPollQueryMS.reset(true);
        }
        if (this.tasksExpiringPerPoll != null) {
            this.tasksExpiringPerPoll.reset(true);
        }
        if (this.numberOfPolls != null) {
            this.numberOfPolls.reset(true);
        }
        this.daemonEnabled = true;
        this.changeAggregatorState(!this.bAllCountersDisabled, this.daemonEnabled);
    }

    public void setInstrumentationLevel(int n) {
        super.setInstrumentationLevel(n);
        if (n < this.currentLevel) {
            this.totalCollisions = 0.0;
            this.totalExecuted = 0.0;
        }
    }

    protected void counterStateChanged(boolean bl) {
        super.counterStateChanged(bl);
        this.changeAggregatorState(!bl, this.daemonEnabled);
    }

    private void changeAggregatorState(boolean bl, boolean bl2) {
        if (bl && bl2) {
            this.startAggregator();
        } else {
            this.stopAggregator();
        }
    }

    private void startAggregator() {
        this.statsAggregatorAL.start();
    }

    private void stopAggregator() {
        this.statsAggregatorAL.cancel();
    }

    private class StatsAggregatorAL
    implements AlarmListener {
        private boolean cancelled = false;
        private boolean started = false;

        private StatsAggregatorAL() {
        }

        public void alarm(Object object) {
            if (!this.isCancelled()) {
                SchedulerPmiModule.this.updateTimerStats();
            }
            if (!this.isCancelled()) {
                this.schedule();
            }
        }

        public synchronized void cancel() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "cancel");
            }
            this.cancelled = true;
            this.started = false;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "cancel");
            }
        }

        public synchronized boolean isCancelled() {
            return this.cancelled;
        }

        private void schedule() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "schedule");
            }
            AlarmManager.createDeferrable(SchedulerPmiModule.this.statsTimerDelta, this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "schedule");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            boolean bl;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "start");
            }
            StatsAggregatorAL statsAggregatorAL = this;
            synchronized (statsAggregatorAL) {
                bl = this.started;
                this.started = true;
                this.cancelled = false;
            }
            if (!bl) {
                this.schedule();
            }
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "start");
            }
        }
    }
}

