/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scheduler.tasks;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.scheduler.SchedulerException;
import com.ibm.websphere.scheduler.TaskHandler;
import com.ibm.websphere.scheduler.TaskHandlerHome;
import com.ibm.websphere.scheduler.TaskInvalid;
import com.ibm.ws.ejbcontainer.BasicEJBInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.EJBContainer;
import com.ibm.ws.scheduler.Runnable;
import com.ibm.ws.scheduler.Utils;
import com.ibm.ws.scheduler.exception.TaskException;
import com.ibm.ws.scheduler.resources.Messages;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.RemoteException;
import javax.ejb.HomeHandle;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

public class BeanTaskInfoWork
extends Runnable {
    private static final TraceComponent tc = Tr.register(BeanTaskInfoWork.class, "Scheduler", "com.ibm.ws.scheduler.resources.SchedulerMessages");
    HomeHandle homeHandle = null;
    String jndiName = null;
    private static final long serialVersionUID = 51L;

    public BeanTaskInfoWork() {
    }

    public BeanTaskInfoWork(TaskHandlerHome taskHandlerHome) throws RemoteException {
        this.setTaskHandler(taskHandlerHome);
    }

    public void setTaskHandler(TaskHandlerHome taskHandlerHome) throws RemoteException {
        if (taskHandlerHome == null) {
            throw new IllegalArgumentException(Messages.getMessage("SCHD0109E", "TaskHandlerHome"));
        }
        this.homeHandle = taskHandlerHome.getHomeHandle();
    }

    public TaskHandlerHome getTaskHandler() throws RemoteException {
        return (TaskHandlerHome)this.homeHandle.getEJBHome();
    }

    public void setTaskHandlerHomeHandle(HomeHandle homeHandle) {
        this.homeHandle = homeHandle;
    }

    public void doWork() throws TaskException {
        TaskHandlerHome taskHandlerHome = this.createBeanHome();
        TaskHandler taskHandler = this.createBeanInstance(taskHandlerHome);
        try {
            taskHandler.process(this.getTaskStatus());
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.tasks.BeanTaskInfoWork.doWork", "120");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception during BeanTaskInfoWork.doWork:", throwable);
            }
            try {
                EJBContainer eJBContainer = (EJBContainer)WsServiceRegistry.getService((Object)this, (Class)EJBContainer.class);
                BasicEJBInfo basicEJBInfo = eJBContainer.getBasicEJBInfo(taskHandlerHome);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "EJBInfo: ", basicEJBInfo);
                }
                throw new TaskException(Messages.getMessage("SCHD0139E", new Object[]{"TaskHandler", Utils.getExceptionMessageWithType(throwable) + " " + Messages.getMessage("SCHD0140I", new Object[]{basicEJBInfo.getHost() + " (" + basicEJBInfo.getHostIP() + ")", new Integer(basicEJBInfo.getPort()), basicEJBInfo.getJ2EEName()})}), throwable);
            }
            catch (TaskException taskException) {
                throw taskException;
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.scheduler.tasks.BeanTaskInfoWork.doWork", "150");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception getting EJBInfo:", throwable);
                }
                throw new TaskException(Messages.getMessage("SCHD0139E", new Object[]{"TaskHandler", Utils.getExceptionMessageWithType(throwable)}), throwable);
            }
        }
    }

    public void validate() throws TaskInvalid {
        if (this.homeHandle == null) {
            throw new TaskInvalid(Messages.getMessage("SCHD0109E", "TaskHandlerHome"));
        }
    }

    private TaskHandlerHome createBeanHome() throws TaskException {
        try {
            if (this.homeHandle == null) {
                throw new IllegalStateException(Messages.getMessage("SCHD0109E", "TaskHandlerHome"));
            }
            return (TaskHandlerHome)this.homeHandle.getEJBHome();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.tasks.BeanTaskInfoWork.createBeanHome", "180");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception during UserCalendar getEJBHome:", throwable);
            }
            throw new TaskException(Messages.getMessage("SCHD0138E", "TaskHandlerHome"), throwable);
        }
    }

    private TaskHandler createBeanInstance(TaskHandlerHome taskHandlerHome) throws TaskException {
        TaskHandler taskHandler;
        try {
            taskHandler = taskHandlerHome.create();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.tasks.BeanTaskInfoWork.createBeanHome", "200");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception during NotificationSink create:", throwable);
            }
            try {
                EJBContainer eJBContainer = (EJBContainer)WsServiceRegistry.getService((Object)this, (Class)EJBContainer.class);
                BasicEJBInfo basicEJBInfo = eJBContainer.getBasicEJBInfo(taskHandlerHome);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "EJBInfo: ", basicEJBInfo);
                }
                throw new TaskException(Messages.getMessage("SCHD0137E", new Object[]{"TaskHandler", Utils.getExceptionMessageWithType(throwable) + " " + Messages.getMessage("SCHD0140I", new Object[]{basicEJBInfo.getHost() + " (" + basicEJBInfo.getHostIP() + ")", new Integer(basicEJBInfo.getPort()), basicEJBInfo.getJ2EEName()})}), throwable);
            }
            catch (TaskException taskException) {
                throw taskException;
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.scheduler.tasks.BeanTaskInfoWork.createBeanHome", "220");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception getting EJBInfo:", throwable);
                }
                throw new TaskException(Messages.getMessage("SCHD0137E", new Object[]{"TaskHandler", Utils.getExceptionMessageWithType(throwable)}), throwable);
            }
        }
        return taskHandler;
    }

    public String getTaskHandlerJNDIName() {
        return this.jndiName;
    }

    public void setTaskHandler(String string) {
        this.jndiName = string;
    }

    public void preSerialize() throws SchedulerException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "preSerialize");
        }
        String string = this.getTaskHandlerJNDIName();
        try {
            if (string != null && string.length() > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The jndiName = " + string);
                }
                InitialContext initialContext = new InitialContext();
                Object object = initialContext.lookup(string);
                TaskHandlerHome taskHandlerHome = (TaskHandlerHome)PortableRemoteObject.narrow((Object)object, (Class)TaskHandlerHome.class);
                this.setTaskHandler(taskHandlerHome);
            }
        }
        catch (Throwable throwable) {
            Tr.error(tc, "SCHD0081E", new Object[]{string, throwable});
            throw new SchedulerException(Utils.getExceptionMessageWithType(throwable), throwable);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "preSerialize");
            }
        }
    }

    public void resolveHome() throws ClassCastException, NamingException, RemoteException {
        if (this.jndiName != null) {
            InitialContext initialContext = new InitialContext();
            Object object = initialContext.lookup(this.jndiName);
            TaskHandlerHome taskHandlerHome = (TaskHandlerHome)PortableRemoteObject.narrow((Object)object, (Class)TaskHandlerHome.class);
            this.homeHandle = taskHandlerHome.getHomeHandle();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public String toString() {
        if (tc.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            stringBuffer.append(" BeanTaskInfoWork: [");
            stringBuffer.append("THHANDLE=").append(this.homeHandle).append(", ");
            stringBuffer.append("THJNDI=").append(this.jndiName);
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
        return super.toString();
    }
}

