/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scheduler.tasks;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.EJBComponentMetaData;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.CustomContainerComponentMetaData;
import com.ibm.ws.scheduler.Runnable;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.webcontainer.metadata.WebComponentMetaData;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import org.eclipse.wst.common.internal.emf.utilities.EncoderDecoder;
import org.eclipse.wst.common.internal.emf.utilities.EncoderDecoderRegistry;

public class MessageTaskInfoWork
extends Runnable
implements FFDCSelfIntrospectable {
    static final int TEXT_MESSAGE = 0;
    static final int BYTE_MESSAGE = 1;
    static final int MAP_MESSAGE = 2;
    private static final long serialVersionUID = 51L;
    private static final TraceComponent tc = Tr.register(MessageTaskInfoWork.class, "Scheduler", "com.ibm.ws.scheduler.resources.SchedulerMessages");
    protected String destinationJndiName = null;
    protected String cfJndiName = null;
    protected int messageType = -1;
    protected byte[] byteMessage = null;
    protected String textMessage = null;
    protected Map mapMessage = null;
    protected int priority = 0;
    private boolean transacted = true;
    protected String username = null;
    protected String password = null;
    protected Map messageHeaders;
    private static final ComponentMetaDataAccessorImpl cmda = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor();
    private static final String RRTYPE_CF = "javax.resource.cci.ConnectionFactory";

    public void initialize(String string, String string2, String string3) {
        this.messageType = 0;
        this.cfJndiName = string;
        this.destinationJndiName = string2;
        this.textMessage = string3;
    }

    public void initialize(String string, String string2, Map map) {
        this.messageType = 2;
        this.cfJndiName = string;
        this.destinationJndiName = string2;
        this.mapMessage = map;
    }

    public void initialize(String string, String string2, byte[] byArray) {
        this.messageType = 1;
        this.cfJndiName = string;
        this.destinationJndiName = string2;
        this.byteMessage = byArray;
    }

    public String[] introspectSelf() {
        return new String[]{this.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(this)), "User name = " + this.username, "Password = ******", "Destination JNDI name = " + this.destinationJndiName, "Connection Factory JNDI name = " + this.cfJndiName, "Priority = " + this.priority, "Message type = " + MessageTaskInfoWork.getMessageTypeAsString(this.messageType), "Text message = " + this.textMessage, "Byte message = " + this.byteMessage, "Map message = " + this.mapMessage, "Message headers = " + this.messageHeaders, "Transacted? " + this.transacted};
    }

    public void setMessageHeaders(Map map) {
        this.messageHeaders = map;
    }

    public Map getMessageHeaders() {
        return this.messageHeaders;
    }

    private static String getMessageTypeAsString(int n) {
        switch (n) {
            case 0: {
                return "TEXT_MESSAGE (" + n + ')';
            }
            case 1: {
                return "BYTE_MESSAGE (" + n + ')';
            }
            case 2: {
                return "MAP_MESSAGE (" + n + ')';
            }
        }
        return "UNKNOWN (" + n + ')';
    }

    public void setConnectionFactoryJndiName(String string) {
        this.cfJndiName = string;
    }

    public String getConnectionFactoryJndiName() {
        return this.cfJndiName;
    }

    public void setDestinationJndiName(String string) {
        this.destinationJndiName = string;
    }

    public String getDestinationJndiName() {
        return this.destinationJndiName;
    }

    public void setMessageData(String string) {
        this.textMessage = string;
        this.messageType = 0;
    }

    public void setMessageData(Map map) {
        this.mapMessage = map;
        this.messageType = 2;
    }

    public void setMessageData(byte[] byArray) {
        this.byteMessage = byArray;
        this.messageType = 1;
    }

    public Object getMessageData() {
        switch (this.messageType) {
            case 0: {
                return this.textMessage;
            }
            case 2: {
                return this.mapMessage;
            }
            case 1: {
                return this.byteMessage;
            }
        }
        return null;
    }

    public void setJMSPriority(int n) {
        this.priority = n;
    }

    public int getJMSPriority() {
        return this.priority;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void doWork() throws Exception {
        MessageTaskInfoWork.sendMessage(this.destinationJndiName, this.cfJndiName, this.username, this.password, this.transacted, this.messageType, this.textMessage, this.byteMessage, this.mapMessage, this.priority, this.messageHeaders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendMessage(String string, String string2, String string3, String string4, boolean bl, int n, String string5, byte[] byArray, Map map, int n2, Map map2) throws Exception {
        Object object;
        ComponentMetaData componentMetaData = cmda.getComponentMetaData();
        if (componentMetaData instanceof CustomContainerComponentMetaData && !((object = (CustomContainerComponentMetaData)componentMetaData) instanceof EJBComponentMetaData) && !(object instanceof WebComponentMetaData)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Non-container EJB call.  Enabling direct-lookups.");
            }
            object.getCustomResourceRefList().addResRef("MessageTaskInfo CF ResRef Stub", string2, string2, RRTYPE_CF, 1, 0, 2);
            object.getCustomResourceRefList().addResRef("MessageTaskInfo Dest ResRef Stub", string, string, RRTYPE_CF, 1, 0, 2);
        }
        object = new InitialContext();
        Destination destination = (Destination)PortableRemoteObject.narrow((Object)((InitialContext)object).lookup(string), (Class)Destination.class);
        Connection connection = null;
        Session session = null;
        MessageProducer messageProducer = null;
        try {
            ConnectionFactory connectionFactory = (ConnectionFactory)PortableRemoteObject.narrow((Object)((InitialContext)object).lookup(string2), (Class)ConnectionFactory.class);
            String string6 = MessageTaskInfoWork.getDefaultEncoderDecoder().decode(string4);
            connection = string3 == null ? connectionFactory.createConnection() : connectionFactory.createConnection(string3, string6);
            connection.start();
            session = connection.createSession(bl, 1);
            messageProducer = session.createProducer(destination);
            Message message = MessageTaskInfoWork.getConstructedMessage(session, n, string5, byArray, map, n2, map2);
            messageProducer.send(message);
            Object var21_20 = null;
        }
        catch (Throwable throwable) {
            Object var21_21 = null;
            try {
                if (messageProducer != null) {
                    messageProducer.close();
                }
            }
            catch (Exception object2) {
                FFDCFilter.processException((Throwable)object2, "com.ibm.ws.scheduler.tasks.MessageTaskInfoWork.sendMessage", "241");
            }
            try {
                if (session != null) {
                    if (session.getTransacted() && ((object2 = TransactionManagerFactory.getUOWCurrent().getUOWCoord()) == null || !object2.isGlobal())) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "not in a global transaction");
                        }
                        session.commit();
                    }
                    session.close();
                }
            }
            catch (Exception object2) {
                FFDCFilter.processException((Throwable)object2, "com.ibm.ws.scheduler.tasks.MessageTaskInfoWork.sendMessage", "252");
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception object2) {
                FFDCFilter.processException((Throwable)object2, "com.ibm.ws.scheduler.tasks.MessageTaskInfoWork.sendMessage", "262");
            }
            throw throwable;
        }
        try {
            if (messageProducer != null) {
                messageProducer.close();
            }
        }
        catch (Exception object3) {
            FFDCFilter.processException((Throwable)object3, "com.ibm.ws.scheduler.tasks.MessageTaskInfoWork.sendMessage", "241");
        }
        try {
            if (session != null) {
                if (session.getTransacted() && ((object3 = TransactionManagerFactory.getUOWCurrent().getUOWCoord()) == null || !object3.isGlobal())) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "not in a global transaction");
                    }
                    session.commit();
                }
                session.close();
            }
        }
        catch (Exception object3) {
            FFDCFilter.processException((Throwable)object3, "com.ibm.ws.scheduler.tasks.MessageTaskInfoWork.sendMessage", "252");
        }
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (Exception object3) {
            FFDCFilter.processException((Throwable)object3, "com.ibm.ws.scheduler.tasks.MessageTaskInfoWork.sendMessage", "262");
        }
    }

    private static Message getConstructedMessage(Session session, int n, String string, byte[] byArray, Map map, int n2, Map map2) throws JMSException {
        Object object;
        Object object2;
        TextMessage textMessage = null;
        if (n == 0) {
            textMessage = session.createTextMessage(string);
        } else if (n == 1) {
            textMessage = session.createBytesMessage();
            ((BytesMessage)textMessage).writeBytes(byArray);
        } else if (n == 2) {
            textMessage = session.createMapMessage();
            object2 = (MapMessage)textMessage;
            object = map.keySet();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                object2.setObject(string2, map.get(string2));
            }
        }
        textMessage.setJMSPriority(n2);
        if (map2 != null) {
            object2 = map2.keySet().iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                textMessage.setObjectProperty((String)object, map2.get(object));
            }
        }
        return textMessage;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    private static EncoderDecoder getDefaultEncoderDecoder() {
        return EncoderDecoderRegistry.getDefaultRegistry().getDefaultEncoderDecoder();
    }

    public String toString() {
        if (tc.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            stringBuffer.append(" MessageTaskInfoWork: [");
            stringBuffer.append("DESTJNDI=").append(this.destinationJndiName).append(", ");
            stringBuffer.append("CFJNDI=").append(this.cfJndiName).append(", ");
            stringBuffer.append("PRI=").append(this.priority).append(", ");
            stringBuffer.append("TRANS=").append(this.transacted).append(", ");
            stringBuffer.append("PRI=").append(this.priority).append(", ");
            stringBuffer.append("USERNAME=").append(this.username).append(", ");
            stringBuffer.append("MSGTYPE=").append(this.messageType).append(", ");
            stringBuffer.append("BYTEMSGL=").append(this.byteMessage == null ? -1 : this.byteMessage.length).append(", ");
            stringBuffer.append("TEXTMSGL=").append(this.textMessage == null ? -1 : this.textMessage.length()).append(", ");
            stringBuffer.append("MAPMSGSZ=").append(this.mapMessage == null ? -1 : this.mapMessage.size()).append(", ");
            stringBuffer.append("HDRSZ=").append(this.messageHeaders == null ? -1 : this.messageHeaders.size());
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
        return super.toString();
    }
}

