/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.websphere.management.configservice.SessionPropertyConstants;
import com.ibm.websphere.management.configservice.ValidationResult;
import com.ibm.websphere.management.configservice.tasks.InstallRARTask;
import com.ibm.websphere.management.configservice.tasks.ServerClusterTasks;
import com.ibm.websphere.management.configservice.tasks.UninstallRARTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.AppRefException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.DocumentNotFoundException;
import com.ibm.websphere.management.exception.InvalidAttributeNameException;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.Document;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.management.repository.DocumentDigest;
import com.ibm.websphere.management.repository.client.ConfigRepositoryClientFactory;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.util.PlatformUtils;
import com.ibm.ws.scripting.AbstractShell;
import com.ibm.ws.scripting.AdminControlClient;
import com.ibm.ws.scripting.ArrayListAttrHelper;
import com.ibm.ws.scripting.AttrHelper;
import com.ibm.ws.scripting.AttrInfo;
import com.ibm.ws.scripting.BaseAttrHelper;
import com.ibm.ws.scripting.BooleanAttrHelper;
import com.ibm.ws.scripting.CommonScriptingObject;
import com.ibm.ws.scripting.ConfigHelper;
import com.ibm.ws.scripting.ConfigNameCache;
import com.ibm.ws.scripting.EnumArrayAttrHelper;
import com.ibm.ws.scripting.EnumAttrHelper;
import com.ibm.ws.scripting.ExceptionSupport;
import com.ibm.ws.scripting.HelpSupport;
import com.ibm.ws.scripting.IntegerArrayAttrHelper;
import com.ibm.ws.scripting.IntegerAttrHelper;
import com.ibm.ws.scripting.LongAttrHelper;
import com.ibm.ws.scripting.MetaInfoCache;
import com.ibm.ws.scripting.ObjectAttrHelper;
import com.ibm.ws.scripting.ObjectNameArrayAttrHelper;
import com.ibm.ws.scripting.ObjectNameAttrHelper;
import com.ibm.ws.scripting.ScriptingException;
import com.ibm.ws.scripting.StringArrayAttrHelper;
import com.ibm.ws.scripting.types.CommonSecureInteropTSHelper;
import com.ibm.ws.scripting.types.HTTPTransportTSHelper;
import com.ibm.ws.scripting.types.IIOPTransportTSHelper;
import com.ibm.ws.scripting.types.LDAPUserRegistryTSHelper;
import com.ibm.ws.scripting.types.PropertyTSHelper;
import com.ibm.ws.scripting.types.SOAPConnectorTSHelper;
import com.ibm.ws.scripting.types.SSLConfigTSHelper;
import com.ibm.ws.scripting.types.SecureSocketLayerTSHelper;
import com.ibm.ws.scripting.types.SecurityTSHelper;
import com.ibm.ws.scripting.types.TransportLayerTSHelper;
import com.ibm.ws.scripting.types.TypeSpecificHelper;
import com.ibm.ws.scripting.types.WASTopicConnectionFactoryTSHelper;
import com.ibm.ws.scripting.types.WebContainerTSHelper;
import com.ibm.ws.util.ImplFactory;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class AdminConfigClient
extends CommonScriptingObject {
    private static TraceComponent tc = Tr.register(AdminConfigClient.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    private static AdminConfigClient _self = null;
    private Session _session = null;
    private boolean overwriteOnSave = false;
    private Integer validationLevel = null;
    private boolean validationLevelChanged = true;
    private Boolean crossValidationEnabled = null;
    private boolean crossValidationEnabledChanged = true;
    private HashMap levelMapper = null;
    private PrintWriter validationWriter = null;
    private String validationOutputFileName = null;
    private int[] validationCounters = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final String VALIDATION_FILE_PROP = "com.ibm.ws.scripting.validationOutput";
    private static final String VALIDATION_FILE_PROP_DEFAULT = "wsadmin.valout";
    private static final String VALIDATION_LEVEL_PROP = "com.ibm.ws.scripting.validationLevel";
    private static final Integer VALIDATION_LEVEL_PROP_DEFAULT = SessionPropertyConstants.HIGHEST_LEVEL_VALIDATION;
    private static final String VALIDATION_CROSS_PROP = "com.ibm.ws.scripting.crossDocumentValidationEnabled";
    private static final Boolean VALIDATION_CROSS_PROP_DEFAULT = Boolean.TRUE;
    private static final String CLUSTERTYPE = "ServerCluster";
    private static final String MEMBERTYPE = "ClusterMember";
    private static final String SERVERTYPE = "Server";
    private static final String NODETYPE = "Node";
    private MetaInfoCache metaCache = null;
    private ConfigNameCache nameCache = null;
    private static ConfigService configServiceProxy = null;
    private ServerClusterTasks clusterTasks = null;
    private static ArrayList validInstallRarOptions = null;
    private static ArrayList validUninstallRarOptions = null;
    protected static int returnCode = 0;
    private ConfigHelper configHelper = null;
    private static final int NAME_CACHE_SIZE = 20;
    private static final String ANONYMOUS = "Script";
    private Hashtable helperTable = null;
    private Hashtable typeSpecificHelperTable = null;
    private String S_Attribute = null;
    private String S_Type = null;
    private String S_Default = null;
    private static final int MARGIN = 32;

    public static AdminConfigClient getInstance() {
        return _self;
    }

    public static ConfigService getConfigService() {
        return configServiceProxy;
    }

    protected ConfigHelper getConfigHelper() {
        return this.configHelper;
    }

    public AdminConfigClient(AbstractShell abstractShell) throws AdminException, ConnectorException {
        super(abstractShell, null);
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AdminConfigClient");
        }
        _self = this;
        this.init();
        if (configServiceProxy != null) {
            object2 = null;
            object = new StringBuffer();
            try {
                object2 = configServiceProxy.getUnsavedChanges(this.getCurrentSession());
                if (object2 != null) {
                    for (int i = 0; i < ((String[])object2).length; ++i) {
                        ((StringBuffer)object).append(object2[i]);
                        ((StringBuffer)object).append(nl);
                    }
                }
            }
            catch (Exception exception) {
                this._shell.setLastException(exception);
                String string = ExceptionSupport.getMessage(exception, "WASX");
                if (string == null) {
                    string = exception.toString();
                }
                throw new ScriptingException(string);
            }
            if (((StringBuffer)object).length() > 0) {
                Tr.audit(tc, "WASX7240I", new Object[]{((StringBuffer)object).toString()});
                this.reset();
            }
        }
        this.metaCache = MetaInfoCache.getInstance();
        this.metaCache.setShell(this._shell);
        this.configHelper = new ConfigHelper(this._shell, "WebSphere");
        this.nameCache = new ConfigNameCache(this.configHelper, 20, this.getCurrentSession());
        this.helperTable = new Hashtable();
        this.helperTable.put("String", new BaseAttrHelper(this.configHelper, this.nameCache, this._shell));
        this.helperTable.put("String*", new StringArrayAttrHelper(this.configHelper, this.nameCache, this._shell));
        object2 = new IntegerAttrHelper(this.configHelper, this.nameCache, this._shell);
        this.helperTable.put("Integer", object2);
        this.helperTable.put("int", object2);
        object2 = new IntegerArrayAttrHelper(this.configHelper, this.nameCache, this._shell);
        this.helperTable.put("Integer*", object2);
        this.helperTable.put("int*", object2);
        object2 = new LongAttrHelper(this.configHelper, this.nameCache, this._shell);
        this.helperTable.put("Long", object2);
        this.helperTable.put("long", object2);
        object2 = new BooleanAttrHelper(this.configHelper, this.nameCache, this._shell);
        this.helperTable.put("Boolean", object2);
        this.helperTable.put("boolean", object2);
        this.helperTable.put("ENUM", new EnumAttrHelper(this.configHelper, this.nameCache, this._shell));
        this.helperTable.put("ENUM*", new EnumArrayAttrHelper(this.configHelper, this.nameCache, this._shell));
        this.helperTable.put("AttributeList", new ObjectAttrHelper(this.configHelper, this.nameCache, this._shell));
        this.helperTable.put("ArrayList", new ArrayListAttrHelper(this.configHelper, this.nameCache, this._shell));
        this.helperTable.put("ObjectName", new ObjectNameAttrHelper(this.configHelper, this.nameCache, this._shell));
        this.helperTable.put("ObjectName*", new ObjectNameArrayAttrHelper(this.configHelper, this.nameCache, this._shell));
        this.typeSpecificHelperTable = new Hashtable();
        this.typeSpecificHelperTable.put("WASTopicConnectionFactory", new WASTopicConnectionFactoryTSHelper(this, this._shell));
        this.typeSpecificHelperTable.put("MQTopicConnectionFactory", new WASTopicConnectionFactoryTSHelper(this, this._shell));
        this.typeSpecificHelperTable.put("Security", new SecurityTSHelper(this, this._shell, this.typeSpecificHelperTable, this.nameCache));
        this.typeSpecificHelperTable.put("SSLConfig", new SSLConfigTSHelper(this, this._shell, this.typeSpecificHelperTable, this.nameCache));
        this.typeSpecificHelperTable.put("SecureSocketLayer", new SecureSocketLayerTSHelper(this, this._shell, this.typeSpecificHelperTable, this.nameCache));
        this.typeSpecificHelperTable.put("Property", new PropertyTSHelper(this, this._shell, this.typeSpecificHelperTable, this.nameCache));
        this.typeSpecificHelperTable.put("TypedProperty", new PropertyTSHelper(this, this._shell, this.typeSpecificHelperTable, this.nameCache));
        this.typeSpecificHelperTable.put("SOAPConnector", new SOAPConnectorTSHelper(this, this._shell, this.typeSpecificHelperTable, this.nameCache));
        this.typeSpecificHelperTable.put("WebContainer", new WebContainerTSHelper(this, this._shell, this.typeSpecificHelperTable, this.nameCache));
        this.typeSpecificHelperTable.put("HTTPTransport", new HTTPTransportTSHelper(this, this._shell, this.typeSpecificHelperTable, this.nameCache));
        this.typeSpecificHelperTable.put("CommonSecureInterop", new CommonSecureInteropTSHelper(this, this._shell, this.typeSpecificHelperTable, this.nameCache));
        this.typeSpecificHelperTable.put("SecurityProtocolConfig", new CommonSecureInteropTSHelper(this, this._shell, this.typeSpecificHelperTable, this.nameCache));
        this.typeSpecificHelperTable.put("SecureAssociationService", new CommonSecureInteropTSHelper(this, this._shell, this.typeSpecificHelperTable, this.nameCache));
        this.typeSpecificHelperTable.put("TransportLayer", new TransportLayerTSHelper(this, this._shell, this.typeSpecificHelperTable, this.nameCache));
        this.typeSpecificHelperTable.put("IIOPTransport", new IIOPTransportTSHelper(this, this._shell, this.typeSpecificHelperTable, this.nameCache));
        this.typeSpecificHelperTable.put("LDAPUserRegistry", new LDAPUserRegistryTSHelper(this, this._shell, this.typeSpecificHelperTable, this.nameCache));
        this.levelMapper = new HashMap();
        this.levelMapper.put(SessionPropertyConstants.NO_VALIDATION, "NONE");
        this.levelMapper.put(SessionPropertyConstants.LOW_LEVEL_VALIDATION, "LOW");
        this.levelMapper.put(SessionPropertyConstants.MEDIUM_LEVEL_VALIDATION, "MEDIUM");
        this.levelMapper.put(SessionPropertyConstants.HIGH_LEVEL_VALIDATION, "HIGH");
        this.levelMapper.put(SessionPropertyConstants.HIGHEST_LEVEL_VALIDATION, "HIGHEST");
        this.validationOutputFileName = System.getProperty(VALIDATION_FILE_PROP);
        if (this.validationOutputFileName == null) {
            this.validationOutputFileName = VALIDATION_FILE_PROP_DEFAULT;
            object = System.getProperty("server.root");
            if (object != null) {
                this.validationOutputFileName = (String)object + File.separator + "logs" + File.separator + this.validationOutputFileName;
            }
        }
        if (((File)(object = new File(this.validationOutputFileName))).exists() && !((File)object).canWrite()) {
            this._shell.setAndThrowScriptingException("WASX7196E", "Cannot write to validation output file.", new Object[]{((File)object).getAbsolutePath()});
        }
        FileOutputStream fileOutputStream = null;
        try {
            if (!((File)object).exists()) {
                ((File)object).createNewFile();
            }
            fileOutputStream = new FileOutputStream((File)object);
        }
        catch (IOException iOException) {
            this._shell.setAndThrowScriptingException("WASX7197E", "IO error creating validation output file", new Object[]{this.validationOutputFileName, iOException.toString()});
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
        this.validationWriter = new PrintWriter((Writer)new BufferedWriter(outputStreamWriter), true);
        String string = System.getProperty(VALIDATION_LEVEL_PROP);
        if (string == null) {
            this.validationLevel = VALIDATION_LEVEL_PROP_DEFAULT;
        } else {
            this.setValidationLevel(string);
        }
        string = System.getProperty(VALIDATION_CROSS_PROP);
        if (string == null) {
            this.crossValidationEnabled = VALIDATION_CROSS_PROP_DEFAULT;
        } else {
            this.setCrossDocumentValidationEnabled(string);
        }
        Tr.audit(tc, "WASX7208I", new Object[]{(String)this.levelMapper.get(this.validationLevel), this.crossValidationEnabled, this.validationOutputFileName});
        this.clusterTasks = new ServerClusterTasks(configServiceProxy);
        this.S_Attribute = _bundle.getString("HELP_STRING_ATTRIBUTE");
        this.S_Type = _bundle.getString("HELP_STRING_TYPE");
        this.S_Default = _bundle.getString("HELP_STRING_DEFAULT");
        validInstallRarOptions = new ArrayList();
        validInstallRarOptions.add("rar.name");
        validInstallRarOptions.add("rar.desc");
        validInstallRarOptions.add("rar.archivePath");
        validInstallRarOptions.add("rar.classpath");
        validInstallRarOptions.add("rar.nativePath");
        validInstallRarOptions.add("rar.threadPoolAlias");
        validInstallRarOptions.add("rar.propertiesSet");
        validUninstallRarOptions = new ArrayList();
        validUninstallRarOptions.add("force");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AdminConfigClient");
        }
    }

    private void init() throws AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init");
        }
        if (_client == null) {
            if (this._shell.getConnectionType().equals("NONE")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating local config service");
                }
                Properties properties = new Properties();
                properties.put("location", "local");
                configServiceProxy = ConfigServiceFactory.getConfigService();
                if (configServiceProxy == null) {
                    configServiceProxy = ConfigServiceFactory.createConfigService(true, properties);
                }
            } else {
                Tr.warning(tc, "WASX7198W", null);
                configServiceProxy = null;
            }
        } else {
            try {
                configServiceProxy = new ConfigServiceProxy(_client);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                Tr.warning(tc, "WASX7198W", null);
                configServiceProxy = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public void doReconnect() throws AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doReconnect");
        }
        this.init();
        this.metaCache.reconnect();
        this.nameCache.reconnect();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doReconnect");
        }
    }

    public String help() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "help");
        }
        String string = this._shell.getFormattedMessage("ADMINCONFIG_GENERAL_HELP", new Object[0], "no help available");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "help");
        }
        return string;
    }

    public String help(String string) {
        String string2;
        String string3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "help - " + string);
        }
        if ((string3 = this._shell.getFormattedMessage(string2 = "ADMINCONFIG_HELP_" + string.toUpperCase(), new Object[0], "No help available for " + string)).startsWith("No help available")) {
            string2 = "WASX7084E";
            string3 = this._shell.getFormattedMessage(string2, new Object[]{string}, "No help available for " + string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "help");
        }
        return string3;
    }

    public String types() throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "types");
        }
        this._shell.setLastException(null);
        String string = null;
        try {
            this.checkService();
            HashSet<String> hashSet = new HashSet<String>();
            String[] stringArray = this.metaCache.getTypes();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    hashSet.add(stringArray[i]);
                }
            }
            string = this._langutils.setToString(hashSet);
        }
        catch (ScriptingException scriptingException) {
            throw scriptingException;
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            String string2 = ExceptionSupport.getMessage(exception, "WASX");
            if (string2 == null) {
                string2 = exception.toString();
            }
            throw new ScriptingException(string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "types");
        }
        return string;
    }

    public String listTemplates(String string) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listTemplates for type " + string);
        }
        String string2 = this.listTemplates(string, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listTemplates for type " + string);
        }
        return string2;
    }

    public String listTemplates(String string, String string2) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listTemplates", new Object[]{string, string2});
        }
        this._shell.setLastException(null);
        String string3 = null;
        this.checkService();
        try {
            string = this.configHelper.cleanString(string);
            ObjectName[] objectNameArray = null;
            objectNameArray = configServiceProxy.queryTemplates(this.getCurrentSession(), string);
            HashSet<String> hashSet = new HashSet<String>();
            if (objectNameArray == null && tc.isDebugEnabled()) {
                Tr.debug(tc, "oList is null!");
            }
            for (int i = 0; i < objectNameArray.length; ++i) {
                String string4 = this.configHelper.getListingName(objectNameArray[i]);
                String string5 = objectNameArray[i].getKeyProperty("_Websphere_Config_Data_Type");
                this.nameCache.add(string4, string5);
                if (string2 != null) {
                    if (string4.indexOf(string2) < 0) continue;
                    hashSet.add(string4);
                    continue;
                }
                hashSet.add(string4);
            }
            string3 = this._langutils.setToString(hashSet);
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            String string6 = ExceptionSupport.getMessage(exception, "WASX");
            if (string6 == null) {
                string6 = exception.toString();
            }
            throw new ScriptingException(string6);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listTemplates");
        }
        return string3;
    }

    public String list(String string) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "list for type " + string);
        }
        this._shell.setLastException(null);
        string = this.configHelper.cleanString(string);
        String string2 = this.list(string, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "list for type " + string);
        }
        return string2;
    }

    protected ObjectName[] internalList(String string, String string2, boolean bl) throws ScriptingException, AdminException, ConnectorException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "internalList for type " + string + " in scope " + string2);
        }
        string = this.configHelper.cleanString(string);
        this.checkService();
        ObjectName[] objectNameArray = null;
        ObjectName objectName = null;
        ObjectName objectName2 = null;
        Hashtable hashtable = null;
        if (string2 != null) {
            hashtable = this.configHelper.parseObjectIdString(string2);
            object = this.nameCache.getType(string2);
            if (object != null) {
                hashtable.put("_Websphere_Config_Data_Type", object);
            }
        }
        object = new Hashtable<String, String>();
        objectNameArray = null;
        ((Hashtable)object).put("_Websphere_Config_Data_Type", string);
        try {
            objectName = new ObjectName("WebSphere", (Hashtable<String, String>)object);
            if (hashtable != null) {
                objectName2 = new ObjectName("WebSphere", hashtable);
            }
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            Tr.event(tc, "Caught exception creating object name for " + string + "; exception: " + malformedObjectNameException);
            String string3 = ExceptionSupport.getMessage(malformedObjectNameException, "WASX");
            if (string3 == null) {
                string3 = malformedObjectNameException.toString();
            }
            throw new ScriptingException(string3);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "About to call queryConfigObjects.");
        }
        objectNameArray = configServiceProxy.queryConfigObjects(this.getCurrentSession(), objectName2, objectName, null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "back from call to queryConfigObjects.");
        }
        if (bl) {
            Vector<ObjectName> vector = new Vector<ObjectName>();
            for (int i = 0; objectNameArray != null && i < objectNameArray.length; ++i) {
                ObjectName[] objectNameArray2;
                ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectNameArray[i]);
                if (configDataId.isResolved()) {
                    vector.add(objectNameArray[i]);
                    continue;
                }
                if (string.equals(NODETYPE) && ("NodeAgent".equals(processType) || "ManagedProcess".equals(processType))) {
                    objectNameArray2 = objectNameArray[i].getKeyProperty("_Websphere_Config_Data_Display_Name");
                    AdminControlClient adminControlClient = AdminControlClient.getInstance();
                    String string4 = adminControlClient.getNode();
                    if (!string4.equals(objectNameArray2)) {
                        if (!tc.isEventEnabled()) continue;
                        Tr.event(tc, "This is not the nodeAgent node; ignoring");
                        continue;
                    }
                }
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Id is not resolved; need to make another call.");
                }
                if ((objectNameArray2 = configServiceProxy.queryConfigObjects(this.getCurrentSession(), null, objectNameArray[i], null)) == null || objectNameArray2.length != 1) continue;
                vector.add(objectNameArray2[0]);
            }
            objectNameArray = new ObjectName[vector.size()];
            objectNameArray = vector.toArray(objectNameArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "internalList");
        }
        return objectNameArray;
    }

    protected String internalGetID(String string) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "internalGetID", new Object[]{string});
        }
        this.checkService();
        String string2 = new String();
        ObjectName objectName = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("_Websphere_Config_Data_Id", string);
        try {
            objectName = new ObjectName("WebSphere", hashtable);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            Tr.event(tc, "Caught exception creating object name for " + string + "; exception: " + malformedObjectNameException);
            String string3 = ExceptionSupport.getMessage(malformedObjectNameException, "WASX");
            if (string3 == null) {
                string3 = malformedObjectNameException.toString();
            }
            throw new ScriptingException(string3);
        }
        ObjectName[] objectNameArray = null;
        try {
            objectNameArray = configServiceProxy.queryConfigObjects(this.getCurrentSession(), null, objectName, null);
        }
        catch (Exception exception) {
            Tr.audit(tc, "Caught exception in internalGetID: " + exception.toString());
        }
        if (objectNameArray != null) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "size of list returned is " + objectNameArray.length);
            }
            if (objectNameArray.length > 1) {
                Tr.audit(tc, "Found " + objectNameArray.length + " objects; returning first.");
            }
            if (objectNameArray.length >= 1) {
                ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectNameArray[0]);
                if (!configDataId.isResolved()) {
                    ObjectName[] objectNameArray2;
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Id is not resolved; need to make another call.");
                    }
                    if ((objectNameArray2 = configServiceProxy.queryConfigObjects(this.getCurrentSession(), null, objectNameArray[0], null)) != null && objectNameArray2.length == 1) {
                        objectNameArray[0] = objectNameArray2[0];
                    }
                }
                string2 = this.configHelper.getListingName(objectNameArray[0]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "internalGetID");
        }
        return string2;
    }

    public String list(String string, String string2) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "list for type " + string + " in scope " + string2);
        }
        this._shell.setLastException(null);
        String string3 = null;
        try {
            ObjectName[] objectNameArray = this.internalList(string, string2, true);
            HashSet<String> hashSet = new HashSet<String>();
            if (objectNameArray == null && tc.isDebugEnabled()) {
                Tr.debug(tc, "oList is null!");
            }
            for (int i = 0; i < objectNameArray.length; ++i) {
                String string4 = this.configHelper.getListingName(objectNameArray[i]);
                String string5 = objectNameArray[i].getKeyProperty("_Websphere_Config_Data_Type");
                this.nameCache.add(string4, string5);
                hashSet.add(string4);
            }
            string3 = this._langutils.setToString(hashSet);
        }
        catch (ScriptingException scriptingException) {
            throw scriptingException;
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            String string6 = ExceptionSupport.getMessage(exception, "WASX");
            if (string6 == null) {
                string6 = exception.toString();
            }
            throw new ScriptingException(string6);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "list");
        }
        return string3;
    }

    public String attributes(String string) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "attributes for type " + string);
        }
        this._shell.setLastException(null);
        this.checkService();
        String string2 = null;
        try {
            HashSet<String> hashSet = new HashSet<String>();
            string = this.configHelper.cleanString(string);
            String[] stringArray = this.metaCache.getAttributeNamesForType(string);
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].equals("trustFileFormat ENUM(JCEK, JKS, JCERACFKS, PKCS12)")) {
                        stringArray[i] = "trustFileFormat ENUM(JCEK, JKS, JCERACFKS, JCE4758RACFKS, PKCS12)";
                    } else if (stringArray[i].equals("keyFileFormat ENUM(JCEK, JKS, JCERACFKS, PKCS12)")) {
                        stringArray[i] = "keyFileFormat ENUM(JCEK, JKS, JCERACFKS, JCE4758RACFKS, PKCS12)";
                    }
                    hashSet.add(stringArray[i]);
                }
            }
            string2 = this._langutils.setToString(hashSet);
        }
        catch (ScriptingException scriptingException) {
            throw scriptingException;
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            String string3 = ExceptionSupport.getMessage(exception, "WASX");
            if (string3 == null) {
                string3 = exception.toString();
            }
            throw new ScriptingException(string3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "attributes for type " + string);
        }
        return string2;
    }

    public String defaults(String string) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "attributes for type " + string);
        }
        this._shell.setLastException(null);
        this.checkService();
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            string = this.configHelper.cleanString(string);
            Vector vector = null;
            try {
                vector = this.metaCache.getFlatAttributeMap(string);
            }
            catch (ScriptingException scriptingException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No attrs for " + string);
                }
                vector = new Vector();
            }
            HelpSupport.spaceit(stringBuffer, this.S_Attribute, 32);
            HelpSupport.spaceit(stringBuffer, this.S_Type, 32);
            stringBuffer.append(this.S_Default);
            for (int i = 0; i < vector.size(); ++i) {
                stringBuffer.append(nl);
                AttrInfo attrInfo = (AttrInfo)vector.get(i);
                HelpSupport.spaceit(stringBuffer, attrInfo.getName(), 32);
                HelpSupport.spaceit(stringBuffer, attrInfo.getType(), 32);
                Object object = attrInfo.defaultValue();
                if (object == null) continue;
                stringBuffer.append(object.toString());
            }
            string2 = stringBuffer.toString();
        }
        catch (ScriptingException scriptingException) {
            throw scriptingException;
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            String string3 = ExceptionSupport.getMessage(exception, "WASX");
            if (string3 == null) {
                string3 = exception.toString();
            }
            throw new ScriptingException(string3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "defaults");
        }
        return string2;
    }

    public String parents(String string) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parents for type " + string);
        }
        this._shell.setLastException(null);
        this.checkService();
        String string2 = null;
        try {
            HashSet<String> hashSet = new HashSet<String>();
            string = this.configHelper.cleanString(string);
            String[] stringArray = this.metaCache.getParentTypes(string);
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    hashSet.add(stringArray[i]);
                }
            } else if (!string.equals("Cell")) {
                string2 = this._shell.getFormattedMessage("WASX7351I", new Object[]{string}, "parents command not available for " + string);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "parents");
                }
                return string2;
            }
            string2 = this._langutils.setToString(hashSet);
        }
        catch (ScriptingException scriptingException) {
            throw scriptingException;
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            String string3 = ExceptionSupport.getMessage(exception, "WASX");
            if (string3 == null) {
                string3 = exception.toString();
            }
            throw new ScriptingException(string3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parents");
        }
        return string2;
    }

    public String contents(String string) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "contains for type " + string);
        }
        this._shell.setLastException(null);
        this.checkService();
        String string2 = null;
        try {
            Properties properties = null;
            string = this.configHelper.cleanString(string);
            properties = this.metaCache.getContentTypes(string);
            string2 = this._langutils.propertiesToString(properties);
        }
        catch (ScriptingException scriptingException) {
            throw scriptingException;
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            String string3 = ExceptionSupport.getMessage(exception, "WASX");
            if (string3 == null) {
                string3 = exception.toString();
            }
            throw new ScriptingException(string3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "contains");
        }
        return string2;
    }

    public String show(String string) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "show for path " + string);
        }
        this._shell.setLastException(null);
        string = this.configHelper.cleanString(string);
        String string2 = null;
        string2 = this.show(string, (String)null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "show for path " + string);
        }
        return string2;
    }

    public String showAttribute(String string, String string2) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "showAttribute", new Object[]{string, string2});
        }
        this._shell.setLastException(null);
        this.checkService();
        if (this.isValidValue(string)) {
            this._shell.setAndThrowScriptingException("WASX7444E", "Invalid parameter value {0} for parameter {1} on command {2}", new Object[]{string, "config id", "showAttribute"});
        }
        String string3 = null;
        String string4 = null;
        try {
            string = this.configHelper.cleanString(string);
            ObjectName objectName = this.configHelper.stringToObjectName(string);
            String[] stringArray = this._langutils.stringToStringArray(string2);
            if (stringArray == null || stringArray.length != 1) {
                this._shell.setAndThrowScriptingException("WASX7328E", "A single attribute name must be specified for showAttribute; received: " + string2, new Object[]{string2});
            }
            if ((string4 = this.nameCache.getType(string)) == null) {
                return null;
            }
            this.metaCache.attrNameValidityCheck(string4, stringArray);
            AttributeList attributeList = configServiceProxy.getAttributes(this.getCurrentSession(), objectName, stringArray, false);
            Attribute attribute = this.configHelper.getAttribute(attributeList, stringArray[0]);
            string3 = this.attributeToString(attribute, false, true);
        }
        catch (ScriptingException scriptingException) {
            throw scriptingException;
        }
        catch (InvalidAttributeNameException invalidAttributeNameException) {
            String[] stringArray = invalidAttributeNameException.getAttributePath();
            this._shell.setAndThrowScriptingException("WASX7080E", "Invalid attributes specified.", new Object[]{string4, stringArray.length > 0 ? stringArray[0] : string2});
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            String string5 = ExceptionSupport.getMessage(exception, "WASX");
            if (string5 == null) {
                string5 = exception.toString();
            }
            throw new ScriptingException(string5);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "show");
        }
        return string3;
    }

    public String show(String string, Object[] objectArray) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "show");
        }
        this._shell.setLastException(null);
        String string2 = this._langutils.objectArrayToString(objectArray);
        String string3 = this.show(string, string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "show");
        }
        return string3;
    }

    public String show(String string, String string2) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "show for path " + string);
        }
        this._shell.setLastException(null);
        this.checkService();
        if (this.isValidValue(string)) {
            this._shell.setAndThrowScriptingException("WASX7444E", "Invalid parameter value {0} for parameter {1} on command {2}", new Object[]{string, "config id", "show"});
        }
        String string3 = null;
        String string4 = null;
        try {
            string = this.configHelper.cleanString(string);
            ObjectName objectName = this.configHelper.stringToObjectName(string);
            String[] stringArray = this._langutils.stringToStringArray(string2);
            string4 = this.nameCache.getType(string);
            if (string4 == null) {
                return null;
            }
            this.metaCache.attrNameValidityCheck(string4, stringArray);
            AttributeList attributeList = configServiceProxy.getAttributes(this.getCurrentSession(), objectName, stringArray, false);
            AttributeList attributeList2 = this.configHelper.stripSystemAttrs(attributeList);
            string3 = this.attributeListToString(attributeList2, false);
        }
        catch (ScriptingException scriptingException) {
            throw scriptingException;
        }
        catch (InvalidAttributeNameException invalidAttributeNameException) {
            String[] stringArray = invalidAttributeNameException.getAttributePath();
            this._shell.setAndThrowScriptingException("WASX7080E", "Invalid attributes specified.", new Object[]{string4, stringArray.length > 0 ? stringArray[0] : string2});
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            String string5 = ExceptionSupport.getMessage(exception, "WASX");
            if (string5 == null) {
                string5 = exception.toString();
            }
            throw new ScriptingException(string5);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "show");
        }
        return string3;
    }

    public String showall(String string) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "show for path " + string);
        }
        this._shell.setLastException(null);
        string = this.configHelper.cleanString(string);
        String string2 = null;
        string2 = this.showall(string, (String)null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "show for path " + string);
        }
        return string2;
    }

    public String showall(String string, Object[] objectArray) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "showall");
        }
        this._shell.setLastException(null);
        String string2 = this._langutils.objectArrayToString(objectArray);
        String string3 = this.showall(string, string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "showall");
        }
        return string3;
    }

    public String showall(String string, String string2) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "showall for path " + string);
        }
        this._shell.setLastException(null);
        this.checkService();
        if (this.isValidValue(string)) {
            this._shell.setAndThrowScriptingException("WASX7444E", "Invalid parameter value {0} for parameter {1} on command {2}", new Object[]{string, "config id", "showall"});
        }
        String string3 = null;
        String string4 = null;
        try {
            string = this.configHelper.cleanString(string);
            ObjectName objectName = this.configHelper.stringToObjectName(string);
            String[] stringArray = this._langutils.stringToStringArray(string2);
            string4 = this.nameCache.getType(string);
            if (string4 == null) {
                return null;
            }
            this.metaCache.attrNameValidityCheck(string4, stringArray);
            AttributeList attributeList = configServiceProxy.getAttributes(this.getCurrentSession(), objectName, stringArray, true);
            AttributeList attributeList2 = this.configHelper.stripSystemAttrs(attributeList);
            string3 = this.attributeListToString(attributeList2, true);
        }
        catch (ScriptingException scriptingException) {
            throw scriptingException;
        }
        catch (InvalidAttributeNameException invalidAttributeNameException) {
            String[] stringArray = invalidAttributeNameException.getAttributePath();
            this._shell.setAndThrowScriptingException("WASX7080E", "Invalid attributes specified.", new Object[]{string4, stringArray.length > 0 ? stringArray[0] : string2});
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            String string5 = ExceptionSupport.getMessage(exception, "WASX");
            if (string5 == null) {
                string5 = exception.toString();
            }
            throw new ScriptingException(string5);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "showall");
        }
        return string3;
    }

    public String showdump(String string) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "show for path " + string);
        }
        string = this.configHelper.cleanString(string);
        String string2 = null;
        string2 = this.showdump(string, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "show for path " + string);
        }
        return string2;
    }

    public String showdump(String string, String string2) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "show for path " + string);
        }
        this.checkService();
        String string3 = null;
        try {
            string = this.configHelper.cleanString(string);
            ObjectName objectName = this.configHelper.stringToObjectName(string);
            String[] stringArray = this._langutils.stringToStringArray(string2);
            String string4 = this.nameCache.getType(string);
            if (string4 == null) {
                return null;
            }
            this.metaCache.attrNameValidityCheck(string4, stringArray);
            AttributeList attributeList = configServiceProxy.getAttributes(this.getCurrentSession(), objectName, stringArray, true);
            this.dumpAttributeList(attributeList, 0);
            AttributeList attributeList2 = this.configHelper.stripSystemAttrs(attributeList);
            string3 = this.attributeListToString(attributeList2, false);
        }
        catch (AdminException adminException) {
            this._shell.setLastException(adminException);
            throw adminException;
        }
        catch (ConnectorException connectorException) {
            this._shell.setLastException(connectorException);
            throw connectorException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "show");
        }
        return string3;
    }

    public void dumpAttributeList(AttributeList attributeList, int n) {
        for (int i = 0; i < attributeList.size(); ++i) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "---------------------------------------------------------");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Attribute number: " + n + "." + i);
            }
            Attribute attribute = (Attribute)attributeList.get(i);
            this.dumpAttribute(attribute, n);
        }
    }

    public void dumpAttribute(Attribute attribute, int n) {
        if (attribute == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "  attribute is null.");
            }
            return;
        }
        String string = attribute.getName();
        Object object = attribute.getValue();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, " name: " + string);
        }
        if (object == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "  value is null.");
            }
        } else {
            Class<?> clazz = object.getClass();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "  type of value: " + clazz.getName());
            }
            if (clazz == AttributeList.class) {
                this.dumpAttributeList((AttributeList)object, n + 1);
            } else if (clazz == ArrayList.class) {
                ArrayList arrayList = (ArrayList)object;
                for (int i = 0; i < arrayList.size(); ++i) {
                    Object e2;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "        ----------------------------------------------");
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "        Array list element: " + n + "." + i);
                    }
                    if ((e2 = arrayList.get(i)) == null) continue;
                    clazz = e2.getClass();
                    if (clazz == (class$javax$management$AttributeList == null ? AdminConfigClient.class$("javax.management.AttributeList") : class$javax$management$AttributeList)) {
                        this.dumpAttributeList((AttributeList)e2, n + 1);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "  list element value.toString is " + object.toString());
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "  value.toString is " + object.toString());
            }
        }
    }

    public String recshow(String string) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "show for path " + string);
        }
        this.checkService();
        String string2 = null;
        try {
            string = this.configHelper.cleanString(string);
            ObjectName objectName = this.configHelper.stringToObjectName(string);
            String[] stringArray = null;
            String string3 = this.nameCache.getType(string);
            if (string3 == null) {
                return null;
            }
            this.metaCache.attrNameValidityCheck(string3, stringArray);
            AttributeList attributeList = configServiceProxy.getAttributes(this.getCurrentSession(), objectName, stringArray, true);
            AttributeList attributeList2 = this.configHelper.stripSystemAttrs(attributeList);
            string2 = this.attributeListToString(attributeList2, true);
        }
        catch (AdminException adminException) {
            this._shell.setLastException(adminException);
            throw adminException;
        }
        catch (ConnectorException connectorException) {
            this._shell.setLastException(connectorException);
            throw connectorException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "show");
        }
        return string2;
    }

    public String modify(String string, String string2) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "modify for path " + string);
        }
        this._shell.setLastException(null);
        this.checkService();
        if (this.isValidValue(string)) {
            this._shell.setAndThrowScriptingException("WASX7444E", "Invalid parameter value {0} for parameter {1} on command {2}", new Object[]{string, "config id", "modify"});
        }
        String string3 = null;
        try {
            TypeSpecificHelper typeSpecificHelper;
            string = this.configHelper.cleanString(string);
            string3 = this.nameCache.getType(string);
            if (string3 == null) {
                return null;
            }
            ObjectName objectName = this.configHelper.stringToObjectName(string);
            string2 = this._langutils.cleanAttributeString(string2);
            AttributeList attributeList = this._langutils.stringToAttributeList(string2);
            Object var6_11 = null;
            AttributeList attributeList2 = null;
            if (tc.isDebugEnabled()) {
                this.dumpAttributeList(attributeList, 0);
            }
            attributeList2 = this.correctTypesInAttributeList(string3, attributeList);
            if (tc.isDebugEnabled()) {
                this.dumpAttributeList(attributeList2, 0);
            }
            if ((typeSpecificHelper = (TypeSpecificHelper)this.typeSpecificHelperTable.get(string3)) != null) {
                attributeList2 = typeSpecificHelper.attributeListUpdate(attributeList2, objectName, false);
            }
            if (tc.isDebugEnabled()) {
                this.dumpAttributeList(attributeList2, 0);
            }
            AttributeList attributeList3 = configServiceProxy.getAttributes(this.getCurrentSession(), objectName, null, true);
            if (tc.isDebugEnabled()) {
                this.dumpAttributeList(attributeList3, 0);
            }
            AttributeList attributeList4 = this.configHelper.merge(attributeList3, attributeList2);
            if (tc.isDebugEnabled()) {
                this.dumpAttributeList(attributeList4, 0);
            }
            configServiceProxy.setAttributes(this.getCurrentSession(), objectName, attributeList4);
        }
        catch (ScriptingException scriptingException) {
            throw scriptingException;
        }
        catch (InvalidAttributeNameException invalidAttributeNameException) {
            String[] stringArray = invalidAttributeNameException.getAttributePath();
            this._shell.setAndThrowScriptingException("WASX7080E", "Invalid attributes specified.", new Object[]{string3, stringArray.length > 0 ? stringArray[0] : string2});
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            String string4 = ExceptionSupport.getMessage(exception, "WASX");
            if (string4 == null) {
                string4 = exception.toString();
            }
            throw new ScriptingException(string4);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "modify");
        }
        return new String();
    }

    public String modify(String string, Object[] objectArray) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "modify");
        }
        String string2 = this._langutils.objectArrayToString(objectArray);
        String string3 = this.modify(string, string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "modify");
        }
        return string3;
    }

    public String createUsingTemplate(String string, String string2, Object[] objectArray, String string3) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createUsingTemplate");
        }
        this._shell.setLastException(null);
        String string4 = this._langutils.objectArrayToString(objectArray);
        String string5 = this.createUsingTemplate(string, string2, string4, string3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createUsingTemplate");
        }
        return string5;
    }

    public String createUsingTemplate(String string, String string2, String string3, String string4) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createUsingTemplate", new Object[]{string, string2, string4});
        }
        this._shell.setLastException(null);
        String string5 = null;
        string4 = this.configHelper.cleanString(string4);
        string5 = this.create(string, string2, string3, null, string4);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createUsingTemplate", new Object[]{string5});
        }
        return string5;
    }

    public String create(String string, String string2, String string3) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create", new Object[]{string, string2, string3});
        }
        this._shell.setLastException(null);
        String string4 = this.create(string, string2, string3, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create");
        }
        return string4;
    }

    public String create(String string, String string2, Object[] objectArray) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create");
        }
        this._shell.setLastException(null);
        String string3 = this._langutils.objectArrayToString(objectArray);
        String string4 = this.create(string, string2, string3, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create");
        }
        return string4;
    }

    public String create(String string, String string2, String string3, String string4) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create", new Object[]{string, string2, string4});
        }
        this._shell.setLastException(null);
        String string5 = null;
        try {
            string = this.configHelper.cleanString(string);
            string2 = this.configHelper.cleanString(string2);
            string5 = this.create(string, string2, string3, string4, null);
        }
        catch (ScriptingException scriptingException) {
            throw scriptingException;
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            String string6 = ExceptionSupport.getMessage(exception, "WASX");
            if (string6 == null) {
                string6 = exception.toString();
            }
            throw new ScriptingException(string6);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create");
        }
        return string5;
    }

    public String create(String string, String string2, Object[] objectArray, String string3) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create");
        }
        this._shell.setLastException(null);
        String string4 = this._langutils.objectArrayToString(objectArray);
        String string5 = this.create(string, string2, string4, string3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create");
        }
        return string5;
    }

    public String create(String string, String string2, String string3, String string4, String string5) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create for type " + string + " in " + string2 + "; nameInParent is " + string4);
        }
        this._shell.setLastException(null);
        this.checkService();
        if (this.isValidValue(string2)) {
            this._shell.setAndThrowScriptingException("WASX7444E", "Invalid parameter value {0} for parameter {1} on command {2}", new Object[]{string2, "parent config id", "create"});
        }
        String string6 = null;
        String string7 = null;
        try {
            string = this.configHelper.cleanString(string);
            string2 = this.configHelper.cleanString(string2);
            string7 = this.nameCache.getType(string2);
            if (string7 == null) {
                this._shell.setAndThrowScriptingException("WASX7083E", "Cannot find config object", new Object[]{string2});
            }
            if (string4 == null) {
                string4 = this.metaCache.findContentNameForType(string7, string);
            }
            string4 = this.configHelper.cleanString(string4);
            string3 = this._langutils.cleanAttributeString(string3);
            AttributeList attributeList = this._langutils.stringToAttributeList(string3);
            AttributeList attributeList2 = null;
            attributeList2 = this.correctTypesInAttributeList(string, attributeList);
            ObjectName objectName = this.configHelper.stringToObjectName(string2);
            this.configHelper.OKToCreate(string, objectName, processType, connectedServer);
            TypeSpecificHelper typeSpecificHelper = (TypeSpecificHelper)this.typeSpecificHelperTable.get(string);
            if (typeSpecificHelper != null) {
                attributeList2 = typeSpecificHelper.attributeListUpdate(attributeList2, objectName, true);
            }
            if (tc.isDebugEnabled()) {
                this.dumpAttributeList(attributeList2, 0);
            }
            ObjectName objectName2 = this.configHelper.stringToObjectName(string5);
            ObjectName objectName3 = configServiceProxy.createConfigDataByTemplate(this.getCurrentSession(), objectName, string4, attributeList2, objectName2);
            string6 = this.configHelper.getListingName(objectName3);
            this.nameCache.add(string6, string);
        }
        catch (ScriptingException scriptingException) {
            throw scriptingException;
        }
        catch (InvalidAttributeNameException invalidAttributeNameException) {
            try {
                this.metaCache.getCorrectError(string7, string, string4);
            }
            catch (Exception exception) {
                this._shell.setLastException(exception);
                String string8 = ExceptionSupport.getMessage(exception, "WASX");
                if (string8 == null) {
                    string8 = exception.toString();
                }
                throw new ScriptingException(string8);
            }
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            String string9 = ExceptionSupport.getMessage(exception, "WASX");
            if (string9 == null) {
                string9 = exception.toString();
            }
            throw new ScriptingException(string9);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create");
        }
        return string6;
    }

    public String remove(String string) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "remove " + string);
        }
        this._shell.setLastException(null);
        String string2 = new String();
        this.checkService();
        if (this.isValidValue(string)) {
            this._shell.setAndThrowScriptingException("WASX7444E", "Invalid parameter value {0} for parameter {1} on command {2}", new Object[]{string, "config id", "remove"});
        }
        try {
            String string3;
            string = this.configHelper.cleanString(string);
            ObjectName objectName = this.configHelper.stringToObjectName(string);
            configServiceProxy.deleteConfigData(this.getCurrentSession(), objectName);
            int n = string.lastIndexOf("#");
            int n2 = string.lastIndexOf("_");
            if (n != -1 && n2 != -1 && n2 > n && (string3 = string.substring(n + 1, n2)).equals(NODETYPE)) {
                if ("UnManagedProcess".equals(processType)) {
                    Tr.audit(tc, "WASX7407I", new Object[0]);
                    string2 = this._shell.getFormattedMessage("WASX7407I", new Object[0], "Node removal in base environment is not a recommended operation.");
                } else if ("DeploymentManager".equals(processType)) {
                    Tr.audit(tc, "WASX7408I", new Object[0]);
                    string2 = this._shell.getFormattedMessage("WASX7408I", new Object[0], "Node removal in NetworkDeployment environment is not a recommended operation.");
                }
            }
        }
        catch (ScriptingException scriptingException) {
            throw scriptingException;
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            String string4 = ExceptionSupport.getMessage(exception, "WASX");
            if (string4 == null) {
                string4 = exception.toString();
            }
            throw new ScriptingException(string4);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "remove");
        }
        return string2;
    }

    public String relate(String string, String string2, String string3) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "relate " + string + " to " + string2 + " via " + string3);
        }
        this.checkService();
        try {
            string = this.configHelper.cleanString(string);
            string2 = this.configHelper.cleanString(string2);
            string3 = this.configHelper.cleanString(string3);
            ObjectName objectName = this.configHelper.stringToObjectName(string);
            ObjectName objectName2 = this.configHelper.stringToObjectName(string2);
            AttributeList attributeList = new AttributeList();
            Attribute attribute = new Attribute(string3, string2);
            attributeList.add(attribute);
            configServiceProxy.setAttributes(this.getCurrentSession(), objectName, attributeList);
        }
        catch (ScriptingException scriptingException) {
            throw scriptingException;
        }
        catch (AdminException adminException) {
            this._shell.setLastException(adminException);
            throw adminException;
        }
        catch (ConnectorException connectorException) {
            this._shell.setLastException(connectorException);
            throw connectorException;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "relate");
        }
        return new String();
    }

    public String dumpDebugInfo() {
        try {
            System.out.println("----------------------------------------------");
            System.out.println("TypeToAttributeCache");
            System.out.println("");
            this.metaCache.dumpTypeToAttributeCache();
            System.out.println("");
            System.out.println("----------------------------------------------");
            System.out.println("FlatAttributeCache");
            System.out.println("");
            this.metaCache.dumpFlatAttrCache();
            System.out.println("");
            System.out.println("----------------------------------------------");
            System.out.println("NameCache");
            System.out.println("");
            this.nameCache.dumpNameCache();
            System.out.println("");
            System.out.println("----------------------------------------------");
            System.out.println("ContainmentCache");
            System.out.println("");
            this.metaCache.dumpContainmentCache();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return new String();
    }

    public void checkService() throws ScriptingException {
        if (configServiceProxy == null) {
            this._shell.setAndThrowScriptingException("CONFIG_NOT_AVAILABLE", "Config service not available", new Object[0]);
        }
    }

    public String getid(String string) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getid - " + string);
        }
        this._shell.setLastException(null);
        String string2 = null;
        this.checkService();
        try {
            string = this.configHelper.cleanString(string);
            String string3 = this.configHelper.nameToResolveString(string);
            ObjectName[] objectNameArray = configServiceProxy.resolve(this.getCurrentSession(), string3);
            HashSet<ObjectName[]> hashSet = new HashSet<ObjectName[]>();
            if (objectNameArray == null && tc.isDebugEnabled()) {
                Tr.debug(tc, "oList is null!");
            }
            for (int i = 0; i < objectNameArray.length; ++i) {
                ObjectName[] objectNameArray2;
                ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectNameArray[i]);
                if (!configDataId.isResolved()) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Id is not resolved; need to make another call.");
                    }
                    if ((objectNameArray2 = configServiceProxy.queryConfigObjects(this.getCurrentSession(), null, objectNameArray[i], null)) != null && objectNameArray2.length == 1) {
                        objectNameArray[i] = objectNameArray2[0];
                    }
                }
                objectNameArray2 = this.configHelper.getListingName(objectNameArray[i]);
                String string4 = objectNameArray[i].getKeyProperty("_Websphere_Config_Data_Type");
                this.nameCache.add((String)objectNameArray2, string4);
                hashSet.add(objectNameArray2);
            }
            string2 = this._langutils.setToString(hashSet);
        }
        catch (ScriptingException scriptingException) {
            throw scriptingException;
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            String string5 = ExceptionSupport.getMessage(exception, "WASX");
            if (string5 == null) {
                string5 = exception.toString();
            }
            throw new ScriptingException(string5);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getid");
        }
        return string2;
    }

    private String getStringValue(AttrHelper attrHelper, Attribute attribute) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStringValue - " + attribute.getName());
        }
        String string = null;
        Locale locale = new Locale("en", "US");
        string = attribute.getName().toLowerCase(locale).indexOf("password") >= 0 || attribute.getName().equals(AdminControlClient.PRIVATE_KEY) || attribute.getName().equals(AdminControlClient.PUBLIC_KEY) || attribute.getName().equals(AdminControlClient.SHARED_KEY) ? (attribute.getValue() == null ? attrHelper.getStringValue(attribute.getValue()) : "*****") : attrHelper.getStringValue(attribute.getValue());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStringValue - " + string);
        }
        return string;
    }

    public String attributeListToString(AttributeList attributeList, boolean bl) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "attributeListToString");
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < attributeList.size(); ++i) {
            String string = this.attributeToString((Attribute)attributeList.get(i), bl, false);
            if (string == null) continue;
            hashSet.add(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "attributeListToString");
        }
        String string = this._langutils.setToString(hashSet);
        return string;
    }

    public String attributeToString(Attribute attribute, boolean bl, boolean bl2) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "attributeToString", new Object[]{attribute.getName()});
        }
        String string = null;
        Object object = attribute.getValue();
        AttrHelper attrHelper = null;
        String string2 = null;
        if (object != null) {
            Object object2;
            int n;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Type of value is " + object.getClass().getName());
            }
            if ((n = (string2 = object.getClass().getName()).lastIndexOf(".")) >= 0) {
                string2 = string2.substring(n + 1);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "type is " + string2);
            }
            String string3 = string2;
            if (object instanceof List && object != null && ((List)object).size() > 0 && (object2 = ((List)object).get(0)) instanceof String) {
                string3 = "String*";
            }
            if (bl && object instanceof List && !string3.equals("String*")) {
                Serializable serializable;
                object2 = new StringBuffer();
                ((StringBuffer)object2).append(this._langutils.getOpenNestedAttribute());
                attrHelper = (AttrHelper)this.helperTable.get("String");
                if (string2.equals("AttributeList")) {
                    serializable = this.configHelper.stripSystemAttrs((AttributeList)object);
                    String string4 = this.attributeListToString((AttributeList)serializable, bl);
                    ((StringBuffer)object2).append(string4);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "nested attr: " + string4);
                    }
                } else if (string2.equals("ArrayList")) {
                    serializable = (ArrayList)object;
                    for (int i = 0; i < ((ArrayList)serializable).size(); ++i) {
                        Object object3;
                        Object e2 = ((ArrayList)serializable).get(i);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "type of list member is " + e2.getClass().getName());
                        }
                        if (e2 instanceof AttributeList) {
                            object3 = this.configHelper.stripSystemAttrs((AttributeList)e2);
                            String string5 = this.attributeListToString((AttributeList)object3, bl);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "nested attr in collection: " + string5);
                            }
                            ((StringBuffer)object2).append(this._langutils.getOpenNestedAttribute());
                            ((StringBuffer)object2).append(string5);
                            ((StringBuffer)object2).append(this._langutils.getCloseNestedAttribute());
                        } else if (e2 instanceof ObjectName) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "ObjectName");
                            }
                            object3 = this.configHelper.getListingName((ObjectName)e2);
                            ((StringBuffer)object2).append((String)object3);
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "other; " + e2.getClass().getName());
                            }
                            object3 = e2.toString();
                            ((StringBuffer)object2).append((String)object3);
                        }
                        if (i >= ((ArrayList)serializable).size() - 1) continue;
                        ((StringBuffer)object2).append(" ");
                    }
                }
                ((StringBuffer)object2).append(this._langutils.getCloseNestedAttribute());
                serializable = new Attribute(attribute.getName(), ((StringBuffer)object2).toString());
                string = bl2 ? this.getStringValue(attrHelper, (Attribute)serializable) : attrHelper.formDisplayString((Attribute)serializable);
            } else {
                attrHelper = (AttrHelper)this.helperTable.get(string3);
                if (attrHelper == null) {
                    attrHelper = (AttrHelper)this.helperTable.get("String");
                }
                string = bl2 ? this.getStringValue(attrHelper, attribute) : attrHelper.formDisplayString(attribute);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "attributeToString", new Object[]{string});
        }
        return string;
    }

    public AttributeList correctTypesInAttributeList(String string, AttributeList attributeList) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "correctTypesInAttributeList - " + string);
        }
        Vector vector = this.metaCache.getFlatAttributeMap(string);
        StringBuffer stringBuffer = new StringBuffer();
        AttributeList attributeList2 = new AttributeList();
        boolean bl = false;
        for (int i = 0; i < attributeList.size(); ++i) {
            String string2 = ((Attribute)attributeList.get(i)).getName();
            Object object = ((Attribute)attributeList.get(i)).getValue();
            String string3 = null;
            int n = string2.indexOf(":");
            if (n >= 0) {
                string3 = string2.substring(n + 1);
                string2 = string2.substring(0, n);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "looking at name: " + string2 + "; val: " + object.toString());
            }
            boolean bl2 = false;
            for (int j = 0; j < vector.size(); ++j) {
                Object object2;
                int n2;
                Object object3;
                AttrInfo attrInfo = (AttrInfo)vector.get(j);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "matching with name " + attrInfo.getName());
                }
                if (!string2.equals(attrInfo.getName())) continue;
                String string4 = attrInfo.getType();
                AttrHelper attrHelper = null;
                int n3 = string4.lastIndexOf(".");
                if (n3 >= 0) {
                    string4 = string4.substring(n3 + 1);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Type of value is " + string4);
                }
                if (attrInfo.isCollection() && attrInfo.isReference()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "type is collection of references");
                    }
                    attrHelper = (AttrHelper)this.helperTable.get("ObjectName*");
                } else if (attrInfo.isCollection()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "type is collection");
                    }
                    attrHelper = (AttrHelper)this.helperTable.get(string4 + "*");
                } else if (attrInfo.isReference()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "type is reference");
                    }
                    attrHelper = (AttrHelper)this.helperTable.get("ObjectName");
                } else {
                    attrHelper = (AttrHelper)this.helperTable.get(string4);
                }
                Attribute attribute = null;
                if (attrHelper != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Type of helper is " + attrHelper.getClass().getName());
                    }
                    attribute = attrHelper.formValidAttribute(attrInfo, (Attribute)attributeList.get(i));
                } else {
                    if (string3 != null) {
                        string4 = string3;
                    }
                    if (attrInfo.isCollection()) {
                        if (object instanceof ArrayList) {
                            object3 = (ArrayList)object;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "This attribute (" + string2 + ") is a collection");
                            }
                            for (n2 = 0; n2 < ((ArrayList)object3).size(); ++n2) {
                                object2 = null;
                                try {
                                    object2 = (AttributeList)((ArrayList)object3).get(n2);
                                }
                                catch (ClassCastException classCastException) {
                                    this._shell.setAndThrowScriptingException("WASX7353E", "The attribute \"" + string2 + "\" must be a collection of objects of type \"" + string4 + "\"; an additional set of curly braces may be required to signify that this is a collection.", new Object[]{string2, string4});
                                }
                                AttributeList attributeList3 = this.correctTypesInAttributeList(string4, (AttributeList)object2);
                                ((ArrayList)object3).set(n2, attributeList3);
                            }
                            attribute = new Attribute(string2, object3);
                        } else if (object instanceof String && ((String)object).length() == 0) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "type is collection, val is zero-length string");
                            }
                            attribute = new Attribute(string2, new ArrayList());
                        } else {
                            this._shell.setAndThrowScriptingException("WASX7353E", "The attribute \"" + string2 + "\" must be a collection of objects of type \"" + string4 + "\"; an additional set of curly braces may be required to signify that this is a collection.", new Object[]{string2, string4});
                        }
                    } else if (attrInfo.isObject()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "type of aVal: " + object.getClass().getName());
                        }
                        if (object instanceof AttributeList) {
                            object3 = this.correctTypesInAttributeList(string4, (AttributeList)object);
                            attribute = new Attribute(string2, object3);
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "using aVal.toString() " + object.toString());
                            }
                            if (((String)(object3 = object.toString())).length() == 0) {
                                object3 = null;
                                attribute = new Attribute(string2, object3);
                            } else {
                                this._shell.setAndThrowScriptingException("WASX7354E", "The attribute \"" + string2 + "\" is an embedded object of type " + string4 + "\"; an invalid value was supplied.", new Object[]{string2, string4});
                            }
                        }
                    } else {
                        this._shell.setAndThrowScriptingException("WASX7239E", "Trying to set bad attr " + string2, new Object[]{string2, string4, object.toString()});
                    }
                }
                if (string3 != null) {
                    object3 = null;
                    for (n2 = 0; n2 < attributeList2.size(); ++n2) {
                        object2 = (Attribute)attributeList2.get(n2);
                        if (!((Attribute)object2).getName().equals(string2)) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Removing attr in pos " + n2 + " of retlist");
                        }
                        object3 = (Attribute)attributeList2.remove(n2);
                        break;
                    }
                    if (object3 != null) {
                        List list = (List)((Attribute)object3).getValue();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Members of existing list: " + list.size());
                        }
                        object2 = (List)attribute.getValue();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Members of new list: " + object2.size());
                        }
                        list.addAll(object2);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Members of merged list: " + list.size());
                        }
                        attribute = new Attribute(string2, list);
                    }
                }
                attributeList2.add(attribute);
                bl2 = true;
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "found true");
                break;
            }
            if (bl2) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(string2);
            bl = true;
        }
        if (bl) {
            this._shell.setAndThrowScriptingException("WASX7080E", "Invalid attributes specified.", new Object[]{string, stringBuffer.toString()});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding type to AttributeList: " + string);
        }
        attributeList2.add(new Attribute("_Websphere_Config_Data_Type", string));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "correctTypesInAttributeList");
        }
        return attributeList2;
    }

    public String save() throws ScriptingException {
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "save");
            }
            this._shell.setLastException(null);
            this.checkService();
            try {
                boolean bl = this.hasChanges();
                configServiceProxy.save(this.getCurrentSession(), this.overwriteOnSave);
                if (!AdminHelper.getPlatformHelper().isZOS() || !this._shell.getConnectionType().equals("NONE") || !bl) break block6;
                String string = System.getProperty("local.node");
                String string2 = System.getProperty("local.cell");
                if (string != null && string2 != null) {
                    PlatformUtils platformUtils = (PlatformUtils)ImplFactory.loadImplFromKey("com.ibm.ws.management.util.PlatformUtils");
                    platformUtils.transform(string2, string);
                    break block6;
                }
                throw new ConfigServiceException("Transformer needs system properties, local.cell and local.node");
            }
            catch (Exception exception) {
                this._shell.setLastException(exception);
                String string = ExceptionSupport.getMessage(exception, "WASX");
                if (string == null) {
                    string = exception.toString();
                }
                throw new ScriptingException(string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "save");
        }
        return new String();
    }

    public String reset() throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reset");
        }
        this._shell.setLastException(null);
        this.checkService();
        try {
            if (configServiceProxy != null) {
                configServiceProxy.discard(this.getCurrentSession());
            }
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            String string = ExceptionSupport.getMessage(exception, "WASX");
            if (string == null) {
                string = exception.toString();
            }
            throw new ScriptingException(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reset");
        }
        return new String();
    }

    public boolean hasChanges() throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "hasChanges");
        }
        String[] stringArray = null;
        this.checkService();
        try {
            stringArray = configServiceProxy.getUnsavedChanges(this.getCurrentSession());
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            String string = ExceptionSupport.getMessage(exception, "WASX");
            if (string == null) {
                string = exception.toString();
            }
            throw new ScriptingException(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "hasChanges", new Object[]{stringArray});
        }
        if (stringArray == null) {
            return false;
        }
        return stringArray.length > 0;
    }

    public String queryChanges() throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "queryChanges");
        }
        this._shell.setLastException(null);
        String[] stringArray = null;
        String string = null;
        this.checkService();
        try {
            stringArray = configServiceProxy.getUnsavedChanges(this.getCurrentSession());
            StringBuffer stringBuffer = new StringBuffer();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append(stringArray[i]);
                    stringBuffer.append(nl);
                }
            }
            string = stringBuffer.length() == 0 ? this._shell.getFormattedMessage("WASX7241I", new Object[0], "There are no unsaved changes in this workspace") : this._shell.getFormattedMessage("WASX7146I", new Object[]{stringBuffer.toString()}, "Unsaved changes in:\n" + stringBuffer.toString());
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "queryChanges");
            }
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            String string2 = ExceptionSupport.getMessage(exception, "WASX");
            if (string2 == null) {
                string2 = exception.toString();
            }
            throw new ScriptingException(string2);
        }
        return string;
    }

    public String setSaveMode(String string) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSaveMode");
        }
        this._shell.setLastException(null);
        if (string.toLowerCase().equals("overwriteonconflict")) {
            this.overwriteOnSave = true;
        } else if (string.toLowerCase().equals("rollbackonconflict")) {
            this.overwriteOnSave = false;
        } else {
            this._shell.setAndThrowScriptingException("WASX7119E", "Invalid option specified.", new Object[]{string});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSaveMode");
        }
        return new String();
    }

    public String getSaveMode() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSaveMode");
        }
        String string = this.setSaveMode();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSaveMode");
        }
        return string;
    }

    public String setSaveMode() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSaveMode");
        }
        String string = "rollbackOnConflict";
        if (this.overwriteOnSave) {
            string = "overwriteOnConflict";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSaveMode");
        }
        return string;
    }

    public String getValidationLevel() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setValidationLevel");
        }
        String string = this.setValidationLevel();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setValidationLevel");
        }
        return string;
    }

    public String setValidationLevel() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setValidationLevel");
        }
        String string = (String)this.levelMapper.get(this.validationLevel);
        String string2 = this._shell.getFormattedMessage("WASX7189I", new Object[]{string}, "Validation level set to ");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setValidationLevel");
        }
        return string2;
    }

    public String setValidationLevel(String string) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setValidationLevel", new Object[]{string});
        }
        this._shell.setLastException(null);
        String string2 = string.toUpperCase();
        if (string2.equals("NONE") || string2.equals("0")) {
            this.validationLevel = SessionPropertyConstants.NO_VALIDATION;
        } else if (string2.equals("LOW") || string2.equals("1")) {
            this.validationLevel = SessionPropertyConstants.LOW_LEVEL_VALIDATION;
        } else if (string2.equals("MEDIUM") || string2.equals("2")) {
            this.validationLevel = SessionPropertyConstants.MEDIUM_LEVEL_VALIDATION;
        } else if (string2.equals("HIGH") || string2.equals("3")) {
            this.validationLevel = SessionPropertyConstants.HIGH_LEVEL_VALIDATION;
        } else if (string2.equals("HIGHEST") || string2.equals("4")) {
            this.validationLevel = SessionPropertyConstants.HIGHEST_LEVEL_VALIDATION;
        } else {
            this._shell.setAndThrowScriptingException("WASX7187E", "Invalid value specified.", new Object[]{string, "none, low, medium, high, highest"});
        }
        this.validationLevelChanged = true;
        String string3 = (String)this.levelMapper.get(this.validationLevel);
        String string4 = this._shell.getFormattedMessage("WASX7189I", new Object[]{string3}, "Validation level set to ");
        Tr.audit(tc, "WASX7208I", new Object[]{(String)this.levelMapper.get(this.validationLevel), this.crossValidationEnabled, this.validationOutputFileName});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setValidationLevel");
        }
        return string4;
    }

    public String getCrossDocumentValidationEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCrossDocumentValidationEnabled");
        }
        String string = this.setCrossDocumentValidationEnabled();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCrossDocumentValidationEnabled");
        }
        return string;
    }

    public String setCrossDocumentValidationEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCrossDocumentValidationEnabled");
        }
        String string = this._shell.getFormattedMessage("WASX7188I", new Object[]{this.crossValidationEnabled}, "Cross-document validation enablement set to ");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCrossDocumentValidationEnabled");
        }
        return string;
    }

    public String setCrossDocumentValidationEnabled(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCrossDocumentValidationEnabled", new Object[]{string});
        }
        this.crossValidationEnabled = new Boolean(string);
        this.crossValidationEnabledChanged = true;
        String string2 = this._shell.getFormattedMessage("WASX7188I", new Object[]{this.crossValidationEnabled}, "Cross-document validation enablement set to ");
        Tr.audit(tc, "WASX7208I", new Object[]{(String)this.levelMapper.get(this.validationLevel), this.crossValidationEnabled, this.validationOutputFileName});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCrossDocumentValidationEnabled");
        }
        return string2;
    }

    public String getValidationSeverityResult(int n) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setValidationResult");
        }
        String string = n > 9 ? this.getValidationSeverityResult() : Integer.toString(this.validationCounters[n]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setValidationResult");
        }
        return string;
    }

    public String validate() throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        this._shell.setLastException(null);
        String string = null;
        try {
            string = this.validate(null, "validate");
        }
        catch (ScriptingException scriptingException) {
            throw scriptingException;
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            String string2 = ExceptionSupport.getMessage(exception, "WASX");
            if (string2 == null) {
                string2 = exception.toString();
            }
            throw new ScriptingException(string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
        return string;
    }

    public String validate(String string) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate", new Object[]{string});
        }
        this._shell.setLastException(null);
        ObjectName objectName = null;
        Hashtable hashtable = null;
        String string2 = null;
        try {
            if (string != null) {
                hashtable = this.configHelper.parseObjectIdString(string);
                String string3 = this.nameCache.getType(string);
                hashtable.put("_Websphere_Config_Data_Type", string3);
                try {
                    if (hashtable != null) {
                        objectName = new ObjectName("WebSphere", hashtable);
                    }
                }
                catch (MalformedObjectNameException malformedObjectNameException) {
                    Tr.event(tc, "Caught exception creating object name for " + string3 + "; exception: " + malformedObjectNameException);
                }
            }
            string2 = this.validate(objectName, "validate");
        }
        catch (ScriptingException scriptingException) {
            throw scriptingException;
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            String string4 = ExceptionSupport.getMessage(exception, "WASX");
            if (string4 == null) {
                string4 = exception.toString();
            }
            throw new ScriptingException(string4);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
        return string2;
    }

    protected String validate(ObjectName objectName, String string) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate", new Object[]{objectName, string});
        }
        this._shell.setLastException(null);
        String string2 = null;
        this.checkService();
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            if (this.validationLevelChanged) {
                hashMap.put("VALIDATION_LEVEL", this.validationLevel);
            }
            if (this.crossValidationEnabledChanged) {
                hashMap.put("ENABLE_CROSS_VALIDATION", this.crossValidationEnabled);
            }
            hashMap.put("LOCALE", Locale.getDefault());
            configServiceProxy.setProperties(this.getCurrentSession(), hashMap);
            ValidationResult validationResult = configServiceProxy.validate(this.getCurrentSession(), objectName);
            string2 = this.writeValidationResults(validationResult, string);
        }
        catch (ScriptingException scriptingException) {
            throw scriptingException;
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            String string3 = ExceptionSupport.getMessage(exception, "WASX");
            if (string3 == null) {
                string3 = exception.toString();
            }
            throw new ScriptingException(string3);
        }
        this.crossValidationEnabledChanged = false;
        this.validationLevelChanged = false;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
        return string2;
    }

    protected String writeValidationResults(ValidationResult validationResult, String string) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeValidationResults", new Object[]{string});
        }
        this._shell.setLastException(null);
        StringBuffer stringBuffer = new StringBuffer();
        Set set = validationResult.getDocuments();
        Tr.debug(tc, "There are " + set.size() + " documents in the ValidationResult.");
        Iterator iterator = set.iterator();
        int n = 0;
        for (int i = 0; i < this.validationCounters.length; ++i) {
            this.validationCounters[i] = 0;
        }
        String string2 = null;
        string2 = this.crossValidationEnabled != false ? this._shell.getFormattedMessage("WASX7191I", null, "enabled") : this._shell.getFormattedMessage("WASX7192I", null, "disabled");
        String string3 = this._shell.getFormattedMessage("WASX7190I", new Object[]{(String)this.levelMapper.get(this.validationLevel), string2, DateFormat.getDateTimeInstance(2, 2).format(new Date()), string}, "Validation messsages:");
        this.validationWriter.println(string3);
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            Tr.debug(tc, "Document: " + string4);
            Set set2 = validationResult.getValidators(string4);
            Tr.debug(tc, "There are " + set2.size() + " validators for document " + string4);
            Iterator iterator2 = set2.iterator();
            while (iterator2.hasNext()) {
                String string5 = (String)iterator2.next();
                List list = validationResult.getValidationMessages(string4, string5);
                Tr.debug(tc, "There are " + list.size() + " messages for validator " + string5);
                Iterator iterator3 = list.iterator();
                while (iterator3.hasNext()) {
                    ValidationResult.ValidationMessage validationMessage = (ValidationResult.ValidationMessage)iterator3.next();
                    ++n;
                    int n2 = this.printValidationMessage(validationMessage);
                    if (n2 >= 10) continue;
                    int n3 = n2;
                    this.validationCounters[n3] = this.validationCounters[n3] + 1;
                }
            }
        }
        stringBuffer.append(this._shell.getFormattedMessage("WASX7193I", new Object[]{this.validationOutputFileName, new Integer(n)}, "Validation results are logged."));
        for (int i = 0; i < 10; ++i) {
            if (this.validationCounters[i] <= 0) continue;
            stringBuffer.append(nl);
            stringBuffer.append(this._shell.getFormattedMessage("WASX7194I", new Object[]{new Integer(i), new Integer(this.validationCounters[i])}, "Validation results are logged."));
        }
        this.validationWriter.println("");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeValidationResults");
        }
        return stringBuffer.toString();
    }

    protected int printValidationMessage(ValidationResult.ValidationMessage validationMessage) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "printValidationMessage");
        }
        int n = validationMessage.getSeverity();
        String string = this._shell.getFormattedMessage("WASX7195I", new Object[]{new Integer(n), new Integer(validationMessage.getLineNo()), validationMessage.getTargetObject(), validationMessage.getMessage()}, "message: ");
        this.validationWriter.println(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "printValidationMessage", new Object[]{new Integer(n)});
        }
        return n;
    }

    public Session getCurrentSession() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCurrentSession");
        }
        if (this._session == null) {
            this.createSession();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCurrentSession");
        }
        return this._session;
    }

    private void createSession() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSession");
        }
        String string = Long.toHexString(System.currentTimeMillis());
        String string2 = ANONYMOUS + string;
        this._session = new Session(string2, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSession");
        }
    }

    public String getObjectName(String string) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectName - " + string);
        }
        this._shell.setLastException(null);
        if (this.isValidValue(string)) {
            this._shell.setAndThrowScriptingException("WASX7444E", "Invalid parameter value {0} for parameter {1} on command {2}", new Object[]{string, "config id", "getObjectName"});
        }
        String string2 = new String();
        try {
            AdminControlClient adminControlClient = AdminControlClient.getInstance();
            if (adminControlClient != null) {
                Hashtable hashtable = this.configHelper.parseObjectIdString(string);
                String string3 = (String)hashtable.get("_Websphere_Config_Data_Id");
                string3 = string3.replace('|', '/');
                String string4 = "mbeanIdentifier=" + string3 + ",*";
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "About to call completeObjectName for " + string4);
                }
                string2 = adminControlClient.completeObjectName(string4);
            }
        }
        catch (ScriptingException scriptingException) {
            throw scriptingException;
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            String string5 = ExceptionSupport.getMessage(exception, "WASX");
            if (string5 == null) {
                string5 = exception.toString();
            }
            throw new ScriptingException(string5);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectName - " + string2);
        }
        return string2;
    }

    public Object extract(String string, String string2) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extract", new Object[]{string, string2});
        }
        String string3 = new String();
        ConfigRepository configRepository = null;
        DocumentDigest documentDigest = null;
        this.checkService();
        try {
            Serializable serializable;
            boolean bl;
            File file = new File(string2);
            if (file.exists() && !file.isFile()) {
                this._shell.setAndThrowScriptingException("WASX7296E", "Specified location is not a file name " + string2, new Object[]{string2});
            }
            if (file.exists() && !file.canWrite()) {
                this._shell.setAndThrowScriptingException("WASX7297E", "Cannot write to " + string2, new Object[]{string2});
            }
            if (bl = this.isLocalMode()) {
                serializable = new Properties();
                ((Properties)serializable).setProperty("location", "local");
                connectionProperties = serializable;
            } else {
                connectionProperties.setProperty("location", "remote");
            }
            configRepository = ConfigRepositoryClientFactory.getConfigRepositoryClient(connectionProperties);
            configRepository.initialize(connectionProperties);
            serializable = configRepository.extract(string);
            InputStream inputStream = ((DocumentContentSource)serializable).getSource();
            this.copyDocument(inputStream, new FileOutputStream(file));
            documentDigest = ((DocumentContentSource)serializable).getDocument().getDigest();
        }
        catch (ScriptingException scriptingException) {
            throw scriptingException;
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            String string4 = ExceptionSupport.getMessage(exception, "WASX");
            if (string4 == null) {
                string4 = exception.toString();
            }
            throw new ScriptingException(string4);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extract");
        }
        return documentDigest;
    }

    public String checkin(String string, String string2, Object object) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkin", new Object[]{string, string2});
        }
        String string3 = new String();
        ConfigRepository configRepository = null;
        this.checkService();
        try {
            Serializable serializable;
            boolean bl;
            File file = new File(string2);
            if (!(file.exists() && file.isFile() && file.canRead())) {
                this._shell.setAndThrowScriptingException("WASX7115E", "Cannot read input file " + string2, new Object[]{string2});
            }
            if (bl = this.isLocalMode()) {
                serializable = new Properties();
                serializable.setProperty("location", "local");
                connectionProperties = serializable;
            } else {
                connectionProperties.setProperty("location", "remote");
            }
            configRepository = ConfigRepositoryClientFactory.getConfigRepositoryClient(connectionProperties);
            configRepository.initialize(connectionProperties);
            serializable = new Document(string, (DocumentDigest)object);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Created document: " + serializable);
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Created stream; available: " + fileInputStream.available());
            }
            DocumentContentSource documentContentSource = new DocumentContentSource((Document)serializable, fileInputStream);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Created source: " + documentContentSource);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "repository is  " + configRepository);
            }
            DocumentDigest documentDigest = configRepository.modify(documentContentSource);
        }
        catch (ScriptingException scriptingException) {
            throw scriptingException;
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            String string4 = ExceptionSupport.getMessage(exception, "WASX");
            if (string4 == null) {
                string4 = exception.toString();
            }
            throw new ScriptingException(string4);
        }
        catch (Throwable throwable) {
            String string5 = ExceptionSupport.getMessage(throwable, "WASX");
            if (string5 == null) {
                string5 = throwable.toString();
            }
            throw new ScriptingException(string5);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkin");
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyDocument(InputStream inputStream, OutputStream outputStream) throws IOException {
        Tr.entry(tc, "copyDocument");
        try {
            byte[] byArray = new byte[4096];
            int n = inputStream.read(byArray);
            while (n != -1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "writing " + n + " bytes to file");
                }
                outputStream.write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
        }
        finally {
            try {
                outputStream.flush();
                outputStream.close();
                inputStream.close();
            }
            catch (Exception exception) {
                Tr.audit(tc, "Error while closing: " + exception);
            }
        }
        Tr.exit(tc, "copyDocument");
    }

    public boolean existsDocument(String string) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "existsDocument", new Object[]{string});
        }
        ConfigRepository configRepository = null;
        boolean bl = false;
        this.checkService();
        try {
            String[] stringArray;
            boolean bl2 = this.isLocalMode();
            if (bl2) {
                stringArray = new Properties();
                stringArray.setProperty("location", "local");
                connectionProperties = stringArray;
            } else {
                connectionProperties.setProperty("location", "remote");
            }
            configRepository = ConfigRepositoryClientFactory.getConfigRepositoryClient(connectionProperties);
            configRepository.initialize(connectionProperties);
            stringArray = new String[]{string};
            DocumentDigest[] documentDigestArray = configRepository.getDigest(stringArray);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "digs return size: " + documentDigestArray.length);
            }
            if (documentDigestArray.length > 0) {
                bl = true;
            }
        }
        catch (DocumentNotFoundException documentNotFoundException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Caught exception; return false");
            }
        }
        catch (ScriptingException scriptingException) {
            throw scriptingException;
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            String string2 = ExceptionSupport.getMessage(exception, "WASX");
            if (string2 == null) {
                string2 = exception.toString();
            }
            throw new ScriptingException(string2);
        }
        catch (Throwable throwable) {
            String string3 = ExceptionSupport.getMessage(throwable, "WASX");
            if (string3 == null) {
                string3 = throwable.toString();
            }
            throw new ScriptingException(string3);
        }
        return bl;
    }

    public Object createDocument(String string, String string2) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDocument", new Object[]{string, string2});
        }
        ConfigRepository configRepository = null;
        DocumentDigest documentDigest = null;
        this.checkService();
        try {
            Serializable serializable;
            boolean bl;
            File file = new File(string2);
            if (!(file.exists() && file.isFile() && file.canRead())) {
                this._shell.setAndThrowScriptingException("WASX7115E", "Cannot read input file " + string2, new Object[]{string2});
            }
            if (bl = this.isLocalMode()) {
                serializable = new Properties();
                serializable.setProperty("location", "local");
                connectionProperties = serializable;
            } else {
                connectionProperties.setProperty("location", "remote");
            }
            configRepository = ConfigRepositoryClientFactory.getConfigRepositoryClient(connectionProperties);
            configRepository.initialize(connectionProperties);
            serializable = new Document(string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Created document: " + serializable);
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Created stream; available: " + fileInputStream.available());
            }
            DocumentContentSource documentContentSource = new DocumentContentSource((Document)serializable, fileInputStream);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Created source: " + documentContentSource);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "repository is  " + configRepository);
            }
            documentDigest = configRepository.create(documentContentSource);
        }
        catch (ScriptingException scriptingException) {
            throw scriptingException;
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            String string3 = ExceptionSupport.getMessage(exception, "WASX");
            if (string3 == null) {
                string3 = exception.toString();
            }
            throw new ScriptingException(string3);
        }
        catch (Throwable throwable) {
            String string4 = ExceptionSupport.getMessage(throwable, "WASX");
            if (string4 == null) {
                string4 = throwable.toString();
            }
            throw new ScriptingException(string4);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDocument");
        }
        return documentDigest;
    }

    public Object deleteDocument(String string) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteDocument", new Object[]{string});
        }
        String string2 = new String();
        ConfigRepository configRepository = null;
        this.checkService();
        try {
            boolean bl = this.isLocalMode();
            if (bl) {
                Properties properties = new Properties();
                properties.setProperty("location", "local");
                connectionProperties = properties;
            } else {
                connectionProperties.setProperty("location", "remote");
            }
            configRepository = ConfigRepositoryClientFactory.getConfigRepositoryClient(connectionProperties);
            configRepository.initialize(connectionProperties);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "repository is  " + configRepository);
            }
            configRepository.delete(string);
        }
        catch (ScriptingException scriptingException) {
            throw scriptingException;
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            String string3 = ExceptionSupport.getMessage(exception, "WASX");
            if (string3 == null) {
                string3 = exception.toString();
            }
            throw new ScriptingException(string3);
        }
        catch (Throwable throwable) {
            String string4 = ExceptionSupport.getMessage(throwable, "WASX");
            if (string4 == null) {
                string4 = throwable.toString();
            }
            throw new ScriptingException(string4);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteDocument");
        }
        return string2;
    }

    public String convertToCluster(String string, String string2) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertToCluster", new Object[]{string, string2});
        }
        this._shell.setLastException(null);
        String string3 = new String();
        this.checkService();
        if (this.isValidValue(string)) {
            this._shell.setAndThrowScriptingException("WASX7444E", "Invalid parameter value {0} for parameter {1} on command {2}", new Object[]{string, "server id", "convertToCluster"});
        }
        try {
            string = this.configHelper.cleanString(string);
            ObjectName objectName = this.configHelper.stringToObjectName(string);
            String string4 = this.nameCache.getType(string);
            if (string4 == null) {
                return null;
            }
            if (!string4.equals(SERVERTYPE)) {
                this._shell.setAndThrowScriptingException("WASX7283E", "This command requires an object of type Server, but the specified object " + string + " has type: " + string4, new Object[]{SERVERTYPE, string, string4});
            }
            ObjectName objectName2 = this.clusterTasks.convertToCluster(this.getCurrentSession(), objectName, string2);
            string3 = this.configHelper.getListingName(objectName2);
        }
        catch (ScriptingException scriptingException) {
            throw scriptingException;
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            String string5 = ExceptionSupport.getMessage(exception, "WASX");
            if (string5 == null) {
                string5 = exception.toString();
            }
            throw new ScriptingException(string5);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertToCluster: " + string3);
        }
        return string3;
    }

    public String createClusterMember(String string, String string2, String string3) throws ScriptingException {
        String string4 = this.createClusterMember(string, string2, string3, null);
        return string4;
    }

    public String createClusterMember(String string, String string2, Object[] objectArray) throws ScriptingException {
        String string3 = this._langutils.objectArrayToString(objectArray);
        String string4 = this.createClusterMember(string, string2, string3, null);
        return string4;
    }

    public String createClusterMember(String string, String string2, Object[] objectArray, String string3) throws ScriptingException {
        String string4 = this._langutils.objectArrayToString(objectArray);
        String string5 = this.createClusterMember(string, string2, string4, string3);
        return string5;
    }

    public String createClusterMember(String string, String string2, String string3, String string4) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createClusterMember", new Object[]{string, string2, string3, string4});
        }
        this._shell.setLastException(null);
        String string5 = new String();
        this.checkService();
        if (this.isValidValue(string)) {
            this._shell.setAndThrowScriptingException("WASX7444E", "Invalid parameter value {0} for parameter {1} on command {2}", new Object[]{string, "cluster id", "createClusterMember"});
        }
        if (this.isValidValue(string2)) {
            this._shell.setAndThrowScriptingException("WASX7444E", "Invalid parameter value {0} for parameter {1} on command {2}", new Object[]{string2, "node id", "createClusterMember"});
        }
        try {
            string = this.configHelper.cleanString(string);
            ObjectName objectName = this.configHelper.stringToObjectName(string);
            string3 = this._langutils.cleanAttributeString(string3);
            AttributeList attributeList = this._langutils.stringToAttributeList(string3);
            AttributeList attributeList2 = null;
            attributeList2 = this.correctTypesInAttributeList(MEMBERTYPE, attributeList);
            String string6 = this.nameCache.getType(string);
            if (string6 == null) {
                return null;
            }
            if (!string6.equals(CLUSTERTYPE)) {
                this._shell.setAndThrowScriptingException("WASX7283E", "This command requires an object of type ServerCluster, but the specified object " + string + " has type: " + string6, new Object[]{CLUSTERTYPE, string, string6});
            }
            ObjectName objectName2 = this.configHelper.stringToObjectName(string2);
            string6 = this.nameCache.getType(string2);
            if (string6 == null) {
                return null;
            }
            if (!string6.equals(NODETYPE)) {
                this._shell.setAndThrowScriptingException("WASX7283E", "This command requires an object of type Node, but the specified object " + string2 + " has type: " + string6, new Object[]{NODETYPE, string2, string6});
            }
            ObjectName objectName3 = null;
            if (string4 != null) {
                objectName3 = this.configHelper.stringToObjectName(string4);
            }
            if (string6 == null) {
                return null;
            }
            ObjectName objectName4 = this.clusterTasks.createClusterMember(this.getCurrentSession(), objectName, attributeList2, objectName2, objectName3);
            string5 = this.configHelper.getListingName(objectName4);
        }
        catch (ScriptingException scriptingException) {
            throw scriptingException;
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            String string7 = ExceptionSupport.getMessage(exception, "WASX");
            if (string7 == null) {
                string7 = exception.toString();
            }
            throw new ScriptingException(string7);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createClusterMember: " + string5);
        }
        return string5;
    }

    private Vector validateInstallRarOptions(Hashtable hashtable) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateInstallRarOptions");
        }
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (validInstallRarOptions.contains(string)) continue;
            vector.add(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateInstallRarOptions");
        }
        return vector;
    }

    public String installResourceAdapter(String string, String string2, Object[] objectArray) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "installResourceAdapter");
        }
        this._shell.setLastException(null);
        String string3 = this._langutils.objectArrayToString(objectArray);
        String string4 = this.installResourceAdapter(string, string2, string3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "installResourceAdapter");
        }
        return string4;
    }

    public String installResourceAdapter(String string, String string2, String string3) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "installResourceAdapter: ", new Object[]{string, string3, string2});
        }
        this._shell.setLastException(null);
        String string4 = null;
        try {
            if (configServiceProxy == null) {
                this._shell.setAndThrowScriptingException("WASX7459E", "The configuration service is not available. Target node's nodeagent may not be running", new Object[0]);
            }
            if ("ManagedProcess".equals(processType)) {
                this._shell.setAndThrowScriptingException("WASX7254E", "installResourceAdapter command not supported when connected to process type " + processType, new Object[]{"installResourceAdapter", processType});
            }
            string = this._shell.normalizeFQPathName(string);
            Hashtable hashtable = this._langutils.optionsToHashtable(string3);
            Vector vector = this.validateInstallRarOptions(hashtable);
            if (vector.size() > 0) {
                this._shell.setAndThrowScriptingException("WASX7107E", "invalid options: " + vector.toString() + "; valid options: " + validInstallRarOptions.toString(), new Object[]{vector.toString(), validInstallRarOptions.toString()});
            }
            Enumeration enumeration = hashtable.keys();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "optProps: " + hashtable.toString());
            }
            hashtable.put("app.client.locale", Locale.getDefault());
            InstallRARTask installRARTask = new InstallRARTask(configServiceProxy);
            ObjectName objectName = installRARTask.installResourceAdapter(this.getCurrentSession(), string2, string, hashtable);
            string4 = this.configHelper.getListingName(objectName);
            this.nameCache.add(string4, "J2CResourceAdapter");
        }
        catch (ScriptingException scriptingException) {
            throw scriptingException;
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            String string5 = ExceptionSupport.getMessage(exception, "WASX");
            if (string5 == null) {
                string5 = exception.toString();
            }
            throw new ScriptingException(string5);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "installResourceAdapter");
        }
        return string4;
    }

    private Vector validateUninstallRarOptions(Hashtable hashtable) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateUninstallRarOptions");
        }
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (validUninstallRarOptions.contains(string)) continue;
            vector.add(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateUninstallRarOptions");
        }
        return vector;
    }

    public void uninstallResourceAdapter(String string) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "uninstallResourceAdapter: ", new Object[]{string});
        }
        this._shell.setLastException(null);
        this.uninstallResourceAdapter(string, new String());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "uninstallResourceAdapter");
        }
    }

    public void uninstallResourceAdapter(String string, Object[] objectArray) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "uninstallResourceAdapter");
        }
        this._shell.setLastException(null);
        String string2 = this._langutils.objectArrayToString(objectArray);
        this.uninstallResourceAdapter(string, string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "uninstallResourceAdapter");
        }
    }

    public void uninstallResourceAdapter(String string, String string2) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "uninstallResourceAdapter: ", new Object[]{string, string2});
        }
        String string3 = new String();
        List list = null;
        this._shell.setLastException(null);
        if (this.isValidValue(string)) {
            this._shell.setAndThrowScriptingException("WASX7444E", "Invalid parameter value {0} for parameter {1} on command {2}", new Object[]{string, "config id", "uninstallResourceAdapter"});
        }
        try {
            if (configServiceProxy == null) {
                this._shell.setAndThrowScriptingException("WASX7459E", "The configuration service is not available. Target node's nodeagent may not be running", new Object[0]);
            }
            if ("ManagedProcess".equals(processType)) {
                this._shell.setAndThrowScriptingException("WASX7254E", "uninstallResourceAdapter command not supported when connected to process type " + processType, new Object[]{"uninstallResourceAdapter", processType});
            }
            string = this.configHelper.cleanString(string);
            ObjectName objectName = this.configHelper.stringToObjectName(string);
            Hashtable hashtable = this._langutils.optionsToHashtable(string2);
            Vector vector = this.validateUninstallRarOptions(hashtable);
            if (vector.size() > 0) {
                this._shell.setAndThrowScriptingException("WASX7107E", "invalid options: " + vector.toString() + "; valid options: " + validUninstallRarOptions.toString(), new Object[]{vector.toString(), validUninstallRarOptions.toString()});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "optProps: " + hashtable.toString());
            }
            hashtable.put("app.client.locale", Locale.getDefault());
            UninstallRARTask uninstallRARTask = new UninstallRARTask(configServiceProxy);
            list = uninstallRARTask.uninstallResourceAdapter(this.getCurrentSession(), objectName, hashtable);
        }
        catch (ScriptingException scriptingException) {
            throw scriptingException;
        }
        catch (AppRefException appRefException) {
            this._shell.setLastException(appRefException);
            String string4 = ExceptionSupport.getMessage(appRefException, "WASX");
            if (string4 == null) {
                string4 = appRefException.toString();
            }
            throw new ScriptingException(string4);
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            String string5 = ExceptionSupport.getMessage(exception, "WASX");
            if (string5 == null) {
                string5 = exception.toString();
            }
            throw new ScriptingException(string5);
        }
        if (list != null || !list.isEmpty()) {
            string3 = this._langutils.setToString(list);
        }
        if (!string3.equals("")) {
            returnCode = this._shell.issueMessage(new Object[]{string3}, "WASX7397I", "List of configuration objects that is being removed");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "uninstallResourceAdapter");
        }
    }

    public String required(String string) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "required - " + string);
        }
        this._shell.setLastException(null);
        this.checkService();
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            string = this.configHelper.cleanString(string);
            Vector vector = null;
            try {
                vector = this.metaCache.getFlatAttributeMap(string);
            }
            catch (ScriptingException scriptingException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No attrs for " + string);
                }
                vector = new Vector();
            }
            for (int i = 0; i < vector.size(); ++i) {
                AttrInfo attrInfo = (AttrInfo)vector.get(i);
                if (!attrInfo.isRequired()) continue;
                stringBuffer.append(nl);
                HelpSupport.spaceit(stringBuffer, attrInfo.getName(), 32);
                stringBuffer.append(attrInfo.getDecoratedType());
            }
            if (stringBuffer.toString().length() > 0) {
                StringBuffer stringBuffer2 = new StringBuffer();
                HelpSupport.spaceit(stringBuffer2, this.S_Attribute, 32);
                stringBuffer2.append(this.S_Type);
                stringBuffer2.append(stringBuffer.toString());
                string2 = stringBuffer2.toString();
            } else {
                string2 = this._shell.getFormattedMessage("WASX7361I", new Object[]{string}, "No required attribute for type {0}");
            }
        }
        catch (ScriptingException scriptingException) {
            throw scriptingException;
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            String string3 = ExceptionSupport.getMessage(exception, "WASX");
            if (string3 == null) {
                string3 = exception.toString();
            }
            throw new ScriptingException(string3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "required");
        }
        return string2;
    }

    private boolean isLocalMode() throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isLocalMode");
        }
        Properties properties = new Properties();
        boolean bl = this._shell.getConnectionType().equals("NONE");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isLocalMode - " + bl);
        }
        return bl;
    }

    private boolean isValidValue(String string) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidValue");
        }
        boolean bl = false;
        if (string == null || string.trim().equals("") || string.trim().equals("''")) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValidValue - parameter value" + string);
        }
        return bl;
    }

    public String list() throws ScriptingException {
        this.helpInfo("list");
        return new String();
    }

    public String listTemplates() throws ScriptingException {
        this.helpInfo("listTemplates");
        return new String();
    }

    public String getObjectName() throws ScriptingException {
        this.helpInfo("getObjectName");
        return new String();
    }

    public String attributes() throws ScriptingException {
        this.helpInfo("attributes");
        return new String();
    }

    public String parents() throws ScriptingException {
        this.helpInfo("parents");
        return new String();
    }

    public String contents() throws ScriptingException {
        this.helpInfo("contents");
        return new String();
    }

    public String show() throws ScriptingException {
        this.helpInfo("show");
        return new String();
    }

    public String showAttribute() throws ScriptingException {
        this.helpInfo("showAttribute");
        return new String();
    }

    public String showAttribute(Object object) throws ScriptingException {
        this.helpInfo("showAttribute");
        return new String();
    }

    public String showall() throws ScriptingException {
        this.helpInfo("showall");
        return new String();
    }

    public String modify() throws ScriptingException {
        this.helpInfo("modify");
        return new String();
    }

    public String create() throws ScriptingException {
        this.helpInfo("create");
        return new String();
    }

    public String create(String string) throws ScriptingException {
        this.helpInfo("create");
        return new String();
    }

    public String create(String string, String string2) throws ScriptingException {
        this.helpInfo("create");
        return new String();
    }

    public String createUsingTemplate() throws ScriptingException {
        this.helpInfo("createUsingTemplate");
        return new String();
    }

    public String createUsingTemplate(String string) throws ScriptingException {
        this.helpInfo("createUsingTemplate");
        return new String();
    }

    public String createUsingTemplate(String string, String string2) throws ScriptingException {
        this.helpInfo("createUsingTemplate");
        return new String();
    }

    public String createClusterMember() throws ScriptingException {
        this.helpInfo("createClusterMember");
        return new String();
    }

    public String createClusterMember(String string) throws ScriptingException {
        this.helpInfo("createClusterMember");
        return new String();
    }

    public String createClusterMember(String string, String string2) throws ScriptingException {
        this.helpInfo("createClusterMember");
        return new String();
    }

    public String convertToCluster() throws ScriptingException {
        this.helpInfo("convertToCluster");
        return new String();
    }

    public String convertToCluster(Object object) throws ScriptingException {
        this.helpInfo("convertToCluster");
        return new String();
    }

    public String remove() throws ScriptingException {
        this.helpInfo("remove");
        return new String();
    }

    public String getid() throws ScriptingException {
        this.helpInfo("getid");
        return new String();
    }

    public String checkin() throws ScriptingException {
        this.helpInfo("checkin");
        return new String();
    }

    public String checkin(Object object) throws ScriptingException {
        this.helpInfo("checkin");
        return new String();
    }

    public String checkin(Object object, Object object2) throws ScriptingException {
        this.helpInfo("checkin");
        return new String();
    }

    public Object extract() throws ScriptingException {
        this.helpInfo("extract");
        return new String();
    }

    public Object extract(Object object) throws ScriptingException {
        this.helpInfo("extract");
        return new String();
    }

    public Object createDocument() throws ScriptingException {
        this.helpInfo("createDocument");
        return new String();
    }

    public Object createDocument(Object object) throws ScriptingException {
        this.helpInfo("createDocument");
        return new String();
    }

    public Object deleteDocument() throws ScriptingException {
        this.helpInfo("deleteDocument");
        return new String();
    }

    public Object existsDocument() throws ScriptingException {
        this.helpInfo("existsDocument");
        return new String();
    }

    public String getValidationSeverityResult() throws ScriptingException {
        this.helpInfo("getValidationSeverityResult");
        return new String();
    }

    public String installResourceAdapter() throws ScriptingException {
        this.helpInfo("installResourceAdapter");
        return new String();
    }

    public String installResourceAdapter(String string) throws ScriptingException {
        this.helpInfo("installResourceAdapter");
        return new String();
    }

    public String installResourceAdapter(String string, String string2) throws ScriptingException {
        this.helpInfo("installResourceAdapter");
        return new String();
    }

    public String uninstallResourceAdapter() throws ScriptingException {
        this.helpInfo("uninstallResourceAdapter");
        return new String();
    }

    public String required() throws ScriptingException {
        this.helpInfo("required");
        return new String();
    }

    public String defaults() throws ScriptingException {
        this.helpInfo("defaults");
        return new String();
    }
}

