/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import com.ibm.bsf.BSFException;
import com.ibm.bsf.BSFManager;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.scripting.ScriptingExtension;
import com.ibm.websphere.scripting.StringHandler;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.scripting.HandlerRegistry;
import com.ibm.ws.scripting.ObjectNameHelper;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ExtensionHelper {
    private static TraceComponent tc = Tr.register(ExtensionHelper.class);
    private static ClassLoader legacyClassLoader;

    public static void processRegisterBeansInExtensions(BSFManager bSFManager) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processRegisterBeansInExtensions");
        }
        Vector vector = ExtensionHelper.getScriptingExtension(true);
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            ProviderInfo providerInfo = (ProviderInfo)iterator.next();
            try {
                Class clazz = null;
                if (providerInfo.bundle != null) {
                    object2 = providerInfo.bundle;
                    object = providerInfo.className.trim();
                    clazz = (Class)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((Bundle)object2, (String)object){
                        private final /* synthetic */ Bundle val$bundle;
                        private final /* synthetic */ String val$className;
                        {
                            this.val$bundle = bundle;
                            this.val$className = string;
                        }

                        public Object run() throws ClassNotFoundException {
                            return this.val$bundle.loadClass(this.val$className);
                        }
                    });
                } else {
                    clazz = providerInfo.classLoader.loadClass(providerInfo.className.trim());
                }
                object2 = (ScriptingExtension)clazz.newInstance();
                bSFManager.declareBean(object2.getBeanName(), object2, object2.getClass());
                if (!tc.isEntryEnabled()) continue;
                Tr.debug(tc, "Registering provider object " + object2.getBeanName() + " with BSF");
            }
            catch (PrivilegedActionException privilegedActionException) {
                object2 = privilegedActionException.getException();
                System.out.println(ObjectNameHelper.getFormattedMessage("WASX7371E", "Exception locating the class for {0} provided in extension: {1}", new Object[]{providerInfo.className.trim(), ((Throwable)object2).toString()}));
                object = new StringWriter();
                ((Throwable)object2).printStackTrace(new PrintWriter((Writer)object));
                Tr.error(tc, "WASX7371E", new Object[]{providerInfo.className.trim(), ((StringWriter)object).toString()});
            }
            catch (BSFException bSFException) {
                System.out.println(ObjectNameHelper.getFormattedMessage("WASX7370E", "Exception registering bean {0} provided in extension: {1}", new Object[]{providerInfo.className.trim(), bSFException.toString()}));
                object2 = new StringWriter();
                bSFException.printStackTrace(new PrintWriter((Writer)object2));
                Tr.error(tc, "WASX7370E", new Object[]{providerInfo.className.trim(), ((StringWriter)object2).toString()});
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println(ObjectNameHelper.getFormattedMessage("WASX7371E", "Exception locating the class for {0} provided in extension: {1}", new Object[]{providerInfo.className.trim(), classNotFoundException.toString()}));
                object2 = new StringWriter();
                classNotFoundException.printStackTrace(new PrintWriter((Writer)object2));
                Tr.error(tc, "WASX7371E", new Object[]{providerInfo.className.trim(), ((StringWriter)object2).toString()});
            }
            catch (InstantiationException instantiationException) {
                System.out.println("Exception instantiate the class for " + providerInfo.className);
                System.out.println(ObjectNameHelper.getFormattedMessage("WASX7372E", "Exception instantiating class {0} provided in extension: {1}", new Object[]{providerInfo.className.trim(), instantiationException.toString()}));
                object2 = new StringWriter();
                instantiationException.printStackTrace(new PrintWriter((Writer)object2));
                Tr.error(tc, "WASX7372E", new Object[]{providerInfo.className.trim(), ((StringWriter)object2).toString()});
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processRegisterBeansInExtensions");
        }
    }

    public static void processRegisterHandlersInExtensions() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processRegisterHandlersInExtensions");
        }
        Vector vector = ExtensionHelper.getScriptingExtension(false);
        String string = null;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            Class clazz;
            Object object;
            HandlerInfo handlerInfo = (HandlerInfo)iterator.next();
            try {
                Class clazz2 = null;
                string = handlerInfo.className.trim();
                if (handlerInfo.bundle != null) {
                    object = handlerInfo.bundle;
                    clazz = string;
                    clazz2 = (Class)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((Bundle)object, (String)((Object)clazz)){
                        private final /* synthetic */ Bundle val$bundle;
                        private final /* synthetic */ String val$className;
                        {
                            this.val$bundle = bundle;
                            this.val$className = string;
                        }

                        public Object run() throws ClassNotFoundException {
                            return this.val$bundle.loadClass(this.val$className);
                        }
                    });
                } else {
                    clazz2 = handlerInfo.classLoader.loadClass(string);
                }
                object = (StringHandler)clazz2.newInstance();
                clazz = null;
                string = handlerInfo.typeName.trim();
                if (handlerInfo.bundle != null) {
                    final Bundle bundle = handlerInfo.bundle;
                    final String string2 = string;
                    clazz = (Class)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                        public Object run() throws ClassNotFoundException {
                            return bundle.loadClass(string2);
                        }
                    });
                } else {
                    clazz = handlerInfo.classLoader.loadClass(string);
                }
                HandlerRegistry.registerHandler((StringHandler)object, clazz);
            }
            catch (PrivilegedActionException privilegedActionException) {
                object = privilegedActionException.getException();
                System.out.println(ObjectNameHelper.getFormattedMessage("WASX7371E", "Exception locating the class for {0} provided in extension: {1}", new Object[]{string, ((Throwable)object).toString()}));
                clazz = new StringWriter();
                ((Throwable)object).printStackTrace(new PrintWriter((Writer)((Object)clazz)));
                Tr.error(tc, "WASX7371E", new Object[]{string, ((StringWriter)((Object)clazz)).toString()});
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println(ObjectNameHelper.getFormattedMessage("WASX7371E", "Exception locating the class for {0} provided in extension: {1}", new Object[]{handlerInfo.className.trim(), classNotFoundException.toString()}));
                object = new StringWriter();
                classNotFoundException.printStackTrace(new PrintWriter((Writer)object));
                Tr.error(tc, "WASX7371E", new Object[]{handlerInfo.className.trim(), ((StringWriter)object).toString()});
            }
            catch (InstantiationException instantiationException) {
                System.out.println(ObjectNameHelper.getFormattedMessage("WASX7372E", "Exception instantiating class {0} provided in extension: {1}", new Object[]{handlerInfo.className.trim(), instantiationException.toString()}));
                object = new StringWriter();
                instantiationException.printStackTrace(new PrintWriter((Writer)object));
                Tr.error(tc, "WASX7372E", new Object[]{handlerInfo.className.trim(), ((StringWriter)object).toString()});
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processRegisterHandlersInExtensions");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Vector getScriptingExtension(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getScriptingExtension " + bl);
        }
        Vector vector = ExtensionHelper.getEclipseScriptingExtensions(bl);
        legacyClassLoader = Thread.currentThread().getContextClassLoader();
        if (!(legacyClassLoader instanceof ExtClassLoader)) {
            legacyClassLoader = ExtClassLoader.getInstance();
        }
        try {
            Enumeration<URL> enumeration = null;
            try {
                enumeration = legacyClassLoader.getResources("scripting-extension.xml");
            }
            catch (IOException iOException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception loading helpers:" + iOException.toString());
                }
                iOException.printStackTrace();
            }
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = null;
            try {
                sAXParser = sAXParserFactory.newSAXParser();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                parserConfigurationException.printStackTrace();
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
            }
            if (sAXParser == null) {
                return vector;
            }
            ExtensionBeanHandler extensionBeanHandler = new ExtensionBeanHandler();
            InputStream inputStream = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing providers ...");
            }
            while (enumeration.hasMoreElements()) {
                Object object;
                URL uRL = enumeration.nextElement();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Next provider URL: " + uRL.toString());
                }
                try {
                    inputStream = uRL.openStream();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                try {
                    Iterator iterator;
                    extensionBeanHandler.setURL(uRL);
                    sAXParser.parse(inputStream, (DefaultHandler)extensionBeanHandler);
                    if (bl) {
                        iterator = extensionBeanHandler.getProviders().values().iterator();
                        while (iterator.hasNext()) {
                            object = (ProviderInfo)iterator.next();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Next Provider Detail:" + ((ProviderInfo)object).toString());
                            }
                            vector.add(object);
                        }
                        continue;
                    }
                    iterator = extensionBeanHandler.getHandlers().values().iterator();
                    while (iterator.hasNext()) {
                        object = (HandlerInfo)iterator.next();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Next Handler Detail:" + ((HandlerInfo)object).toString());
                        }
                        vector.add(object);
                    }
                }
                catch (SAXParseException sAXParseException) {
                    object = new StringWriter();
                    sAXParseException.printStackTrace(new PrintWriter((Writer)object));
                    System.out.println(ObjectNameHelper.getFormattedMessage("EXTENSION_PARSER_EXCEPTION_MESSAGE", "{0} in {1} at line {2} column {3}:\n{4}", new Object[]{sAXParseException.getMessage(), uRL.getFile(), new Integer(sAXParseException.getLineNumber()), new Integer(sAXParseException.getColumnNumber()), new String()}));
                    Tr.error(tc, "EXTENSION_PARSER_EXCEPTION_MESSAGE", new Object[]{sAXParseException.getMessage(), uRL.getFile(), new Integer(sAXParseException.getLineNumber()), new Integer(sAXParseException.getColumnNumber()), ((StringWriter)object).toString()});
                }
                catch (SAXException sAXException) {
                    if (sAXException.getException() != null) {
                        sAXException.getException().printStackTrace();
                        continue;
                    }
                    sAXException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getScriptingExtension");
        }
        return vector;
    }

    private static Vector getEclipseScriptingExtensions(boolean bl) {
        Vector<Object> vector = new Vector<Object>();
        IExtensionRegistry iExtensionRegistry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        if (iExtensionRegistry == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to get eclipse extension registry");
            }
        } else {
            String string = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".scripting-extension";
            IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(string);
            if (iExtensionPoint == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unable to get extension point - " + string);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing extension point - " + string);
                }
                IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
                for (int i = 0; i < iExtensionArray.length; ++i) {
                    IExtension iExtension = iExtensionArray[i];
                    String string2 = iExtension.getNamespace();
                    Bundle bundle = Platform.getBundle((String)string2);
                    ClassLoader classLoader = bundle.getClass().getClassLoader();
                    IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
                    if (iConfigurationElementArray.length != 1) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Invalid number of scriptingExtension elements - " + iConfigurationElementArray.length);
                        continue;
                    }
                    IConfigurationElement iConfigurationElement = iConfigurationElementArray[0];
                    if (!iConfigurationElement.getName().equals("scriptingExtension")) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Invalid element name - expecting <scriptingExtension>, got <" + iConfigurationElement.getName() + ">");
                        continue;
                    }
                    IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElement.getChildren();
                    block1: for (int j = 0; j < iConfigurationElementArray2.length; ++j) {
                        Object object;
                        String string3;
                        IConfigurationElement iConfigurationElement2 = iConfigurationElementArray2[j];
                        if (iConfigurationElement2.getName().equals("beanProvider")) {
                            if (!bl) continue;
                            IConfigurationElement[] iConfigurationElementArray3 = iConfigurationElement2.getChildren();
                            if (iConfigurationElementArray3.length != 1) {
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "Invalid number of beanImplClass elements - " + iConfigurationElementArray3.length);
                                continue;
                            }
                            IConfigurationElement iConfigurationElement3 = iConfigurationElementArray3[0];
                            if (!iConfigurationElement3.getName().equals("beanImplClass")) {
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "Invalid element name - expecting <beanImplClass>, got <" + iConfigurationElement3.getName() + ">");
                                continue;
                            }
                            string3 = iConfigurationElement3.getValue();
                            if (string3 == null) {
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "Missing class name for <beanImplClass>");
                                continue;
                            }
                            object = new ProviderInfo();
                            ((ProviderInfo)object).className = string3;
                            ((ProviderInfo)object).bundle = bundle;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Next Provider Detail:" + ((ProviderInfo)object).toString());
                            }
                            vector.add(object);
                            continue;
                        }
                        if (iConfigurationElement2.getName().equals("typeHandler")) {
                            if (bl) continue;
                            boolean bl2 = false;
                            boolean bl3 = false;
                            string3 = null;
                            object = null;
                            IConfigurationElement[] iConfigurationElementArray4 = iConfigurationElement2.getChildren();
                            for (int k = 0; k < iConfigurationElementArray4.length; ++k) {
                                IConfigurationElement iConfigurationElement4 = iConfigurationElementArray4[k];
                                if (iConfigurationElement4.getName().equals("typeImplClass")) {
                                    if (bl2) {
                                        if (!tc.isDebugEnabled()) continue block1;
                                        Tr.debug(tc, "Duplicate element <typeImplClass>");
                                        continue block1;
                                    }
                                    bl2 = true;
                                    string3 = iConfigurationElement4.getValue();
                                    if (string3 != null) continue;
                                    if (!tc.isDebugEnabled()) continue block1;
                                    Tr.debug(tc, "Missing class name for <typeImplClass>");
                                    continue block1;
                                }
                                if (iConfigurationElement4.getName().equals("typeClass")) {
                                    if (bl3) {
                                        if (!tc.isDebugEnabled()) continue block1;
                                        Tr.debug(tc, "Duplicate element <typeClass>");
                                        continue block1;
                                    }
                                    bl3 = true;
                                    object = iConfigurationElement4.getValue();
                                    if (object != null) continue;
                                    if (!tc.isDebugEnabled()) continue block1;
                                    Tr.debug(tc, "Missing type name for <typeClass>");
                                    continue block1;
                                }
                                if (!tc.isDebugEnabled()) continue block1;
                                Tr.debug(tc, "Invalid element name - expecting <typeImplClass> or <typeClass>, got <" + iConfigurationElement4.getName() + ">");
                                continue block1;
                            }
                            if (!bl2) {
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "Missing <typeImplClass> element");
                                continue;
                            }
                            if (!bl3) {
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "Missing <typeClass> element");
                                continue;
                            }
                            HandlerInfo handlerInfo = new HandlerInfo();
                            handlerInfo.className = string3;
                            handlerInfo.classLoader = classLoader;
                            handlerInfo.typeName = object;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Next Handler Detail:" + handlerInfo.toString());
                            }
                            vector.add(handlerInfo);
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Invalid element name - expecting <beanProvider> or <typeHandler>, but got <" + iConfigurationElement2.getName() + ">");
                    }
                }
            }
        }
        return vector;
    }

    static class ExtensionBeanHandler
    extends DefaultHandler {
        Locator locator;
        Map providers = new HashMap();
        Map handlers = new HashMap();
        ProviderInfo currentProvider;
        HandlerInfo currentHandler;
        URL currentURL;
        StringBuffer value = new StringBuffer();

        public void setURL(URL uRL) {
            this.currentURL = uRL;
        }

        public Map getProviders() {
            return this.providers;
        }

        public Map getHandlers() {
            return this.handlers;
        }

        public void startDocument() throws SAXException {
            this.providers.clear();
        }

        public void endDocument() throws SAXException {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes2) throws SAXException {
            this.value.setLength(0);
            if (string3.equals("scriptingExtension")) {
                this.providers.clear();
                this.handlers.clear();
                this.currentProvider = null;
                this.currentHandler = null;
            }
            if (string3.equals("beanProvider")) {
                if (this.currentProvider != null) {
                    return;
                }
                this.currentProvider = new ProviderInfo();
            }
            if (string3.equals("typeHandler")) {
                if (this.currentHandler != null) {
                    return;
                }
                this.currentHandler = new HandlerInfo();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (string3.equals("beanProvider") || string3.equals("beanImplClass") ? this.currentProvider == null : (string3.equals("typeHandler") || string3.equals("typeImplClass") || string3.equals("typeClass")) && this.currentHandler == null) {
                return;
            }
            if (string3.equals("beanProvider")) {
                if (this.currentProvider.className != null) {
                    ProviderInfo providerInfo = this.providers.put(this.currentProvider.className, this.currentProvider);
                    if (providerInfo != null) {
                        System.out.println(ObjectNameHelper.getFormattedMessage("WASX7373W", "Duplicate implementation class entry, {0}, found in {1} at line {2}", new Object[]{this.currentProvider.className.trim(), this.currentURL, new Integer(this.locator.getLineNumber())}));
                    }
                } else {
                    System.out.println(ObjectNameHelper.getFormattedMessage("WASX7374W", "Missing element type {0} in {1} at line {2}. Skipping the {3} element.", new Object[]{"<beanImplClass>", this.currentURL, new Integer(this.locator.getLineNumber()), "<beanProvider>"}));
                }
                this.currentProvider = null;
            } else if (string3.equals("beanImplClass")) {
                if (this.currentProvider.className != null) throw new SAXParseException(ObjectNameHelper.getFormattedMessage("WASX7375E", "element type {0} is already defined", new Object[]{"<beanImplClass>"}), this.locator);
                this.currentProvider.className = this.value.toString();
                this.currentProvider.classLoader = legacyClassLoader;
            } else if (string3.equals("typeHandler")) {
                if (this.currentHandler.className != null && this.currentHandler.typeName != null) {
                    HandlerInfo handlerInfo = this.handlers.put(this.currentHandler.typeName, this.currentHandler);
                    if (handlerInfo != null) {
                        System.out.println(ObjectNameHelper.getFormattedMessage("WASX7377W", "Duplicate type handler class entry, {0}, found in {1} at line {2}", new Object[]{this.currentHandler.typeName.trim(), this.currentURL, new Integer(this.locator.getLineNumber())}));
                    }
                } else {
                    if (this.currentHandler.className == null) {
                        System.out.println(ObjectNameHelper.getFormattedMessage("WASX7374W", "Missing element type {0} in {1} at line {2}. Skipping the {3} element.", new Object[]{"<typeImplClass>", this.currentURL, new Integer(this.locator.getLineNumber()), "<typeHandler>"}));
                    }
                    if (this.currentHandler.typeName == null) {
                        System.out.println(ObjectNameHelper.getFormattedMessage("WASX7374W", "Missing element type {0} in {1} at line {2}. Skipping the {3} element.", new Object[]{"<typeClass>", this.currentURL, new Integer(this.locator.getLineNumber()), "<typeHandler>"}));
                    }
                }
                this.currentHandler = null;
            } else if (string3.equals("typeImplClass")) {
                if (this.currentHandler.className != null) throw new SAXParseException(ObjectNameHelper.getFormattedMessage("WASX7375E", "element type {0} is already defined", new Object[]{"<typeImplClass>"}), this.locator);
                this.currentHandler.className = this.value.toString();
                this.currentHandler.classLoader = legacyClassLoader;
            } else if (string3.equals("typeClass")) {
                if (this.currentHandler.typeName != null) throw new SAXParseException(ObjectNameHelper.getFormattedMessage("WASX7375E", "element type {0} is already defined", new Object[]{"<typeClass>"}), this.locator);
                this.currentHandler.typeName = this.value.toString();
            } else if (!string3.equals("scriptingExtension")) {
                throw new SAXParseException(ObjectNameHelper.getFormattedMessage("WASX7376E", "Invalid element end-tag: {0}", new Object[]{string3}), this.locator);
            }
            this.value.setLength(0);
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            this.currentProvider = null;
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            this.currentProvider = null;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.providers.clear();
            this.handlers.clear();
            this.currentProvider = null;
            this.currentHandler = null;
            throw sAXParseException;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.value.append(cArray, n, n2);
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }
    }

    static class HandlerInfo {
        public String className;
        public ClassLoader classLoader;
        public Bundle bundle;
        public String typeName;

        HandlerInfo() {
        }

        public String toString() {
            return "HandlerInfo{className=" + this.className + ", typeName=" + this.typeName + ", classLoader=" + this.classLoader.toString() + "}";
        }
    }

    static class ProviderInfo {
        public String className;
        public ClassLoader classLoader;
        public Bundle bundle;

        ProviderInfo() {
        }

        public String toString() {
            String string = null;
            if (this.classLoader != null) {
                string = this.classLoader.toString();
            }
            String string2 = null;
            if (this.bundle != null) {
                string2 = this.bundle.getSymbolicName();
            }
            return "ProviderInfo{className=" + this.className + ", classLoader=" + string + ", bundle name=" + string2 + "}";
        }
    }
}

