/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.scripting.ConfigHelper;
import com.ibm.ws.scripting.HandlerRegistry;
import com.ibm.ws.scripting.LanguageUtilities;
import com.ibm.ws.scripting.ScriptingException;
import com.ibm.ws.scripting.compat.StringPropertiesEditor;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class JaclUtilities
extends LanguageUtilities {
    public static String OPENOPTIONSYNTAX = "{";
    public static String CLOSEOPTIONSYNTAX = "}";
    private static TraceComponent tc = Tr.register(JaclUtilities.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    private static final String IS_A_NULL = "$$WebSphere_Null_Value$$";

    public JaclUtilities(ResourceBundle resourceBundle) {
        super(resourceBundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties stringToProperties(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stringToProperties");
        }
        if (string == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "stringToProperties");
            }
            return new Properties();
        }
        StringPropertiesEditor stringPropertiesEditor = new StringPropertiesEditor();
        try {
            stringPropertiesEditor.setAsText(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("RRK: caught IllegalArgumentException " + illegalArgumentException);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "stringToProperties");
            }
        }
        return (Properties)stringPropertiesEditor.getValue();
    }

    public String propertiesToString(Properties properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "propertiesToString");
        }
        if (properties == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "propertiesToString");
            }
            return new String();
        }
        StringPropertiesEditor stringPropertiesEditor = new StringPropertiesEditor();
        stringPropertiesEditor.setValue(properties);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "propertiesToString");
        }
        return stringPropertiesEditor.getAsText();
    }

    public String attributeListToString(AttributeList attributeList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "attributeListToString");
        }
        Properties properties = new Properties();
        for (int i = 0; i < attributeList.size(); ++i) {
            Object object;
            if (tc.isDebugEnabled()) {
                try {
                    object = attributeList.get(i);
                    Tr.debug(tc, "Class of Attribute " + i + " is " + object.getClass().getName());
                    Tr.debug(tc, "name of attr is " + ((Attribute)attributeList.get(i)).getName());
                    Object object2 = ((Attribute)attributeList.get(i)).getValue();
                    if (object2 != null) {
                        Tr.debug(tc, "Class of value is " + object2.getClass().getName());
                    }
                }
                catch (Exception exception) {
                    Tr.debug(tc, "caught " + exception);
                }
            }
            if ((object = ((Attribute)attributeList.get(i)).getValue()) != null) {
                properties.setProperty(((Attribute)attributeList.get(i)).getName(), object.toString());
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Attribute null; skipping: " + ((Attribute)attributeList.get(i)).getName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "attributeListToString");
        }
        return this.propertiesToString(properties);
    }

    public String setToString(Collection collection) {
        return this.setToString(collection, true);
    }

    public String setToString(Collection collection, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setToString");
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (collection == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setToString");
            }
            return new String();
        }
        Object[] objectArray = collection.toArray();
        if (bl) {
            this.sortArray(objectArray);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            String string = objectArray[i].toString();
            if (!(string.indexOf(" ") < 0 || string.startsWith("\"") || string.endsWith("\"") || string.startsWith("{") || string.endsWith("}"))) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "adding quotes to \"" + string + "\"");
                }
                string = "\"" + string + "\"";
            }
            stringBuffer.append(string);
            if (i >= objectArray.length - 1) continue;
            stringBuffer.append(this.nl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setToString");
        }
        return stringBuffer.toString();
    }

    public String[] stringToStringArray(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stringToStringArray");
        }
        String[] stringArray = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringTokenizer stringTokenizer = null;
        if (string != null) {
            int n;
            Object object;
            string = string.trim();
            stringTokenizer = new StringTokenizer(string, "{} ", true);
            String string2 = null;
            int n2 = 0;
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (string2.equals("$")) {
                    bl = true;
                    stringBuffer.append(string2);
                    continue;
                }
                if (string2.equals("{")) {
                    ++n2;
                } else if (string2.equals("}")) {
                    --n2;
                }
                stringBuffer.append(string2);
                if (stringBuffer.toString().startsWith("\"") && !string2.endsWith("\"")) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "buf to string:" + stringBuffer.toString());
                }
                object = stringBuffer.toString().trim();
                if (n2 == 0 && !bl) {
                    if (!((String)object).equals("")) {
                        if (((String)object).startsWith("\"") && ((String)object).endsWith("\"") && ((String)object).lastIndexOf("\"") <= ((String)object).indexOf("\"", 1) || ((String)object).startsWith("{") && ((String)object).endsWith("}")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "removing quotes from \"" + (String)object + "\"");
                            }
                            object = ((String)object).substring(1, ((String)object).length() - 1);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding " + (String)object);
                        }
                        arrayList.add(object);
                    }
                    stringBuffer = new StringBuffer();
                    continue;
                }
                if (n2 != 0 || !bl) continue;
                arrayList.add(stringBuffer.toString());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding " + stringBuffer.toString());
                }
                bl = false;
                stringBuffer = new StringBuffer();
            }
            object = new ArrayList();
            StringBuffer stringBuffer2 = new StringBuffer();
            StringTokenizer stringTokenizer2 = null;
            for (n = 0; n < arrayList.size(); ++n) {
                String string3 = (String)arrayList.get(n);
                Tr.debug(tc, "val: " + string3);
                if (string3.indexOf("Ljava") >= 0 && !string3.endsWith(";")) {
                    string3 = string3 + ";";
                }
                if (string3.indexOf(";") >= 0 && string3.indexOf("Ljava") < 0) {
                    stringTokenizer2 = new StringTokenizer(string3, ";", false);
                    while (stringTokenizer2.hasMoreTokens()) {
                        string2 = stringTokenizer2.nextToken();
                        ((ArrayList)object).add(string2);
                    }
                    continue;
                }
                if (string3.indexOf(" ") >= 0) {
                    if (string3.indexOf("\"") >= 0) {
                        String[] stringArray2 = string3.split(" ");
                        for (int i = 0; i < stringArray2.length; ++i) {
                            String string4 = stringArray2[i];
                            if (string4.startsWith("\"") && string4.endsWith("\"")) {
                                string4 = string4.substring(1, string4.length() - 1);
                                ((ArrayList)object).add(string4);
                            } else if (string4.startsWith("\"")) {
                                stringBuffer2.append(string4);
                                stringBuffer2.append(" ");
                            } else if (string4.endsWith("\"")) {
                                stringBuffer2.append(string4);
                            } else {
                                ((ArrayList)object).add(string4);
                            }
                            if (!stringBuffer2.toString().startsWith("\"") || !stringBuffer2.toString().endsWith("\"")) continue;
                            String string5 = stringBuffer2.substring(1, stringBuffer2.length() - 1);
                            stringBuffer2 = new StringBuffer();
                            ((ArrayList)object).add(string5);
                        }
                        continue;
                    }
                    ((ArrayList)object).add(string3);
                    continue;
                }
                ((ArrayList)object).add(string3);
            }
            stringArray = new String[((ArrayList)object).size()];
            for (n = 0; n < ((ArrayList)object).size(); ++n) {
                stringArray[n] = (String)((ArrayList)object).get(n);
                Tr.debug(tc, "result[j] " + stringArray[n]);
                if (stringArray[n].startsWith("\"") && stringArray[n].endsWith("\"")) {
                    stringArray[n] = stringArray[n].substring(1, stringArray[n].length() - 1);
                    continue;
                }
                if (stringArray[n].startsWith("\"")) {
                    stringArray[n] = stringArray[n].substring(1, stringArray[n].length());
                    continue;
                }
                if (!stringArray[n].endsWith("\"")) continue;
                stringArray[n] = stringArray[n].substring(0, stringArray[n].length() - 1);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stringToStringArray");
        }
        return stringArray;
    }

    public String[] createArgSettingCommands(Collection collection) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createArgSettingCommands");
        }
        String string = this.setToString(collection, false);
        String[] stringArray = new String[2];
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("set argv {");
        stringBuffer.append(string);
        stringBuffer.append("}");
        stringArray[0] = stringBuffer.toString();
        stringArray[1] = new String("set argc " + collection.size());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createArgSettingCommands");
        }
        return stringArray;
    }

    public String getOpenNestedAttribute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOpenNestedAttribute");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOpenNestedAttribute");
        }
        return "{";
    }

    public String getCloseNestedAttribute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCloseNestedAttribute");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCloseNestedAttribute");
        }
        return "}";
    }

    public String getTokenizerString() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTokenizerString");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTokenizerString");
        }
        return "{}\" ";
    }

    public String addQuotes() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getQuotes");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getQuotes");
        }
        return "";
    }

    public String removeQuotes(String string) {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeQuotes");
        }
        if ((string2 = new String(string)).startsWith("\"") && string2.endsWith("\"") || string2.startsWith("{") && string2.endsWith("}")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "removing quotes from \"" + string2 + "\"");
            }
            string2 = string2.substring(1, string2.length() - 1);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeQuotes");
        }
        return string2;
    }

    public boolean isStringWithQuotes(String string) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isStringWithQuote");
        }
        boolean bl2 = bl = string.startsWith("\"") && string.endsWith("\"") || string.startsWith("{") && string.endsWith("}");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isStringWithQuote - " + bl);
        }
        return bl;
    }

    public String attributeToString(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "attributeToString", new Object[]{string, string2});
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        stringBuffer.append(string);
        stringBuffer.append(" ");
        if (string2 == null || string2.equals("")) {
            stringBuffer.append("{}");
        } else if (string2.indexOf(" ") >= 0) {
            if (!(string2.startsWith("\"") || string2.endsWith("\"") || string2.startsWith("{") || string2.endsWith("}"))) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "adding quotes to \"" + string2 + "\"");
                }
                stringBuffer.append("\"");
                stringBuffer.append(string2);
                stringBuffer.append("\"");
            } else {
                stringBuffer.append(string2);
            }
        } else {
            stringBuffer.append(string2);
        }
        stringBuffer.append("}");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "attributeToString " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    public String arrayListToString(ArrayList arrayList, ConfigHelper configHelper) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "arrayListToString ");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e2 = arrayList.get(i);
            if (e2 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Type of value is " + e2.getClass().getName());
                }
                if (e2 instanceof ObjectName) {
                    stringBuffer.append(configHelper.getListingName((ObjectName)e2));
                } else {
                    stringBuffer.append(e2.toString());
                }
            } else {
                stringBuffer.append("{}");
            }
            if (i + 1 >= arrayList.size()) continue;
            stringBuffer.append(" ");
        }
        stringBuffer.append("}");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "arrayListToString " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    public String stringArrayToString(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stringArrayToString ");
        }
        String string = null;
        if (object == null) {
            string = "{}";
        } else if (object instanceof List) {
            StringBuffer stringBuffer = new StringBuffer();
            List list = (List)object;
            for (int i = 0; i < list.size(); ++i) {
                string = list.get(i).toString();
                if (string.indexOf(" ") >= 0) {
                    if (!(string.startsWith("\"") || string.endsWith("\"") || string.startsWith("{") || string.endsWith("}"))) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "adding quotes to \"" + string + "\"");
                        }
                        stringBuffer.append("\"");
                        stringBuffer.append(string);
                        stringBuffer.append("\"");
                    } else {
                        stringBuffer.append(string);
                    }
                } else {
                    stringBuffer.append(string);
                }
                if (i >= list.size() - 1) continue;
                stringBuffer.append(";");
            }
            string = stringBuffer.toString();
        } else {
            string = object.toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stringArrayToString " + string);
        }
        return string;
    }

    public String integerArrayToString(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "integerArrayToString");
        }
        String string = null;
        if (object == null) {
            string = "{}";
        } else if (object instanceof List) {
            StringBuffer stringBuffer = new StringBuffer();
            List list = (List)object;
            for (int i = 0; i < list.size(); ++i) {
                stringBuffer.append(list.get(i).toString());
                if (i >= list.size() - 1) continue;
                stringBuffer.append(" ");
            }
            string = stringBuffer.toString();
        } else {
            string = object.toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "integerArrayToString " + string);
        }
        return string;
    }

    public String buildAdminCmdString(String string, String string2, String string3, String string4, String string5) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildAdminCmdString");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("$");
        stringBuffer.append(string);
        stringBuffer.append(" ");
        stringBuffer.append(string2);
        stringBuffer.append(" ");
        if (string3 != null && string3.length() > 0) {
            stringBuffer.append(string3);
            stringBuffer.append(" ");
        }
        if (string4 != null && string4.length() > 0 || string5 != null && string5.length() > 0) {
            stringBuffer.append(OPENOPTIONSYNTAX);
        }
        if (string4 != null && string4.length() > 0) {
            stringBuffer.append(string4);
            if (string5 != null) {
                stringBuffer.append(" ");
            }
        }
        if (string5 != null && string5.length() > 0) {
            stringBuffer.append(string5);
        }
        if (string4 != null && string4.length() > 0 || string5 != null && string5.length() > 0) {
            stringBuffer.append(CLOSEOPTIONSYNTAX);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildAdminCmdString - " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    public Object stringToObjectArray(String string, Class clazz) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stringToObjectArray");
        }
        Object object = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Class<?> clazz2 = null;
        if (!clazz.isArray()) {
            return new Object();
        }
        clazz2 = clazz.getComponentType();
        String string2 = string;
        if (string2.startsWith("{") && string2.endsWith("}")) {
            string2 = string2.substring(1, string2.length() - 1);
        }
        if (string2 != null) {
            Object object2;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "{} ", true);
            String string3 = null;
            int n = 0;
            StringBuffer stringBuffer = new StringBuffer();
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                if (string3.equals("{")) {
                    ++n;
                } else if (string3.equals("}")) {
                    --n;
                }
                stringBuffer.append(string3);
                if (stringBuffer.toString().startsWith("\"") && !string3.endsWith("\"")) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "buf to string:" + stringBuffer.toString());
                }
                if (n != 0) continue;
                object2 = stringBuffer.toString().trim();
                if (!((String)object2).equals("")) {
                    if (((String)object2).startsWith("\"") && ((String)object2).endsWith("\"") || ((String)object2).startsWith("{") && ((String)object2).endsWith("}")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "removing quotes from \"" + (String)object2 + "\"");
                        }
                        object2 = ((String)object2).substring(1, ((String)object2).length() - 1);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding " + (String)object2);
                    }
                    arrayList.add(object2);
                }
                stringBuffer = new StringBuffer();
            }
            object2 = HandlerRegistry.getHandler(clazz2);
            if (object2 != null) {
                object = Array.newInstance(clazz2, arrayList.size());
                for (int i = 0; i < arrayList.size(); ++i) {
                    try {
                        Array.set(object, i, object2.formValidObject((String)arrayList.get(i), clazz2, "jacl"));
                        continue;
                    }
                    catch (com.ibm.websphere.scripting.ScriptingException scriptingException) {
                        throw new ScriptingException(scriptingException.toString());
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stringToObjectArray - " + object.toString());
        }
        return object;
    }
}

