/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.scripting.AbstractShell;
import com.ibm.ws.scripting.AdminConfigClient;
import com.ibm.ws.scripting.AttrInfo;
import com.ibm.ws.scripting.ContainmentInfo;
import com.ibm.ws.scripting.ScriptingException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;

public class MetaInfoCache {
    private static TraceComponent tc = Tr.register(MetaInfoCache.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    private static MetaInfoCache _self = null;
    private AbstractShell _shell = null;
    private Hashtable containmentCache = null;
    private ConfigService configServiceProxy = null;
    private Hashtable typeToAttributeMap = null;
    private Hashtable flatAttributeMap = null;
    private Properties subtypeMap = null;
    private String[] supportedTypes = null;

    public static MetaInfoCache getInstance() {
        if (_self == null) {
            _self = new MetaInfoCache();
        }
        return _self;
    }

    public MetaInfoCache() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "MetaInfoCache");
        }
        _self = this;
        this.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "MetaInfoCache");
        }
    }

    private void init() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init");
        }
        this.configServiceProxy = AdminConfigClient.getConfigService();
        this.typeToAttributeMap = new Hashtable();
        this.flatAttributeMap = new Hashtable();
        this.containmentCache = new Hashtable();
        this.subtypeMap = new Properties();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public void setShell(AbstractShell abstractShell) {
        this._shell = abstractShell;
    }

    public void reconnect() throws AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reconnect");
        }
        this.containmentCache = null;
        this.typeToAttributeMap = null;
        this.flatAttributeMap = null;
        this.subtypeMap = null;
        this.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reconnect");
        }
    }

    public String[] getTypes() throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTypes");
        }
        if (this.supportedTypes == null) {
            this.supportedTypes = this.configServiceProxy.getSupportedConfigObjectTypes();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTypes");
        }
        return this.supportedTypes;
    }

    public String[] getParentTypes(String string) throws ScriptingException, AdminException, ConnectorException {
        ContainmentInfo containmentInfo;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getParentTypes - " + string);
        }
        if ((containmentInfo = (ContainmentInfo)this.containmentCache.get(string)) == null) {
            containmentInfo = this.updateContainmentCache(string);
        }
        if (containmentInfo == null) {
            this._shell.setAndThrowScriptingException("WASX7086E", "Unable to find relationship info for " + string, new Object[]{string});
        }
        String[] stringArray = containmentInfo.getParentTypes();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getParentTypes");
        }
        return stringArray;
    }

    public Properties getContentTypes(String string) throws ScriptingException, AdminException, ConnectorException {
        ContainmentInfo containmentInfo;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getContentTypes - " + string);
        }
        if ((containmentInfo = (ContainmentInfo)this.containmentCache.get(string)) == null) {
            containmentInfo = this.updateContainmentCache(string);
        }
        if (containmentInfo == null) {
            this._shell.setAndThrowScriptingException("WASX7086E", "Unable to find relationship info for " + string, new Object[]{string});
        }
        Properties properties = containmentInfo.getChildren();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getContentTypes");
        }
        return properties;
    }

    private ContainmentInfo updateContainmentCache(String string) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateContainmentCache - " + string);
        }
        AttributeList attributeList = this.configServiceProxy.getRelationshipsMetaInfo(string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "got back relationships metainfo - size " + (attributeList == null ? "null" : Integer.toString(attributeList.size())));
        }
        ContainmentInfo containmentInfo = new ContainmentInfo(string);
        block0: for (int i = 0; i < attributeList.size(); ++i) {
            Attribute attribute;
            int n;
            Attribute attribute2 = (Attribute)attributeList.get(i);
            AttributeList attributeList2 = (AttributeList)attribute2.getValue();
            String string2 = attribute2.getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "name of Attr is " + string2);
            }
            if (string2.equals("parent")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found a parent!");
                }
                for (n = 0; n < attributeList2.size(); ++n) {
                    attribute = (Attribute)attributeList2.get(n);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "name of sub attr is " + attribute.getName());
                    }
                    if (!attribute.getName().equals("_Attribute_MetaInfo_Type")) continue;
                    containmentInfo.addParentTypes((ArrayList)attribute.getValue());
                    continue block0;
                }
                continue;
            }
            for (n = 0; n < attributeList2.size(); ++n) {
                attribute = (Attribute)attributeList2.get(n);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "name of sub attr is " + attribute.getName());
                }
                if (!attribute.getName().equals("_Attribute_MetaInfo_Type")) continue;
                containmentInfo.addChild((String)attribute.getValue(), string2);
                if (!tc.isDebugEnabled()) continue block0;
                Tr.debug(tc, "val: " + attribute.getValue());
                continue block0;
            }
        }
        this.containmentCache.put(string, containmentInfo);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateContainmentCache");
        }
        return containmentInfo;
    }

    public void attrNameValidityCheck(String string, String[] stringArray) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "attrNameValidityCheck - " + string);
        }
        if (stringArray == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "attrNameValidityCheck - null");
            }
            return;
        }
        Vector vector = this.getFlatAttributeMap(string);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            boolean bl2 = false;
            for (int j = 0; j < vector.size(); ++j) {
                AttrInfo attrInfo = (AttrInfo)vector.get(j);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "current: " + string2 + "; matching with: " + attrInfo.getName());
                }
                if (!string2.equals(attrInfo.getName())) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(string2);
            bl = true;
        }
        if (bl) {
            this._shell.setAndThrowScriptingException("WASX7080E", "Invalid attributes specified.", new Object[]{string, stringBuffer.toString()});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "attrNameValidityCheck");
        }
    }

    private Hashtable getAttributeCacheForType(String string) throws ScriptingException, AdminException, ConnectorException {
        Cloneable cloneable;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributeCacheForType - " + string);
        }
        if (!this.typeToAttributeMap.containsKey(string)) {
            if (tc.isEntryEnabled()) {
                Tr.event(tc, "type " + string + " not in map; get meta info...");
            }
            cloneable = this.configServiceProxy.getAttributesMetaInfo(string);
            if (tc.isEntryEnabled()) {
                Tr.event(tc, "got metainfo for type " + string);
            }
            this.convertMetadataToAttrInfoCache(string, (AttributeList)cloneable);
        }
        cloneable = (Hashtable)this.typeToAttributeMap.get(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributeCacheForType");
        }
        return cloneable;
    }

    private void convertMetadataToAttrInfoCache(String string, AttributeList attributeList) throws ScriptingException, AdminException, ConnectorException {
        block12: {
            try {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "convertMetadataToAttrCacheInfo " + string);
                }
                Hashtable<String, AttrInfo> hashtable = new Hashtable<String, AttrInfo>();
                Vector<AttrInfo> vector = new Vector<AttrInfo>();
                if (attributeList == null) break block12;
                if (tc.isEntryEnabled()) {
                    Tr.event(tc, "Size of AttributeList is " + attributeList.size());
                }
                for (int i = 0; i < attributeList.size(); ++i) {
                    AttrInfo attrInfo;
                    block13: {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Dealing with attribute: " + ((Attribute)attributeList.get(i)).getName());
                        }
                        AttributeList attributeList2 = (AttributeList)((Attribute)attributeList.get(i)).getValue();
                        attrInfo = this.createAttrInfo(attributeList2);
                        if (tc.isEntryEnabled()) {
                            Tr.event(tc, "Created attr info for " + attrInfo.getName());
                        }
                        if (attrInfo.isObject()) {
                            try {
                                this.addEmbeddedInfo(attrInfo);
                            }
                            catch (Exception exception) {
                                if (!tc.isEntryEnabled()) break block13;
                                Tr.event(tc, "Caught exception adding embedded info.");
                            }
                        }
                    }
                    if (attrInfo.hasSubtypes() && !attrInfo.isReference()) {
                        this.mapSubtypes(string, attrInfo);
                    }
                    hashtable.put(attrInfo.getName(), attrInfo);
                    vector.add(attrInfo);
                }
                this.typeToAttributeMap.put(string, hashtable);
                this.flatAttributeMap.put(string, vector);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new ScriptingException(exception.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertmetadataToAttrCacheInfo");
        }
    }

    private void addEmbeddedInfo(AttrInfo attrInfo) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addEmbeddedInfo - " + attrInfo.getType());
        }
        AttributeList attributeList = null;
        if (this.flatAttributeMap.containsKey(attrInfo.getType())) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addEmbeddedInfo - already done");
            }
            return;
        }
        this.flatAttributeMap.put(attrInfo.getType(), "dummy");
        try {
            if (!attrInfo.getType().equals("Boolean")) {
                attributeList = this.configServiceProxy.getAttributesMetaInfo(attrInfo.getType());
            }
        }
        catch (Exception exception) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.event(tc, "got meta info for " + attrInfo.getType());
        }
        Vector<AttrInfo> vector = new Vector<AttrInfo>();
        if (!attrInfo.getType().equals("Boolean")) {
            for (int i = 0; i < attributeList.size(); ++i) {
                AttributeList attributeList2 = (AttributeList)((Attribute)attributeList.get(i)).getValue();
                AttrInfo attrInfo2 = this.createAttrInfo(attributeList2);
                if (tc.isEntryEnabled()) {
                    Tr.event(tc, "Created attr info for " + attrInfo2.getName());
                }
                if (attrInfo2.isObject()) {
                    this.addEmbeddedInfo(attrInfo2);
                }
                if (attrInfo2.hasSubtypes()) {
                    this.mapSubtypes(attrInfo.getType(), attrInfo2);
                }
                attrInfo.addContained(attrInfo2.getName(), attrInfo2);
                vector.add(attrInfo2);
            }
        }
        this.flatAttributeMap.put(attrInfo.getType(), vector);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addEmbeddedInfo - " + attrInfo.getType());
        }
    }

    private void mapSubtypes(String string, AttrInfo attrInfo) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapSubtypes - " + string);
        }
        ArrayList arrayList = attrInfo.getSubtypes();
        String string2 = attrInfo.getName();
        for (int i = 0; i < arrayList.size(); ++i) {
            Object object;
            String string3 = (String)arrayList.get(i) + ":" + string;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding to subtypeMap: " + string3 + " = " + string2);
            }
            if ((object = this.subtypeMap.get(string3)) != null) {
                if (object instanceof Vector) {
                    if (((Vector)object).contains(string2)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Existing key found with value " + (Vector)object);
                    }
                    ((Vector)object).addElement(string2);
                    this.subtypeMap.put(string3, object);
                    continue;
                }
                if (!(object instanceof String) || string2.equals(object)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Existing key found with value " + (String)object);
                }
                Vector<String> vector = new Vector<String>();
                vector.addElement((String)object);
                vector.addElement(string2);
                this.subtypeMap.put(string3, vector);
                continue;
            }
            this.subtypeMap.setProperty(string3, string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapSubtypes");
        }
    }

    private Object getSubtype(String string, String string2) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSubtype - " + string + " " + string2);
        }
        Vector vector = this.getFlatAttributeMap(string);
        Object object = this.subtypeMap.get(string2 + ":" + string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSubtype - " + object);
        }
        return object;
    }

    public void dumpTypeToAttributeCache() {
        Enumeration enumeration = this.typeToAttributeMap.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            System.out.println("Type: " + string);
            System.out.println("-------------------------------");
            System.out.println("");
            Hashtable hashtable = (Hashtable)this.typeToAttributeMap.get(string);
            if (hashtable == null) continue;
            Enumeration enumeration2 = hashtable.keys();
            while (enumeration2.hasMoreElements()) {
                this.dumpAttrInfo((AttrInfo)hashtable.get(enumeration2.nextElement()), 0);
            }
        }
    }

    private void dumpAttrInfo(AttrInfo attrInfo, int n) {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        stringBuffer.append(attrInfo.getName());
        stringBuffer.append("\t");
        stringBuffer.append(attrInfo.getType());
        stringBuffer.append("\t");
        Object object3 = attrInfo.defaultValue();
        stringBuffer.append(object3 != null ? attrInfo.defaultValue().toString() : "\t");
        stringBuffer.append("\t");
        stringBuffer.append(attrInfo.isObject());
        stringBuffer.append("\t");
        stringBuffer.append(attrInfo.isReference());
        stringBuffer.append("\t");
        stringBuffer.append(attrInfo.isCollection());
        Hashtable hashtable = attrInfo.enumInfo();
        if (hashtable != null) {
            stringBuffer.append("\n\t");
            object2 = hashtable.keys();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                stringBuffer.append((String)object);
                stringBuffer.append(":");
                stringBuffer.append(hashtable.get(object).toString());
                if (!object2.hasMoreElements()) continue;
                stringBuffer.append(", ");
            }
        }
        System.out.println(stringBuffer.toString());
        if (attrInfo.isObject()) {
            object2 = attrInfo.getContained();
            object = ((Hashtable)object2).keys();
            while (object.hasMoreElements()) {
                this.dumpAttrInfo((AttrInfo)((Hashtable)object2).get(object.nextElement()), n + 2);
            }
        }
    }

    public void dumpFlatAttrCache() {
        Enumeration enumeration = this.flatAttributeMap.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            System.out.println("Type: " + string);
            System.out.println("-------------------------------");
            System.out.println("");
            StringBuffer stringBuffer = new StringBuffer();
            Vector vector = (Vector)this.flatAttributeMap.get(string);
            for (int i = 0; i < vector.size(); ++i) {
                AttrInfo attrInfo = (AttrInfo)vector.get(i);
                stringBuffer.append(attrInfo.getName());
                if (i >= vector.size()) continue;
                stringBuffer.append(" ");
            }
            System.out.println(stringBuffer.toString());
        }
    }

    public void dumpContainmentCache() {
        Enumeration enumeration = this.containmentCache.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            System.out.println("Type: " + string);
            System.out.println("-------------------------------");
            System.out.println("");
        }
    }

    private AttrInfo createAttrInfo(AttributeList attributeList) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createAttrInfo");
        }
        String string = null;
        String string2 = null;
        boolean bl = false;
        boolean bl2 = false;
        Hashtable hashtable = null;
        Object object = null;
        boolean bl3 = false;
        boolean bl4 = false;
        List list = null;
        boolean bl5 = false;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        for (int i = 0; i < attributeList.size(); ++i) {
            Serializable serializable;
            String string6 = ((Attribute)attributeList.get(i)).getName();
            if (((Attribute)attributeList.get(i)).getName().equals("_Attribute_MetaInfo_Name")) {
                string = (String)((Attribute)attributeList.get(i)).getValue();
                continue;
            }
            if (((Attribute)attributeList.get(i)).getName().equals("_Attribute_MetaInfo_Type")) {
                string2 = (String)((Attribute)attributeList.get(i)).getValue();
                continue;
            }
            if (((Attribute)attributeList.get(i)).getName().equals("_Attribute_MetaInfo_Subtypes")) {
                bl4 = true;
                list = (List)((Attribute)attributeList.get(i)).getValue();
                continue;
            }
            if (((Attribute)attributeList.get(i)).getName().equals("_Attribute_MetaInfo_Default_Value")) {
                object = ((Attribute)attributeList.get(i)).getValue();
                continue;
            }
            if (((Attribute)attributeList.get(i)).getName().equals("_Attribute_MetaInfo_Is_Object")) {
                serializable = (Boolean)((Attribute)attributeList.get(i)).getValue();
                bl = (Boolean)serializable;
                continue;
            }
            if (((Attribute)attributeList.get(i)).getName().equals("_Attribute_MetaInfo_Is_Reference")) {
                serializable = (Boolean)((Attribute)attributeList.get(i)).getValue();
                bl2 = (Boolean)serializable;
                continue;
            }
            if (((Attribute)attributeList.get(i)).getName().equals("_Attribute_MetaInfo_Is_Collection")) {
                serializable = (Boolean)((Attribute)attributeList.get(i)).getValue();
                bl3 = (Boolean)serializable;
                continue;
            }
            if (((Attribute)attributeList.get(i)).getName().equals("_Attribute_MetaInfo_Enum_Info")) {
                serializable = (AttributeList)((Attribute)attributeList.get(i)).getValue();
                hashtable = this.createEnumInfo((AttributeList)serializable);
                continue;
            }
            if (((Attribute)attributeList.get(i)).getName().equals("_Attribute_MetaInfo_Is_Required")) {
                serializable = (Boolean)((Attribute)attributeList.get(i)).getValue();
                bl5 = (Boolean)serializable;
                continue;
            }
            if (((Attribute)attributeList.get(i)).getName().equals("_Attribute_MetaInfo_Start")) {
                string3 = (String)((Attribute)attributeList.get(i)).getValue();
                continue;
            }
            if (((Attribute)attributeList.get(i)).getName().equals("_Attribute_MetaInfo_Removed")) {
                string5 = (String)((Attribute)attributeList.get(i)).getValue();
                continue;
            }
            if (!((Attribute)attributeList.get(i)).getName().equals("_Attribute_MetaInfo_Deprecated")) continue;
            string4 = (String)((Attribute)attributeList.get(i)).getValue();
        }
        AttrInfo attrInfo = new AttrInfo(string, string2, bl, bl2, object, hashtable, bl3, bl4, bl5, string3, string5, string4);
        if (bl4) {
            attrInfo.addSubtypes(list);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createAttrInfo: " + string + "; type: " + string2);
        }
        return attrInfo;
    }

    private Hashtable createEnumInfo(AttributeList attributeList) throws ScriptingException {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        try {
            for (int i = 0; i < attributeList.size(); ++i) {
                String string = ((Attribute)attributeList.get(i)).getName();
                Integer n = (Integer)((Attribute)attributeList.get(i)).getValue();
                hashtable.put(string, n);
            }
        }
        catch (Exception exception) {
            this._shell.setAndThrowScriptingException("WASX7081E", "Error obtaining enum information.", new Object[]{exception.toString()});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createEnumInfo");
        }
        return hashtable;
    }

    public String[] getAttributeNamesForType(String string) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributeNamesForType " + string);
        }
        Hashtable hashtable = this.getAttributeCacheForType(string);
        String[] stringArray = new String[hashtable.size()];
        int n = 0;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            StringBuffer stringBuffer = new StringBuffer();
            AttrInfo attrInfo = (AttrInfo)hashtable.get((String)enumeration.nextElement());
            if (attrInfo.getRemoved() != null && !attrInfo.getRemoved().equals("")) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "attribute " + attrInfo.getName() + " tagged as removed. Skipping this attribute");
                continue;
            }
            stringBuffer.append(attrInfo.getName());
            stringBuffer.append(" ");
            stringBuffer.append(attrInfo.getDecoratedType());
            stringArray[n] = stringBuffer.toString();
            ++n;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributeNamesForType " + string);
        }
        return stringArray;
    }

    public boolean isCollectionReln(String string, String string2) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isCollectionReln : " + string + " " + string2);
        }
        Vector vector = this.getFlatAttributeMap(string);
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            if (!string2.equals(((AttrInfo)vector.get(i)).getName())) continue;
            if (((AttrInfo)vector.get(i)).isCollection()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string2 + " is a collection.");
                }
                bl = true;
                break;
            }
            if (!tc.isDebugEnabled()) break;
            Tr.debug(tc, string2 + " is not a collection.");
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isCollectionReln");
        }
        return bl;
    }

    public String findAttrNameForType(String string, String string2) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findAttrNameForType : " + string2 + " in " + string);
        }
        Vector vector = this.getFlatAttributeMap(string);
        String string3 = null;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            for (int i = 0; i < vector.size(); ++i) {
                if (!string2.equals(((AttrInfo)vector.get(i)).getType())) continue;
                if (string3 != null) {
                    if (!bl) {
                        stringBuffer.append(string3);
                        stringBuffer.append(" ");
                    }
                    bl = true;
                    stringBuffer.append(((AttrInfo)vector.get(i)).getName());
                    stringBuffer.append(" ");
                }
                string3 = ((AttrInfo)vector.get(i)).getName();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ScriptingException(exception.toString());
        }
        if (string3 == null) {
            Object object = this.getSubtype(string, string2);
            if (object instanceof Vector) {
                if (((Vector)object).size() > 1) {
                    bl = true;
                }
            } else if (object instanceof String) {
                string3 = (String)object;
            }
        }
        if (bl) {
            this._shell.setAndThrowScriptingException("WASX7082E", "Found ambiguous type in the model.", new Object[]{string, string2, stringBuffer.toString()});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findAttrNameForType - " + string3);
        }
        return string3;
    }

    public String findContentNameForType(String string, String string2) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findContentNameForType : " + string2 + " in " + string);
        }
        String string3 = null;
        ContainmentInfo containmentInfo = (ContainmentInfo)this.containmentCache.get(string);
        if (containmentInfo == null) {
            containmentInfo = this.updateContainmentCache(string);
        }
        if (containmentInfo == null) {
            this._shell.setAndThrowScriptingException("WASX7086E", "Unable to find relationship info for " + string, new Object[]{string});
        }
        Properties properties = containmentInfo.getChildren();
        string3 = properties.getProperty(string2);
        if (tc.isDebugEnabled()) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string4 = (String)enumeration.nextElement();
                Tr.debug(tc, "Propnames: " + string4 + "; value: " + properties.getProperty(string4));
            }
            Tr.debug(tc, "memberType is " + string2);
        }
        if (string3 == null) {
            string3 = this.findAttrNameForType(string, string2);
        }
        if (string3 == null) {
            this._shell.setAndThrowScriptingException("WASX7129E", "Cannot create objects of type " + string2 + " in parents of type " + string, new Object[]{string2, string});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findContentNameForType - " + string3);
        }
        return string3;
    }

    public Vector getFlatAttributeMap(String string) throws ScriptingException, AdminException, ConnectorException {
        Vector vector;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFlatAttributeMap - " + string);
        }
        if ((vector = (Vector)this.flatAttributeMap.get(string)) == null || vector.size() == 0) {
            Hashtable hashtable = this.getAttributeCacheForType(string);
            vector = (Vector)this.flatAttributeMap.get(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFlatAttributeMap");
        }
        return vector;
    }

    public void getCorrectError(String string, String string2, String string3) throws ScriptingException, AdminException, ConnectorException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCorrectError : " + string2 + " in " + string + " with " + string3);
        }
        String string4 = null;
        boolean bl = false;
        boolean bl2 = false;
        ContainmentInfo containmentInfo = (ContainmentInfo)this.containmentCache.get(string);
        if (containmentInfo == null) {
            containmentInfo = this.updateContainmentCache(string);
        }
        if (containmentInfo == null) {
            this._shell.setAndThrowScriptingException("WASX7086E", "Unable to find relationship info for " + string, new Object[]{string});
        }
        Properties properties = containmentInfo.getChildren();
        string4 = properties.getProperty(string2);
        if (tc.isDebugEnabled()) {
            object = properties.propertyNames();
            while (object.hasMoreElements()) {
                String string5 = (String)object.nextElement();
                Tr.debug(tc, "Propnames: " + string5 + "; value: " + properties.getProperty(string5));
            }
            Tr.debug(tc, "type is " + string4);
        }
        if (string4 == null) {
            object = this.getFlatAttributeMap(string);
            block1: for (int i = 0; i < ((Vector)object).size(); ++i) {
                AttrInfo attrInfo = (AttrInfo)((Vector)object).get(i);
                if (!string3.equals(attrInfo.getName())) continue;
                bl2 = true;
                ArrayList arrayList = attrInfo.getSubtypes();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "subtypes are " + arrayList);
                }
                if (arrayList == null) {
                    String string6 = attrInfo.getType();
                    if (!string2.equals(string6)) continue;
                    bl = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "correctType is " + string6);
                    }
                    break;
                }
                for (int j = 0; j < arrayList.size(); ++j) {
                    if (!string2.equals(arrayList.get(j))) continue;
                    bl = true;
                    if (!tc.isDebugEnabled()) continue block1;
                    Tr.debug(tc, "correct subtype is " + arrayList.get(j));
                    continue block1;
                }
            }
        } else {
            bl = true;
            bl2 = true;
        }
        if (!bl && bl2) {
            this._shell.setAndThrowScriptingException("WASX7129E", "Cannot create objects of type " + string2 + " in parents of type " + string, new Object[]{string2, string});
        }
        if (!bl2) {
            this._shell.setAndThrowScriptingException("WASX7080E", "Invalid attributes specified.", new Object[]{string, string3});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCorrectError");
        }
    }
}

