/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.scripting.ConfigHelper;
import com.ibm.ws.scripting.ScriptingException;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class ObjectNameHelper {
    private static TraceComponent tc = Tr.register(ConfigHelper.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    private static ResourceBundle bundle = ResourceBundle.getBundle("com.ibm.ws.scripting.resources.wscpMessage", Locale.getDefault());
    private static String DOMAIN = "WebSphere";

    public static String getListingName(ObjectName objectName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getListingName");
        }
        String string = null;
        if (objectName != null) {
            String string2 = objectName.getKeyProperty("_Websphere_Config_Data_Display_Name");
            String string3 = objectName.getKeyProperty("_Websphere_Config_Data_Id");
            string = string2 != null ? string2 + "(" + string3 + ")" : "(" + string3 + ")";
            if (string.indexOf(" ") >= 0) {
                string = "\"" + string + "\"";
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getListingName");
        }
        return string;
    }

    public static Hashtable parseObjectIdString(String string) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseObjectIdString: " + string);
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (string != null) {
            if (string.startsWith("\"") && string.endsWith("\"")) {
                string = string.substring(1, string.length() - 1);
            }
            String string2 = null;
            String string3 = null;
            if (!string.endsWith(")")) {
                throw new ScriptingException(ObjectNameHelper.getFormattedMessage("WASX7077E", "incomplete config id", new Object[]{string}));
            }
            int n = string.lastIndexOf("(");
            if (n < 0) {
                throw new ScriptingException(ObjectNameHelper.getFormattedMessage("WASX7078E", "missing config id", new Object[]{string}));
            }
            string3 = string.substring(n + 1, string.length() - 1);
            if (n > 0) {
                string2 = string.substring(0, n);
            }
            hashtable.put("_Websphere_Config_Data_Id", string3);
            if (string2 != null) {
                hashtable.put("_Websphere_Config_Data_Display_Name", string2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseObjectIdString:");
        }
        return hashtable;
    }

    public static ObjectName stringToObjectName(String string) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stringToObjectName: " + string);
        }
        ObjectName objectName = null;
        Hashtable hashtable = ObjectNameHelper.parseObjectIdString(string);
        if (hashtable.size() > 0) {
            try {
                objectName = new ObjectName(DOMAIN, hashtable);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                throw new ScriptingException(ObjectNameHelper.getFormattedMessage("MALFORMED_OBJECT_NAME", "Malformed object name", new Object[]{hashtable.toString()}));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stringToObjectName:");
        }
        return objectName;
    }

    public static ObjectName makeObjectName(String string) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "makeObjectName");
        }
        ObjectName objectName = null;
        try {
            if (string == null || string.trim().equals("")) {
                throw new ScriptingException(ObjectNameHelper.getFormattedMessage("MALFORMED_OBJECT_NAME", "Malformed object name", new Object[]{string}));
            }
            if (string.startsWith("\"") && string.endsWith("\"")) {
                string = string.substring(1, string.length() - 1);
            }
            if (string != null && string.indexOf("=") > 0) {
                if (string.indexOf(":") < 0) {
                    string = DOMAIN + ":" + string;
                }
                objectName = new ObjectName(string);
            } else {
                objectName = ObjectNameHelper.stringToObjectName(string);
            }
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new ScriptingException(ObjectNameHelper.getFormattedMessage("MALFORMED_OBJECT_NAME", "Malformed object name", new Object[]{string}));
        }
        catch (Exception exception) {
            throw new ScriptingException(exception.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "makeObjectName");
        }
        return objectName;
    }

    public static String getFormattedMessage(String string, String string2, Object[] objectArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFormattedMessage");
        }
        if (string == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getFormattedMessage - default");
            }
            return string2;
        }
        try {
            String string3 = bundle.getString(string);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getFormattedMessage");
            }
            return MessageFormat.format(string3, objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getFormattedMessage - default");
            }
            return MessageFormat.format(string2, objectArray);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getFormattedMessage - default");
            }
            return string2;
        }
    }
}

