/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.scripting.AbstractShell;
import com.ibm.ws.scripting.AdminConfigClient;
import com.ibm.ws.scripting.AdminControlClient;
import com.ibm.ws.scripting.ConfigHelper;
import com.ibm.ws.scripting.ScriptingException;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.ObjectName;

public class StopServerCommand {
    private static TraceComponent tc = Tr.register(StopServerCommand.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    private static final String stopAction = "stop";
    private static final String stopImmediateAction = "stopImmediate";
    private static final String terminateAction = "terminate";
    private static final int MAX_WAIT = 1800000;
    private AbstractShell _shell = null;
    private AdminClient _client = null;
    private ConfigService cfgService = null;
    private AdminConfigClient cfgClient = null;
    private AdminControlClient ctrlClient = null;
    private ConfigHelper cfgHelper = null;
    private ResourceBundle _bundle = null;
    private String serverName = null;
    private String nodeName = null;
    private String domain = null;
    private boolean immediate = false;
    private boolean terminate = false;
    private String connectedProcessType = null;
    private boolean isOverload = false;
    private int statusTimeout = 0;
    private Integer statusPort = null;
    private ServerSocket statusSocket = null;
    private NotificationFilterSupport myFilter = null;

    public StopServerCommand(AdminClient adminClient, AbstractShell abstractShell, AdminControlClient adminControlClient) throws ScriptingException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "StopServerCommand");
        }
        this._client = adminClient;
        this._shell = abstractShell;
        this.cfgService = AdminConfigClient.getConfigService();
        this.cfgClient = AdminConfigClient.getInstance();
        this.ctrlClient = adminControlClient;
        this.cfgHelper = this.cfgClient.getConfigHelper();
        this._bundle = this._shell.getBundle();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "StopServerCommand");
        }
    }

    public void setServerName(String string) {
        this.serverName = string;
    }

    public void setNodeName(String string) {
        this.nodeName = string;
        if (!(this.nodeName == null || this.nodeName.indexOf(" ") < 0 || this.nodeName.startsWith("\"") || this.nodeName.endsWith("\"") || this.nodeName.startsWith("{") || this.nodeName.endsWith("}"))) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "adding quotes to \"" + this.nodeName + "\"");
            }
            this.nodeName = "\"" + this.nodeName + "\"";
        }
    }

    public void setImmediateMode(String string) {
        if (string != null && string.equalsIgnoreCase("immediate")) {
            this.immediate = true;
        }
    }

    public void setActionMode(String string) {
        if (string != null) {
            if (string.equalsIgnoreCase("immediate")) {
                this.immediate = true;
            } else if (string.equalsIgnoreCase(terminateAction)) {
                this.terminate = true;
            }
        }
    }

    public void setConnectedProcessType(String string) {
        this.connectedProcessType = string;
    }

    public void setDomain(String string) {
        this.domain = string;
    }

    public void setIsOverload(boolean bl) {
        this.isOverload = bl;
    }

    public Object invoke() throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke - " + this.serverName + " " + this.nodeName + " " + this.isOverload);
        }
        String string = null;
        int n = 0;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "invoke stop server using connected type " + this.connectedProcessType);
        }
        try {
            ObjectName objectName;
            String string2;
            if (this.terminate) {
                String string3;
                if ("UnManagedProcess".equals(this.connectedProcessType) || "ManagedProcess".equals(this.connectedProcessType) || this.connectedProcessType.equals("unknown")) {
                    this._shell.setAndThrowScriptingException("WASX7254E", "stopServer action not supported when process type is " + this.connectedProcessType, new Object[]{"stopServer", this.connectedProcessType});
                }
                if ("DeploymentManager".equals(this.connectedProcessType) || "NodeAgent".equals(this.connectedProcessType)) {
                    string3 = this.ctrlClient.completeObjectName(this.domain + ":node=" + this.nodeName + ",type=NodeAgent,process=nodeagent,*");
                    if (string3 == null || string3.trim().length() == 0) {
                        this._shell.setAndThrowScriptingException("WASX7346E", "stopServer action not supported when nodeAgent cannot be located for server " + this.serverName + " of " + "ManagedProcess", new Object[]{this.serverName, "ManagedProcess"});
                    } else {
                        ObjectName objectName2 = this.ctrlClient.makeObjectName(string3);
                        String string4 = objectName2.getKeyProperty("process");
                        if (string4.equals(this.serverName)) {
                            this._shell.setAndThrowScriptingException("WASX7480E", "stopServer terminate action only supported for Managed Processes", new Object[]{terminateAction, "NodeAgent"});
                        }
                    }
                }
                string3 = string = this.stopManagedProcess(this.nodeName, null, terminateAction);
                return string3;
            }
            boolean bl = this.isOverload;
            while (true) {
                String string5 = "";
                if (this.serverName.indexOf(",") < 0) {
                    if (this.nodeName != null && this.nodeName.trim().length() != 0) {
                        string5 = "node=" + this.nodeName + ",";
                    }
                    string5 = string5 + "type=Server,process=" + this.serverName + ",*";
                } else {
                    string5 = string5 + this.serverName;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "usedName is " + string5);
                }
                string2 = this.ctrlClient.completeObjectName(string5);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "oName is " + string2);
                }
                if (string2 != null && string2.length() != 0) break;
                boolean bl2 = true;
                if (bl) {
                    bl = false;
                    if (this.nodeName.equalsIgnoreCase("immediate")) {
                        this.immediate = true;
                        this.nodeName = null;
                        bl2 = false;
                    }
                }
                if (!bl2) continue;
                this._shell.setAndThrowScriptingException("WASX7252E", "Cannot find server " + this.serverName, new Object[]{this.serverName});
            }
            String string6 = null;
            string6 = this.immediate ? stopImmediateAction : stopAction;
            String string7 = this.ctrlClient.getAttribute(string2, "processType");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "processType is " + string7);
            }
            if ((objectName = this.ctrlClient.makeObjectName(string2)) != null) {
                this.nodeName = objectName.getKeyProperty("node");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeName is " + this.nodeName);
            }
            if (!"ManagedProcess".equals(string7)) {
                this.statusPort = this.getFreePort();
                boolean bl3 = this.sendWaitStop(objectName, string6);
                String string8 = null;
                if (!string6.equals(stopImmediateAction)) {
                    string8 = this._shell.getFormattedMessage("WASX7337I", new Object[]{this.serverName}, "Invoked stop for server \"" + this.serverName + ";\" Waiting for stop completion.");
                    System.out.println(string8);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "needToWaitForCallback " + bl3);
                }
                n = bl3 ? this.waitForServer() : 0;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "got status " + n);
                }
                if (n == 0) {
                    string8 = this._shell.getFormattedMessage("WASX7264I", new Object[]{this.serverName, this.nodeName}, "Stop completed for server " + this.serverName + " on node " + this.nodeName);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Stop OK for server " + this.serverName);
                    }
                } else {
                    string8 = this._shell.getFormattedMessage("WASX7265W", new Object[]{this.serverName, this.nodeName}, "Stop not completed for server " + this.serverName + " on node " + this.nodeName + ".  The stop process may have timed out.");
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Stop not complete for server " + this.serverName + ", possibly timeout.");
                    }
                }
                string = string8;
            } else if (objectName != null) {
                string = this.stopManagedProcess(this.nodeName, string2, string6);
            }
        }
        catch (ScriptingException scriptingException) {
            throw scriptingException;
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            throw new ScriptingException(exception.toString());
        }
        finally {
            if (this.statusSocket != null) {
                try {
                    this.statusSocket.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke - " + this.serverName);
        }
        return string;
    }

    private Integer getFreePort() throws SocketException, IOException {
        Integer n = null;
        this.statusSocket = new ServerSocket(0);
        this.statusSocket.setSoTimeout(this.statusTimeout);
        n = new Integer(this.statusSocket.getLocalPort());
        return n;
    }

    private int waitForServer() {
        Socket socket = null;
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (!bl && !bl2) {
            try {
                socket = this.statusSocket.accept();
            }
            catch (InterruptedIOException interruptedIOException) {
                socket = null;
                bl2 = true;
            }
            catch (IOException iOException) {
                Tr.audit(tc, "WASX7338E", new Object[]{this.serverName, iOException.toString()});
                socket = null;
                bl = true;
                n = -10;
            }
            if (socket == null || (n = this.getStatus(socket)) != 0) continue;
            bl = true;
        }
        if (!bl) {
            n = -11;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int getStatus(Socket socket) {
        FilterInputStream filterInputStream;
        InputStream inputStream;
        int n;
        block10: {
            n = -10;
            inputStream = null;
            filterInputStream = null;
            inputStream = socket.getInputStream();
            filterInputStream = new DataInputStream(inputStream);
            n = ((DataInputStream)filterInputStream).readInt();
            try {
                filterInputStream.close();
                inputStream.close();
                break block10;
            }
            catch (IOException iOException) {
                Tr.audit(tc, "WASX7338E", new Object[]{this.serverName, iOException.toString()});
            }
            break block10;
            catch (IOException iOException) {
                int n2;
                try {
                    Tr.audit(tc, "WASX7338E", new Object[]{this.serverName, iOException.toString()});
                    n2 = -10;
                }
                catch (Throwable throwable) {
                    try {
                        filterInputStream.close();
                        inputStream.close();
                    }
                    catch (IOException iOException2) {
                        Tr.audit(tc, "WASX7338E", new Object[]{this.serverName, iOException2.toString()});
                    }
                    filterInputStream = null;
                    inputStream = null;
                    throw throwable;
                }
                try {
                    filterInputStream.close();
                    inputStream.close();
                }
                catch (IOException iOException3) {
                    Tr.audit(tc, "WASX7338E", new Object[]{this.serverName, iOException3.toString()});
                }
                filterInputStream = null;
                inputStream = null;
                return n2;
            }
        }
        filterInputStream = null;
        inputStream = null;
        return n;
    }

    private boolean sendWaitStop(ObjectName objectName, String string) throws Exception {
        boolean bl = true;
        boolean bl2 = false;
        String[] stringArray = new String[]{"java.lang.Boolean", "java.lang.Integer"};
        Object[] objectArray = new Object[]{new Boolean(true), this.statusPort};
        try {
            if (string.equals(stopImmediateAction)) {
                String string2 = objectName.toString();
                this.ctrlClient.invoke(string2, string);
                bl = false;
            } else {
                this.ctrlClient.invoke_jmx(objectName, string, objectArray, stringArray);
            }
        }
        catch (Exception exception) {
            try {
                this.ctrlClient.isAlive();
                bl2 = true;
                throw exception;
            }
            catch (Exception exception2) {
                if (bl2) {
                    throw exception2;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String stopManagedProcess(String string, String string2, String string3) throws Exception {
        String string4;
        block20: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "stopManagedProcess: nodeName " + string + " action " + string3);
            }
            ObjectName objectName = null;
            string4 = null;
            try {
                String string5;
                block22: {
                    block21: {
                        String string6 = this.ctrlClient.completeObjectName(this.domain + ":node=" + string + ",type=NodeAgent,process=nodeagent,*");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "naName is " + string6);
                        }
                        if (string6 == null || string6.trim().length() == 0) {
                            this._shell.setAndThrowScriptingException("WASX7346E", "stopServer action not supported when nodeAgent cannot be located for server " + this.serverName + " of " + "ManagedProcess" + " process type", new Object[]{this.serverName, "ManagedProcess"});
                        }
                        objectName = new ObjectName(string6);
                        this.myFilter = new NotificationFilterSupport();
                        this.myFilter.enableType("websphere.process.stopped");
                        this.myFilter.enableType("websphere.process.failed");
                        this.myFilter.enableType("websphere.process.not.monitored");
                        this._client.addNotificationListener(objectName, this.ctrlClient, (NotificationFilter)this.myFilter, null);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "About to invoke stopServer " + string3 + " for server " + this.serverName);
                        }
                        if (this.terminate) {
                            this.ctrlClient.invoke(string6, string3, this.serverName);
                        } else {
                            this.ctrlClient.invoke(string2, string3);
                        }
                        string5 = this._shell.getFormattedMessage("WASX7337I", new Object[]{this.serverName}, "Invoked stop for server \"" + this.serverName + ";\" Waiting for stop completion.");
                        System.out.println(string5);
                        Vector<String> vector = new Vector<String>();
                        vector.addElement("websphere.process.stopped");
                        vector.addElement("websphere.process.failed");
                        vector.addElement("websphere.process.not.monitored");
                        boolean bl = this.ctrlClient.waitForCompletion(vector, 1800000);
                        if (!bl) break block21;
                        if (this.ctrlClient.isProcessMonitored()) {
                            string5 = this._shell.getFormattedMessage("WASX7264I", new Object[]{this.serverName, string}, "Stop completed for server " + this.serverName + " on node " + string);
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, "Stop OK for server " + this.serverName);
                            }
                            break block22;
                        } else {
                            string5 = this._shell.getFormattedMessage("WASX7443I", new Object[]{this.serverName, string}, "Server " + this.serverName + " on node " + string + " is not being monitored. Please verify that the server has stopped before continuing.");
                        }
                        break block22;
                    }
                    string5 = this._shell.getFormattedMessage("WASX7265W", new Object[]{this.serverName, string}, "Stop not completed for server " + this.serverName + " on node " + string + ".  The stop process may have timed out.");
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Server stop not complete; possibly timed out.");
                    }
                }
                string4 = string5;
                if (objectName == null) break block20;
            }
            catch (Exception exception) {
                try {
                    throw exception;
                }
                catch (Throwable throwable) {
                    if (objectName == null) throw throwable;
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "removing notif list. in finally");
                        }
                        this._client.removeNotificationListener(objectName, this.ctrlClient);
                        throw throwable;
                    }
                    catch (Exception exception2) {
                        this._shell.setLastException(exception2);
                        throw new ScriptingException(exception2.toString());
                    }
                }
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "removing notif list. in finally");
                }
                this._client.removeNotificationListener(objectName, this.ctrlClient);
            }
            catch (Exception exception) {
                this._shell.setLastException(exception);
                throw new ScriptingException(exception.toString());
            }
        }
        if (!tc.isEntryEnabled()) return string4;
        Tr.exit(tc, "stopManagedProcess");
        return string4;
    }
}

