/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting.adminCommand;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandStep;
import com.ibm.websphere.management.cmdframework.TaskCommand;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandStepMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.ParameterMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.scripting.StringHandler;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.scripting.AbstractShell;
import com.ibm.ws.scripting.AdminConfigClient;
import com.ibm.ws.scripting.DefaultStringHandler;
import com.ibm.ws.scripting.ExceptionSupport;
import com.ibm.ws.scripting.HandlerRegistry;
import com.ibm.ws.scripting.LanguageUtilities;
import com.ibm.ws.scripting.ScriptingException;
import com.ibm.ws.scripting.adminCommand.AdminCmd;
import com.ibm.ws.scripting.adminCommand.AdminCmdClient;
import com.ibm.ws.scripting.adminCommand.AdminCmdHelp;
import com.ibm.ws.scripting.adminCommand.AdminCmdInteractiveStepsPrompt;
import com.ibm.ws.scripting.adminCommand.AdminCmdInteractiveTableStepsPrompt;
import com.ibm.ws.scripting.adminCommand.AdminCmdScriptGenerator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;
import org.eclipse.emf.common.util.EList;

public class AdminCmdController
extends AdminCmd {
    public static final String REQUIRED_NOTATION = "*";
    private static TraceComponent tc = Tr.register(AdminCmdController.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    protected LanguageUtilities _langutils;
    private static String select;
    private static String finish;
    private static String cancel;
    private static String edit;
    private static String selectSelection;
    private static String finishSelection;
    private static String cancelSelection;
    private static String editSelection;
    private StringHandler _handler;
    private AbstractShell _shell;
    private AdminCmdClient _adminCmdClient;
    private AdminCmdHelp _adminCmdHelp;
    private AdminCmdScriptGenerator _adminCmdScriptGen;

    public AdminCmdController(AdminCmdClient adminCmdClient) throws ScriptingException {
        this._adminCmdClient = adminCmdClient;
        this._shell = this._adminCmdClient.getShell();
        this._handler = new DefaultStringHandler(this._shell);
        this._langutils = this._shell.getLangUtils();
        this._adminCmdHelp = new AdminCmdHelp(this._adminCmdClient);
        this._adminCmdScriptGen = new AdminCmdScriptGenerator(this._adminCmdClient.getShell().getLang());
        select = this._shell.getFormattedMessage("ADMINTASK_SELECT_HOTKEY", new Object[0], "S");
        finish = this._shell.getFormattedMessage("ADMINTASK_FINISH_HOTKEY", new Object[0], "F");
        cancel = this._shell.getFormattedMessage("ADMINTASK_CANCEL_HOTKEY", new Object[0], "C");
        edit = this._shell.getFormattedMessage("ADMINTASK_EDIT_HOTKEY", new Object[0], "E");
        selectSelection = this._shell.getFormattedMessage("ADMINTASK_SELECT_SELECTION", new Object[0], "S (Select");
        finishSelection = this._shell.getFormattedMessage("ADMINTASK_FINISH_SELECTION", new Object[0], "F (Finish");
        cancelSelection = this._shell.getFormattedMessage("ADMINTASK_CANCEL_SELECTION", new Object[0], "C (Cancel)");
        editSelection = this._shell.getFormattedMessage("ADMINTASK_EDIT_SELECTION", new Object[0], "E (Edit)");
    }

    public AbstractShell getShell() {
        return this._shell;
    }

    public StringHandler getHandler() {
        return this._handler;
    }

    public String processCmd(String string, Object[] objectArray) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processCmd", new Object[]{string, objectArray});
        }
        AdminCommand adminCommand = null;
        boolean bl = true;
        String string2 = null;
        adminCommand = this._adminCmdClient.getCommandMgr().createCommand(string);
        AdminConfigClient adminConfigClient = AdminConfigClient.getInstance();
        if (adminConfigClient != null) {
            adminCommand.setConfigSession(adminConfigClient.getCurrentSession());
        }
        adminCommand.setLocale(Locale.getDefault());
        try {
            CommandMetadata commandMetadata = adminCommand.getCommandMetadata();
            boolean bl2 = false;
            if (objectArray != null) {
                ArgsParseResult argsParseResult = this.parseArgs(commandMetadata, objectArray);
                String string3 = argsParseResult.targetObj;
                Hashtable hashtable = argsParseResult.optionTable;
                if (hashtable != null && hashtable.containsKey("interactive")) {
                    hashtable.remove("interactive");
                    bl2 = true;
                }
                if (string3 != null) {
                    this.processTargetObject(adminCommand, commandMetadata, string3);
                }
                if (hashtable != null && hashtable.size() > 0) {
                    this.processOptions(adminCommand, commandMetadata, hashtable);
                }
                if (bl2) {
                    bl = this.processInteractive(adminCommand, commandMetadata);
                }
            }
        }
        catch (Throwable throwable) {
            this._shell.setLastException((Exception)throwable);
            throw new ScriptingException(throwable.toString());
        }
        if (bl) {
            string2 = this.executeCmd(adminCommand);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processCmd - " + string2);
        }
        return string2;
    }

    private ArgsParseResult parseArgs(CommandMetadata commandMetadata, Object[] objectArray) throws Throwable {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseArgs", new Object[]{commandMetadata, objectArray});
        }
        String string = null;
        Hashtable hashtable = null;
        Hashtable<Object, String> hashtable2 = new Hashtable<Object, String>();
        String string2 = null;
        String string3 = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "arg length: " + objectArray.length);
        }
        if (objectArray.length > 1) {
            string = (String)objectArray[0];
            string3 = objectArray[1].getClass().getName();
            string2 = !string3.equals("java.lang.String") ? this._langutils.objectArrayToString((Object[])objectArray[1]) : objectArray[1].toString();
            hashtable = this._langutils.optionsToHashtable(string2);
            object2 = hashtable.keys();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                if (((String)object).toLowerCase().indexOf("password") != -1 || ((String)object).toLowerCase().indexOf("pwd") != -1) {
                    hashtable2.put(object, "*****");
                    continue;
                }
                hashtable2.put(object, (String)hashtable.get(object));
            }
        } else if (objectArray.length == 1) {
            int n = this.getTargetObjectRequired(commandMetadata);
            string3 = objectArray[0].getClass().getName();
            string2 = !string3.equals("java.lang.String") ? this._langutils.objectArrayToString((Object[])objectArray[0]) : objectArray[0].toString();
            try {
                hashtable = this._langutils.optionsToHashtable(string2);
                object = hashtable.keys();
                while (object.hasMoreElements()) {
                    String string4 = (String)object.nextElement();
                    if (string4.toLowerCase().indexOf("password") != -1 || string4.toLowerCase().indexOf("pwd") != -1) {
                        hashtable2.put(string4, "*****");
                        continue;
                    }
                    hashtable2.put(string4, (String)hashtable.get(string4));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                hashtable = null;
                if (n != 2) {
                    string = (String)objectArray[0];
                }
                this._shell.setAndThrowScriptingException("WASX8009E", "Invalid argument: " + objectArray[0], new Object[]{objectArray[0]});
            }
        }
        object2 = new ArgsParseResult();
        object = new ArgsParseResult();
        ((ArgsParseResult)object2).targetObj = string;
        ((ArgsParseResult)object2).optionTable = hashtable;
        ((ArgsParseResult)object).targetObj = string;
        ((ArgsParseResult)object).optionTable = hashtable2;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseArgs - " + ((ArgsParseResult)object).targetObj + " " + ((ArgsParseResult)object).optionTable);
        }
        return object2;
    }

    private void processTargetObject(AdminCommand adminCommand, CommandMetadata commandMetadata, String string) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processTargetObject", new Object[]{string});
        }
        Object object = this.formValidObject(commandMetadata.getTargetObjectType(), string);
        adminCommand.setTargetObject(object);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processTargetObject");
        }
    }

    private void processOptions(AdminCommand adminCommand, CommandMetadata commandMetadata, Hashtable hashtable) throws Throwable {
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.toLowerCase().indexOf("password") != -1 || string.toLowerCase().indexOf("pwd") != -1) {
                hashtable2.put(string, "*****");
                continue;
            }
            hashtable2.put(string, (String)hashtable.get(string));
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processOptions", new Object[]{hashtable2});
        }
        this.processParameters(adminCommand, commandMetadata, hashtable);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "optionProps - " + hashtable);
        }
        if (!hashtable.isEmpty()) {
            if (commandMetadata instanceof TaskCommandMetadata) {
                this.processSteps((TaskCommand)adminCommand, hashtable, false);
            } else {
                this._shell.setAndThrowScriptingException("WASX8009E", "Invalid parameter: " + hashtable, new Object[]{hashtable});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processOptions");
        }
    }

    private void processParameters(AdminCommand adminCommand, CommandMetadata commandMetadata, Hashtable hashtable) throws Throwable {
        Object object;
        Object object2;
        Hashtable<Object, String> hashtable2 = new Hashtable<Object, String>();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            if (((String)object2).toLowerCase().indexOf("password") != -1 || ((String)object2).toLowerCase().indexOf("pwd") != -1) {
                hashtable2.put(object2, "*****");
                continue;
            }
            hashtable2.put(object2, (String)hashtable.get(object2));
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processParameters", new Object[]{hashtable2});
        }
        object2 = new Vector();
        Enumeration enumeration2 = hashtable.keys();
        boolean bl = true;
        while (enumeration2.hasMoreElements()) {
            object = null;
            String string = (String)enumeration2.nextElement();
            Object object3 = hashtable.get(string);
            if (object3 instanceof List) {
                if (commandMetadata instanceof TaskCommandMetadata) continue;
                this._shell.setAndThrowScriptingException("WASX8015E", "Invalid option value for ", new Object[]{string, object3});
            }
            try {
                object = this.getParameterMetadata(commandMetadata, string);
                if (object != null) {
                    bl = true;
                }
            }
            catch (ScriptingException scriptingException) {
                if (commandMetadata instanceof TaskCommandMetadata) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Swallow scripting exception: " + scriptingException.toString());
                    }
                    bl = false;
                }
                this._shell.setLastException(scriptingException);
                throw scriptingException;
            }
            if (!bl) continue;
            if ((object.getType().equals("java.lang.Boolean") || object.getType().equals("Boolean")) && (object3 == null || object3.toString().trim().length() == 0)) {
                object3 = "true";
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting " + object.getName() + " to true");
                }
            }
            Object object4 = this.formValidObject(object.getType(), (String)object3);
            adminCommand.setParameter(string, object4);
            ((Vector)object2).addElement(string);
        }
        if (!((Vector)object2).isEmpty()) {
            object = ((Vector)object2).elements();
            while (object.hasMoreElements()) {
                hashtable.remove((String)object.nextElement());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processParameters");
        }
    }

    private void processSteps(TaskCommand taskCommand, Hashtable hashtable, boolean bl) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processSteps - " + hashtable + " " + bl);
        }
        String[] stringArray = taskCommand.listCommandSteps();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            int n;
            Object object;
            Object object2;
            Object object3;
            Hashtable hashtable2;
            CommandStep commandStep = null;
            String string = (String)enumeration.nextElement();
            Object object4 = hashtable.get(string);
            if (object4 == null) continue;
            if (string.equals("delete")) {
                hashtable2 = this._adminCmdClient.getShell().getLangUtils().optionsToHashtable((String)object4);
                this.processSteps(taskCommand, hashtable2, true);
                continue;
            }
            try {
                commandStep = taskCommand.getCommandStep(string);
            }
            catch (CommandNotFoundException commandNotFoundException) {
                this._shell.setLastException(commandNotFoundException);
                throw new ScriptingException(commandNotFoundException.toString());
            }
            if (!commandStep.isEnabled()) {
                this._shell.setAndThrowScriptingException("WASX8012E", "step " + string + " is not enabled", new Object[]{string});
            }
            hashtable2 = commandStep.getCommandMetadata().getParameters();
            boolean bl2 = ((CommandStepMetadata)commandStep.getCommandMetadata()).isTable();
            boolean bl3 = ((CommandStepMetadata)commandStep.getCommandMetadata()).isEnableAddRows();
            if (object4 != null && this._shell.getLang().equalsIgnoreCase("jython") && (((String)(object3 = object4.toString())).trim().startsWith("\"") || ((String)object3).trim().startsWith("'")) && (((String)object3).trim().endsWith("\"") || ((String)object3).trim().endsWith("'")) && ((String)object3).trim().indexOf("-") != -1) {
                object2 = new StringTokenizer((String)object3, " ", false);
                object = new StringBuffer();
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    String string2 = ((StringTokenizer)object2).nextToken();
                    string2 = string2.substring(1, string2.length() - 1) + " ";
                    ((StringBuffer)object).append(string2);
                }
                object4 = ((StringBuffer)object).toString();
            }
            if (!(object4 instanceof List)) {
                if (bl2) {
                    int n2;
                    for (n2 = 0; n2 < stringArray.length && !stringArray[n2].equals(string); ++n2) {
                    }
                    if (n2 < stringArray.length) {
                        this._shell.setAndThrowScriptingException("WASX8015E", "Invalid option value for ", new Object[]{string, object4});
                    } else {
                        this._shell.setAndThrowScriptingException("WASX8009E", "Invalid parameter: " + string, new Object[]{string});
                    }
                } else {
                    object3 = commandStep.getCommandMetadata();
                    object2 = this.parseArgs((CommandMetadata)object3, new Object[]{object4});
                    object = ((ArgsParseResult)object2).optionTable;
                    if (object != null && ((Hashtable)object).size() != 0) {
                        this.processParameters(commandStep, (CommandMetadata)object3, (Hashtable)object);
                        continue;
                    }
                    this._shell.setAndThrowScriptingException("WASX8015E", "Invalid option value for ", new Object[]{string, object4});
                }
            }
            if (!bl2 && ((List)object4).size() > 1) {
                this._shell.setAndThrowScriptingException("WASX8014E", "step " + string + " is not a table", new Object[]{string});
            }
            int n3 = commandStep.getNumberOfRows();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "step " + string + " has " + n3 + " row(s)");
            }
            object2 = null;
            if (n3 > 0) {
                object2 = this.buildKeyFromTableStep(commandStep, n3, (EList)hashtable2);
            }
            object = new Boolean[n3];
            for (n = 0; n < n3; ++n) {
                object[n] = Boolean.FALSE;
            }
            for (n = 0; n < ((List)object4).size(); ++n) {
                Object object5;
                int n4;
                List list = (List)((List)object4).get(n);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "row " + n + " : " + list);
                }
                if (list.size() == 0) continue;
                StringBuffer stringBuffer = new StringBuffer();
                int n5 = n;
                if (n3 > 0) {
                    n4 = 0;
                    for (int i = 0; i < hashtable2.size(); ++i) {
                        ParameterMetadata parameterMetadata = (ParameterMetadata)hashtable2.get(i);
                        if (!parameterMetadata.isKeyField()) continue;
                        int n6 = i;
                        if (bl) {
                            n6 = n4++;
                        }
                        if (list.size() > n6) {
                            stringBuffer.append(list.get(n6));
                            stringBuffer.append(" ");
                            continue;
                        }
                        this._shell.setAndThrowScriptingException("WASX8019E", "Incorrect number of key fields provided for step " + string + ": " + list.toString(), new Object[]{string, list.toString()});
                    }
                    object5 = stringBuffer.toString().trim();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "input key: " + (String)object5);
                    }
                    n5 = -1;
                    for (n4 = 0; n4 < ((Object)object2).length; ++n4) {
                        if (!((String)object2[n4]).equals(object5)) continue;
                        n5 = n4;
                        break;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "matching index: " + n5);
                    }
                    if (n5 == -1) {
                        if (!bl && bl3) {
                            n5 = commandStep.getNumberOfRows();
                        } else {
                            this._shell.setAndThrowScriptingException("WASX8018E", "Cannot find a match for supplied options " + list.toString() + " for step " + string, new Object[]{list.toString(), string});
                        }
                    }
                } else if (bl || !bl3) {
                    this._shell.setAndThrowScriptingException("WASX8018E", "Cannot find a match for supplied options " + list.toString() + " for step " + string, new Object[]{list.toString(), string});
                }
                if (bl) {
                    object[n5] = Boolean.TRUE;
                    continue;
                }
                object5 = new AttributeList();
                n4 = list.size() >= hashtable2.size() ? hashtable2.size() : list.size();
                Tr.debug(tc, "param list size " + hashtable2.size());
                Tr.debug(tc, "row size " + list.size());
                for (int i = 0; i < n4; ++i) {
                    Object object6;
                    ParameterMetadata parameterMetadata = (ParameterMetadata)hashtable2.get(i);
                    if (n3 == 0 && ((String)list.get(i)).trim().length() == 0) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Skip setting " + parameterMetadata.getName());
                        continue;
                    }
                    if (bl2 && n5 >= commandStep.getNumberOfRows()) {
                        if (((String)list.get(i)).length() <= 0) continue;
                        object6 = new Attribute(parameterMetadata.getName(), this.formValidObject(parameterMetadata.getType(), (String)list.get(i)));
                        ((AttributeList)object5).add((Attribute)object6);
                        continue;
                    }
                    if (((String)list.get(i)).length() <= 0) continue;
                    object6 = null;
                    if (((String)list.get(i)).trim().length() > 0) {
                        object6 = this.formValidObject(parameterMetadata.getType(), (String)list.get(i));
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting " + parameterMetadata.getName() + " to " + object6);
                    }
                    if (parameterMetadata.isReadonly()) continue;
                    commandStep.setParameter(parameterMetadata.getName(), object6, n5);
                }
                if (!bl2 || n5 < commandStep.getNumberOfRows()) continue;
                commandStep.addRow((AttributeList)object5, n5);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Adding new row " + n5 + ": " + object5);
            }
            if (!bl) continue;
            for (n = ((Object)object).length - 1; n >= 0; --n) {
                if (!((Boolean)object[n]).booleanValue()) continue;
                commandStep.deleteRow(n);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Deleting row " + n);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processSteps");
        }
    }

    private String[] buildKeyFromTableStep(CommandStep commandStep, int n, EList eList) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildKeyFromTableStep");
        }
        String[] stringArray = new String[n];
        if (n > 0) {
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int j = 0; j < eList.size(); ++j) {
                    ParameterMetadata parameterMetadata = (ParameterMetadata)eList.get(j);
                    if (!parameterMetadata.isKeyField()) continue;
                    Object object = commandStep.getParameter(parameterMetadata.getName(), i);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "paramValue: " + object);
                    }
                    stringBuffer.append(this._handler.formDisplayString(object, this._shell.getLang()));
                    stringBuffer.append(" ");
                }
                stringArray[i] = stringBuffer.toString().trim();
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "row key " + i + ": " + stringArray[i]);
                Tr.debug(tc, "row key " + i + ": " + stringBuffer.toString().trim());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildKeyFromTableStep");
        }
        return stringArray;
    }

    private boolean processInteractive(AdminCommand adminCommand, CommandMetadata commandMetadata) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processInteractive");
        }
        boolean bl = true;
        int n = this.getTargetObjectRequired(commandMetadata);
        int n2 = this.getParameterRequired(commandMetadata);
        int n3 = this.getStepExisted(commandMetadata);
        if (n != 2 || n2 != 2 || n3 != 2) {
            String string = this.getMetadataTitle(commandMetadata);
            String string2 = this.getMetadataDescription(commandMetadata);
            boolean bl2 = false;
            if (n != 2) {
                System.out.println(string + nl);
                System.out.println(string2 + nl);
                bl2 = true;
                this.promptTargetObject(adminCommand, commandMetadata, n == 1);
            }
            if (n2 != 2) {
                if (!bl2) {
                    System.out.println(string + nl);
                    System.out.println(string2 + nl);
                }
                this.promptParameters(adminCommand, commandMetadata, true);
            }
            bl = n3 != 2 ? this.promptSteps((TaskCommand)adminCommand) : this.promptExecution(string);
        }
        if (bl) {
            this.logScriptGeneration(adminCommand);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processInteractive - " + bl);
        }
        return bl;
    }

    private void promptTargetObject(AdminCommand adminCommand, CommandMetadata commandMetadata, boolean bl) throws Throwable {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "promptTargetObject");
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = commandMetadata.getTargetObjectTitle();
        if (bl) {
            stringBuffer.append(REQUIRED_NOTATION);
        }
        if (string2 == null) {
            stringBuffer.append(this._shell.getFormattedMessage("ADMINTASK_TARGET_TITLE", new Object[0], "Target object"));
        } else {
            stringBuffer.append(string2);
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        Object[] objectArray = adminCommand.getTargetObjectChoices();
        if (objectArray != null && objectArray.length != 0) {
            stringBuffer.append(" [");
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuffer2.append(this._handler.formDisplayString(objectArray[i], this._shell.getLang()));
                if (i + 1 >= objectArray.length) continue;
                stringBuffer2.append(", ");
            }
            stringBuffer.append(stringBuffer2.toString());
            stringBuffer.append("]");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "target object choices: " + stringBuffer2.toString());
            }
        }
        stringBuffer.append(": ");
        Object object = adminCommand.getTargetObject();
        String string3 = "";
        if (object != null) {
            string3 = "[" + this._handler.formDisplayString(object, this._shell.getLang()) + "]";
        }
        if ((string = this.promptInput(stringBuffer.toString() + string3, bl, string3)) != null) {
            this.processTargetObject(adminCommand, commandMetadata, string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "promptTargetObject");
        }
    }

    public String promptParameters(AdminCommand adminCommand, CommandMetadata commandMetadata, boolean bl) throws Throwable {
        String string = this.promptParameters(adminCommand, commandMetadata, bl, 0, false);
        return string;
    }

    public String promptParameters(AdminCommand adminCommand, CommandMetadata commandMetadata, boolean bl, int n) throws Throwable {
        String string = this.promptParameters(adminCommand, commandMetadata, bl, n, false);
        return string;
    }

    public String promptParameters(AdminCommand adminCommand, CommandMetadata commandMetadata, boolean bl, int n, boolean bl2) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "promptParameters - " + bl + " " + n + " " + bl2);
        }
        AttributeList attributeList = new AttributeList();
        StringBuffer stringBuffer = new StringBuffer();
        EList eList = commandMetadata.getParameters();
        boolean bl3 = false;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "size of parameter: " + eList.size());
        }
        if (adminCommand instanceof CommandStep) {
            bl3 = ((CommandStepMetadata)adminCommand.getCommandMetadata()).isTable();
        }
        for (int i = 0; i < eList.size(); ++i) {
            ParameterMetadata parameterMetadata = (ParameterMetadata)eList.get(i);
            StringBuffer stringBuffer2 = new StringBuffer();
            if (parameterMetadata.isRequired()) {
                stringBuffer2.append(REQUIRED_NOTATION);
            }
            stringBuffer2.append(this.getMetadataTitle(parameterMetadata));
            stringBuffer2.append(" (");
            stringBuffer2.append(parameterMetadata.getName());
            stringBuffer2.append(")");
            StringBuffer stringBuffer3 = new StringBuffer();
            Object[] objectArray = adminCommand instanceof CommandStep ? ((CommandStep)adminCommand).getChoices(parameterMetadata.getName(), n) : adminCommand.getChoices(parameterMetadata.getName());
            if (objectArray != null && objectArray.length != 0) {
                stringBuffer2.append(" [");
                for (int j = 0; j < objectArray.length; ++j) {
                    stringBuffer3.append(this._handler.formDisplayString(objectArray[j], this._shell.getLang()));
                    if (j + 1 >= objectArray.length) continue;
                    stringBuffer3.append(", ");
                }
                stringBuffer2.append(stringBuffer3.toString());
                stringBuffer2.append("]");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "choices: " + stringBuffer3.toString());
                }
            }
            stringBuffer2.append(": ");
            Object object = null;
            if (adminCommand instanceof CommandStep && bl3) {
                if (!bl2 && n < ((CommandStep)adminCommand).getNumberOfRows()) {
                    object = ((CommandStep)adminCommand).getParameter(parameterMetadata.getName(), n);
                }
            } else {
                object = adminCommand.getParameter(parameterMetadata.getName());
                if (object == null) {
                    object = parameterMetadata.getDefaultValue();
                }
            }
            String string = "";
            if (object != null) {
                string = this._handler.formDisplayString(object, this._shell.getLang());
                stringBuffer2.append("[");
                stringBuffer2.append(string);
                stringBuffer2.append("] ");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Current value is " + string);
                }
            } else if (parameterMetadata.isRequired() && objectArray != null && objectArray.length == 1) {
                stringBuffer2.append("[");
                stringBuffer2.append(stringBuffer3.toString());
                stringBuffer2.append("] ");
                string = stringBuffer3.toString().substring(0, stringBuffer3.toString().length());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "assign choice as value: " + string);
                }
            }
            if (bl) {
                if (parameterMetadata.isReadonly()) {
                    System.out.println(stringBuffer2.toString());
                    continue;
                }
                String string2 = this.promptInput(stringBuffer2.toString(), parameterMetadata.isRequired(), string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "input for " + parameterMetadata.getName() + ": " + string2);
                }
                if (string2 == null && object == null && parameterMetadata.isRequired() && objectArray != null && objectArray.length == 1) {
                    string2 = string;
                }
                if (string2 == null) continue;
                try {
                    Object object2;
                    if (adminCommand instanceof CommandStep && bl3) {
                        if (!bl2) {
                            object2 = null;
                            if (string2.trim().length() != 0) {
                                object2 = this.formValidObject(parameterMetadata.getType(), string2);
                            }
                            ((CommandStep)adminCommand).setParameter(parameterMetadata.getName(), object2, n);
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Setting parameter " + parameterMetadata.getName());
                            continue;
                        }
                        object2 = new Attribute(parameterMetadata.getName(), this.formValidObject(parameterMetadata.getType(), string2));
                        attributeList.add((Attribute)object2);
                        continue;
                    }
                    object2 = null;
                    if (string2.trim().length() != 0) {
                        object2 = this.formValidObject(parameterMetadata.getType(), string2);
                    }
                    adminCommand.setParameter(parameterMetadata.getName(), object2);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Setting parameter " + parameterMetadata.getName());
                }
                catch (Exception exception) {
                    System.out.println(exception.toString());
                    --i;
                }
                continue;
            }
            stringBuffer.append(stringBuffer2.toString());
            stringBuffer.append(nl);
        }
        if (bl && !attributeList.isEmpty() && bl3 && bl2) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding new row " + n + ": " + attributeList);
            }
            ((CommandStep)adminCommand).addRow(attributeList, n);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "promptParameters");
        }
        return stringBuffer.toString();
    }

    private boolean promptSteps(TaskCommand taskCommand) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "promptSteps");
        }
        boolean bl = true;
        AdminCmdInteractiveStepsPrompt adminCmdInteractiveStepsPrompt = new AdminCmdInteractiveStepsPrompt(this);
        bl = adminCmdInteractiveStepsPrompt.processTaskSteps(taskCommand);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "promptSteps - " + bl);
        }
        return bl;
    }

    private boolean promptExecution(String string) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "promptExecution");
        }
        boolean bl = true;
        String string2 = "junk";
        String string3 = this._shell.getFormattedMessage("ADMINTASK_EXECUTION_PROMPT", new Object[]{string, finishSelection + nl + cancelSelection, finish + ", " + cancel, finish}, string + "\n\nF (Finish)\nC (Cancel)\n\nSelect [F, C]: F");
        while (string2 != null && !string2.equalsIgnoreCase(finish) && !string2.equalsIgnoreCase(cancel)) {
            string2 = this.promptInput(string3, true, finish);
        }
        if (string2 != null && string2.equalsIgnoreCase(cancel)) {
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "promptExecution - " + bl);
        }
        return bl;
    }

    public String promptInput(String string, boolean bl, String string2) throws Throwable {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "promptInput", new Object[]{string, string2});
        }
        String string3 = null;
        InputStreamReader inputStreamReader = null;
        if (AdminHelper.getPlatformHelper().isZOS()) {
            object = System.getProperty("ws.input.encoding");
            if (object != null) {
                try {
                    inputStreamReader = new InputStreamReader(System.in, (String)object);
                }
                catch (Throwable throwable) {
                    this._shell.setLastException((Exception)throwable);
                    throw new ScriptingException(throwable.toString());
                }
            } else {
                inputStreamReader = new InputStreamReader(System.in);
            }
        } else {
            inputStreamReader = new InputStreamReader(System.in);
        }
        object = new BufferedReader(inputStreamReader);
        while (true) {
            System.out.print(string);
            try {
                string3 = ((BufferedReader)object).readLine();
            }
            catch (IOException iOException) {
                this._shell.setLastException(iOException);
                throw iOException;
            }
            if (!bl || !string2.equals("") || string3 != null && (string3 == null || string3.trim().length() != 0)) break;
            System.out.println(this._shell.getFormattedMessage("WASX7137I", new Object[0], "Enter a value for the required field"));
        }
        if (string3 != null && (bl && string3.trim().length() == 0 || !bl && string3.trim().length() == 0)) {
            string3 = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "promptInput - " + string3);
        }
        return string3;
    }

    private void logScriptGeneration(AdminCommand adminCommand) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logScriptGeneration");
        }
        String string = this._adminCmdScriptGen.generateScriptFromCmd(adminCommand);
        Tr.audit(tc, "WASX7278I", string);
        System.out.println(this._shell.getFormattedMessage("WASX7278I", new Object[]{string}, "Generated command is " + string));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logScriptGeneration");
        }
    }

    public void processSelectStep(TaskCommand taskCommand, CommandStep commandStep) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processSelectStep");
        }
        if (((CommandStepMetadata)commandStep.getCommandMetadata()).isTable()) {
            this.processTableStep(commandStep);
        } else {
            this.processNonTableStep(taskCommand, commandStep);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processSelectStep");
        }
    }

    private void processTableStep(CommandStep commandStep) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processTableStep");
        }
        AdminCmdInteractiveTableStepsPrompt adminCmdInteractiveTableStepsPrompt = new AdminCmdInteractiveTableStepsPrompt(this);
        adminCmdInteractiveTableStepsPrompt.processTaskSteps(commandStep);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processTableStep");
        }
    }

    private void processNonTableStep(TaskCommand taskCommand, CommandStep commandStep) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processNonTableStep");
        }
        String string = this.buildStepPrompt(commandStep);
        String string2 = this._shell.getFormattedMessage("ADMINTASK_STEP_REPEAT_PROMPT", new Object[]{cancelSelection + ", " + editSelection, edit}, "Select [" + cancelSelection + ", " + editSelection + "] : [" + edit + "] ");
        String string3 = "junk";
        string3 = this.promptInput(string, false, null);
        while (string3 != null && string3.trim().length() != 0 && !string3.trim().equalsIgnoreCase(cancel) && !string3.trim().equalsIgnoreCase(edit)) {
            string3 = this.promptInput(string2, false, null);
        }
        if (string3 == null || string3 != null && string3.equalsIgnoreCase(edit)) {
            this.promptParameters(commandStep, commandStep.getCommandMetadata(), true);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processNonTableStep");
        }
    }

    private String buildStepPrompt(CommandStep commandStep) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildStepPrompt");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(nl);
        stringBuffer.append(this.getMetadataTitle(commandStep.getCommandMetadata()));
        stringBuffer.append(" (");
        stringBuffer.append(commandStep.getName());
        stringBuffer.append(")");
        stringBuffer.append(nl);
        stringBuffer.append(nl);
        stringBuffer.append(this.promptParameters(commandStep, commandStep.getCommandMetadata(), false));
        stringBuffer.append(nl);
        stringBuffer.append(this._shell.getFormattedMessage("ADMINTASK_STEP_REPEAT_PROMPT", new Object[]{cancelSelection + ", " + editSelection, edit}, "Select [" + cancelSelection + ", " + editSelection + "] : [" + edit + "] "));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildStepPrompt - " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    public void processStepsHelp(TaskCommand taskCommand) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processStepsHelp");
        }
        System.out.println(nl + this._adminCmdHelp.getCommandDetailHelp(taskCommand.getName()));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processStepsHelp");
        }
    }

    public void processStepHelp(CommandStep commandStep) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processStepHelp");
        }
        System.out.println(nl + this._adminCmdHelp.getCommandDetailStep((CommandStepMetadata)commandStep.getCommandMetadata(), commandStep.getName()));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processStepHelp");
        }
    }

    private String executeCmd(AdminCommand adminCommand) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "executeCmd");
        }
        adminCommand.execute();
        String string = new String();
        CommandResult commandResult = adminCommand.getCommandResult();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Command result: " + commandResult);
        }
        if (commandResult != null) {
            if (commandResult.isSuccessful()) {
                Object object = commandResult.getResult();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Command runs successful with result: " + object);
                }
                if (object != null) {
                    string = this._handler.formDisplayString(object, this._shell.getLang());
                }
            } else {
                Throwable throwable = commandResult.getException();
                String string2 = new String();
                String string3 = ExceptionSupport.getMessage(throwable, "WASX");
                if (throwable instanceof Exception) {
                    this._shell.setLastException((Exception)throwable);
                } else {
                    StringWriter stringWriter = new StringWriter();
                    throwable.printStackTrace(new PrintWriter(stringWriter));
                    string2 = stringWriter.toString();
                    if (string3 == null) {
                        string3 = throwable.toString();
                    }
                    Tr.error(tc, "WASX7120E", new Object[]{string3, string2});
                }
                throw new ScriptingException(string3);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "executeCmd - " + string);
        }
        return string;
    }

    protected StringHandler getHandler(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHandler", new Object[]{string});
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        StringHandler stringHandler = null;
        if (clazz != null) {
            stringHandler = HandlerRegistry.getHandler(clazz);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getHandler - " + stringHandler);
        }
        return stringHandler;
    }

    protected Object formValidObject(String string, String string2) throws com.ibm.websphere.scripting.ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formValidObject", new Object[]{string, string2});
        }
        if (string == null || string.trim().length() == 0) {
            this._shell.setAndThrowScriptingException("WASX8016E", "Command provider error: null object type", new Object[0]);
        }
        Class<?> clazz = null;
        StringHandler stringHandler = null;
        Object object = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            string = "java.lang." + string;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                throw new ScriptingException(classNotFoundException2.toString());
            }
        }
        if (clazz != null) {
            stringHandler = HandlerRegistry.getHandler(clazz);
        }
        if (stringHandler != null) {
            object = stringHandler.formValidObject(string2, clazz, this._adminCmdClient.getShell().getLang());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formValidObject - " + object);
        }
        return object;
    }

    private class ParameterMetaInfo {
        public String name;
        public boolean readonly;

        private ParameterMetaInfo() {
        }
    }

    private class ArgsParseResult {
        public String targetObj;
        public Hashtable optionTable;

        private ArgsParseResult() {
        }
    }
}

