/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting.adminCommand;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandStep;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandStepMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.ParameterMetadata;
import com.ibm.ws.scripting.ScriptingException;
import com.ibm.ws.scripting.adminCommand.AdminCmdController;
import com.ibm.ws.scripting.adminCommand.AdminCmdInteractivePrompt;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;

public class AdminCmdInteractiveTableStepsPrompt
extends AdminCmdInteractivePrompt {
    private static TraceComponent tc = Tr.register(AdminCmdInteractiveTableStepsPrompt.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    protected static String add;
    protected static String delete;
    protected static String addSelection;
    protected static String addBeforeSelection;
    protected static String deleteSelection;
    private CommandStep cmdStep;
    private String defaultSelection;
    private String completeStepMsg = "";
    private boolean selectStepFound;
    private boolean hasRequiredData;
    private Vector selectionIndex;
    private Vector keyNames;
    private int selectRowIndex;
    private boolean addAllowed;

    public AdminCmdInteractiveTableStepsPrompt(AdminCmdController adminCmdController) {
        super(adminCmdController);
        add = this._adminCmdController.getShell().getFormattedMessage("ADMINTASK_ADD_HOTKEY", new Object[0], "A");
        delete = this._adminCmdController.getShell().getFormattedMessage("ADMINTASK_DELETE_HOTKEY", new Object[0], "D");
        addSelection = this._adminCmdController.getShell().getFormattedMessage("ADMINTASK_ADD_SELECTION", new Object[0], "A (Add Row)");
        addBeforeSelection = this._adminCmdController.getShell().getFormattedMessage("ADMINTASK_ADD_BEFORE_SELECTION", new Object[0], "A (Add Row Before)");
        deleteSelection = this._adminCmdController.getShell().getFormattedMessage("ADMINTASK_DELETE_SELECTION", new Object[0], "D (Delete Row)");
        selectSelection = this._adminCmdController.getShell().getFormattedMessage("ADMINTASK_SELECT_ROW_SELECTION", new Object[0], "S (Select Row)");
    }

    protected void setAdminCommand(AdminCommand adminCommand) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAdminCommand");
        }
        this.cmdStep = (CommandStep)adminCommand;
        this.selectStepFound = false;
        this.hasRequiredData = false;
        this.defaultSelection = select;
        this.keyNames = null;
        this.selectRowIndex = 0;
        this.addAllowed = ((CommandStepMetadata)this.cmdStep.getCommandMetadata()).isEnableAddRows();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAdminCommand");
        }
    }

    protected String getTitle() {
        return AdminCmdController.nl + this.getMetadataTitle(this.cmdStep.getCommandMetadata()) + " (" + this.cmdStep.getName() + ")";
    }

    protected String getDescription() throws Throwable {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDescription");
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.keyNames = this.getKeyNamesForTable((CommandStepMetadata)this.cmdStep.getCommandMetadata());
        StringBuffer stringBuffer2 = new StringBuffer();
        if (!this.keyNames.isEmpty()) {
            for (n = 0; n < this.keyNames.size(); ++n) {
                if (stringBuffer2.length() != 0) {
                    stringBuffer2.append(", ");
                }
                String[] stringArray = (String[])this.keyNames.get(n);
                stringBuffer2.append(stringArray[0]);
                stringBuffer2.append(" (");
                stringBuffer2.append(stringArray[1]);
                stringBuffer2.append(")");
            }
        } else {
            throw new ScriptingException(this._adminCmdController.getShell().getFormattedMessage("WASX8017E", new Object[]{this.cmdStep.getName()}, "Step " + this.cmdStep.getName() + " does not contain any key"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDescription - " + stringBuffer2.toString());
        }
        stringBuffer.append("    | " + stringBuffer2.toString());
        stringBuffer.append(AdminCmdController.nl);
        stringBuffer.append("    --");
        for (n = 0; n < stringBuffer2.length(); ++n) {
            stringBuffer.append("-");
        }
        return stringBuffer.toString();
    }

    private Vector getKeyNamesForTable(CommandStepMetadata commandStepMetadata) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyNamesForTable");
        }
        Vector<String[]> vector = new Vector<String[]>();
        EList eList = commandStepMetadata.getParameters();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "size of parameter: " + eList.size());
        }
        for (int i = 0; i < eList.size(); ++i) {
            ParameterMetadata parameterMetadata = (ParameterMetadata)eList.get(i);
            if (!parameterMetadata.isKeyField()) continue;
            String[] stringArray = new String[]{this.getMetadataTitle(parameterMetadata), parameterMetadata.getName()};
            vector.addElement(stringArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyNamesForTable - " + vector.toString());
        }
        return vector;
    }

    protected boolean isLoopDone(String string) {
        if (string == null) {
            string = this.defaultSelection;
        }
        return string != null && !string.equalsIgnoreCase(finish);
    }

    protected String getStepTitles() throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStepTitles");
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.hasRequiredData = false;
        this.selectStepFound = false;
        if (this.cmdStep.getNumberOfRows() > 0) {
            for (int i = 0; i < this.cmdStep.getNumberOfRows(); ++i) {
                if (i == this.selectRowIndex) {
                    this.selectStepFound = true;
                    if (this.cmdStep.isRequired(i)) {
                        stringBuffer.append("-> " + "*");
                        this.hasRequiredData = true;
                    } else {
                        stringBuffer.append("->  ");
                    }
                } else if (this.cmdStep.isRequired(i)) {
                    stringBuffer.append("   " + "*");
                    this.hasRequiredData = true;
                } else {
                    stringBuffer.append("    ");
                }
                stringBuffer.append("| ");
                for (int j = 0; j < this.keyNames.size(); ++j) {
                    String[] stringArray = (String[])this.keyNames.get(j);
                    Object object = this.cmdStep.getParameter(stringArray[1], i);
                    String string = "";
                    if (object != null) {
                        stringBuffer.append(this._adminCmdController.getHandler().formDisplayString(object, this._adminCmdController.getShell().getLang()));
                    } else {
                        stringBuffer.append("\"\"");
                    }
                    if (j + 1 >= this.keyNames.size()) continue;
                    stringBuffer.append(", ");
                }
                stringBuffer.append(AdminCmdController.nl);
            }
        }
        if (!this.selectStepFound && this.cmdStep.getNumberOfRows() > 0) {
            stringBuffer.append("->  ");
            stringBuffer.append(this.completeStepMsg);
            stringBuffer.append(AdminCmdController.nl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStepTitles - " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    protected String getSelectionMenu() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSelectionMenu");
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.selectionIndex = new Vector();
        this.defaultSelection = select;
        if (this.selectStepFound) {
            stringBuffer.append(selectSelection);
            stringBuffer.append(AdminCmdController.nl);
            this.selectionIndex.addElement(select);
        }
        if (this.selectRowIndex + 1 <= this.cmdStep.getNumberOfRows()) {
            stringBuffer.append(nextSelection);
            stringBuffer.append(AdminCmdController.nl);
            this.selectionIndex.addElement(next);
        } else if (!this.selectStepFound && this.cmdStep.getNumberOfRows() > 0) {
            this.defaultSelection = previous;
        }
        if (this.selectRowIndex > 0) {
            stringBuffer.append(previousSelection);
            stringBuffer.append(AdminCmdController.nl);
            this.selectionIndex.addElement(previous);
        }
        if (this.addAllowed) {
            if (!this.selectStepFound) {
                this.defaultSelection = add;
            }
            if (this.cmdStep.getNumberOfRows() == 0) {
                stringBuffer.append(addSelection);
            } else {
                stringBuffer.append(addBeforeSelection);
            }
            stringBuffer.append(nl);
            this.selectionIndex.addElement(add);
            if (this.cmdStep.getNumberOfRows() > 0 && this.selectStepFound) {
                stringBuffer.append(deleteSelection);
                stringBuffer.append(nl);
                this.selectionIndex.addElement(delete);
            }
        }
        if (!this.hasRequiredData) {
            stringBuffer.append(finishSelection);
            stringBuffer.append(AdminCmdController.nl);
            this.selectionIndex.addElement(finish);
            if (this.cmdStep.getNumberOfRows() != 0) {
                this.defaultSelection = finish;
            }
        }
        stringBuffer.append(helpSelection);
        stringBuffer.append(AdminCmdController.nl);
        this.selectionIndex.addElement(help);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSelectionMenu - " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    protected String getSelectionPrompt() {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSelectionPrompt");
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.selectionIndex.isEmpty()) {
            object = this.selectionIndex.elements();
            while (object.hasMoreElements()) {
                if (stringBuffer.length() != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append((String)object.nextElement());
            }
        }
        object = this._adminCmdController.getShell().getFormattedMessage("ADMINTASK_STEP_REPEAT_PROMPT", new Object[]{stringBuffer.toString(), this.defaultSelection}, "Select [" + stringBuffer.toString() + "] : [" + this.defaultSelection + "] ");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSelectionPrompt - " + (String)object);
        }
        return object;
    }

    protected String getDefaultSelection() {
        return this.defaultSelection;
    }

    protected boolean validateAnswer(String string) {
        if (string == null) {
            string = this.defaultSelection;
        }
        return string != null && (this.selectionIndex.contains(string.toUpperCase()) || this.selectionIndex.contains(string.toLowerCase()));
    }

    protected boolean processSelection(String string) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processSelection", new Object[]{string});
        }
        boolean bl = true;
        if (string == null) {
            string = this.defaultSelection;
        }
        if (string != null && string.equalsIgnoreCase(select)) {
            this._adminCmdController.promptParameters(this.cmdStep, this.cmdStep.getCommandMetadata(), true, this.selectRowIndex);
            ++this.selectRowIndex;
        } else if (string != null && string.equalsIgnoreCase(next)) {
            ++this.selectRowIndex;
        } else if (string != null && string.equalsIgnoreCase(previous)) {
            this.selectRowIndex = !this.selectStepFound ? this.cmdStep.getNumberOfRows() - 1 : --this.selectRowIndex;
        } else if (string != null && string.equalsIgnoreCase(add)) {
            this._adminCmdController.promptParameters(this.cmdStep, this.cmdStep.getCommandMetadata(), true, this.selectRowIndex, this.addAllowed);
            ++this.selectRowIndex;
        } else if (string.equalsIgnoreCase(delete)) {
            this.cmdStep.deleteRow(this.selectRowIndex);
        } else if (string.equalsIgnoreCase(help)) {
            this._adminCmdController.processStepHelp(this.cmdStep);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processSelection");
        }
        return bl;
    }

    public boolean processTaskSteps(AdminCommand adminCommand) throws Throwable {
        String string;
        String string2;
        String string3;
        boolean bl;
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "processTaskSteps");
            }
            bl = true;
            string3 = null;
            string2 = null;
            string = null;
            this.setAdminCommand(adminCommand);
            string = this.getTitle();
            try {
                string2 = this.getDescription();
            }
            catch (ScriptingException scriptingException) {
                if (scriptingException.toString().indexOf("WASX8017E") <= 0) break block7;
                System.out.println(scriptingException.toString() + AdminCmdController.nl);
                return false;
            }
        }
        while (this.isLoopDone(string3)) {
            String string4 = this.getStepTitles();
            String string5 = this.getBatchDescription();
            String string6 = this.getSelectionMenu();
            String string7 = this.getSelectionPrompt();
            String string8 = this.getDefaultSelection();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string + AdminCmdController.nl + AdminCmdController.nl + string2 + AdminCmdController.nl + string4 + AdminCmdController.nl);
            if (string4.length() > 0) {
                stringBuffer.append(string5 + AdminCmdController.nl + AdminCmdController.nl);
            }
            stringBuffer.append(string6 + AdminCmdController.nl + string7);
            string3 = this._adminCmdController.promptInput(stringBuffer.toString(), true, string8);
            while (!this.validateAnswer(string3)) {
                string3 = this._adminCmdController.promptInput(AdminCmdController.nl + string7, true, string8);
            }
            bl = this.processSelection(string3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processTaskSteps");
        }
        return bl;
    }

    private String getBatchDescription() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBatchDescription");
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.keyNames.isEmpty()) {
            for (int i = 0; i < this.keyNames.size(); ++i) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                String[] stringArray = (String[])this.keyNames.get(i);
                stringBuffer.append(stringArray[0]);
            }
        }
        String string = this._adminCmdController.getShell().getFormattedMessage("ADMINTASK_STEP_BATCH_FIELD_DESC", new Object[]{stringBuffer.toString()}, stringBuffer.toString() + " are required for batch mode");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getBatchDescription - " + string);
        }
        return string;
    }
}

