/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting.types;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.scripting.AbstractShell;
import com.ibm.ws.scripting.AdminConfigClient;
import com.ibm.ws.scripting.ConfigNameCache;
import com.ibm.ws.scripting.ScriptingException;
import com.ibm.ws.scripting.types.FIPSTSHelper;
import com.ibm.ws.scripting.types.PropertyTSHelper;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;

public class SecureSocketLayerTSHelper
extends FIPSTSHelper {
    private static TraceComponent tc = Tr.register(SecureSocketLayerTSHelper.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");

    public SecureSocketLayerTSHelper(AdminConfigClient adminConfigClient, AbstractShell abstractShell, Hashtable hashtable, ConfigNameCache configNameCache) {
        super(adminConfigClient, abstractShell, hashtable, configNameCache);
    }

    public void reset() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reset");
        }
        this.msgId = "SECURITY_NONFIPS_PROVIDER";
        this.validationType = "com.ibm.ssl.contextProvider";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reset");
        }
    }

    public AttributeList attributeListUpdate(AttributeList attributeList, ObjectName objectName, boolean bl) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "attributeListUpdate");
        }
        try {
            this.validate(attributeList, objectName);
        }
        catch (AdminException adminException) {
            this._shell.setLastException(adminException);
            throw new ScriptingException(adminException.toString());
        }
        catch (ConnectorException connectorException) {
            this._shell.setLastException(connectorException);
            throw new ScriptingException(connectorException.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "attributeListUpdate");
        }
        return attributeList;
    }

    protected boolean validate(AttributeList attributeList, ObjectName objectName) throws ScriptingException, AdminException, ConnectorException {
        boolean bl;
        ArrayList arrayList;
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "validate");
            }
            arrayList = null;
            bl = false;
            try {
                arrayList = (ArrayList)ConfigServiceHelper.getAttributeValue(attributeList, "properties");
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                if (!tc.isDebugEnabled()) break block11;
                Tr.debug(tc, "Ex - " + attributeNotFoundException.toString());
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "arlist: " + arrayList);
        }
        if (arrayList != null) {
            PropertyTSHelper propertyTSHelper = (PropertyTSHelper)this.getTSHelper("Property");
            propertyTSHelper.setMessageId(this.msgId);
            propertyTSHelper.setValidationType(this.validationType);
            for (int i = 0; i < arrayList.size(); ++i) {
                AttributeList attributeList2 = null;
                Object e2 = arrayList.get(i);
                if (e2 instanceof ObjectName) {
                    AttributeList attributeList3 = this.getAttributeListFromON((ObjectName)e2);
                    objectName = (ObjectName)e2;
                    if (attributeList3 != null) {
                        attributeList2 = attributeList3;
                    }
                } else if (e2 instanceof AttributeList) {
                    attributeList2 = (AttributeList)e2;
                }
                bl = propertyTSHelper.validate(attributeList2, objectName);
                if (bl) break;
            }
            propertyTSHelper.reset();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate - " + bl);
        }
        return bl;
    }
}

