/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting.types;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.scripting.AbstractShell;
import com.ibm.ws.scripting.AdminConfigClient;
import com.ibm.ws.scripting.ConfigNameCache;
import com.ibm.ws.scripting.ScriptingException;
import com.ibm.ws.scripting.types.FIPSTSHelper;
import com.ibm.ws.scripting.types.PropertyTSHelper;
import com.ibm.ws.scripting.types.SSLConfigTSHelper;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;

public class SecurityTSHelper
extends FIPSTSHelper {
    private static TraceComponent tc = Tr.register(SecurityTSHelper.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    public static final int FIPS_NOT_SET = 0;
    public static final int FIPS_TRUE = 1;
    public static final int FIPS_FALSE = 2;
    private int foundUseFIPS = 1;

    public SecurityTSHelper(AdminConfigClient adminConfigClient, AbstractShell abstractShell, Hashtable hashtable, ConfigNameCache configNameCache) {
        super(adminConfigClient, abstractShell, hashtable, configNameCache);
    }

    public void reset() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reset");
        }
        this.msgId = "SECURITY_NONFIPS_PROVIDER";
        this.validationType = "com.ibm.ssl.contextProvider";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reset");
        }
    }

    public AttributeList attributeListUpdate(AttributeList attributeList, ObjectName objectName, boolean bl) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "attributeListUpdate");
        }
        try {
            this.validate(attributeList, objectName);
        }
        catch (AdminException adminException) {
            this._shell.setLastException(adminException);
            throw new ScriptingException(adminException.toString());
        }
        catch (ConnectorException connectorException) {
            this._shell.setLastException(connectorException);
            throw new ScriptingException(connectorException.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "attributeListUpdate");
        }
        return attributeList;
    }

    protected boolean validate(AttributeList attributeList, ObjectName objectName) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate - " + objectName);
        }
        boolean bl = false;
        ArrayList arrayList = null;
        int n = this.validateFIPSProperty(attributeList, objectName);
        if (n == 0 || n == 1) {
            block11: {
                try {
                    arrayList = (ArrayList)ConfigServiceHelper.getAttributeValue(attributeList, "repertoire");
                }
                catch (AttributeNotFoundException attributeNotFoundException) {
                    if (!tc.isDebugEnabled()) break block11;
                    Tr.debug(tc, "Ex - " + attributeNotFoundException.toString());
                }
            }
            if (arrayList != null) {
                SSLConfigTSHelper sSLConfigTSHelper = (SSLConfigTSHelper)this.getTSHelper("SSLConfig");
                sSLConfigTSHelper.setMessageId(this.msgId);
                sSLConfigTSHelper.setValidationType(this.validationType);
                for (int i = 0; i < arrayList.size(); ++i) {
                    AttributeList attributeList2 = null;
                    Object e2 = arrayList.get(i);
                    if (e2 instanceof ObjectName) {
                        AttributeList attributeList3 = this.getAttributeListFromON((ObjectName)e2);
                        if (attributeList3 != null) {
                            attributeList2 = attributeList3;
                        }
                    } else if (e2 instanceof AttributeList) {
                        attributeList2 = (AttributeList)e2;
                    }
                    bl = sSLConfigTSHelper.validate(attributeList2, objectName);
                    if (bl) break;
                }
                sSLConfigTSHelper.reset();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate - " + bl);
        }
        return bl;
    }

    protected int validateFIPSProperty(AttributeList attributeList, ObjectName objectName) throws ScriptingException, AdminException, ConnectorException {
        int n;
        boolean bl;
        ArrayList arrayList;
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "validateFIPSProperty - " + objectName);
            }
            arrayList = null;
            bl = false;
            n = 0;
            try {
                arrayList = (ArrayList)ConfigServiceHelper.getAttributeValue(attributeList, "properties");
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                if (!tc.isDebugEnabled()) break block13;
                Tr.debug(tc, "Ex - " + attributeNotFoundException.toString());
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "arlist: " + arrayList);
        }
        if (arrayList != null) {
            PropertyTSHelper propertyTSHelper = (PropertyTSHelper)this.getTSHelper("Property");
            for (int i = 0; i < arrayList.size(); ++i) {
                AttributeList attributeList2 = null;
                Object e2 = arrayList.get(i);
                if (e2 instanceof ObjectName) {
                    AttributeList attributeList3 = this.getAttributeListFromON((ObjectName)e2);
                    if (attributeList3 != null) {
                        attributeList2 = attributeList3;
                    }
                } else if (e2 instanceof AttributeList) {
                    attributeList2 = (AttributeList)e2;
                }
                n = this.checkFIPSProperty(attributeList2);
                if (n != 0) break;
            }
            if (n == this.foundUseFIPS) {
                String string;
                propertyTSHelper.setMessageId("SECURITY_NONFIPS_SSL");
                propertyTSHelper.setValidationType("com.ibm.ssl.contextProvider");
                propertyTSHelper.setSkipFIPSCheck(true);
                bl = propertyTSHelper.matchSSLConfig("lookThroughAllSSLConfig", objectName);
                propertyTSHelper.setSkipFIPSCheck(false);
                propertyTSHelper.reset();
                if (!bl && objectName != null && (string = this.getConfigPath(objectName)).indexOf("/servers/") == -1) {
                    bl = this.checkServerSSLConfig(objectName);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateFIPSProperty - " + n);
        }
        return n;
    }

    public int checkFIPSProperty(AttributeList attributeList) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkFIPSProperty");
        }
        int n = 0;
        String string = new String();
        String string2 = new String();
        for (int i = 0; i < attributeList.size(); ++i) {
            String string3 = ((Attribute)attributeList.get(i)).getName();
            Object object = ((Attribute)attributeList.get(i)).getValue();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "name: " + string3);
            }
            if (string3.equals("name")) {
                string = (String)object;
            }
            if (!string3.equals("value")) continue;
            string2 = (String)object;
        }
        if (string.equals("com.ibm.security.useFIPS")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found matching useFIPS property, value: " + string2);
            }
            n = string2.equals("true") ? 1 : 2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkFIPSProperty - " + n);
        }
        return n;
    }

    public boolean checkServerSSLConfig(ObjectName objectName) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkServerSSLConfig");
        }
        boolean bl = false;
        ObjectName[] objectNameArray = this.getObjectNameListForType("Server", null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "serverList: " + objectNameArray);
        }
        if (objectNameArray != null) {
            for (int i = 0; i < objectNameArray.length; ++i) {
                ObjectName[] objectNameArray2 = this.getObjectNameListForType("Security", objectNameArray[i]);
                if (objectNameArray2 != null) {
                    AttributeList attributeList;
                    for (int j = 0; j < objectNameArray2.length && !(bl = this.validate(attributeList = this.getAttributeListFromON(objectNameArray2[j]), objectNameArray2[i])); ++j) {
                    }
                }
                if (bl) break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkServerSSLConfig - " + bl);
        }
        return bl;
    }
}

