/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting.types;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.scripting.AbstractShell;
import com.ibm.ws.scripting.AdminConfigClient;
import com.ibm.ws.scripting.ConfigNameCache;
import com.ibm.ws.scripting.ScriptingException;
import com.ibm.ws.scripting.types.FIPSTSHelper;
import com.ibm.ws.scripting.types.HTTPTransportTSHelper;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;

public class WebContainerTSHelper
extends FIPSTSHelper {
    private static TraceComponent tc = Tr.register(WebContainerTSHelper.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");

    public WebContainerTSHelper(AdminConfigClient adminConfigClient, AbstractShell abstractShell, Hashtable hashtable, ConfigNameCache configNameCache) {
        super(adminConfigClient, abstractShell, hashtable, configNameCache);
        this.reset();
    }

    public void reset() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reset");
        }
        this.msgId = "SECURITY_NONFIPS_PROVIDER";
        this.validationType = "sslConfig";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reset");
        }
    }

    public AttributeList attributeListUpdate(AttributeList attributeList, ObjectName objectName, boolean bl) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "attributeListUpdate");
        }
        try {
            this.validate(attributeList, objectName);
        }
        catch (AdminException adminException) {
            this._shell.setLastException(adminException);
            throw new ScriptingException(adminException.toString());
        }
        catch (ConnectorException connectorException) {
            this._shell.setLastException(connectorException);
            throw new ScriptingException(connectorException.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "attributeListUpdate");
        }
        return attributeList;
    }

    protected boolean validate(AttributeList attributeList, ObjectName objectName) throws ScriptingException, AdminException, ConnectorException {
        ArrayList arrayList;
        boolean bl;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "validate");
            }
            bl = false;
            arrayList = null;
            try {
                arrayList = (ArrayList)ConfigServiceHelper.getAttributeValue(attributeList, "transports");
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "Ex - " + attributeNotFoundException.toString());
            }
        }
        if (arrayList != null) {
            HTTPTransportTSHelper hTTPTransportTSHelper = (HTTPTransportTSHelper)this.getTSHelper("HTTPTransport");
            hTTPTransportTSHelper.setMessageId("SECURITY_NONFIPS_PROVIDER");
            hTTPTransportTSHelper.setValidationType("sslConfig");
            for (int i = 0; i < arrayList.size(); ++i) {
                String string;
                AttributeList attributeList2;
                block9: {
                    attributeList2 = (AttributeList)arrayList.get(i);
                    string = null;
                    try {
                        string = (String)ConfigServiceHelper.getAttributeValue(attributeList2, "_Websphere_Config_Data_Type");
                    }
                    catch (AttributeNotFoundException attributeNotFoundException) {
                        if (!tc.isDebugEnabled()) break block9;
                        Tr.debug(tc, "Ex - " + attributeNotFoundException.toString());
                    }
                }
                if (string != null && string.equals("HTTPTransport") && (bl = hTTPTransportTSHelper.validate(attributeList2, objectName))) break;
            }
            hTTPTransportTSHelper.reset();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate - " + bl);
        }
        return bl;
    }
}

