/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.mediator.jdbc;

import com.ibm.websphere.sdo.mediator.jdbc.metadata.Column;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Key;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Metadata;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Table;
import commonj.sdo.ChangeSummary;
import commonj.sdo.DataObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.sdo.EChangeSummarySetting;

public class DataObjectWrapper {
    private final Table table;
    private final HashMap values = new HashMap();
    private ArrayList primaryKey;

    public DataObjectWrapper(Metadata metadata2, DataObject dataObject) {
        this.table = metadata2.getTableByPropertyName(((EObject)dataObject).eClass().getName());
        ChangeSummary changeSummary = dataObject.getDataGraph().getChangeSummary();
        if (changeSummary.isDeleted(dataObject)) {
            Iterator iterator = changeSummary.getOldValues(dataObject).iterator();
            while (iterator.hasNext()) {
                EChangeSummarySetting eChangeSummarySetting = (EChangeSummarySetting)iterator.next();
                this.values.put(eChangeSummarySetting.getFeatureName(), eChangeSummarySetting.getValue());
            }
        } else {
            EObject eObject = (EObject)dataObject;
            Iterator iterator = eObject.eClass().getEAllStructuralFeatures().iterator();
            while (iterator.hasNext()) {
                EStructuralFeature eStructuralFeature = (EStructuralFeature)iterator.next();
                this.values.put(eStructuralFeature.getName(), eObject.eGet(eStructuralFeature));
            }
        }
    }

    public Table getTable() {
        return this.table;
    }

    public boolean hasCollisionColumn() {
        return this.table.getCollisionColumn() != null;
    }

    public Column getCollisionColumn() {
        return this.table.getCollisionColumn();
    }

    public int getCollisionColumnValue() {
        Integer n = (Integer)this.values.get(this.table.getCollisionColumn().getPropertyName());
        return n;
    }

    public Key getPrimaryKey() {
        return this.table.getPrimaryKey();
    }

    public ArrayList getPrimaryKeyValue() {
        if (this.primaryKey == null) {
            ArrayList arrayList = new ArrayList();
            Iterator iterator = this.table.getPrimaryKey().getColumns().iterator();
            while (iterator.hasNext()) {
                Column column = (Column)iterator.next();
                arrayList.add(this.values.get(column.getPropertyName()));
            }
            this.primaryKey = arrayList;
        }
        return this.primaryKey;
    }
}

