/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.mediator.jdbc;

import com.ibm.websphere.sdo.mediator.CountingPager;
import com.ibm.websphere.sdo.mediator.JDBCMediator;
import com.ibm.websphere.sdo.mediator.exception.MediatorException;
import com.ibm.websphere.sdo.mediator.jdbc.exception.DBException;
import com.ibm.websphere.sdo.mediator.jdbc.exception.JDBCMediatorException;
import com.ibm.ws.sdo.mediator.jdbc.MediatorImpl;
import commonj.sdo.DataObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EObjectImpl;

public class GenericPagerImpl
implements CountingPager {
    private static final long serialVersionUID = -2924495946081344807L;
    private int pageSize;
    private int pageNumber;
    private Map arguments;
    private DataObject doArguments = null;
    private int totalPages;

    public GenericPagerImpl(int n, DataObject dataObject) {
        this.pageSize = n;
        if (null != dataObject) {
            this.doArguments = dataObject;
            this.arguments = this.argMapFor(dataObject);
        } else {
            this.arguments = null;
        }
        this.totalPages = -1;
    }

    public GenericPagerImpl(int n) {
        this(n, null);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public DataObject next(JDBCMediator jDBCMediator) throws JDBCMediatorException {
        if (this.isLastPage(jDBCMediator)) {
            throw new JDBCMediatorException("Cannot move past the last page");
        }
        MediatorImpl mediatorImpl = (MediatorImpl)jDBCMediator;
        mediatorImpl.setPageSize(this.pageSize);
        int n = this.pageNumber * this.pageSize;
        DataObject dataObject = null;
        dataObject = mediatorImpl.isSuppliedQuerySearch() ? mediatorImpl.suppliedQueryPage(n, this.doArguments) : mediatorImpl.nextGenericPage(n, this.arguments);
        ++this.pageNumber;
        return dataObject;
    }

    public DataObject previous(JDBCMediator jDBCMediator) throws JDBCMediatorException {
        if (this.pageNumber <= 1) {
            throw new JDBCMediatorException("Cannot move prior to the first page");
        }
        MediatorImpl mediatorImpl = (MediatorImpl)jDBCMediator;
        mediatorImpl.setPageSize(this.pageSize);
        int n = this.pageNumber * this.pageSize;
        DataObject dataObject = null;
        dataObject = mediatorImpl.isSuppliedQuerySearch() ? mediatorImpl.suppliedQueryPage(n - 2 * this.pageSize, this.doArguments) : mediatorImpl.previousGenericPage(n - this.pageSize, this.arguments);
        --this.pageNumber;
        return dataObject;
    }

    public DataObject page(int n, JDBCMediator jDBCMediator) throws MediatorException {
        MediatorImpl mediatorImpl = (MediatorImpl)jDBCMediator;
        mediatorImpl.setPageSize(this.pageSize);
        boolean bl = mediatorImpl.isSuppliedQuerySearch();
        if (!bl) {
            if (n < 1) {
                throw new JDBCMediatorException("Cannot move prior to the first page");
            }
            if (n > this.lastPageNumber(jDBCMediator)) {
                throw new JDBCMediatorException("Cannot move past the last page");
            }
        }
        int n2 = (n - 1) * this.pageSize;
        DataObject dataObject = null;
        dataObject = bl ? mediatorImpl.suppliedQueryPage(n2, this.doArguments) : mediatorImpl.genericPage(n2, this.arguments);
        this.pageNumber = n;
        return dataObject;
    }

    public int pageCount(JDBCMediator jDBCMediator) throws MediatorException {
        return this.totalPages(jDBCMediator);
    }

    public boolean isFirstPage(JDBCMediator jDBCMediator) throws MediatorException {
        return this.pageNumber == 1;
    }

    public boolean isLastPage(JDBCMediator jDBCMediator) throws JDBCMediatorException {
        return this.pageNumber == this.lastPageNumber(jDBCMediator);
    }

    private int lastPageNumber(JDBCMediator jDBCMediator) throws DBException {
        return this.totalPages(jDBCMediator);
    }

    private int totalPages(JDBCMediator jDBCMediator) throws DBException {
        if (this.totalPages == -1) {
            long l = 0L;
            MediatorImpl mediatorImpl = (MediatorImpl)jDBCMediator;
            l = mediatorImpl.isSuppliedQuerySearch() ? mediatorImpl.rowCount(this.doArguments) : mediatorImpl.rowCount(this.arguments);
            this.totalPages = (int)Math.ceil((float)l / (float)this.pageSize);
        }
        return this.totalPages;
    }

    private Map argMapFor(DataObject dataObject) {
        EClass eClass = ((EObjectImpl)dataObject).eClass();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Iterator iterator = eClass.getEStructuralFeatures().iterator();
        while (iterator.hasNext()) {
            EStructuralFeature eStructuralFeature = (EStructuralFeature)iterator.next();
            hashMap.put(eStructuralFeature.getName(), dataObject.get(eStructuralFeature.getName()));
        }
        return hashMap;
    }
}

