/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.mediator.jdbc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sdo.mediator.jdbc.ConnectionWrapperImpl;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryPredicates;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.SelectPredicates;
import commonj.sdo.DataObject;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import org.eclipse.emf.ecore.sdo.impl.DynamicEDataObjectImpl;

public class JDBCAdapter {
    protected static final TraceComponent tc = Tr.register(JDBCAdapter.class, "JDBCMediator", "jdbcmediator.properties");
    private ConnectionWrapperImpl connectionWrapper;

    public JDBCAdapter(ConnectionWrapperImpl connectionWrapperImpl) {
        this.connectionWrapper = connectionWrapperImpl;
    }

    public ResultSet executeSelect(String string, SelectPredicates selectPredicates) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "executeSelect", new Object[]{string, selectPredicates});
        }
        ResultSet resultSet = null;
        try {
            PreparedStatement preparedStatement = this.getConnection().prepareStatement(string);
            selectPredicates.populate(preparedStatement);
            resultSet = preparedStatement.executeQuery();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "executeSelect");
            }
            return resultSet;
        }
        catch (SQLException sQLException) {
            this.discardResultSet(resultSet);
            this.ffdcFilter(sQLException, "executeSelect", "1");
            throw sQLException;
        }
    }

    public ResultSet executeSelect(String string) throws SQLException {
        return this.executeSelect(string, new SelectPredicates(null, new HashMap(), null));
    }

    public int executeUpdate(String string, QueryPredicates queryPredicates) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "executeUpdate", new Object[]{string, queryPredicates});
        }
        PreparedStatement preparedStatement = this.getConnection().prepareStatement(string);
        queryPredicates.populate(preparedStatement);
        int n = preparedStatement.executeUpdate();
        preparedStatement.close();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "executeUpdate", new Object[]{new Integer(n)});
        }
        return n;
    }

    public ResultSet executeDirectQuery(String string) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "executeDirectQuery", new Object[]{string});
        }
        Statement statement = this.getConnection().createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "executeDirectQuery");
        }
        return resultSet;
    }

    public ResultSet executeDirectquery(String string, DataObject dataObject) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "executeDirectQuery", new Object[]{string, dataObject});
        }
        PreparedStatement preparedStatement = this.getConnection().prepareStatement(string);
        DynamicEDataObjectImpl dynamicEDataObjectImpl = (DynamicEDataObjectImpl)dataObject;
        int n = dynamicEDataObjectImpl.eClass().getEAllAttributes().size();
        for (int i = 1; i <= n; ++i) {
            preparedStatement.setObject(i, dataObject.get(i - 1));
        }
        ResultSet resultSet = preparedStatement.executeQuery();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "executeDirectQuery");
        }
        return resultSet;
    }

    public int executeDirectUpdate(String string) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "executeDirectUpdate", new Object[]{string});
        }
        Statement statement = this.getConnection().createStatement();
        int n = statement.executeUpdate(string);
        statement.close();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "executeDirectUpdate", new Object[]{new Integer(n)});
        }
        return n;
    }

    public void discardResultSet(ResultSet resultSet) throws SQLException {
        if (resultSet != null) {
            resultSet.close();
        }
    }

    private Connection getConnection() {
        return this.connectionWrapper.getConnection();
    }

    private void ffdcFilter(Exception exception, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName()).append(".").append(string);
        FFDCFilter.processException((Throwable)exception, stringBuffer.toString(), string2, this);
    }
}

