/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.mediator.jdbc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sdo.mediator.JDBCMediator;
import com.ibm.websphere.sdo.mediator.ResultSetInfo;
import com.ibm.websphere.sdo.mediator.exception.MediatorException;
import com.ibm.websphere.sdo.mediator.jdbc.ConnectionWrapper;
import com.ibm.websphere.sdo.mediator.jdbc.exception.DBException;
import com.ibm.websphere.sdo.mediator.jdbc.exception.InvalidMetadataException;
import com.ibm.websphere.sdo.mediator.jdbc.exception.JDBCMediatorException;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Metadata;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sdo.mediator.jdbc.ConnectionWrapperImpl;
import com.ibm.ws.sdo.mediator.jdbc.GraphChanges;
import com.ibm.ws.sdo.mediator.jdbc.UniqueKeys;
import com.ibm.ws.sdo.mediator.jdbc.graphbuilder.PagedGraphInfo;
import com.ibm.ws.sdo.mediator.jdbc.graphbuilder.RelationalGraphBuilder;
import com.ibm.ws.sdo.mediator.jdbc.graphbuilder.RelationalGraphBuilderFactory;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryEngine;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryEngineException;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryEngineFactoryImpl;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryResult;
import commonj.sdo.ChangeSummary;
import commonj.sdo.DataObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;

public class MediatorImpl
implements JDBCMediator {
    private EClass suppliedSchema;
    private String suppliedQuery;
    protected static final TraceComponent tc = Tr.register(MediatorImpl.class, "JDBCMediator", "jdbcmediator.properties");
    private QueryEngine queryEngine;
    private Metadata metadata;
    private RelationalGraphBuilder graphBuilder;
    private ConnectionWrapperImpl connectionWrapper;
    private int pageSize;
    private UniqueKeys uniqueKeys;
    private ResultSetInfo resultSetInfo;

    public MediatorImpl(Metadata metadata2, ConnectionWrapper connectionWrapper) {
        this.metadata = metadata2;
        this.connectionWrapper = (ConnectionWrapperImpl)connectionWrapper;
        this.initialize();
    }

    public MediatorImpl(Metadata metadata2, EClass eClass, String string, ConnectionWrapper connectionWrapper) {
        this(metadata2, connectionWrapper);
        this.suppliedSchema = eClass;
        this.suppliedQuery = string;
    }

    public MediatorImpl(Metadata metadata2, String string, ConnectionWrapper connectionWrapper) {
        this(metadata2, connectionWrapper);
        this.suppliedQuery = string;
    }

    public MediatorImpl(Metadata metadata2, EClass eClass, ConnectionWrapper connectionWrapper) {
        this(metadata2, connectionWrapper);
        this.suppliedSchema = eClass;
    }

    private void initialize() {
        QueryEngineFactoryImpl queryEngineFactoryImpl = QueryEngineFactoryImpl.soleInstance();
        if (!this.connectionWrapper.isNullWrapper()) {
            this.queryEngine = queryEngineFactoryImpl.createQueryEngine(this.metadata, this, this.connectionWrapper.getDBType());
        }
        this.pageSize = 0;
    }

    public void applyChanges(boolean bl, DataObject dataObject) throws JDBCMediatorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "applyChanges");
        }
        this.applyChanges(bl, dataObject.getDataGraph().getChangeSummary());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "applyChanges");
        }
    }

    public void applyChanges(DataObject dataObject) throws JDBCMediatorException {
        this.applyChanges(true, dataObject);
    }

    public void applyChanges(boolean bl, ChangeSummary changeSummary) throws JDBCMediatorException {
        GraphChanges graphChanges = new GraphChanges(this.metadata, this.queryEngine, changeSummary, bl);
        try {
            this.connectionWrapper.start();
            graphChanges.applyChanges();
            this.connectionWrapper.commit();
            changeSummary.getChangedDataObjects().clear();
        }
        catch (DBException dBException) {
            Tr.debug(tc, "DBException: {0}", dBException);
            this.ffdcFilter(dBException, "applyChanges", "1");
            this.connectionWrapper.rollback();
            throw dBException;
        }
    }

    public DataObject getGraph(DataObject dataObject) throws MediatorException {
        if (this.suppliedQuery == null) {
            return this.getGraph((Map)dataObject);
        }
        try {
            if (this.resultSetInfo != null) {
                this.graphBuilder().setResultSetInfo(this.resultSetInfo);
            }
            return this.graphBuilder().graph(this.getResultSets(dataObject));
        }
        catch (SQLException sQLException) {
            Tr.error(tc, "SQL Exception: {0}", sQLException);
            throw new JDBCMediatorException("SQL Exception", sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataObject getGraph(Map map) throws JDBCMediatorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGraph", new Object[]{map});
        }
        QueryResult queryResult = null;
        try {
            queryResult = this.queryEngine.executeSelect(map);
            this.checkException(queryResult, "select");
            DataObject dataObject = this.graphBuilder().graph(queryResult.getResults(), queryResult.getResultDescriptors());
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGraph");
            }
            DataObject dataObject2 = dataObject;
            return dataObject2;
        }
        finally {
            this.cleanup(queryResult);
        }
    }

    protected DataObject suppliedQueryPage(int n, DataObject dataObject) throws JDBCMediatorException {
        if (this.suppliedQuery == null) {
            return this.getGraph((Map)dataObject);
        }
        try {
            if (this.resultSetInfo != null) {
                this.graphBuilder().setResultSetInfo(this.resultSetInfo);
            }
            DataObject dataObject2 = this.graphBuilder().pagedGraph(this.getResultSets(dataObject, n), new ArrayList(), this.pageSize);
            return dataObject2;
        }
        catch (SQLException sQLException) {
            Tr.error(tc, "SQL Exception: {0}", sQLException);
            sQLException.printStackTrace();
            throw new JDBCMediatorException("SQL Exception", sQLException);
        }
    }

    protected boolean isSuppliedQuerySearch() {
        return null != this.suppliedQuery;
    }

    private DataObject getRoot() throws JDBCMediatorException {
        try {
            if (this.resultSetInfo != null) {
                this.graphBuilder().setResultSetInfo(this.resultSetInfo);
            }
            DataObject dataObject = this.graphBuilder().graph(this.getResultSets());
            return dataObject;
        }
        catch (SQLException sQLException) {
            throw new JDBCMediatorException("SQL Exception", sQLException);
        }
    }

    private List getResultSets() throws SQLException {
        return Collections.singletonList(this.connectionWrapper.executeDirectQuery(this.suppliedQuery));
    }

    private List getResultSets(DataObject dataObject) throws SQLException {
        return Collections.singletonList(this.connectionWrapper.executeDirectQuery(this.suppliedQuery, dataObject));
    }

    protected long rowCount(DataObject dataObject) throws DBException {
        long l = 0L;
        try {
            ResultSet resultSet = this.connectionWrapper.executeDirectQuery(this.suppliedQuery, dataObject);
            while (resultSet.next()) {
                ++l;
            }
        }
        catch (SQLException sQLException) {
            throw new DBException("get row count failed for supplied query", sQLException);
        }
        finally {
            this.connectionWrapper.commit();
        }
        return l;
    }

    private List getResultSets(DataObject dataObject, int n) throws SQLException {
        ResultSet resultSet = this.connectionWrapper.executeDirectQuery(this.suppliedQuery, dataObject);
        boolean bl = true;
        if (n < 0) {
            return null;
        }
        for (int i = 0; bl && i < n; ++i) {
            bl = resultSet.next();
        }
        return Collections.singletonList(resultSet);
    }

    public DataObject getGraph() throws JDBCMediatorException {
        if (this.suppliedQuery != null) {
            return this.getRoot();
        }
        return this.getGraph(Collections.EMPTY_MAP);
    }

    public DataObject getEmptyGraph() throws JDBCMediatorException {
        return this.graphBuilder().emptyGraph();
    }

    public EClass getSchema() throws JDBCMediatorException {
        return this.graphBuilder().schema();
    }

    public long getKey() throws MediatorException {
        return this.uniqueKeys().getKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PagedGraphInfo nextPage(int n, Map map) throws JDBCMediatorException {
        PagedGraphInfo pagedGraphInfo;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "nextPage", new Object[]{new Integer(n), map});
        }
        QueryResult queryResult = null;
        try {
            queryResult = this.queryEngine.executeSelectNextPage(map, n);
            this.checkException(queryResult, "select");
            PagedGraphInfo pagedGraphInfo2 = this.graphBuilder().pagedGraph(queryResult.getResults(), queryResult.getResultDescriptors());
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "nextPage");
            }
            pagedGraphInfo = pagedGraphInfo2;
        }
        catch (Throwable throwable) {
            this.cleanup(queryResult);
            throw throwable;
        }
        this.cleanup(queryResult);
        return pagedGraphInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataObject nextGenericPage(int n, Map map) throws JDBCMediatorException {
        DataObject dataObject;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "nextGenericPage", new Object[]{new Integer(n), map});
        }
        QueryResult queryResult = null;
        try {
            queryResult = this.queryEngine.executeSelectNextPage(map, n);
            this.checkException(queryResult, "nextGenericPage");
            DataObject dataObject2 = this.graphBuilder().pagedGraph(queryResult.getResults(), queryResult.getResultDescriptors(), this.pageSize);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "nextGenericPage");
            }
            dataObject = dataObject2;
        }
        catch (Throwable throwable) {
            this.cleanup(queryResult);
            throw throwable;
        }
        this.cleanup(queryResult);
        return dataObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataObject genericPage(int n, Map map) throws JDBCMediatorException {
        DataObject dataObject;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "genericPage", new Object[]{new Integer(n), map});
        }
        QueryResult queryResult = null;
        try {
            queryResult = this.queryEngine.executeSelectNextPage(map, n);
            this.checkException(queryResult, "genericPage");
            DataObject dataObject2 = this.graphBuilder().pagedGraph(queryResult.getResults(), queryResult.getResultDescriptors(), this.pageSize);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "genericPage");
            }
            dataObject = dataObject2;
        }
        catch (Throwable throwable) {
            this.cleanup(queryResult);
            throw throwable;
        }
        this.cleanup(queryResult);
        return dataObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataObject previousGenericPage(int n, Map map) throws JDBCMediatorException {
        DataObject dataObject;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "previousGenericPage", new Object[]{new Integer(n), map});
        }
        QueryResult queryResult = null;
        try {
            queryResult = this.queryEngine.executeSelectPreviousPage(map, n);
            this.checkException(queryResult, "previousGenericPage");
            DataObject dataObject2 = this.graphBuilder().pagedGraph(queryResult.getResults(), queryResult.getResultDescriptors(), this.pageSize);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "previousGenericPage");
            }
            dataObject = dataObject2;
        }
        catch (Throwable throwable) {
            this.cleanup(queryResult);
            throw throwable;
        }
        this.cleanup(queryResult);
        return dataObject;
    }

    private UniqueKeys uniqueKeys() {
        if (this.uniqueKeys == null) {
            this.uniqueKeys = new UniqueKeys(this, this.metadata);
        }
        return this.uniqueKeys;
    }

    protected void setPageSize(int n) {
        this.pageSize = n;
        this.queryEngine.setPageSize(n);
    }

    protected int getPageSize() {
        return this.pageSize;
    }

    private RelationalGraphBuilder graphBuilder() throws InvalidMetadataException {
        if (this.graphBuilder == null) {
            this.graphBuilder = RelationalGraphBuilderFactory.getRelationalGraphBuilder(this.metadata, this.suppliedSchema);
        }
        return this.graphBuilder;
    }

    private void cleanup(QueryResult queryResult) throws DBException {
        try {
            this.connectionWrapper.commit();
            if (queryResult != null) {
                queryResult.discard();
            }
        }
        catch (QueryEngineException queryEngineException) {
            this.ffdcFilter(queryEngineException, "cleanup", "2");
            throw new DBException("QueryEngineException in cleanup: " + queryEngineException, queryEngineException);
        }
    }

    private void checkException(QueryResult queryResult, String string) throws DBException {
        if (queryResult.hasException()) {
            QueryEngineException queryEngineException = queryResult.getException();
            throw new DBException("QE " + string + ":" + queryEngineException, queryEngineException);
        }
    }

    public void setConnectionWrapper(ConnectionWrapper connectionWrapper) {
        this.connectionWrapper = (ConnectionWrapperImpl)connectionWrapper;
    }

    public ConnectionWrapper getConnectionWrapper() {
        return this.connectionWrapper;
    }

    protected QueryEngine getQueryEngine() {
        return this.queryEngine;
    }

    private void ffdcFilter(Exception exception, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName()).append(".").append(string);
        FFDCFilter.processException((Throwable)exception, stringBuffer.toString(), string2, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long rowCount(Map map) throws DBException {
        try {
            long l = this.queryEngine.executeCount(map);
            return l;
        }
        finally {
            this.connectionWrapper.commit();
        }
    }

    public DataObject getParameterDataObject() throws InvalidMetadataException {
        if (this.suppliedQuery == null) {
            return this.graphBuilder().getParameterDataObject();
        }
        return this.graphBuilder().getParameterDataObject(this.suppliedQuery);
    }

    public void setResultSetInfo(ResultSetInfo resultSetInfo) throws MediatorException {
        this.resultSetInfo = resultSetInfo;
    }
}

