/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.mediator.jdbc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sdo.mediator.JDBCMediator;
import com.ibm.websphere.sdo.mediator.jdbc.exception.DBException;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Column;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Metadata;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Table;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sdo.mediator.jdbc.ConnectionWrapperImpl;
import com.ibm.ws.sdo.mediator.jdbc.MediatorImpl;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryEngine;
import java.sql.ResultSet;
import java.sql.SQLException;

public class UniqueKeys {
    protected static final TraceComponent tc = Tr.register(UniqueKeys.class, "JDBCMediator", "jdbcmediator.properties");
    private long currentKey;
    private long lastKeyInRange;
    private int keyBufferSize;
    private boolean initialized;
    private JDBCMediator mediator;
    private Metadata metadata;
    private String nextColumnName;

    public UniqueKeys(JDBCMediator jDBCMediator, Metadata metadata2) {
        this.mediator = jDBCMediator;
        this.metadata = metadata2;
        this.keyBufferSize = metadata2.getUniqueKeyBufferSize();
        if (this.keyBufferSize == 0) {
            throw new Error("Key buffer size cannot be zero");
        }
        this.initialized = false;
    }

    private void initialize() throws DBException {
        Table table = this.metadata.getUniqueKeyTable();
        Column column = (Column)table.getColumns().get(1);
        this.nextColumnName = column.getName();
        this.moreKeys();
        this.initialized = true;
    }

    public long getKey() throws DBException {
        if (!this.initialized) {
            this.initialize();
        }
        if (this.currentKey <= this.lastKeyInRange) {
            long l = this.currentKey++;
            return l;
        }
        this.moreKeys();
        return this.getKey();
    }

    private void moreKeys() throws DBException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "moreKeys");
        }
        String string = this.getQueryEngine().getUniqueKeySelectString();
        try {
            this.getConnectionWrapper().start();
            long l = 0L;
            ResultSet resultSet = this.getConnectionWrapper().executeDirectQuery(string);
            if (resultSet.next()) {
                l = resultSet.getLong(this.nextColumnName);
            } else {
                this.insertInitialRow();
                this.moreKeys();
            }
            this.getConnectionWrapper().discardResultSet(resultSet);
            this.currentKey = l;
            this.lastKeyInRange = l + (long)this.keyBufferSize - 1L;
            long l2 = l + (long)this.keyBufferSize;
            String string2 = this.getQueryEngine().getUniqueKeyUpdateString(l2);
            this.getConnectionWrapper().executeDirectUpdate(string2);
            this.getConnectionWrapper().commit();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "moreKeys", new Object[]{new Integer(this.keyBufferSize), string2});
            }
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.wdo.mediator.rdb.UniqueKeys.moreKeys", "1", this);
            this.getConnectionWrapper().rollback();
            throw new DBException("Unable to read the Key Table: " + sQLException, sQLException);
        }
    }

    private QueryEngine getQueryEngine() {
        return ((MediatorImpl)this.mediator).getQueryEngine();
    }

    private ConnectionWrapperImpl getConnectionWrapper() {
        return (ConnectionWrapperImpl)this.mediator.getConnectionWrapper();
    }

    private void insertInitialRow() throws SQLException {
        String string = this.getQueryEngine().getUniqueKeyInsertString();
        this.getConnectionWrapper().executeDirectUpdate(string);
    }
}

