/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.mediator.jdbc.graphbuilder.impl;

import com.ibm.websphere.sdo.mediator.ResultSetInfo;
import com.ibm.websphere.sdo.mediator.jdbc.exception.InvalidMetadataException;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Column;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Metadata;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Table;
import com.ibm.ws.sdo.mediator.jdbc.graphbuilder.impl.ResultSetInfoImpl;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryResultDescriptor;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class GraphBuilderMetadata {
    private String[] tableNames;
    private String[] aliasNames;
    private int[] columnTypes;
    private HashMap columnMap;
    private HashMap featureMap;
    private int startIndex = 1;
    private HashMap tableMap;
    private HashMap refMap;
    private int columnCount = 0;
    private boolean[] primaryKeys;

    public GraphBuilderMetadata(QueryResultDescriptor queryResultDescriptor, boolean bl, EClass eClass) throws InvalidMetadataException {
        this.columnCount = queryResultDescriptor.size();
        this.initialize(this.columnCount);
        Iterator iterator = queryResultDescriptor.columns().iterator();
        if (bl) {
            iterator.next();
            this.startIndex = 2;
        }
        this.buildRefMap(eClass);
        int n = 0;
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            this.columnTypes[n] = column.getType();
            this.tableNames[n] = column.getTable().getPropertyName();
            this.aliasNames[n] = column.getTable().getName();
            this.primaryKeys[n] = column.getTable().getPrimaryKey().getColumns().contains((Object)column);
            this.setFeature(this.tableNames[n], column);
            ++n;
        }
    }

    private void setFeature(String string, Column column) throws InvalidMetadataException {
        ArrayList<EStructuralFeature> arrayList = (ArrayList<EStructuralFeature>)this.featureMap.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<EStructuralFeature>();
            this.featureMap.put(string, arrayList);
        }
        EClass eClass = this.getTableClass(string);
        EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(column.getPropertyName());
        arrayList.add(eStructuralFeature);
    }

    private void buildRefMap(EClass eClass) {
        this.refMap = new HashMap();
        Iterator iterator = eClass.getEAllReferences().iterator();
        while (iterator.hasNext()) {
            EReference eReference = (EReference)iterator.next();
            this.refMap.put(eReference.getEReferenceType().getName(), eReference);
        }
    }

    private void initialize(int n) {
        this.columnTypes = new int[n];
        this.tableNames = new String[n];
        this.primaryKeys = new boolean[n];
        this.aliasNames = new String[n];
        this.featureMap = new HashMap();
    }

    public GraphBuilderMetadata(Metadata metadata2, ResultSet resultSet, ResultSetInfo resultSetInfo, EClass eClass) throws SQLException, InvalidMetadataException {
        ResultSetInfoImpl resultSetInfoImpl = (ResultSetInfoImpl)resultSetInfo;
        if (resultSetInfoImpl == null) {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            resultSetInfoImpl = new ResultSetInfoImpl(resultSetMetaData);
        }
        this.columnCount = resultSetInfoImpl.getSize();
        this.initialize(this.columnCount);
        this.buildRefMap(eClass);
        for (int i = 0; i < this.columnCount; ++i) {
            Object object;
            String string = resultSetInfoImpl.getColumnName(i);
            String string2 = resultSetInfoImpl.getTableName(i);
            String string3 = resultSetInfoImpl.getAliasName(i);
            if (string2 == null || string2.equals("")) {
                this.tableNames[i] = this.findColumn(metadata2, string).getTable().getPropertyName();
                object = this.findColumn(metadata2, string);
                this.columnTypes[i] = object.getType();
                this.primaryKeys[i] = object.getTable().getPrimaryKey().getColumns().contains(object);
                if (string3 == null || string3.equals("")) {
                    this.aliasNames[i] = object.getTable().getName();
                }
                this.setFeature(this.tableNames[i], (Column)object);
                continue;
            }
            object = metadata2.getTable(string2);
            Column column = this.findColumn(metadata2, string2, string);
            if (object == null) {
                throw new InvalidMetadataException("The table " + string2 + " is returned from the query but is not defined in the Metadata", 5140);
            }
            this.tableNames[i] = object.getPropertyName();
            if (column == null) {
                throw new InvalidMetadataException("The column " + string + " is returned from the query but is not defined in the Metadata", 5160);
            }
            this.columnTypes[i] = column.getType();
            this.primaryKeys[i] = column.getTable().getPrimaryKey().getColumns().contains((Object)column);
            this.aliasNames[i] = string3;
            this.setFeature(this.tableNames[i], column);
        }
    }

    private Column findColumn(Metadata metadata2, String string, String string2) throws InvalidMetadataException {
        HashMap hashMap;
        if (this.tableMap == null) {
            this.buildTableColumnMap(metadata2);
        }
        if ((hashMap = (HashMap)this.tableMap.get(string.toUpperCase())) == null) {
            throw new InvalidMetadataException("The table " + string + " is returned from the query but is not defined in the Metadata", 5140);
        }
        Column column = (Column)hashMap.get(string2.toUpperCase());
        if (column == null) {
            throw new InvalidMetadataException("The column " + string2 + " is returned from the query but is not defined in the Metadata", 5160);
        }
        return column;
    }

    private void buildTableColumnMap(Metadata metadata2) {
        this.tableMap = new HashMap();
        Iterator iterator = metadata2.getTables().iterator();
        while (iterator.hasNext()) {
            Table table = (Table)iterator.next();
            HashMap<String, Column> hashMap = new HashMap<String, Column>();
            Iterator iterator2 = table.getColumns().iterator();
            while (iterator2.hasNext()) {
                Column column = (Column)iterator2.next();
                hashMap.put(column.getName().toUpperCase(), column);
            }
            this.tableMap.put(table.getName().toUpperCase(), hashMap);
        }
    }

    private Column findColumn(Metadata metadata2, String string) throws InvalidMetadataException {
        Column column;
        if (this.columnMap == null) {
            this.populateColumnMap(metadata2);
        }
        if ((column = (Column)this.columnMap.get(string.toUpperCase())) == null) {
            throw new InvalidMetadataException("The column " + string + " is returned from the query but is not defined in the Metadata", 5160);
        }
        return column;
    }

    private void populateColumnMap(Metadata metadata2) throws InvalidMetadataException {
        this.columnMap = new HashMap();
        Iterator iterator = metadata2.getTables().iterator();
        while (iterator.hasNext()) {
            Table table = (Table)iterator.next();
            Iterator iterator2 = table.getColumns().iterator();
            while (iterator2.hasNext()) {
                Column column = (Column)iterator2.next();
                if (this.columnMap.put(column.getName().toUpperCase(), column) == null) continue;
                throw new InvalidMetadataException("The query returns multiple columns named " + column.getName() + ". The table name can not be determined.", 5150);
            }
        }
    }

    public String getTableName(int n) {
        return this.tableNames[n - 1];
    }

    public String getAliasName(int n) {
        return this.aliasNames[n - 1];
    }

    public int getType(int n) {
        return this.columnTypes[n - 1];
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.getColumnCount();
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public EClass getTableClass(String string) throws InvalidMetadataException {
        EReference eReference = (EReference)this.refMap.get(string);
        if (eReference == null) {
            throw new InvalidMetadataException("The table " + string + " is returned from the query but is either not defined or defined as external in the Metadata", 5140);
        }
        return eReference.getEReferenceType();
    }

    public EReference getReference(String string) {
        return (EReference)this.refMap.get(string);
    }

    public boolean isPrimaryKey(int n) {
        return this.primaryKeys[n - 1];
    }

    public int getTableSize(String string) {
        List list = (List)this.featureMap.get(string);
        return list.size();
    }

    public EStructuralFeature getFeature(String string, int n) {
        ArrayList arrayList = (ArrayList)this.featureMap.get(string);
        return (EStructuralFeature)arrayList.get(n);
    }
}

