/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.mediator.jdbc.graphbuilder.impl;

import com.ibm.websphere.sdo.mediator.jdbc.exception.InvalidMetadataException;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Column;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Filter;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Metadata;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Relationship;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Table;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sdo.mediator.jdbc.graphbuilder.MetadataValidator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public class MetadataValidatorImpl
implements MetadataValidator {
    private Metadata metadata;
    private ArrayList errors;
    private ArrayList tableNames;
    private boolean atRuntime = false;

    public MetadataValidatorImpl(Metadata metadata2) {
        this.metadata = metadata2;
        this.errors = new ArrayList();
        this.tableNames = new ArrayList();
    }

    public void validate() throws InvalidMetadataException {
        this.validate(true);
    }

    private void validate(boolean bl) throws InvalidMetadataException {
        this.atRuntime = bl;
        this.checkForAtLeastOneTable();
        this.checkForRootTable();
        this.checkTables();
        this.checkChildKeys();
    }

    public List getValidationErrors() {
        this.errors.clear();
        try {
            this.validate(false);
        }
        catch (InvalidMetadataException invalidMetadataException) {
            FFDCFilter.processException((Throwable)invalidMetadataException, "com.ibm.websphere.wdo.mediator.rdb.graphbuilder.MetadataValidatorImpl.getValidationErrors", "58", this);
        }
        return this.errors;
    }

    private void addError(String string, int n) throws InvalidMetadataException {
        if (this.atRuntime) {
            throw new InvalidMetadataException(string, n);
        }
        this.errors.add(string);
    }

    private void checkTables() throws InvalidMetadataException {
        this.tableNames.clear();
        Iterator iterator = this.metadata.getTables().iterator();
        while (iterator.hasNext()) {
            Table table = (Table)iterator.next();
            this.checkPrimaryKey(table);
            this.checkQueryInfo(table.getFilter());
            this.checkColumns(table.getName(), (List)table.getColumns());
            this.checkName(table.qualifiedName());
        }
    }

    private void checkName(String string) throws InvalidMetadataException {
        if (this.tableNames.contains(string)) {
            this.addError("Multiple tables were found with the name: " + string, 5030);
        }
        this.tableNames.add(string);
    }

    private void checkPrimaryKey(Table table) throws InvalidMetadataException {
        if (table.getPrimaryKey() == null) {
            this.addError("No primary key is defined for table: " + table.getName(), 5040);
            return;
        }
        EList eList = table.getPrimaryKey().getColumns();
        if (eList.isEmpty()) {
            this.addError("The primary key for table " + table.getName() + " must contain at least one column", 5050);
        }
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            if (!table.getColumns().contains((Object)column)) {
                this.addError("The column " + column.getName() + " is part of the primary key for table " + table.getName() + " but is not contained in the table's list of columns.", 5060);
            }
            this.checkNullable(column);
        }
    }

    private void checkNullable(Column column) throws InvalidMetadataException {
        if (column.isNullable()) {
            this.addError("The column " + column.getName() + " can not have a nullable type because it is part of a primary key.", 5070);
        }
    }

    private void checkColumns(String string, List list) throws InvalidMetadataException {
        if (list.isEmpty()) {
            this.addError("The table " + string + " does not contain any columns", 5080);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            if (arrayList.contains(column.getName())) {
                this.addError("The table: " + string + " contains a duplicate column: " + column.getName(), 5090);
                continue;
            }
            arrayList.add(column.getName());
        }
    }

    private void checkQueryInfo(Filter filter) throws InvalidMetadataException {
        if (filter == null) {
            return;
        }
        String string = filter.getPredicate();
        if (string == null) {
            this.addError("Filter must contain a predicate", 5100);
        }
        if (this.argCount(string) != filter.getFilterArguments().size()) {
            this.addError("Invalid number of filter arguments for the given filter string", 5110);
        }
    }

    private void checkChildKeys() throws InvalidMetadataException {
        EList eList = this.metadata.getRelationships();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Relationship relationship = (Relationship)iterator.next();
            if (relationship.getChildKey().isForeignKey()) continue;
            this.addError("The child key in a relationship must be a foreign key", 5120);
        }
    }

    private int argCount(String string) {
        int n = string.indexOf("?");
        if (n == -1) {
            return 0;
        }
        return this.argCount(string.substring(n + 1)) + 1;
    }

    private void checkForRootTable() throws InvalidMetadataException {
        if (this.metadata.getRootTable() == null) {
            if (this.metadata.getTables().size() == 1) {
                this.metadata.setRootTable((Table)this.metadata.getTables().get(0));
            } else {
                this.addError("A root table must be defined", 5120);
            }
        }
    }

    private void checkForAtLeastOneTable() throws InvalidMetadataException {
        if (this.metadata.getTables().isEmpty()) {
            this.addError("Metadata must contain at least one table", 5130);
        }
    }
}

