/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.mediator.jdbc.graphbuilder.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sdo.mediator.ResultSetInfo;
import com.ibm.websphere.sdo.mediator.jdbc.exception.DBException;
import com.ibm.websphere.sdo.mediator.jdbc.exception.InvalidMetadataException;
import com.ibm.websphere.sdo.mediator.jdbc.exception.JDBCMediatorException;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Metadata;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sdo.mediator.jdbc.graphbuilder.MetadataValidator;
import com.ibm.ws.sdo.mediator.jdbc.graphbuilder.PagedGraphInfo;
import com.ibm.ws.sdo.mediator.jdbc.graphbuilder.RelationalGraphBuilder;
import com.ibm.ws.sdo.mediator.jdbc.graphbuilder.RelationalGraphBuilderFactory;
import com.ibm.ws.sdo.mediator.jdbc.graphbuilder.impl.ResultSetProcessor;
import com.ibm.ws.sdo.mediator.jdbc.graphbuilder.schema.ESchemaMaker;
import com.ibm.ws.sdo.mediator.jdbc.graphbuilder.schema.InputSchemaMaker;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryResultDescriptor;
import commonj.sdo.DataObject;
import commonj.sdo.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.sdo.EType;
import org.eclipse.emf.ecore.sdo.SDOFactory;
import org.eclipse.emf.ecore.sdo.impl.EDataGraphImpl;
import org.eclipse.emf.ecore.sdo.impl.SDOPackageImpl;
import org.eclipse.emf.ecore.sdo.util.SDOUtil;
import org.eclipse.emf.ecore.util.InternalEList;

public class RelationalGraphBuilderImpl
implements RelationalGraphBuilder {
    protected static final TraceComponent tc = Tr.register(RelationalGraphBuilderImpl.class, "JDBCMediator", "jdbcmediator.properties");
    private final Metadata metadata;
    private EClass schema;
    private boolean usingStaticSchema = false;
    private ResultSetInfo info;

    public RelationalGraphBuilderImpl(Metadata metadata2) throws InvalidMetadataException {
        this.metadata = metadata2;
        this.init();
        this.validate();
    }

    public void setResultSetInfo(ResultSetInfo resultSetInfo) {
        this.info = resultSetInfo;
    }

    private void validate() throws InvalidMetadataException {
        MetadataValidator metadataValidator = RelationalGraphBuilderFactory.getMetadataValidator(this.metadata);
        metadataValidator.validate();
    }

    private void init() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SDOPackageImpl.init();
                return null;
            }
        });
    }

    public RelationalGraphBuilderImpl(Metadata metadata2, EClass eClass) throws InvalidMetadataException {
        this(metadata2);
        this.schema = eClass;
        this.usingStaticSchema = true;
    }

    private DataObject graph(List list, List list2, PagedGraphInfo pagedGraphInfo, int n) throws JDBCMediatorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "graph");
        }
        EDataGraphImpl eDataGraphImpl = this.createEDataGraph(this.schema());
        ResultSetProcessor resultSetProcessor = new ResultSetProcessor(this.metadata, eDataGraphImpl.getRootObject());
        try {
            if (list != null) {
                Iterator iterator = list.iterator();
                Iterator iterator2 = list2.iterator();
                if (iterator.hasNext()) {
                    resultSetProcessor.process((ResultSet)iterator.next(), this.info, pagedGraphInfo, this.getNextDescriptor(iterator2), n, false);
                }
                while (iterator.hasNext()) {
                    resultSetProcessor.process((ResultSet)iterator.next(), this.info, pagedGraphInfo, this.getNextDescriptor(iterator2), Integer.MAX_VALUE, true);
                }
            }
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.websphere.wdo.mediator.rdb.graphbuilder.impl.RelationalGraphBuilderImpl", "58", this);
            throw new DBException("Error processing ResultSet: " + sQLException, sQLException);
        }
        eDataGraphImpl.getChangeSummary().beginLogging();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "graph");
        }
        return eDataGraphImpl.getRootObject();
    }

    private EDataGraphImpl createEDataGraph(EClass eClass) {
        EType eType;
        final EDataGraphImpl eDataGraphImpl = (EDataGraphImpl)SDOFactory.eINSTANCE.createEDataGraph();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SDOUtil.createResourceSet();
                return null;
            }
        });
        ResourceSet resourceSet = SDOUtil.createResourceSet();
        if (!this.usingStaticSchema) {
            eType = resourceSet.createResource(URI.createURI((String)eClass.getEPackage().getNsURI()));
            InternalEList internalEList = (InternalEList)eType.getContents();
            internalEList.addUnique((Object)eClass.getEPackage());
        }
        eDataGraphImpl.setResourceSet(resourceSet);
        eType = SDOUtil.adaptType((EClassifier)eClass);
        AccessController.doPrivileged(new PrivilegedAction((Type)eType){
            private final /* synthetic */ Type val$rootType;
            {
                this.val$rootType = type;
            }

            public Object run() {
                eDataGraphImpl.createRootObject(this.val$rootType);
                return null;
            }
        });
        return eDataGraphImpl;
    }

    public DataObject emptyGraph() throws JDBCMediatorException {
        return this.graph(null, null, null, Integer.MAX_VALUE);
    }

    public EClass schema() {
        if (this.schema == null) {
            ESchemaMaker eSchemaMaker = new ESchemaMaker(this.metadata);
            this.schema = eSchemaMaker.getESchema();
        }
        return this.schema;
    }

    public PagedGraphInfo pagedGraph(List list, List list2) throws JDBCMediatorException {
        PagedGraphInfo pagedGraphInfo = new PagedGraphInfo();
        DataObject dataObject = this.graph(list, list2, pagedGraphInfo, Integer.MAX_VALUE);
        pagedGraphInfo.setGraph(dataObject);
        return pagedGraphInfo;
    }

    public DataObject graph(List list, List list2) throws JDBCMediatorException {
        return this.graph(list, list2, null, Integer.MAX_VALUE);
    }

    public DataObject graph(List list) throws JDBCMediatorException {
        return this.graph(list, new ArrayList());
    }

    public DataObject pagedGraph(List list, List list2, int n) throws JDBCMediatorException {
        DataObject dataObject = this.graph(list, list2, null, n);
        return dataObject;
    }

    public DataObject graph(ResultSet resultSet) throws JDBCMediatorException {
        return this.graph(Collections.singletonList(resultSet));
    }

    private QueryResultDescriptor getNextDescriptor(Iterator iterator) {
        return iterator.hasNext() ? (QueryResultDescriptor)iterator.next() : null;
    }

    private ResultSetInfo getNextRSInfo(Iterator iterator) {
        return iterator.hasNext() ? (ResultSetInfo)iterator.next() : null;
    }

    public DataObject getParameterDataObject() {
        InputSchemaMaker inputSchemaMaker = new InputSchemaMaker();
        EClass eClass = inputSchemaMaker.getInputSchema(this.metadata);
        return this.createEDataGraph(eClass).getRootObject();
    }

    public DataObject getParameterDataObject(String string) {
        InputSchemaMaker inputSchemaMaker = new InputSchemaMaker();
        EClass eClass = inputSchemaMaker.getInputSchema(string);
        return this.createEDataGraph(eClass).getRootObject();
    }
}

