/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.mediator.jdbc.graphbuilder.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sdo.mediator.jdbc.graphbuilder.impl.GraphBuilderMetadata;
import com.ibm.ws.sdo.mediator.jdbc.graphbuilder.impl.TableData;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ResultSetRow {
    protected static final TraceComponent tc = Tr.register(ResultSetRow.class, "JDBCMediator", "jdbcmediator.properties");
    private final GraphBuilderMetadata metadata;
    private HashMap tableMapByAlias;
    private HashMap tableMapByName;

    public ResultSetRow(ResultSet resultSet, GraphBuilderMetadata graphBuilderMetadata) throws SQLException {
        this.metadata = graphBuilderMetadata;
        this.tableMapByAlias = new HashMap();
        this.tableMapByName = new HashMap();
        this.processRow(resultSet);
    }

    private void processRow(ResultSet resultSet) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processRow");
        }
        for (int i = this.metadata.getStartIndex(); i <= this.metadata.getEndIndex(); ++i) {
            Object object = this.getObject(resultSet, i);
            TableData tableData = this.getRawData(this.metadata.getAliasName(i), this.metadata.getTableName(i));
            tableData.addData(object, this.metadata.isPrimaryKey(i));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processRow");
        }
    }

    private Object getObject(ResultSet resultSet, int n) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObject");
        }
        Object object = null;
        switch (this.metadata.getType(n)) {
            case 0: {
                object = new Integer(resultSet.getInt(n));
                break;
            }
            case 9: {
                object = resultSet.getBigDecimal(n);
                break;
            }
            case 13: {
                Blob blob = resultSet.getBlob(n);
                if (blob == null || blob.length() <= 0L) break;
                object = blob.getBytes(1L, (int)blob.length());
                break;
            }
            case 1: {
                object = new Boolean(resultSet.getBoolean(n));
                break;
            }
            case 2: {
                object = new Byte(resultSet.getByte(n));
                break;
            }
            case 15: {
                object = resultSet.getBytes(n);
                break;
            }
            case 14: {
                Clob clob = resultSet.getClob(n);
                if (clob == null || clob.length() <= 0L) break;
                object = clob.getSubString(1L, (int)clob.length());
                break;
            }
            case 10: {
                object = resultSet.getDate(n);
                break;
            }
            case 5: {
                object = new Double(resultSet.getDouble(n));
                break;
            }
            case 7: {
                object = new Float(resultSet.getFloat(n));
                break;
            }
            case 6: {
                object = new Long(resultSet.getLong(n));
                break;
            }
            case 3: {
                object = new Short(resultSet.getShort(n));
                break;
            }
            case 4: {
                object = resultSet.getString(n);
                break;
            }
            case 11: {
                object = resultSet.getTime(n);
                break;
            }
            case 12: {
                object = resultSet.getTimestamp(n);
                break;
            }
            default: {
                object = resultSet.getObject(n);
            }
        }
        if (resultSet.wasNull()) {
            object = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObject", new Object[]{object});
        }
        return object;
    }

    public TableData getTable(String string) {
        return (TableData)this.tableMapByAlias.get(string.toUpperCase());
    }

    public List getTableByName(String string) {
        return (List)this.tableMapByName.get(string);
    }

    private TableData getRawData(String string, String string2) {
        TableData tableData;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRawData");
        }
        if ((tableData = (TableData)this.tableMapByAlias.get(string.toUpperCase())) == null) {
            tableData = new TableData(string2, this.metadata);
            this.tableMapByAlias.put(string.toUpperCase(), tableData);
            ArrayList<TableData> arrayList = (ArrayList<TableData>)this.tableMapByName.get(string2);
            if (null == arrayList) {
                arrayList = new ArrayList<TableData>();
                this.tableMapByName.put(string2, arrayList);
            }
            arrayList.add(tableData);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRawData");
        }
        return tableData;
    }
}

