/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.mediator.jdbc.graphbuilder.schema;

import com.ibm.websphere.models.util.MapDataObjectImpl;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Metadata;
import com.ibm.ws.sdo.mediator.jdbc.graphbuilder.schema.EReferenceMaker;
import com.ibm.ws.sdo.mediator.jdbc.graphbuilder.schema.RelationshipMaker;
import com.ibm.ws.sdo.mediator.jdbc.graphbuilder.schema.TableMaker;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;

public class ESchemaMaker {
    private final Metadata metadata;
    private EClass eSchema;
    private EPackage dataGraphPackage;
    private final String nsPrefix;
    private final String pkgName;

    public ESchemaMaker(Metadata metadata2) {
        this(metadata2, null, null);
    }

    public ESchemaMaker(Metadata metadata2, String string, String string2) {
        if (string == null) {
            string = "datagraph";
        }
        if (string2 == null) {
            string2 = "datagraph";
        }
        this.metadata = metadata2;
        this.nsPrefix = string;
        this.pkgName = string2;
        this.createESchema();
    }

    public EClass getESchema() {
        return this.eSchema;
    }

    private void createESchema() {
        TableMaker tableMaker = new TableMaker(this.getEPackage());
        tableMaker.createSchemaForTables((List)this.metadata.getTables());
        RelationshipMaker relationshipMaker = new RelationshipMaker(this.getEPackage());
        relationshipMaker.createSchemaForRelationships((List)this.metadata.getRelationships());
        EReferenceMaker eReferenceMaker = new EReferenceMaker();
        EClass eClass = EcoreFactory.eINSTANCE.createEClass();
        eClass.setName(this.metadata.getRootObject());
        this.getEPackage().getEClassifiers().add((Object)eClass);
        Iterator iterator = tableMaker.getTableNames().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            EClass eClass2 = (EClass)this.getEPackage().getEClassifier(string);
            EReference eReference = eReferenceMaker.createOneToManyReference(string, eClass2, true);
            eClass.getEStructuralFeatures().add((Object)eReference);
        }
        this.eSchema = eClass;
        EcoreUtil.freeze((EPackage)this.eSchema.getEPackage());
    }

    private void save(ENamedElement eNamedElement, OutputStream outputStream) throws IOException {
        XMIResourceImpl xMIResourceImpl = new XMIResourceImpl();
        xMIResourceImpl.getContents().add((Object)eNamedElement);
        xMIResourceImpl.save(outputStream, null);
    }

    public void save(OutputStream outputStream) throws IOException {
        this.save((ENamedElement)this.getEPackage(), outputStream);
    }

    public EPackage getEPackage() {
        if (this.dataGraphPackage == null) {
            this.dataGraphPackage = this.createEPackage();
        }
        return this.dataGraphPackage;
    }

    protected EPackage createEPackage() {
        EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
        ePackage.setName(this.pkgName);
        ePackage.setNsPrefix(this.nsPrefix);
        ePackage.setNsURI(this.metadata.getRootObject() + ".ecore");
        ePackage.setEFactoryInstance((EFactory)new EFactoryImpl(){

            public EObject basicCreate(EClass eClass) {
                MapDataObjectImpl mapDataObjectImpl = new MapDataObjectImpl(eClass);
                return mapDataObjectImpl;
            }
        });
        return ePackage;
    }
}

