/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.mediator.jdbc.queryengine;

import com.ibm.ObjectQuery.crud.util.ListWrapper;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Metadata;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.CTESelectStatementCreator;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryEngineException;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryEngineInfo;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryResultDescriptor;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.RootJoinMapNode;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.RootTableCountSelectBuilder;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.SelectBuilder;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.SelectStatementCreator;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.schema.RDBSchema;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.FullOrSubSelect;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.SelectStatement;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.SqlStatement;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.SubSelect;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.TableReference;
import java.util.ArrayList;

public class CountSelectBuilder
extends SelectBuilder {
    public static final String T1 = "T1";
    public static final String T2 = "T2";

    public CountSelectBuilder(Metadata metadata2, RDBSchema rDBSchema) throws QueryEngineException {
        this.setMetadata(metadata2);
        this.setSchema(rDBSchema);
        this.initialize();
    }

    public SqlStatement defaultStatement() throws QueryEngineException {
        TableReference tableReference;
        if (this.isSingle() && this.getRootFilter() == null) {
            RootTableCountSelectBuilder rootTableCountSelectBuilder = new RootTableCountSelectBuilder(this.getMetadata(), this.getSchema());
            return rootTableCountSelectBuilder.statement();
        }
        SelectStatementCreator selectStatementCreator = this.newSelectStatementCreator();
        selectStatementCreator.resultColumns(this.resultDescriptor().resultSetElements());
        if (!this.isForRootOnly()) {
            selectStatementCreator.joinMap(RootJoinMapNode.from(this.rootTable()));
        }
        SelectStatement selectStatement = selectStatementCreator.build();
        if (this.isSingle() || !this.isUsingCTESelectBuilder()) {
            this.addFilters(selectStatement);
        } else if (this.isUsingCTESelectBuilder()) {
            this.filterArguments().addAll(((CTESelectStatementCreator)selectStatementCreator).filterArguments());
        }
        SubSelect subSelect = null;
        FullOrSubSelect fullOrSubSelect = selectStatement.select();
        if (!this.isSingle()) {
            selectStatementCreator = new SelectStatementCreator();
            tableReference = QueryEngineInfo.isOracle() ? new TableReference(fullOrSubSelect) : new TableReference(fullOrSubSelect, T1);
            subSelect = new SubSelect(new ArrayList(), ListWrapper.list(tableReference));
            subSelect.selectClause().distinct();
        } else {
            subSelect = (SubSelect)selectStatement.select();
        }
        selectStatementCreator = new SelectStatementCreator();
        tableReference = QueryEngineInfo.isOracle() ? new TableReference(subSelect) : new TableReference(subSelect, T2);
        selectStatementCreator.tables(ListWrapper.list(tableReference));
        this.resultDescriptor(this.createResultDescriptorForCount());
        selectStatementCreator.resultColumns(this.resultDescriptor().resultSetElements());
        SelectStatement selectStatement2 = selectStatementCreator.build();
        if (!selectStatement.hasCTEs()) {
            return selectStatement2;
        }
        selectStatement.select(selectStatement2.select());
        return selectStatement;
    }

    public QueryResultDescriptor createResultDescriptor() {
        return new QueryResultDescriptor(this.getSchema().root().getPrimaryKey().getMembers());
    }
}

