/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.mediator.jdbc.queryengine;

import com.ibm.ObjectQuery.crud.util.Trace;
import com.ibm.websphere.sdo.mediator.JDBCMediator;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Metadata;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sdo.mediator.jdbc.ConnectionWrapperImpl;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.CloudscapePagingPredicates;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.CloudscapePagingSelectBuilder;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.CountSelectBuilder;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.DeleteBuilder;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.DeletePredicates;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.FindByPrimaryKeyFromDOPredicates;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.FindByPrimaryKeySelectBuilder;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.InsertBuilder;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.InsertPredicates;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.OverqualfiedUpdatePredicates;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.PagingPredicates;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.PagingSelectBuilder;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.PartialUpdatePredicates;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryEngine;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryEngineException;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryEngineInfo;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryInputDescriptor;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryPlan;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryPredicates;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryResult;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryResultImpl;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QuerySubplan;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.Rank;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.RootOnlySelectBuilder;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.RootTableCountSelectBuilder;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.SelectBuilder;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.SelectPredicates;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.UniqueKeyInsertBuilder;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.UniqueKeySelectBuilder;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.UniqueKeyUpdateBuilder;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.UpdateBuilder;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.WithoutRootSelectBuilder;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.schema.RDBSchema;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.schema.RDBTable;
import commonj.sdo.DataObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;

public class QueryEngineImpl
implements QueryEngine {
    Metadata fMetadata;
    JDBCMediator fMediator;
    private RDBSchema fSchema;
    private int fPageSize = 10;
    private boolean fGenericPaging = true;

    public QueryEngineImpl(Metadata metadata2, JDBCMediator jDBCMediator, String string) {
        this.setMetadata(metadata2);
        this.setMediator(jDBCMediator);
        QueryEngineInfo.singleton().targetDatabase(string);
    }

    public QueryResult executeSelect(Map map) {
        QueryResultImpl queryResultImpl = this.createSelectPlan();
        this.trace("select query", queryResultImpl, map);
        if (!queryResultImpl.hasException()) {
            SelectPredicates selectPredicates = new SelectPredicates(this.getMetadata(), map, queryResultImpl.getInputDescriptor());
            this.executeReadQuery(queryResultImpl, selectPredicates);
        }
        return queryResultImpl;
    }

    public QueryResult nextPageGeneric(Map map, int n) {
        QueryResultImpl queryResultImpl = this.createGenericPagingPlan();
        this.trace("generic paging select query", queryResultImpl, map);
        if (!queryResultImpl.hasException()) {
            Object object;
            Object object2;
            if (queryResultImpl.isSingleQuery()) {
                object2 = new SelectPredicates(this.getMetadata(), map, queryResultImpl.getInputDescriptor());
                this.executeReadQuery(queryResultImpl, (QueryPredicates)object2);
            } else {
                object2 = new ArrayList();
                object = queryResultImpl.getInputDescriptors().iterator();
                while (object.hasNext()) {
                    QueryInputDescriptor queryInputDescriptor = (QueryInputDescriptor)object.next();
                    ((ArrayList)object2).add(new SelectPredicates(this.getMetadata(), map, queryInputDescriptor));
                }
                this.executeReadQuery(queryResultImpl, (ArrayList)object2);
            }
            try {
                object2 = (ResultSet)queryResultImpl.getResults().get(0);
                boolean bl = true;
                for (int i = 0; bl && i < n; ++i) {
                    bl = object2.next();
                }
            }
            catch (SQLException sQLException) {
                object = new StringBuffer();
                ((StringBuffer)object).append("error moving cursor forward ").append(n).append(" rows");
                queryResultImpl.addException(new QueryEngineException(((StringBuffer)object).toString(), sQLException));
                this.ffdcFilter(sQLException, "nextPageGeneric", "17");
            }
        }
        return queryResultImpl;
    }

    public QueryResult executeFindByPrimaryKeyOn(DataObject dataObject) {
        QueryResultImpl queryResultImpl = this.createFindByPrimaryKeyPlan(dataObject);
        this.trace("findy by primary key query", queryResultImpl, null);
        if (!queryResultImpl.hasException()) {
            FindByPrimaryKeyFromDOPredicates findByPrimaryKeyFromDOPredicates = new FindByPrimaryKeyFromDOPredicates(this.getMetadata(), dataObject, queryResultImpl.getInputDescriptor());
            this.executeReadQuery(queryResultImpl, findByPrimaryKeyFromDOPredicates);
        }
        return queryResultImpl;
    }

    public QueryResult executeInsert(DataObject dataObject) {
        QueryResultImpl queryResultImpl = this.createInsertPlan(dataObject);
        this.trace("insert query", queryResultImpl, null);
        if (!queryResultImpl.hasException()) {
            InsertPredicates insertPredicates = new InsertPredicates(this.getMetadata(), dataObject);
            this.executeWriteQuery(queryResultImpl, insertPredicates);
        }
        return queryResultImpl;
    }

    public QueryResult executeUpdate(DataObject dataObject) {
        QueryResultImpl queryResultImpl = this.createUpdatePlan(dataObject);
        this.trace("update query", queryResultImpl, null);
        if (!queryResultImpl.hasException()) {
            PartialUpdatePredicates partialUpdatePredicates;
            RDBTable rDBTable = this.tableFor(dataObject);
            if (rDBTable.hasCollisionColumn()) {
                partialUpdatePredicates = new OverqualfiedUpdatePredicates(this.getMetadata(), dataObject, rDBTable.getWDOTable());
                queryResultImpl.setOverQualifiedUpdate();
            } else {
                partialUpdatePredicates = new PartialUpdatePredicates(this.getMetadata(), dataObject);
            }
            this.executeWriteQuery(queryResultImpl, partialUpdatePredicates);
        }
        return queryResultImpl;
    }

    public QueryResult executeDelete(DataObject dataObject) {
        QueryResultImpl queryResultImpl = this.createDeletePlan(dataObject);
        this.trace("delete query", queryResultImpl, null);
        if (!queryResultImpl.hasException()) {
            DeletePredicates deletePredicates = new DeletePredicates(this.getMetadata(), dataObject);
            this.executeWriteQuery(queryResultImpl, deletePredicates);
        }
        return queryResultImpl;
    }

    public RDBSchema getSchema() {
        if (this.fSchema == null && this.getMetadata() != null) {
            this.fSchema = new RDBSchema(this.getMetadata());
        }
        return this.fSchema;
    }

    public Metadata getMetadata() {
        return this.fMetadata;
    }

    public RDBTable getRootRDBTable() {
        return this.getSchema().findTable(this.getMetadata().getRootTable());
    }

    public void executeWriteQuery(QueryResultImpl queryResultImpl, QueryPredicates queryPredicates) {
        QueryPlan queryPlan = queryResultImpl.getQueryPlan();
        queryResultImpl.setConnectionWrapper(this.getConnectionWrapper());
        try {
            Iterator iterator = queryPlan.subplans().iterator();
            while (iterator.hasNext()) {
                QuerySubplan querySubplan = (QuerySubplan)iterator.next();
                queryResultImpl.rowsAffected(this.getConnectionWrapper().executeUpdate(querySubplan.getQuery(), queryPredicates));
            }
        }
        catch (SQLException sQLException) {
            queryResultImpl.addException(new QueryEngineException(queryPlan.getQueryType(), sQLException));
            this.ffdcFilter(sQLException, "executeWriteQuery", "3");
        }
    }

    public void executeReadQuery(QueryResultImpl queryResultImpl, ArrayList arrayList) {
        QueryPlan queryPlan = queryResultImpl.getQueryPlan();
        queryResultImpl.setConnectionWrapper(this.getConnectionWrapper());
        try {
            Iterator iterator = queryPlan.subplans().iterator();
            Iterator iterator2 = arrayList.iterator();
            while (iterator.hasNext()) {
                QuerySubplan querySubplan = (QuerySubplan)iterator.next();
                ResultSet resultSet = this.getConnectionWrapper().executeSelect(querySubplan.getQuery(), (SelectPredicates)iterator2.next());
                queryResultImpl.addResult(resultSet);
            }
        }
        catch (SQLException sQLException) {
            queryResultImpl.addException(new QueryEngineException(queryPlan.getQueryType(), sQLException));
            this.ffdcFilter(sQLException, "createReadQuery", "4");
        }
    }

    public void executeReadQuery(QueryResultImpl queryResultImpl, QueryPredicates queryPredicates) {
        QueryPlan queryPlan = queryResultImpl.getQueryPlan();
        queryResultImpl.setConnectionWrapper(this.getConnectionWrapper());
        try {
            Iterator iterator = queryPlan.subplans().iterator();
            while (iterator.hasNext()) {
                QuerySubplan querySubplan = (QuerySubplan)iterator.next();
                ResultSet resultSet = this.getConnectionWrapper().executeSelect(querySubplan.getQuery(), (SelectPredicates)queryPredicates);
                queryResultImpl.addResult(resultSet);
            }
        }
        catch (SQLException sQLException) {
            queryResultImpl.addException(new QueryEngineException(queryPlan.getQueryType(), sQLException));
            this.ffdcFilter(sQLException, "createReadQuery", "4");
        }
    }

    public void trace(String string, QueryResultImpl queryResultImpl, Map map) {
        Trace.showSection(string);
        if (queryResultImpl.hasPlan()) {
            Iterator iterator = queryResultImpl.getQueryPlan().subplans().iterator();
            while (iterator.hasNext()) {
                this.trace((QuerySubplan)iterator.next(), map);
            }
        }
        if (queryResultImpl.hasException()) {
            Trace.show(queryResultImpl.getException());
        }
    }

    public void trace(QuerySubplan querySubplan, Map map) {
        Trace.show("query >>>> ", querySubplan.getQuery());
        Trace.show("input shape>>>> ", querySubplan.getInput());
        Trace.show("output shape>>>> ", querySubplan.getOutput());
        Trace.show("input args>>> ", map);
    }

    public QueryResultImpl createSelectPlan() {
        QueryResultImpl queryResultImpl = new QueryResultImpl();
        try {
            SelectBuilder selectBuilder = new SelectBuilder(this.getMetadata());
            queryResultImpl.setQueryPlan(selectBuilder.createPlan());
        }
        catch (Exception exception) {
            queryResultImpl.addException(new QueryEngineException("error creating select plan", exception));
            this.ffdcFilter(exception, "createSelectPlan", "5");
        }
        return queryResultImpl;
    }

    public QueryResultImpl createDeletePlan(DataObject dataObject) {
        QueryResultImpl queryResultImpl = new QueryResultImpl();
        try {
            DeleteBuilder deleteBuilder = new DeleteBuilder(this.tableFor(dataObject));
            queryResultImpl.setQueryPlan(deleteBuilder.createPlan());
        }
        catch (Exception exception) {
            queryResultImpl.addException(new QueryEngineException("error creating delete plan", exception));
            this.ffdcFilter(exception, "createDeletePlan", "6");
        }
        return queryResultImpl;
    }

    public QueryResultImpl createInsertPlan(DataObject dataObject) {
        QueryResultImpl queryResultImpl = new QueryResultImpl();
        try {
            InsertBuilder insertBuilder = new InsertBuilder(this.tableFor(dataObject));
            queryResultImpl.setQueryPlan(insertBuilder.createPlan());
        }
        catch (Exception exception) {
            queryResultImpl.addException(new QueryEngineException("error creating insert plan", exception));
            this.ffdcFilter(exception, "createInsertPlan", "7");
        }
        return queryResultImpl;
    }

    public QueryResultImpl createUpdatePlan(DataObject dataObject) {
        QueryResultImpl queryResultImpl = new QueryResultImpl();
        try {
            RDBTable rDBTable = this.tableFor(dataObject);
            UpdateBuilder updateBuilder = new UpdateBuilder(rDBTable, dataObject);
            queryResultImpl.setQueryPlan(updateBuilder.createPlan());
            updateBuilder.parmColumns();
        }
        catch (Exception exception) {
            queryResultImpl.addException(new QueryEngineException("error creating update plan", exception));
            this.ffdcFilter(exception, "createUpadatePlan", "8");
        }
        return queryResultImpl;
    }

    private RDBTable tableFor(DataObject dataObject) {
        EObject eObject = (EObject)dataObject;
        String string = eObject.eClass().getName();
        return this.getSchema().findTableByName(string);
    }

    public JDBCMediator getMediator() {
        return this.fMediator;
    }

    public void setMediator(JDBCMediator jDBCMediator) {
        this.fMediator = jDBCMediator;
    }

    private ConnectionWrapperImpl getConnectionWrapper() {
        return (ConnectionWrapperImpl)this.getMediator().getConnectionWrapper();
    }

    public void setMetadata(Metadata metadata2) {
        this.fMetadata = metadata2;
    }

    public void setPageSize(int n) {
        this.fPageSize = n;
    }

    public int getPageSize() {
        return this.fPageSize;
    }

    public QueryResult executeSelectNextPage(Map map, int n) {
        if (this.isGenericPaging()) {
            return this.nextPageGeneric(map, n);
        }
        return this.nextPage(map, n + 1, n + this.getPageSize());
    }

    public QueryResult executeSelectPreviousPage(Map map, int n) {
        if (this.isGenericPaging()) {
            return this.nextPageGeneric(map, n - this.getPageSize());
        }
        return this.nextPage(map, n - this.getPageSize(), n - 1);
    }

    public QueryResult nextPage(Map map, int n, int n2) {
        return this.cteNextPage(map, n, n2);
    }

    public QueryResultImpl createPagingPlan() {
        QueryResultImpl queryResultImpl = new QueryResultImpl();
        try {
            PagingSelectBuilder pagingSelectBuilder = new PagingSelectBuilder(this.getMetadata(), this.getSchema());
            queryResultImpl.setQueryPlan(pagingSelectBuilder.createPlan());
        }
        catch (Exception exception) {
            queryResultImpl.addException(new QueryEngineException("error creating paging select plan", exception));
            this.ffdcFilter(exception, "createPagingPlan", "9");
        }
        return queryResultImpl;
    }

    public void ffdcFilter(Exception exception, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName()).append(".").append(string);
        FFDCFilter.processException((Throwable)exception, stringBuffer.toString(), string2, this);
    }

    public String getUniqueKeySelectString() {
        String string = null;
        try {
            string = new UniqueKeySelectBuilder(this.getMetadata(), this.getSchema()).query();
        }
        catch (QueryEngineException queryEngineException) {
            QueryEngineException queryEngineException2 = new QueryEngineException("error creating unique key select query string", queryEngineException);
            this.ffdcFilter(queryEngineException2, "getUniqueKeySelectString", "10");
            throw new Error("Error creating unique key select string " + queryEngineException2);
        }
        return string;
    }

    public String getUniqueKeyUpdateString(long l) {
        String string = null;
        try {
            string = new UniqueKeyUpdateBuilder(this.getSchema().uniqueKeyTable(), l).query();
        }
        catch (Exception exception) {
            QueryEngineException queryEngineException = new QueryEngineException("error creating unique key update query string", exception);
            this.ffdcFilter(queryEngineException, "getUniqueKeyUpdateString", "11");
            throw new Error("Error creating unique key update string " + queryEngineException);
        }
        return string;
    }

    public String getUniqueKeyInsertString() {
        String string = null;
        try {
            string = new UniqueKeyInsertBuilder(this.getSchema().uniqueKeyTable()).query();
        }
        catch (Exception exception) {
            QueryEngineException queryEngineException = new QueryEngineException("error creating unique key insert query string", exception);
            this.ffdcFilter(queryEngineException, "getUniqueKeyInsertString", "12");
            throw new Error("Error creating unique key insert string " + queryEngineException);
        }
        return string;
    }

    public long basicExecuteCount(String string, SelectPredicates selectPredicates) throws QueryEngineException {
        long l = -1L;
        ResultSet resultSet = null;
        try {
            resultSet = this.getConnectionWrapper().executeSelect(string, selectPredicates);
            resultSet.next();
            l = resultSet.getLong(1);
        }
        catch (Exception exception) {
            this.ffdcFilter(exception, "executeCount", "13");
            throw new QueryEngineException("count(*) query failed", exception);
        }
        return l;
    }

    public void setupCloudscapePaging() throws QueryEngineException {
        RootTableCountSelectBuilder rootTableCountSelectBuilder = new RootTableCountSelectBuilder(this.getMetadata(), this.getSchema());
        Rank.reset();
        Trace.show("count query => ", rootTableCountSelectBuilder.query());
        long l = this.basicExecuteCount(rootTableCountSelectBuilder.query(), null);
        Trace.show("count query result => ", l);
        Rank.count(l);
    }

    public QueryResult cloudscapeNextPage(Map map, int n, int n2) {
        QueryResultImpl queryResultImpl = this.createCloudscapePagingPlan();
        try {
            this.setupCloudscapePaging();
        }
        catch (Exception exception) {
            queryResultImpl.addException(new QueryEngineException("error in Cloudscape paging setup", exception));
            this.ffdcFilter(exception, "cloudscapeNextPage", "14");
            return queryResultImpl;
        }
        this.trace("select cloudscape page query", queryResultImpl, map);
        if (!queryResultImpl.hasException()) {
            CloudscapePagingPredicates cloudscapePagingPredicates = new CloudscapePagingPredicates(this.getMetadata(), map, n, n2, queryResultImpl.getInputDescriptor());
            this.executeReadQuery(queryResultImpl, cloudscapePagingPredicates);
        }
        return queryResultImpl;
    }

    public QueryResultImpl createCloudscapePagingPlan() {
        QueryResultImpl queryResultImpl = new QueryResultImpl();
        try {
            CloudscapePagingSelectBuilder cloudscapePagingSelectBuilder = new CloudscapePagingSelectBuilder(this.getMetadata(), this.getSchema());
            queryResultImpl.setQueryPlan(cloudscapePagingSelectBuilder.createPlan());
        }
        catch (Exception exception) {
            queryResultImpl.addException(new QueryEngineException("error creating cloudscape paging select plan", exception));
            this.ffdcFilter(exception, "createCloudscapePagingPlan", "15");
        }
        return queryResultImpl;
    }

    public QueryResult cteNextPage(Map map, int n, int n2) {
        QueryResultImpl queryResultImpl = this.createPagingPlan();
        this.trace("select page query", queryResultImpl, map);
        if (!queryResultImpl.hasException()) {
            PagingPredicates pagingPredicates = new PagingPredicates(this.getMetadata(), map, n, n2, queryResultImpl.getInputDescriptor());
            this.executeReadQuery(queryResultImpl, pagingPredicates);
        }
        return queryResultImpl;
    }

    public boolean isGenericPaging() {
        return this.fGenericPaging;
    }

    public void doNotUseGenericPaging() {
        this.fGenericPaging = false;
    }

    public QueryResultImpl createGenericPagingPlan() {
        QueryResultImpl queryResultImpl = new QueryResultImpl();
        try {
            RootOnlySelectBuilder rootOnlySelectBuilder = new RootOnlySelectBuilder(this.getMetadata(), this.getSchema());
            QueryPlan queryPlan = rootOnlySelectBuilder.createPlan();
            if (!this.getSchema().isSingleTable()) {
                WithoutRootSelectBuilder withoutRootSelectBuilder = new WithoutRootSelectBuilder(this.getMetadata(), this.getSchema());
                queryPlan.addSubplan(withoutRootSelectBuilder.createSubplan());
            }
            queryResultImpl.setQueryPlan(queryPlan);
        }
        catch (QueryEngineException queryEngineException) {
            queryResultImpl.addException(new QueryEngineException("error creating generic paging plan", queryEngineException));
            this.ffdcFilter(queryEngineException, "createGenericPagingPlan", "16");
        }
        return queryResultImpl;
    }

    public long executeCount(Map map) {
        try {
            CountSelectBuilder countSelectBuilder = new CountSelectBuilder(this.getMetadata(), this.getSchema());
            SelectPredicates selectPredicates = new SelectPredicates(this.getMetadata(), map, countSelectBuilder.inputDescriptor());
            Trace.show("count query => ", countSelectBuilder.query());
            long l = this.basicExecuteCount(countSelectBuilder.query(), selectPredicates);
            Trace.show("count query result => ", l);
            return l;
        }
        catch (QueryEngineException queryEngineException) {
            this.ffdcFilter(queryEngineException, "executeCount", "17");
            throw new Error("error in count query: " + queryEngineException, queryEngineException);
        }
    }

    public QueryResultImpl createFindByPrimaryKeyPlan(DataObject dataObject) {
        QueryResultImpl queryResultImpl = new QueryResultImpl();
        try {
            RDBTable rDBTable = this.tableFor(dataObject);
            FindByPrimaryKeySelectBuilder findByPrimaryKeySelectBuilder = new FindByPrimaryKeySelectBuilder(this.getMetadata(), this.getSchema(), rDBTable);
            queryResultImpl.setQueryPlan(findByPrimaryKeySelectBuilder.createPlan());
        }
        catch (Exception exception) {
            queryResultImpl.addException(new QueryEngineException("error creating find by primary key plan", exception));
            this.ffdcFilter(exception, "createFindByPrimaryKeyPlan", "18");
        }
        return queryResultImpl;
    }
}

