/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.mediator.jdbc.queryengine;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sdo.mediator.jdbc.ConnectionWrapperImpl;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryEngineException;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryInputDescriptor;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryPlan;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryResult;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryResultDescriptor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class QueryResultImpl
implements QueryResult {
    private List fResults;
    private List fExceptions;
    private QueryPlan fQueryPlan;
    private ConnectionWrapperImpl fConnectionWrapper;
    private int fRowsAffected = -1;
    private boolean fOverQualifiedUpdate = false;

    public List getResults() {
        if (this.fResults == null) {
            this.fResults = new ArrayList();
        }
        return this.fResults;
    }

    public QueryEngineException getException() {
        if (this.hasException()) {
            return (QueryEngineException)this.getExceptions().get(0);
        }
        return null;
    }

    public void addException(QueryEngineException queryEngineException) {
        this.getExceptions().add(queryEngineException);
    }

    public boolean hasException() {
        return this.fExceptions != null && !this.fExceptions.isEmpty();
    }

    public boolean hasResults() {
        return this.fResults != null && !this.fResults.isEmpty();
    }

    public QueryPlan getQueryPlan() {
        return this.fQueryPlan;
    }

    public void setQueryPlan(QueryPlan queryPlan) {
        this.fQueryPlan = queryPlan;
    }

    public QueryResultDescriptor getResultDescriptor() {
        if (this.hasPlan()) {
            return this.getQueryPlan().getOutput();
        }
        return null;
    }

    public QueryInputDescriptor getInputDescriptor() {
        if (this.hasPlan()) {
            return this.getQueryPlan().getInput();
        }
        return null;
    }

    public void discard() throws QueryEngineException {
        Iterator iterator = this.getResults().iterator();
        while (iterator.hasNext()) {
            try {
                this.getConnectionWrapper().discardResultSet((ResultSet)iterator.next());
            }
            catch (SQLException sQLException) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.getClass().getName()).append(".").append("discard");
                FFDCFilter.processException((Throwable)sQLException, stringBuffer.toString(), "1", this);
                throw new QueryEngineException(sQLException);
            }
        }
        this.fResults = null;
        this.fExceptions = null;
        this.fQueryPlan = null;
    }

    public String getQuery() {
        if (this.hasPlan()) {
            return this.getQueryPlan().getQuery();
        }
        return null;
    }

    public void addResult(Object object) {
        this.getResults().add(object);
    }

    public boolean hasPlan() {
        return this.fQueryPlan != null;
    }

    public int rowsAffected() {
        return this.fRowsAffected;
    }

    public void rowsAffected(int n) {
        this.fRowsAffected = n;
    }

    public void setOverQualifiedUpdate() {
        this.fOverQualifiedUpdate = true;
    }

    public boolean isOverQualifiedUpdate() {
        return this.fOverQualifiedUpdate;
    }

    public boolean isFailedOverQualifiedUpdate() {
        return this.isOverQualifiedUpdate() && this.rowsAffected() < 1;
    }

    public void setConnectionWrapper(ConnectionWrapperImpl connectionWrapperImpl) {
        this.fConnectionWrapper = connectionWrapperImpl;
    }

    private ConnectionWrapperImpl getConnectionWrapper() {
        return this.fConnectionWrapper;
    }

    public boolean isSingleQuery() {
        return this.getQueryPlan().isSingleQuery();
    }

    public List getExceptions() {
        if (this.fExceptions == null) {
            this.fExceptions = new ArrayList();
        }
        return this.fExceptions;
    }

    public List getResultDescriptors() {
        return this.getQueryPlan().getOutputs();
    }

    public List getInputDescriptors() {
        return this.getQueryPlan().getInputs();
    }
}

