/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.mediator.jdbc.queryengine;

import com.ibm.ObjectQuery.crud.util.Association;
import com.ibm.ObjectQuery.crud.util.ClassShortName;
import com.ibm.ObjectQuery.crud.util.ListWrapper;
import com.ibm.ObjectQuery.crud.util.ShouldNotImplement;
import com.ibm.ObjectQuery.crud.util.StSet;
import com.ibm.ObjectQuery.crud.util.TreeNode;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.JoinMap;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.JoinMapNode;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.schema.Connection;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.schema.RDBColumn;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.schema.RDBReferenceByKey;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.schema.RDBTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class RootJoinMapNode
extends TreeNode
implements JoinMap {
    private static final long serialVersionUID = -2900118265382480553L;
    private List fConnections;
    private List fDiscriminators;

    public void addColumnsAndValues(List list, List list2) {
        this.discriminators().add(new Association(list, ListWrapper.list(list2)));
    }

    public void addConnection(Object object) {
        Connection connection;
        if (object instanceof RDBReferenceByKey) {
            connection = new Connection((RDBReferenceByKey)object);
        }
        connection = (Connection)object;
        this.connections().add(connection);
    }

    public void addDiscriminatorTableTo(Collection collection, JoinMap joinMap) {
        Iterator iterator = joinMap.discriminators().iterator();
        while (iterator.hasNext()) {
            Association association = (Association)iterator.next();
            if (association.key() instanceof RDBColumn) {
                collection.add(((RDBColumn)association.key()).getOwningTable());
                continue;
            }
            Iterator iterator2 = ((List)association.key()).iterator();
            while (iterator2.hasNext()) {
                collection.add(((RDBColumn)iterator2.next()).getOwningTable());
            }
        }
    }

    public void addTablesFromConnections(Iterator iterator, Collection collection) {
        while (iterator.hasNext()) {
            Connection connection = (Connection)iterator.next();
            collection.add(connection.parentTable());
            collection.add(connection.memberTable());
        }
    }

    public List childSideJoinColumns() {
        return new ArrayList();
    }

    public RDBTable childSideTable() {
        if (this.children().isEmpty()) {
            return null;
        }
        return ((JoinMap)this.children().get(0)).parentSideTable();
    }

    public List connections() {
        if (this.fConnections == null) {
            this.fConnections = new ArrayList();
        }
        return this.fConnections;
    }

    public void connections(List list) {
        this.fConnections = list;
    }

    public List connectionsInPath() {
        StSet stSet = new StSet();
        stSet.hashFunction(Connection.hashFunction());
        stSet.equalityRelation(Connection.equalityRelation());
        Iterator iterator = this.toRootIterator();
        while (iterator.hasNext()) {
            stSet.addAll((Collection)((JoinMap)iterator.next()).connections());
        }
        return stSet.toList();
    }

    public List allConnections() {
        StSet stSet = new StSet();
        stSet.hashFunction(Connection.hashFunction());
        stSet.equalityRelation(Connection.equalityRelation());
        Iterator iterator = ((TreeNode)this.root()).iterator();
        while (iterator.hasNext()) {
            stSet.addAll((Collection)((JoinMap)iterator.next()).connections());
        }
        return stSet.toList();
    }

    public List connectionTables() {
        StSet stSet = new StSet();
        Iterator iterator = this.connections().iterator();
        while (iterator.hasNext()) {
            Connection connection = (Connection)iterator.next();
            stSet.add(connection.parentTable());
            stSet.add(connection.memberTable());
        }
        return stSet.toList();
    }

    public JoinMap copyEmpty() {
        return new RootJoinMapNode();
    }

    public JoinMap copyJoinTree() {
        JoinMap joinMap = this.disconnectedCopy();
        Iterator iterator = this.children().iterator();
        while (iterator.hasNext()) {
            joinMap.addChild(((JoinMap)iterator.next()).copyJoinTree());
        }
        return joinMap;
    }

    public JoinMap copyPathToRoot() {
        JoinMap joinMap = this;
        Iterator iterator = this.toRootIterator();
        while (iterator.hasNext()) {
            JoinMap joinMap2 = (JoinMap)iterator.next();
            JoinMap joinMap3 = this.disconnectedCopy();
            if (joinMap != null) {
                joinMap3.addChild(joinMap);
            }
            joinMap = joinMap3;
        }
        return joinMap;
    }

    public JoinMap disconnectedCopy() {
        Iterator iterator;
        JoinMap joinMap = this.copyEmpty();
        if (this.hasConnections()) {
            iterator = this.connections().iterator();
            while (iterator.hasNext()) {
                joinMap.addConnection(iterator.next());
            }
        }
        if (this.hasDiscriminators()) {
            iterator = this.discriminators().iterator();
            while (iterator.hasNext()) {
                Association association = (Association)iterator.next();
                joinMap.discriminators().add(new Association(association.key(), association.value()));
            }
        }
        return joinMap;
    }

    public List discriminators() {
        if (this.fDiscriminators == null) {
            this.fDiscriminators = new ArrayList();
        }
        return this.fDiscriminators;
    }

    public void discriminators(List list) {
        this.fDiscriminators = list;
    }

    public List discriminatorsInPath() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.toRootIterator();
        while (iterator.hasNext()) {
            arrayList.addAll(((JoinMap)iterator.next()).discriminators());
        }
        return arrayList;
    }

    public void doNotInclude() {
    }

    public void addChild(JoinMap joinMap) {
        this.addChild((TreeNode)((Object)joinMap));
    }

    public static JoinMap from(RDBTable rDBTable) {
        RootJoinMapNode rootJoinMapNode = new RootJoinMapNode();
        rootJoinMapNode.initializeFrom(rDBTable);
        return rootJoinMapNode;
    }

    public boolean hasConnections() {
        return !this.connections().isEmpty();
    }

    public boolean hasDiscriminators() {
        return !this.discriminators().isEmpty();
    }

    public void initializeFrom(RDBTable rDBTable) {
        StSet stSet = new StSet();
        this.extendJoinMap(rDBTable, this, stSet);
    }

    public boolean isIncluded() {
        throw new ShouldNotImplement();
    }

    public boolean isNormal() {
        return true;
    }

    public boolean isOuterJoin() {
        throw new ShouldNotImplement();
    }

    public boolean isRelationshipJoin() {
        return false;
    }

    public boolean isReversed() {
        return false;
    }

    public boolean isRoot() {
        return true;
    }

    public List parentSideJoinColumns() {
        return new ArrayList();
    }

    public RDBTable parentSideTable() {
        return null;
    }

    public void printOn(StringBuffer stringBuffer) {
        stringBuffer.append(ClassShortName.name(this));
        stringBuffer.append("(");
        int n = 1;
        Iterator iterator = this.children().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(n);
            stringBuffer.append(". ");
            stringBuffer.append(iterator.next());
            if (iterator.hasNext()) {
                stringBuffer.append("\n");
            }
            ++n;
        }
        stringBuffer.append(")");
    }

    public List tables() {
        if (this.isRoot()) {
            return this.tablesInTree();
        }
        return this.tablesInPath();
    }

    public List tablesInPath() {
        StSet stSet = new StSet();
        Iterator iterator = this.toRootIterator();
        while (iterator.hasNext()) {
            JoinMap joinMap = (JoinMap)iterator.next();
            if (!joinMap.isRoot() && joinMap.isRelationshipJoin()) {
                stSet.add(joinMap.childSideTable());
                stSet.add(joinMap.parentSideTable());
            }
            this.addTablesFromConnections(joinMap.connections().iterator(), stSet);
            if (!stSet.isEmpty() || !joinMap.hasDiscriminators()) continue;
            this.addDiscriminatorTableTo(stSet, joinMap);
        }
        return stSet.toList();
    }

    public List tablesInTree() {
        StSet stSet = new StSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            JoinMap joinMap = (JoinMap)iterator.next();
            if (joinMap.isRoot()) continue;
            stSet.add(joinMap.parentSideTable());
            stSet.add(joinMap.childSideTable());
        }
        return stSet.toList();
    }

    public void extendJoinMap(RDBTable rDBTable, JoinMap joinMap, StSet stSet) {
        JoinMapNode joinMapNode;
        Iterator iterator = rDBTable.getRelationships().iterator();
        while (iterator.hasNext()) {
            RDBReferenceByKey rDBReferenceByKey = (RDBReferenceByKey)iterator.next();
            if (stSet.contains(rDBReferenceByKey)) continue;
            stSet.add(rDBReferenceByKey);
            joinMapNode = new JoinMapNode(rDBTable, new Connection(rDBReferenceByKey));
            joinMap.addChild(joinMapNode);
        }
        iterator = joinMap.children().iterator();
        while (iterator.hasNext()) {
            joinMapNode = (JoinMapNode)iterator.next();
            this.extendJoinMap(joinMapNode.childSideTable(), joinMapNode, stSet);
        }
    }
}

