/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.mediator.jdbc.queryengine;

import com.ibm.ObjectQuery.crud.util.Association;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Filter;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Metadata;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.OrderBy;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryEngineException;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryResultDescriptor;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.SelectBuilder;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.SelectStatementCreator;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.schema.RDBSchema;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.SelectStatement;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.SqlStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public class RootOnlySelectBuilder
extends SelectBuilder {
    public RootOnlySelectBuilder(Metadata metadata2, RDBSchema rDBSchema) throws QueryEngineException {
        this.setMetadata(metadata2);
        this.setSchema(rDBSchema);
        this.initialize();
    }

    public List orderByColumns() {
        EList eList = this.getMetadata().getOrderBys();
        if (eList.isEmpty()) {
            return null;
        }
        Iterator iterator = eList.iterator();
        ArrayList<Association> arrayList = new ArrayList<Association>();
        while (iterator.hasNext()) {
            OrderBy orderBy = (OrderBy)iterator.next();
            if (!orderBy.getColumn().getTable().equals(this.rootTable().getWDOTable())) continue;
            arrayList.add(new Association(this.getSchema().findColumn(orderBy.getColumn()), new Boolean(orderBy.isAscending())));
        }
        return arrayList;
    }

    public SqlStatement defaultStatement() throws QueryEngineException {
        SelectStatementCreator selectStatementCreator = new SelectStatementCreator();
        selectStatementCreator.setSingle();
        selectStatementCreator.resultColumns(this.resultDescriptor().resultSetElements());
        selectStatementCreator.joinMap(null);
        List list = this.orderByColumns();
        if (list != null) {
            selectStatementCreator.addColumnsToOrderBy(list);
        }
        SelectStatement selectStatement = selectStatementCreator.build();
        this.addFilters(selectStatement);
        return selectStatement;
    }

    public void addFilters(SelectStatement selectStatement) {
        Filter filter = this.rootTable().getWDOTable().getFilter();
        if (filter != null) {
            selectStatement.addNativeFilter(filter.getPredicate());
            this.filterArguments().addAll(filter.getFilterArguments());
        }
    }

    public QueryResultDescriptor createResultDescriptor() {
        return new QueryResultDescriptor(this.getSchema().root());
    }
}

