/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.mediator.jdbc.queryengine;

import com.ibm.ObjectQuery.crud.util.Association;
import com.ibm.ObjectQuery.crud.util.ListWrapper;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Filter;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Metadata;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.OrderBy;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.CTESelectStatementCreator;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.InLinedSelectStatementCreator;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryBuilder;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryEngineException;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryEngineInfo;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryResultDescriptor;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.RootJoinMapNode;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.SelectStatementCreator;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.schema.RDBSchema;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.schema.RDBTable;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.Count;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.PredicateWithVariables;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.ResultSetExpression;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.SelectStatement;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.SqlStatement;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.SubSelect;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public class SelectBuilder
extends QueryBuilder {
    private RDBSchema fSchema;
    private Metadata fMetadata;
    private List fFilterArguments;
    private boolean fIgnoreOrderBysFlag = false;
    private boolean fUseCTEBuilder = true;
    private boolean fUseOnlyRoot = false;

    public SelectBuilder() {
    }

    public SelectBuilder(Metadata metadata2, RDBSchema rDBSchema) throws QueryEngineException {
        this.setMetadata(metadata2);
        this.setSchema(rDBSchema);
        if (!this.isOracle() && !this.isDB2()) {
            this.doNotUseCTESelectBuilder();
        }
        this.initialize();
    }

    public SelectBuilder(Metadata metadata2) throws QueryEngineException {
        this(metadata2, new RDBSchema(metadata2));
    }

    public List orderByColumns() {
        EList eList = this.getMetadata().getOrderBys();
        if (eList.isEmpty()) {
            return null;
        }
        Iterator iterator = eList.iterator();
        ArrayList<Association> arrayList = new ArrayList<Association>();
        while (iterator.hasNext()) {
            OrderBy orderBy = (OrderBy)iterator.next();
            arrayList.add(new Association(this.getSchema().findColumn(orderBy.getColumn()), new Boolean(orderBy.isAscending())));
        }
        return arrayList;
    }

    public String selectStatement() throws QueryEngineException {
        return this.query();
    }

    public PredicateWithVariables connectionsPredicate() {
        SelectStatementCreator selectStatementCreator = new SelectStatementCreator();
        selectStatementCreator.resultColumns(this.resultDescriptor().columns());
        return selectStatementCreator.createConnectionsJoin();
    }

    public boolean isSingle() {
        return this.getMetadata().getTables().size() == 1;
    }

    public SqlStatement defaultStatement() throws QueryEngineException {
        Object object;
        SelectStatementCreator selectStatementCreator = this.newSelectStatementCreator();
        if (this.isSingle()) {
            selectStatementCreator.setSingle();
        }
        selectStatementCreator.resultColumns(this.resultDescriptor().resultSetElements());
        if (!this.isForRootOnly()) {
            selectStatementCreator.joinMap(RootJoinMapNode.from(this.rootTable()));
        }
        if (!this.ignoreOrderBys() && (object = this.orderByColumns()) != null) {
            selectStatementCreator.addColumnsToOrderBy((List)object);
        }
        object = selectStatementCreator.build();
        if (this.isSingle() || !this.isUsingCTESelectBuilder()) {
            this.addFilters((SelectStatement)object);
        } else if (this.isUsingCTESelectBuilder()) {
            this.filterArguments().addAll(((CTESelectStatementCreator)selectStatementCreator).filterArguments());
        }
        return object;
    }

    public void addFilters(SelectStatement selectStatement) {
        Iterator iterator = selectStatement.branches().iterator();
        while (iterator.hasNext()) {
            SubSelect subSelect = (SubSelect)iterator.next();
            Iterator iterator2 = subSelect.fromClause().tables().iterator();
            while (iterator2.hasNext()) {
                RDBTable rDBTable = (RDBTable)iterator2.next();
                Filter filter = rDBTable.getWDOTable().getFilter();
                if (filter == null) continue;
                if (this.isSingle()) {
                    subSelect.addNativeFilter(filter.getPredicate());
                }
                this.filterArguments().addAll(filter.getFilterArguments());
            }
        }
    }

    public boolean isDistinct() throws QueryEngineException {
        return ((SelectStatement)this.statement()).isDistinct();
    }

    public boolean isSingleTable() throws QueryEngineException {
        return ((SelectStatement)this.statement()).isSingleTable();
    }

    public List parmColumnsAllowCopies(boolean bl) throws QueryEngineException {
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }

    public boolean references(RDBTable rDBTable) throws QueryEngineException {
        return ((SelectStatement)this.statement()).includes(rDBTable);
    }

    public boolean hasForUpdateClause() throws QueryEngineException {
        return ((SelectStatement)this.statement()).hasForUpdateClause();
    }

    public boolean isSelectInto() throws QueryEngineException {
        return ((SelectStatement)this.statement()).isSelectInto();
    }

    public QueryResultDescriptor resultDescriptor() {
        if (super.resultDescriptor() == null) {
            this.resultDescriptor(this.createResultDescriptor());
        }
        return super.resultDescriptor();
    }

    public QueryResultDescriptor createResultDescriptor() {
        if (this.isForRootOnly()) {
            return new QueryResultDescriptor(this.getSchema().root());
        }
        return new QueryResultDescriptor(this.getSchema().getNonexternalTables(), this.getSchema().root());
    }

    public Metadata getMetadata() {
        return this.fMetadata;
    }

    public void setMetadata(Metadata metadata2) {
        this.fMetadata = metadata2;
    }

    public void setSchema(RDBSchema rDBSchema) {
        this.fSchema = rDBSchema;
    }

    public RDBSchema getSchema() {
        return this.fSchema;
    }

    public Filter getRootFilter() {
        return this.getMetadata().getRootTable().getFilter();
    }

    public void createInputDescriptor() throws QueryEngineException {
        super.createInputDescriptor();
        this.inputDescriptor().addFilterArguments(this.filterArguments());
    }

    public RDBTable rootTable() {
        return this.getSchema().findTable(this.getMetadata().getRootTable());
    }

    public String queryType() {
        return "read";
    }

    public List filterArguments() {
        if (this.fFilterArguments == null) {
            this.fFilterArguments = new ArrayList();
        }
        return this.fFilterArguments;
    }

    public boolean ignoreOrderBys() {
        return this.fIgnoreOrderBysFlag;
    }

    public void setToIgnoreOrderBys() {
        this.fIgnoreOrderBysFlag = true;
    }

    public boolean isUsingCTESelectBuilder() {
        return this.fUseCTEBuilder;
    }

    public void doNotUseCTESelectBuilder() {
        this.fUseCTEBuilder = false;
    }

    public boolean isForRootOnly() {
        return this.fUseOnlyRoot;
    }

    public void useOnlyRoot() {
        this.fUseOnlyRoot = true;
    }

    public SelectStatementCreator newSelectStatementCreator() {
        CTESelectStatementCreator cTESelectStatementCreator;
        if (QueryEngineInfo.isDB2() && !QueryEngineInfo.isOS390() || QueryEngineInfo.isOracle()) {
            cTESelectStatementCreator = new CTESelectStatementCreator();
            cTESelectStatementCreator.cteTables(this.getSchema().getTables());
        } else {
            cTESelectStatementCreator = new InLinedSelectStatementCreator();
            ((InLinedSelectStatementCreator)cTESelectStatementCreator).cteTables(this.getSchema().getTables());
        }
        return cTESelectStatementCreator;
    }

    public ResultSetExpression createCountStar() {
        Count count = new Count();
        return new ResultSetExpression(count);
    }

    public QueryResultDescriptor createResultDescriptorForCount() {
        return new QueryResultDescriptor(ListWrapper.list(this.createCountStar()));
    }
}

