/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.mediator.jdbc.queryengine;

import com.ibm.ObjectQuery.crud.util.AbstractDoubleLinkTreeNode;
import com.ibm.ObjectQuery.crud.util.StSet;
import com.ibm.ObjectQuery.crud.util.TreeNode;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.JoinMap;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryEngineException;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryEngineInfo;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.SubSelectCreator;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.schema.Connection;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.schema.RDBColumn;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.schema.RDBTable;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.AbstractResultSetFiller;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.CorrelationAliasTable;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.ExistsPredicate;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.FullOrSubSelect;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.FullSelect;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.Predicate;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.PredicateWithVariables;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.ResultSetElement;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.SelectStatement;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.SortKey;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.SubSelect;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class SelectStatementCreator {
    private JoinMap fJoinMap;
    private SelectStatement fStatement;
    private List fResultColumns;
    private Predicate fExtraSearchCondition;
    private CorrelationAliasTable fAliasTable;
    private int fForUpdateFlag = 0;
    private boolean fIsSingle = false;
    private List fOrderByList;
    private List fTables;

    public SelectStatementCreator() {
    }

    public SelectStatementCreator(List list) {
        this.resultColumns(list);
    }

    public boolean isSingle() {
        return this.fIsSingle;
    }

    public void setSingle() {
        this.fIsSingle = true;
    }

    public boolean isForUpdate() {
        return this.fForUpdateFlag == 1;
    }

    public boolean isForUpdateWithColumns() {
        return this.fForUpdateFlag == 2;
    }

    public void forUpdate() {
        this.fForUpdateFlag = 1;
    }

    public void forUpdateWithColumns() {
        this.fForUpdateFlag = 2;
    }

    public void addOuterJoins(JoinMap joinMap, List list, StSet stSet) throws QueryEngineException {
        boolean bl = false;
        Iterator iterator = ((TreeNode)((Object)joinMap)).toRootMinusOneIterator();
        while (iterator.hasNext()) {
            JoinMap joinMap2 = (JoinMap)iterator.next();
            if (stSet.contains(joinMap2)) {
                bl = true;
            }
            if (bl) {
                return;
            }
            if (joinMap2.isOuterJoin()) {
                this.addStatement(this.buildLeftOuterJoin(joinMap2, list));
            }
            if (!joinMap2.isBranch()) continue;
            stSet.add(joinMap2);
        }
    }

    public void addStatement(FullOrSubSelect fullOrSubSelect) {
        if (this.statement() == null) {
            this.statement(new SelectStatement(fullOrSubSelect));
        } else {
            this.statement().unionAll(fullOrSubSelect);
        }
    }

    public void addStatement(SelectStatement selectStatement) {
        this.statement(selectStatement);
    }

    public CorrelationAliasTable aliasTable() {
        if (this.fAliasTable == null) {
            this.fAliasTable = new CorrelationAliasTable();
        }
        return this.fAliasTable;
    }

    public void aliasTable(CorrelationAliasTable correlationAliasTable) {
        this.fAliasTable = correlationAliasTable;
    }

    public SelectStatement build() throws QueryEngineException {
        this.buildCore();
        this.addOrderByClause();
        this.addForUpdateClause();
        return this.statement();
    }

    public void buildCore() throws QueryEngineException {
        CorrelationAliasTable.reset();
        if (this.joinMap() == null || !this.joinMap().hasChildren()) {
            this.addStatement(this.buildSingleSelect());
            return;
        }
        Iterator iterator = this.joinMap().leaves().iterator();
        StSet stSet = new StSet();
        while (iterator.hasNext()) {
            JoinMap joinMap = (JoinMap)iterator.next();
            List list = this.createTopLevelFilledResultSet(joinMap);
            if (joinMap.isRelationshipJoin() && this.isUsingOuterJoinSyntax()) {
                this.addStatement(this.buildLeftOuterJoinUsingSQL99(joinMap, list));
                continue;
            }
            this.addStatement(this.buildInnerJoin(joinMap, list));
            if (!joinMap.isRelationshipJoin()) continue;
            this.addOuterJoins(joinMap, list, stSet);
        }
    }

    public SubSelect buildInnerJoin(JoinMap joinMap, List list) {
        SubSelectCreator subSelectCreator = new SubSelectCreator(list, joinMap, this.aliasTable(), this.extraSearchCondition());
        if (this.isSingle()) {
            subSelectCreator.setSingle();
        }
        subSelectCreator.buildInnerJoinUsingPath();
        return subSelectCreator.statement();
    }

    public SubSelect buildInnerJoinWithParentNode(JoinMap joinMap, List list) {
        SubSelectCreator subSelectCreator = new SubSelectCreator(list, joinMap, this.aliasTable(), this.extraSearchCondition());
        if (this.isSingle()) {
            subSelectCreator.setSingle();
        }
        subSelectCreator.buildInnerJoinUsingPathAndParent(this.tablesInPathFrom(joinMap));
        return subSelectCreator.statement();
    }

    public SubSelect buildLeftOuterJoinUsingSQL99(JoinMap joinMap, List list) {
        SubSelectCreator subSelectCreator = new SubSelectCreator(list, joinMap, this.aliasTable(), this.extraSearchCondition());
        if (this.isSingle()) {
            subSelectCreator.setSingle();
        }
        subSelectCreator.buildLeftOuterJoinInSQL99UsingPath();
        return subSelectCreator.statement();
    }

    public FullOrSubSelect buildLeftOuterJoin(JoinMap joinMap, List list) throws QueryEngineException {
        if (this.isSubquery()) {
            return this.buildLeftOuterJoinUsingSubquery(joinMap, list);
        }
        return this.buildLeftOuterJoinUsingExcept(joinMap, list);
    }

    public FullOrSubSelect buildLeftOuterJoinUsingLeftOuterJoinSyntax(JoinMap joinMap, List list) throws QueryEngineException {
        List list2 = this.createResultSetWithFiller(joinMap, list);
        SubSelect subSelect = this.buildInnerJoinWithParentNode(joinMap, list2);
        SubSelect subSelect2 = this.buildInnerJoin(joinMap, list2);
        FullSelect fullSelect = new FullSelect();
        fullSelect.exceptAll(subSelect, subSelect2);
        return fullSelect;
    }

    public FullOrSubSelect buildLeftOuterJoinUsingExcept(JoinMap joinMap, List list) throws QueryEngineException {
        List list2 = this.createResultSetWithFiller(joinMap, list);
        SubSelect subSelect = this.buildInnerJoinWithParentNode(joinMap, list2);
        SubSelect subSelect2 = this.buildInnerJoin(joinMap, list2);
        FullSelect fullSelect = new FullSelect();
        fullSelect.exceptAll(subSelect, subSelect2);
        return fullSelect;
    }

    public FullOrSubSelect buildLeftOuterJoinUsingSubquery(JoinMap joinMap, List list) throws QueryEngineException {
        List list2 = this.createResultSetWithFiller(joinMap, list);
        SubSelect subSelect = this.buildInnerJoinWithParentNode(joinMap, list2);
        SubSelect subSelect2 = this.buildSubquery(joinMap, subSelect);
        ExistsPredicate existsPredicate = new ExistsPredicate(subSelect2);
        subSelect.and(existsPredicate.not());
        return subSelect;
    }

    public SubSelect buildSingleInnerJoin(JoinMap joinMap, List list) {
        SubSelectCreator subSelectCreator = new SubSelectCreator(list, joinMap, this.aliasTable(), this.extraSearchCondition());
        if (this.isSingle()) {
            subSelectCreator.setSingle();
        }
        subSelectCreator.buildInnerJoinUsingPath();
        return subSelectCreator.statement();
    }

    public SubSelect buildSingleSelect() {
        SubSelectCreator subSelectCreator = new SubSelectCreator(this.resultColumns(), this.joinMap(), this.aliasTable(), this.extraSearchCondition());
        if (this.hasOrderByColumns()) {
            subSelectCreator.addColumnsToOrderBy(this.orderByColumns());
        }
        if (this.tables() != null && !this.tables().isEmpty()) {
            subSelectCreator.tables(this.tables());
        }
        if (this.isSingle()) {
            subSelectCreator.setSingle();
        }
        subSelectCreator.buildSingleSelect();
        return subSelectCreator.statement();
    }

    public SubSelect buildSubquery(JoinMap joinMap, SubSelect subSelect) {
        SubSelectCreator subSelectCreator = new SubSelectCreator(null, joinMap, null, null);
        if (this.isSingle()) {
            subSelectCreator.setSingle();
        }
        subSelectCreator.containingSubSelect(subSelect);
        subSelectCreator.buildSelectStarUsingPathLeaf();
        return subSelectCreator.statement();
    }

    public PredicateWithVariables createConnectionsJoin() {
        SubSelectCreator subSelectCreator = new SubSelectCreator(this.resultColumns(), this.joinMap(), this.aliasTable(), null);
        if (this.isSingle()) {
            subSelectCreator.setSingle();
        }
        subSelectCreator.buildSingleSelect();
        return subSelectCreator.getConnectionsPredicate();
    }

    public ResultSetElement createFiller(RDBColumn rDBColumn) throws QueryEngineException {
        return AbstractResultSetFiller.newFillerElement(rDBColumn);
    }

    public List createResultSetWithFiller(JoinMap joinMap, List list) throws QueryEngineException {
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        StSet stSet = this.tablesInPathFrom(joinMap);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (e2 instanceof RDBColumn) {
                RDBColumn rDBColumn = (RDBColumn)e2;
                if (!stSet.contains(rDBColumn.getOwningTable())) {
                    arrayList.add(this.createFiller(rDBColumn));
                    continue;
                }
                arrayList.add(rDBColumn);
                continue;
            }
            arrayList.add(e2);
        }
        return arrayList;
    }

    public List createTopLevelFilledResultSet(JoinMap joinMap) throws QueryEngineException {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.resultColumns().size());
        List list = joinMap.tablesInPath();
        Iterator iterator = this.resultColumns().iterator();
        while (iterator.hasNext()) {
            RDBColumn rDBColumn = (RDBColumn)iterator.next();
            if (!list.contains(rDBColumn.getOwningTable())) {
                arrayList.add(this.createFiller(rDBColumn));
                continue;
            }
            arrayList.add(rDBColumn);
        }
        return arrayList;
    }

    public Predicate extraSearchCondition() {
        return this.fExtraSearchCondition;
    }

    public void extraSearchCondition(Predicate predicate) {
        this.fExtraSearchCondition = predicate;
    }

    public boolean includeFilterExpression(Predicate predicate, FullOrSubSelect fullOrSubSelect) {
        if (predicate == null) {
            return false;
        }
        List list = fullOrSubSelect.tableScope();
        Iterator iterator = predicate.tables().iterator();
        while (iterator.hasNext()) {
            if (list.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean isSubquery() {
        return QueryEngineInfo.singleton().generateSubqueriesLeftOuterJoins();
    }

    public boolean isUsingOuterJoinSyntax() {
        return QueryEngineInfo.singleton().useOuterJoinSyntax();
    }

    public JoinMap joinMap() {
        return this.fJoinMap;
    }

    public void joinMap(JoinMap joinMap) {
        this.fJoinMap = joinMap;
    }

    public List resultColumns() {
        return this.fResultColumns;
    }

    public void resultColumns(List list) {
        this.fResultColumns = list;
    }

    public SelectStatement statement() {
        return this.fStatement;
    }

    public void statement(SelectStatement selectStatement) {
        this.fStatement = selectStatement;
    }

    public StSet tablesInPathFrom(JoinMap joinMap) {
        StSet stSet = new StSet();
        Iterator iterator = ((AbstractDoubleLinkTreeNode)((Object)joinMap)).toRootIterator();
        RDBTable rDBTable = null;
        RDBTable rDBTable2 = null;
        while (iterator.hasNext()) {
            JoinMap joinMap2 = (JoinMap)iterator.next();
            if (!joinMap2.isRoot()) {
                if (joinMap2 != joinMap) {
                    rDBTable = joinMap2.childSideTable();
                    stSet.add(rDBTable);
                }
                rDBTable2 = joinMap2.parentSideTable();
                stSet.add(rDBTable2);
            }
            Iterator iterator2 = joinMap2.connections().iterator();
            while (iterator2.hasNext()) {
                Connection connection = (Connection)iterator2.next();
                if (!joinMap2.isRoot() && !connection.includesTable(rDBTable) && !connection.includesTable(rDBTable2)) continue;
                stSet.addAll((Collection)connection.tables());
            }
        }
        return stSet;
    }

    public void addForUpdateClause() {
        if (!this.isForUpdate() && !this.isForUpdateWithColumns()) {
            return;
        }
        if (this.isForUpdate() && (QueryEngineInfo.isDB2() || QueryEngineInfo.isCloudscape())) {
            this.statement().addForUpdateClauseWithOneColumn();
        } else if (this.isForUpdate()) {
            this.statement().addForUpdateClause();
        } else if (this.isForUpdateWithColumns()) {
            this.statement().addForUpdateClauseWithColumns();
        }
    }

    public List orderByColumns() {
        if (this.fOrderByList == null) {
            this.fOrderByList = new ArrayList();
        }
        return this.fOrderByList;
    }

    public void addColumnToOrderBy(RDBColumn rDBColumn) {
        this.orderByColumns().add(rDBColumn);
    }

    public void addColumnsToOrderBy(List list) {
        this.orderByColumns().addAll(list);
    }

    public boolean hasOrderByColumns() {
        if (this.fOrderByList == null) {
            return false;
        }
        return !this.orderByColumns().isEmpty();
    }

    public void addOrderByClause() {
        if (!this.hasOrderByColumns()) {
            return;
        }
        this.statement().select().createOrderByClause(this.orderByColumns());
        if (this.isSingle()) {
            return;
        }
        Iterator iterator = this.statement().select().orderByClause().sortKeys().iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            SortKey sortKey = (SortKey)iterator.next();
            sortKey.alias(this.findPosition(sortKey.column()).toString());
        }
    }

    public void tables(List list) {
        this.fTables = list;
    }

    public List tables() {
        return this.fTables;
    }

    public Integer findPosition(RDBColumn rDBColumn) {
        Iterator iterator = this.resultColumns().iterator();
        int n = 1;
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (e2 instanceof RDBColumn && ((RDBColumn)e2).equals(rDBColumn)) {
                return new Integer(n);
            }
            ++n;
        }
        return new Integer(-1);
    }
}

