/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.mediator.jdbc.queryengine;

import com.ibm.ObjectQuery.crud.util.AbstractDoubleLinkTreeNode;
import com.ibm.ObjectQuery.crud.util.Association;
import com.ibm.ObjectQuery.crud.util.ListWrapper;
import com.ibm.ObjectQuery.crud.util.StSet;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.JoinMap;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryEngineInfo;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.schema.Connection;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.schema.RDBColumn;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.schema.RDBTable;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.ColumnName;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.CorrelationAliasTable;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.NullPredicate;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.Predicate;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.PredicateWithVariables;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.ResultSetElement;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.ResultSetFiller;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.SelectClause;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.SubSelect;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.TableReference;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.WhereClause;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SubSelectCreator {
    private JoinMap fJoinMap;
    private SubSelect fStatement;
    private List fResultColumns;
    private Predicate fExtraSearchCondition;
    private CorrelationAliasTable fAliasTable;
    private boolean fIsSingle = false;
    private List fOrderByList;
    private List fTables;

    public SubSelectCreator(List list, JoinMap joinMap, CorrelationAliasTable correlationAliasTable, Predicate predicate) {
        this.resultColumns(list);
        this.aliasTable(correlationAliasTable);
        this.joinMap(joinMap);
        this.extraSearchCondition(predicate);
    }

    public SubSelectCreator(List list) {
        this.resultColumns(list);
    }

    public SubSelectCreator(TableReference tableReference) {
        this.tables().add(tableReference);
    }

    public boolean isSingle() {
        return this.fIsSingle;
    }

    public void setSingle() {
        this.fIsSingle = true;
    }

    public void addConnections() {
        this.statement().and(this.getConnectionsPredicate());
    }

    public void addDiscriminators(boolean bl) {
        this.statement().and(this.createDiscriminators(bl));
    }

    public void addExtraSearchCondition() {
        if (this.extraSearchCondition() != null) {
            Iterator iterator = this.extraSearchCondition().tables().iterator();
            while (iterator.hasNext()) {
                this.statement().addTable((RDBTable)iterator.next());
            }
            this.statement().and(this.extraSearchCondition());
        }
    }

    public String aliasFor(RDBTable rDBTable) {
        if (rDBTable == null) {
            return null;
        }
        String string = this.aliasTable().aliasAt(rDBTable);
        if (string == null) {
            return this.statement().fromClause().aliasFor(rDBTable);
        }
        return string;
    }

    public CorrelationAliasTable aliasTable() {
        if (this.fAliasTable == null) {
            this.fAliasTable = new CorrelationAliasTable();
        }
        return this.fAliasTable;
    }

    public void aliasTable(CorrelationAliasTable correlationAliasTable) {
        this.fAliasTable = correlationAliasTable;
    }

    public ColumnName asColumnName(Object object) {
        if (object instanceof ColumnName) {
            return (ColumnName)object;
        }
        if (object instanceof RDBColumn) {
            return new ColumnName((RDBColumn)object);
        }
        throw new RuntimeException("not a column!");
    }

    public ResultSetElement asResultSetElement(Object object) {
        if (object instanceof ResultSetElement) {
            return (ResultSetElement)object;
        }
        if (object instanceof RDBColumn) {
            return new ColumnName((RDBColumn)object);
        }
        throw new RuntimeException("not a result set element!");
    }

    public void buildInnerJoin() {
        this.createFromClause();
        this.createSelectClause();
        if (this.joinMap().hasChildren()) {
            this.statement().whereClause(WhereClause.equiJoin(this.joinMap()));
            this.statement().addTables(this.statement().whereClause().tables());
        }
    }

    public void buildInnerJoinUsingPath() {
        this.createFromClause(this.resultColumns(), this.joinMap().tablesInPath());
        this.createSelectClause();
        if (!this.joinMap().isRoot() && this.joinMap().isRelationshipJoin()) {
            this.statement().whereClause(WhereClause.equiJoinOnPath(this.joinMap()));
        }
        this.updateTablesInFromClauseUsingWhereClause();
        this.addConnections();
        this.addDiscriminators(false);
        this.addExtraSearchCondition();
        this.updateTablesInFromClauseUsingWhereClause();
    }

    public void buildLeftOuterJoinInSQL99UsingPath() {
        this.createLeftOuterJoinFromClause(this.resultColumns(), this.joinMap().tablesInPath());
        this.createSelectClause();
        this.updateTablesInFromClauseUsingWhereClause();
        this.addConnections();
        this.addDiscriminators(true);
        this.addExtraSearchCondition();
        this.updateTablesInFromClauseUsingWhereClause();
    }

    public void buildInnerJoinUsingPathAndParent(Collection collection) {
        JoinMap joinMap = (JoinMap)this.joinMap().parent();
        this.createFromClauseFromTables(collection);
        this.createSelectClause();
        if (!joinMap.isRoot() && joinMap.isRelationshipJoin()) {
            this.statement().whereClause(WhereClause.equiJoinOnPath(this.joinMap()));
        }
        this.updateTablesInFromClauseUsingWhereClause();
        this.addConnections();
        this.addDiscriminators(false);
        this.addExtraSearchCondition();
        this.updateTablesInFromClauseUsingWhereClause();
    }

    public void buildSelectStarUsingPathLeaf() {
        this.statement().addColumn(new ResultSetFiller(new Integer(1)));
        this.statement().fromClause().addTable(this.joinMap().childSideTable());
        if (!this.joinMap().isRoot() && this.joinMap().isRelationshipJoin()) {
            this.statement().whereClause(WhereClause.equiJoinOnPath(this.joinMap()));
        }
        this.addConnections();
        this.addDiscriminators(false);
        this.addExtraSearchCondition();
    }

    public void buildSingleSelect() {
        this.statement().aliasTable(this.aliasTable());
        this.statement().select(this.resultColumns());
        if (this.joinMap() != null) {
            this.addDiscriminators(false);
            this.addConnections();
        }
        if (this.tables() != null && !this.tables().isEmpty()) {
            this.createFromClauseFromTables(this.tables());
        }
        this.addExtraSearchCondition();
        this.addOrderByClause();
    }

    public void buildSingleSelectFromInLineSelect() {
        this.statement().aliasTable(this.aliasTable());
        this.statement().select((TableReference)this.tables().get(0));
        if (this.joinMap() != null) {
            this.addDiscriminators(false);
            this.addConnections();
        }
        this.addExtraSearchCondition();
        this.addOrderByClause();
    }

    public PredicateWithVariables createDiscriminators(boolean bl) {
        RDBColumn rDBColumn;
        List list = this.joinMap().discriminatorsInPath();
        Iterator<Object> iterator = list.iterator();
        PredicateWithVariables predicateWithVariables = new PredicateWithVariables();
        StSet stSet = new StSet();
        StSet stSet2 = new StSet();
        while (iterator.hasNext()) {
            Association association = (Association)iterator.next();
            Iterator iterator2 = ((List)association.key()).iterator();
            while (iterator2.hasNext()) {
                rDBColumn = (RDBColumn)iterator2.next();
                stSet.add(rDBColumn.getOwningTable());
                stSet2.add(rDBColumn);
            }
        }
        if (!this.doesResultSetTableScopeInclude(stSet)) {
            return predicateWithVariables;
        }
        iterator = list.iterator();
        iterator = this.reduceDiscriminators(stSet2, list).entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            PredicateWithVariables predicateWithVariables2 = new PredicateWithVariables();
            rDBColumn = (RDBColumn)entry.getKey();
            predicateWithVariables2.createInFilter(rDBColumn, (List)entry.getValue());
            predicateWithVariables.and(predicateWithVariables2);
            if (!bl || !this.isRightOnHandSide(rDBColumn)) continue;
            predicateWithVariables.or(new NullPredicate(rDBColumn));
        }
        return predicateWithVariables;
    }

    public boolean isRightOnHandSide(RDBColumn rDBColumn) {
        return true;
    }

    public Map reduceDiscriminators(StSet stSet, Collection collection) {
        RDBColumn rDBColumn;
        Iterator iterator = stSet.iterator();
        HashMap hashMap = new HashMap();
        while (iterator.hasNext()) {
            rDBColumn = (RDBColumn)iterator.next();
            hashMap.put(rDBColumn, new ArrayList());
        }
        iterator = collection.iterator();
        while (iterator.hasNext()) {
            Association association = (Association)iterator.next();
            rDBColumn = (RDBColumn)((List)association.key()).get(0);
            ((List)hashMap.get(rDBColumn)).addAll((List)((List)association.value()).get(0));
        }
        return hashMap;
    }

    public void createFromClause() {
        this.createFromClause(this.resultColumns());
    }

    public void createFromClause(Collection collection, Collection collection2) {
        Collection collection3 = this.tablesFrom(collection);
        collection3.addAll(collection2);
        this.createFromClauseFromTables(collection3);
    }

    public void createLeftOuterJoinFromClause(Collection collection, Collection collection2) {
        Collection collection3 = this.tablesFrom(collection);
        collection3.addAll(collection2);
        this.statement().aliasTable(this.aliasTable());
        this.statement().fromClause().addTablesAndLeftOuterJoins(this.joinMap(), collection3);
    }

    public void createFromClause(List list) {
        this.createFromClauseFromTables(this.tablesFrom(list));
    }

    public void createFromClauseFromTables(Collection collection) {
        this.statement().aliasTable(this.aliasTable());
        this.statement().addTables(collection);
    }

    public void createSelectClause() {
        SelectClause selectClause = this.statement().selectClause();
        Iterator iterator = this.resultColumns().iterator();
        while (iterator.hasNext()) {
            ResultSetElement resultSetElement = this.asResultSetElement(iterator.next());
            String string = this.aliasFor(resultSetElement.table());
            if (string != null) {
                resultSetElement.tableAlias(string);
            }
            selectClause.addColumn(resultSetElement);
        }
    }

    public boolean doesResultSetTableScopeInclude(Collection collection) {
        StSet stSet = ListWrapper.toStSet(this.statement().tableScope());
        int n = stSet.size();
        stSet.addAll(collection);
        return stSet.size() == n;
    }

    public Predicate extraSearchCondition() {
        return this.fExtraSearchCondition;
    }

    public void extraSearchCondition(Predicate predicate) {
        this.fExtraSearchCondition = predicate;
    }

    public PredicateWithVariables getConnectionsPredicate() {
        this.updateTablesInFromClauseUsingJoinMap();
        List list = this.statement().tableScope();
        ArrayList<Connection> arrayList = new ArrayList<Connection>();
        Iterator iterator = this.joinMap().connectionsInPath().iterator();
        while (iterator.hasNext()) {
            Connection connection = (Connection)iterator.next();
            if (!list.contains(connection.parentTable()) || !list.contains(connection.memberTable())) continue;
            arrayList.add(connection);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        PredicateWithVariables predicateWithVariables = new PredicateWithVariables();
        predicateWithVariables.createEquiJoinFilter(arrayList);
        return predicateWithVariables;
    }

    public JoinMap joinMap() {
        return this.fJoinMap;
    }

    public void joinMap(JoinMap joinMap) {
        this.fJoinMap = joinMap;
    }

    public void containingSubSelect(SubSelect subSelect) {
        this.statement().containingSubSelect(subSelect);
    }

    public List resultColumns() {
        return this.fResultColumns;
    }

    public void resultColumns(List list) {
        this.fResultColumns = list;
    }

    public SubSelect statement() {
        if (this.fStatement == null) {
            this.fStatement = this.defaultStatement();
        }
        return this.fStatement;
    }

    public SubSelect defaultStatement() {
        SubSelect subSelect = new SubSelect();
        SelectClause selectClause = new SelectClause(subSelect);
        subSelect.selectClause(selectClause);
        if (subSelect.isSQLJ() && subSelect.isDB2() && this.isSingle() && QueryEngineInfo.isGenerateSelectInto()) {
            selectClause.setToSelectInto();
        }
        return subSelect;
    }

    public void statement(SubSelect subSelect) {
        this.fStatement = subSelect;
    }

    public RDBTable table(Object object) {
        if (object instanceof ColumnName) {
            return ((ColumnName)object).table();
        }
        return ((RDBColumn)object).getOwningTable();
    }

    public Collection tablesFrom(Collection collection) {
        StSet stSet = new StSet();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!(e2 instanceof RDBColumn)) continue;
            stSet.add(((RDBColumn)e2).getOwningTable());
        }
        return stSet;
    }

    public StSet tablesInPathFrom(JoinMap joinMap) {
        StSet stSet = new StSet();
        Iterator iterator = ((AbstractDoubleLinkTreeNode)((Object)joinMap)).toRootIterator();
        RDBTable rDBTable = null;
        RDBTable rDBTable2 = null;
        while (iterator.hasNext()) {
            JoinMap joinMap2 = (JoinMap)iterator.next();
            if (!joinMap2.isRoot()) {
                if (joinMap2 != joinMap) {
                    rDBTable = joinMap2.childSideTable();
                    stSet.add(rDBTable);
                }
                rDBTable2 = joinMap2.parentSideTable();
                stSet.add(rDBTable2);
            }
            Iterator iterator2 = joinMap2.connections().iterator();
            while (iterator2.hasNext()) {
                Connection connection = (Connection)iterator2.next();
                if (!joinMap2.isRoot() && !connection.includesTable(rDBTable) && !connection.includesTable(rDBTable2)) continue;
                stSet.addAll((Collection)connection.tables());
            }
        }
        return stSet;
    }

    public void updateTablesInFromClauseUsingJoinMap() {
        if (this.statement().whereClause() != null) {
            this.statement().addTables(this.tablesInPathFrom(this.joinMap()));
        }
    }

    public void updateTablesInFromClauseUsingWhereClause() {
        if (this.statement().whereClause() != null) {
            this.statement().addTables(this.statement().whereClause().tables());
        }
    }

    public List orderByColumns() {
        if (this.fOrderByList == null) {
            this.fOrderByList = new ArrayList();
        }
        return this.fOrderByList;
    }

    public void addColumnToOrderBy(RDBColumn rDBColumn) {
        this.orderByColumns().add(rDBColumn);
    }

    public void addColumnsToOrderBy(List list) {
        this.orderByColumns().addAll(list);
    }

    public boolean hasOrderByColumns() {
        if (this.fOrderByList == null) {
            return false;
        }
        return !this.orderByColumns().isEmpty();
    }

    public void addOrderByClause() {
        if (this.hasOrderByColumns()) {
            this.statement().createOrderByClause(this.orderByColumns());
        }
    }

    public void tables(List list) {
        this.fTables = list;
    }

    public List tables() {
        if (this.fTables == null) {
            this.fTables = new ArrayList();
        }
        return this.fTables;
    }
}

