/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.mediator.jdbc.queryengine;

import com.ibm.ObjectQuery.crud.util.ArrayIterator;
import com.ibm.ObjectQuery.crud.util.StSet;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Column;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Relationship;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.impl.MetadataImpl;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryEngineException;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.WriteQueryBuilder;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.schema.RDBColumn;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.schema.RDBTable;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.BinaryCondition;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.ColumnName;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.NullPredicate;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.PredicateWithVariables;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.SqlStatement;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.SqlStatementWithWhereClause;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.Update;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.WhereClause;
import commonj.sdo.DataObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.sdo.EChangeSummarySetting;

public class UpdateBuilder
extends WriteQueryBuilder {
    private int fAssignmentSize = -1;
    private int fPredicateSize = -1;
    private DataObject fDataObject;

    public UpdateBuilder(RDBTable rDBTable) throws QueryEngineException {
        super(rDBTable);
        this.initialize();
    }

    public UpdateBuilder(RDBTable rDBTable, DataObject dataObject) throws QueryEngineException {
        super(rDBTable);
        this.dataObject(dataObject);
        this.initialize();
    }

    public void addParameterColumns() throws QueryEngineException {
        ((Update)this.statement()).addColumns(this.parameterColumns());
    }

    public SqlStatement defaultStatement() {
        return new Update();
    }

    public void initialize() throws QueryEngineException {
        Update update = (Update)this.statement();
        update.table(this.getTable());
        this.addParameterColumns();
        this.assignmentSize(update.assignmentSize());
        this.addOidFilter();
        this.predicateSize(update.predicateSize());
        this.addPredicateFilter();
        if (this.getTable().hasCollisionColumn()) {
            PredicateWithVariables predicateWithVariables = new PredicateWithVariables();
            predicateWithVariables.createEquiFilter(this.getTable().collisionColumn());
            int n = this.dataObject().getInt(this.getTable().collisionColumn().getWDOColumn().getPropertyName());
            if (n == 1) {
                NullPredicate nullPredicate = new NullPredicate(this.getTable().collisionColumn());
                BinaryCondition binaryCondition = new BinaryCondition(nullPredicate, "OR", predicateWithVariables);
                ((SqlStatementWithWhereClause)((Object)this.statement())).and(binaryCondition);
            } else {
                this.predicateColumns().add(this.getTable().collisionColumn());
                ((SqlStatementWithWhereClause)((Object)this.statement())).and(predicateWithVariables);
            }
        }
        if (this.key() == null || this.key().isEmpty()) {
            throw new QueryEngineException("update with no primary key");
        }
        this.createInputDescriptor();
    }

    public List parmColumnsAllowCopies(boolean bl) throws QueryEngineException {
        WhereClause whereClause = ((Update)this.statement()).whereClause();
        List list = this.parameterColumns();
        if (whereClause != null) {
            Iterator iterator = whereClause.gatherVariableColumnsInOrder().iterator();
            while (iterator.hasNext()) {
                list.add(((ColumnName)iterator.next()).value());
            }
        }
        return list;
    }

    public String predicateColumnString() {
        StringBuffer stringBuffer = new StringBuffer();
        ArrayIterator arrayIterator = new ArrayIterator(this.getPredicateColumnNames());
        stringBuffer.append("{");
        while (arrayIterator.hasNext()) {
            stringBuffer.append("\"");
            stringBuffer.append((String)arrayIterator.next());
            stringBuffer.append("\"");
            if (!arrayIterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public int assignmentSize() {
        return this.fAssignmentSize;
    }

    public int predicateSize() {
        return this.fPredicateSize;
    }

    public void assignmentSize(int n) {
        this.fAssignmentSize = n;
    }

    public void predicateSize(int n) {
        this.fPredicateSize = n;
    }

    public boolean isUpdateQuery() {
        return true;
    }

    public List parameterColumns() {
        ArrayList arrayList = new ArrayList();
        List list = this.dataObject() == null ? this.getTable().getColumns() : this.dirtyColumns();
        Iterator iterator = list.iterator();
        StSet stSet = StSet.setOn(this.getTable().getPrimaryKey().getMembers());
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (stSet.contains(e2)) continue;
            arrayList.add(e2);
        }
        return arrayList;
    }

    public String queryType() {
        return "update";
    }

    private List getReferenceColumns(String string) {
        RDBColumn rDBColumn;
        Column column;
        ArrayList<RDBColumn> arrayList = new ArrayList<RDBColumn>();
        MetadataImpl metadataImpl = (MetadataImpl)this.getTable().getWDOTable().getMetadata();
        boolean bl = false;
        Relationship relationship = metadataImpl.getRelationship(string);
        Iterator iterator = relationship.getChildKey().getColumns().iterator();
        while (iterator.hasNext()) {
            column = (Column)iterator.next();
            rDBColumn = this.getTable().findColumn(column);
            if (rDBColumn != null) {
                arrayList.add(rDBColumn);
                continue;
            }
            bl = true;
        }
        if (bl) {
            iterator = relationship.getParentKey().getColumns().iterator();
            while (iterator.hasNext()) {
                column = (Column)iterator.next();
                rDBColumn = this.getTable().findColumn(column);
                if (rDBColumn == null) continue;
                arrayList.add(rDBColumn);
            }
        }
        return arrayList;
    }

    public List dirtyColumns() {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        List list = this.dataObject().getDataGraph().getChangeSummary().getOldValues(this.dataObject());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (EChangeSummarySetting)iterator.next();
            arrayList2.add(object.getFeatureName());
        }
        iterator = this.getTable().getColumns().iterator();
        while (iterator.hasNext()) {
            object = (RDBColumn)iterator.next();
            if (!arrayList2.contains(((RDBColumn)object).getWDOColumn().getPropertyName())) continue;
            arrayList.add(object);
            arrayList2.remove(((RDBColumn)object).getWDOColumn().getPropertyName());
        }
        iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            arrayList.addAll(this.getReferenceColumns((String)iterator.next()));
        }
        if (this.getTable().collisionColumn() != null) {
            arrayList.add(this.getTable().collisionColumn());
        }
        return arrayList;
    }

    public void dataObject(DataObject dataObject) {
        this.fDataObject = dataObject;
    }

    public DataObject dataObject() {
        return this.fDataObject;
    }
}

